/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.splitter;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.impl.splitter.AbstractBillSplitter;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.SitDateUtil;

public abstract class TaxFileBillAbstractSplitter
extends AbstractBillSplitter {
    protected static final Log logger = LogFactory.getLog(TaxFileBillAbstractSplitter.class);
    protected Date bsled;

    @Override
    protected Map<Long, DynamicObject> extractFromBill(List<DynamicObject> bills, List<DynamicObject> exsitEntityBills) {
        HashMap<Long, DynamicObject> extractFromBillMap = new HashMap<Long, DynamicObject>(bills.size());
        DynamicObjectType type = bills.get(0).getDynamicObjectType();
        for (DynamicObject bill : bills) {
            String entityCode = this.getEntityCode();
            if (type.getProperty(entityCode) == null) break;
            DynamicObjectCollection collection = bill.getDynamicObjectCollection(entityCode);
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            DynamicObject objFromBill = (DynamicObject)collection.get(0);
            this.fillBillObject(objFromBill);
            extractFromBillMap.put(this.linkKeyFromBill(bill), objFromBill);
            exsitEntityBills.add(bill);
        }
        return extractFromBillMap;
    }

    protected void fillBillObject(DynamicObject objFromBill) {
    }

    @Override
    protected Map<Long, DynamicObject> findOrCreateLocalObj(List<DynamicObject> bills, Map<Long, DynamicObject> extractFromBillMap, TaxFileOpContext taxFileOpContext) {
        String entityCode = this.getEntityCode();
        HashMap<Long, DynamicObject> dataMap = taxFileOpContext.getInfo(entityCode);
        if (dataMap != null) {
            return dataMap;
        }
        dataMap = new HashMap<Long, DynamicObject>(bills.size());
        ArrayList billIds = new ArrayList(bills.size());
        bills.forEach(obj -> billIds.add(obj.getLong("boid")));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityCode);
        QFilter filter = new QFilter("taxfile.id", "in", billIds);
        filter.and("iscurrentversion", "=", (Object)"1");
        filter.and("status", "!=", (Object)"E");
        DynamicObject[] query = serviceHelper.query(this.getFieldCodes(), new QFilter[]{filter});
        DynamicObjectType dynamicObjectType = null;
        if (query != null && query.length != 0) {
            for (DynamicObject obj2 : query) {
                dataMap.put(obj2.getLong("taxfile.id"), obj2);
            }
            dynamicObjectType = query[0].getDynamicObjectType();
        }
        if (bills.size() != dataMap.size()) {
            ORM orm = ORM.create();
            long[] pkIds = orm.genLongIds(entityCode, bills.size() - dataMap.size());
            AtomicInteger index = new AtomicInteger(0);
            for (DynamicObject bill : bills) {
                Long billId = this.linkKeyFromBill(bill);
                if (dataMap.containsKey(billId) || !extractFromBillMap.containsKey(billId)) continue;
                DynamicObject object = dynamicObjectType != null ? (DynamicObject)dynamicObjectType.createInstance() : serviceHelper.generateEmptyDynamicObject();
                DynamicObject taxFileEmpty = serviceHelper.generateEmptyDynamicObject("itc_taxfile");
                taxFileEmpty.set("bsed", bill.get("bsed"));
                taxFileEmpty.set("id", (Object)billId);
                taxFileEmpty.set("person", bill.get("person"));
                long pkId = pkIds[index.getAndIncrement()];
                object.set("id", (Object)pkId);
                object.set("taxfile", (Object)taxFileEmpty);
                dataMap.put(billId, object);
            }
        }
        taxFileOpContext.addExtraInfo(entityCode, dataMap);
        return dataMap;
    }

    protected Date getBsled() {
        if (this.bsled == null) {
            try {
                Date date = SitDateUtil.parseDate((String)"2999-12-31");
                Calendar instance = Calendar.getInstance();
                instance.setTime(date);
                instance.set(10, 0);
                instance.set(13, 0);
                instance.set(12, 0);
                instance.set(14, 0);
                this.bsled = instance.getTime();
            }
            catch (ParseException e) {
                logger.info("TaxFileBillAbstractSplitter getBsled error: {}", (Object)e);
            }
        }
        return this.bsled;
    }
}

