/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.impl.splitter;

import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.impl.splitter.AbstractBillSplitter;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;
import kd.sit.sitbp.common.model.TaxFileOpContext;
import kd.sit.sitbp.common.util.BatchResult;

public class TaxFileSplitter
extends AbstractBillSplitter {
    private static Set<String> forbidUpdateFields = Sets.newHashSet((Object[])new String[]{"number", "org", "taxunit", "person"});

    @Override
    protected String getEntityCode() {
        return "itc_taxfile";
    }

    @Override
    protected Long linkKeyFromBill(DynamicObject bill) {
        return bill.getLong("id");
    }

    @Override
    protected Map<Long, DynamicObject> extractFromBill(List<DynamicObject> bills, List<DynamicObject> exsitEntityBills) {
        return null;
    }

    @Override
    public BatchResult<DynamicObject> splitBills(List<DynamicObject> bills, TaxFileOpContext taxFileOpContext, Map<String, Map<String, Set<String>>> nullFieldSet) {
        Map<Long, DynamicObject> localInfoMap = this.findOrCreateLocalObj(bills, null, taxFileOpContext);
        BatchResult batchResult = new BatchResult(true, new ArrayList(bills.size()));
        for (DynamicObject bill : bills) {
            long taxFileId = bill.getLong("boid");
            DynamicObject localInfo = localInfoMap.get(taxFileId);
            if (localInfo == null) continue;
            String msg = this.validateValue(bill, localInfo);
            if (StringUtils.isEmpty((CharSequence)msg)) {
                batchResult.addSuccessResult((Object)bill);
                continue;
            }
            batchResult.addFailItem((Object)bill, msg);
        }
        return batchResult;
    }

    private String validateValue(DynamicObject bill, DynamicObject localInfo) {
        String msg = "";
        DynamicObjectType type = bill.getDynamicObjectType();
        StringBuilder errorFieldNames = new StringBuilder();
        for (String forbidUpdateField : forbidUpdateFields) {
            DynamicProperty property = type.getProperty(forbidUpdateField);
            if (property == null || SITBaseDataHelper.fieldIsEqual((DynamicObject)bill, (DynamicObject)localInfo, (String)forbidUpdateField, (DynamicProperty)property)) continue;
            errorFieldNames.append(property.getDisplayName()).append('\u3001');
        }
        msg = errorFieldNames.toString();
        if (!StringUtils.isEmpty((CharSequence)msg)) {
            msg = msg.substring(0, msg.length() - 1);
            return MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u201c{0}\u201d\u7981\u6b62\u4fee\u6539\u3002", (String)"TaxFileSplitter_100", (String)"sit-itc-business", (Object[])new Object[0]), msg);
        }
        return msg;
    }

    @Override
    protected Map<Long, DynamicObject> findOrCreateLocalObj(List<DynamicObject> bills, Map<Long, DynamicObject> extractFromBillMap, TaxFileOpContext taxFileOpContext) {
        String entityCode = this.getEntityCode();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityCode);
        HashMap<Long, DynamicObject> taxFileBillMap = new HashMap<Long, DynamicObject>(bills.size());
        Object[] taxFileIds = (Long[])bills.stream().map(e1 -> e1.getLong("boid")).toArray(Long[]::new);
        if (!ArrayUtils.isEmpty((Object[])taxFileIds)) {
            DynamicObject[] query;
            QFilter filter = new QFilter("id", "in", (Object)taxFileIds);
            for (DynamicObject obj : query = serviceHelper.query(this.getFieldCodes(), new QFilter[]{filter})) {
                taxFileBillMap.put(obj.getLong("boid"), obj);
            }
        }
        return taxFileBillMap;
    }

    private Set<String> getBillImportFields() {
        HashSet<String> importFields = new HashSet<String>(16);
        MainEntityType taxFileBillType = EntityMetadataCache.getDataEntityType((String)"itc_taxfilebill");
        DataEntityPropertyCollection taxFileBillProps = taxFileBillType.getProperties();
        for (IDataEntityProperty prop : taxFileBillProps) {
            String propName;
            if (prop instanceof EntryProp || this.breakFields.contains(propName = prop.getName()) || propName.endsWith(this.fixStr) || propName.startsWith("entryboid")) continue;
            importFields.add(propName);
        }
        return importFields;
    }
}

