/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.imports;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.ListOperationColumn;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.imports.entity.ImportEntity;
import kd.sit.itc.business.taxfile.imports.entity.ImportField;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import org.apache.poi.ss.usermodel.Workbook;

public class TaxExportHelper {
    protected static final Log logger = LogFactory.getLog(TaxExportHelper.class);
    private static final String IMPORT_NUMBER_FORMAT = "IMPORT_%s_%s";
    private static final Set<String> dropDownFields = Sets.newHashSet((Object[])new String[]{"itc_taxfile.depcytype.name", "itc_employment.taxpayertype.name", "itc_employment.emptype.name", "itc_investor.duty.name", "itc_overseasperson.taxreason.name", "itc_overseasperson.otheridtype.name"});
    private static final Map<String, String> langMap = new HashMap<String, String>(3);
    private static Map<Long, Integer> dataprecisionMap = new HashMap<Long, Integer>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getImportTemplate(String queryId) {
        String downUrl = "";
        if (StringUtils.isEmpty((CharSequence)queryId)) {
            return downUrl;
        }
        List<ImportEntity> importEntities = TaxExportHelper.getTemplateInfo(queryId, false);
        HashMap<String, List<ImportEntity>> param = new HashMap<String, List<ImportEntity>>(16);
        param.put("template", importEntities);
        WorkbookInfo workbookInfo = WorkbookInfoGenerator.generateWith((String)"sitTaxFileExport", param);
        Workbook wb = null;
        try {
            wb = ExcelHelper.writeData((WorkbookInfo)workbookInfo, (List)Lists.newArrayList(), (ExportResult)new ExportResult(Integer.valueOf(0)));
            downUrl = ExcelHelper.writeFile((Workbook)wb, (String)TaxExportHelper.getFileName());
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    logger.error(" TaxExportHelper getImportTemplate close wb error:", (Throwable)e);
                }
            }
        }
        return downUrl;
    }

    public static List<ImportEntity> getTemplateInfo(String queryId, boolean isExport) {
        if (StringUtils.isEmpty((CharSequence)queryId)) {
            return null;
        }
        ArrayList<ImportEntity> importEntities = new ArrayList(10);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryId);
        if (queryEntityType != null) {
            MainEntityType mainEntityType;
            List joinEntityList = queryEntityType.getJoinEntitys();
            int entityCount = joinEntityList.size();
            HashMap<String, ImportEntity> joinEntityMap = new HashMap<String, ImportEntity>(entityCount);
            HashMap<String, MainEntityType> joinEntityTypeMap = new HashMap<String, MainEntityType>(entityCount);
            String entityCode = queryEntityType.getEntityName();
            ImportEntity mainEntity = new ImportEntity(entityCode, (mainEntityType = EntityMetadataCache.getDataEntityType((String)entityCode)).getDisplayName().getLocaleValue(), new ArrayList<ImportField>(mainEntityType.getFields().size()));
            if (StringUtils.equals((CharSequence)mainEntity.getEntityCode(), (CharSequence)"itc_taxfile")) {
                mainEntity.setEntityOp("apisave");
            }
            importEntities.add(mainEntity);
            for (Object JoinEntity2 : joinEntityList) {
                entityCode = JoinEntity2.getEntityName();
                MainEntityType joinEntityType = EntityMetadataCache.getDataEntityType((String)entityCode);
                ImportEntity joinEntity = new ImportEntity(entityCode, joinEntityType.getDisplayName().getLocaleValue(), new ArrayList<ImportField>(joinEntityType.getFields().size()));
                joinEntityMap.put(entityCode, joinEntity);
                joinEntityTypeMap.put(entityCode, joinEntityType);
                importEntities.add(joinEntity);
            }
            List joinRelations = queryEntityType.getJoinRelations();
            for (QuerySourceJoinRelation relation : joinRelations) {
                String entityNumber = relation.getEntityNumber();
                if (!StringUtils.equals((CharSequence)entityNumber, (CharSequence)mainEntity.getEntityCode())) continue;
                List conditionRows = relation.getCondition();
                for (QSConditionRow conditionRow : conditionRows) {
                    String rightItem = conditionRow.getRightItem().toString();
                    String[] items = rightItem.split("\\.");
                    String rightEntityName = items[0];
                    String rightPropName = items[1];
                    ImportEntity importEntity = (ImportEntity)joinEntityMap.get(rightEntityName);
                    if (importEntity == null) continue;
                    Map<String, String> relationMap = importEntity.getEntityRelations();
                    if (CollectionUtils.isEmpty(relationMap)) {
                        relationMap = new HashMap<String, String>(conditionRows.size());
                    }
                    relationMap.put(rightPropName, entityNumber);
                    importEntity.setEntityRelations(relationMap);
                }
            }
            List selectFields = queryEntityType.getSelectFields();
            for (int i = 0; i < selectFields.size(); ++i) {
                QuerySelectField field = (QuerySelectField)selectFields.get(i);
                ImportEntity entity2 = null;
                MainEntityType entityType = null;
                String fieldCode = field.getAlias();
                String fieldName = field.getDisplayName();
                if (fieldCode.indexOf(46) > 0) {
                    String beginCode = fieldCode.substring(0, fieldCode.indexOf(46));
                    entity2 = (ImportEntity)joinEntityMap.get(beginCode);
                    entityType = (EntityType)joinEntityTypeMap.get(beginCode);
                }
                if (entity2 == null) {
                    entity2 = mainEntity;
                    entityType = mainEntityType;
                    fieldCode = entity2.getEntityCode() + '.' + fieldCode;
                } else {
                    fieldName = fieldName.replace(entity2.getEntityName() + ".", "");
                }
                ImportField importField = TaxExportHelper.getImportField((EntityType)entityType, fieldCode, fieldName, isExport);
                importField.setColNum(i);
                entity2.getImportFieldList().add(importField);
            }
        }
        importEntities = importEntities.stream().filter(entity -> entity.getFieldSize() > 0).collect(Collectors.toList());
        return importEntities;
    }

    private static ImportField getImportField(EntityType entityType, String fieldCode, String fieldName, boolean isExport) {
        if (StringUtils.isEmpty((CharSequence)fieldCode) || entityType == null) {
            return null;
        }
        ImportField field = new ImportField(fieldCode, fieldName);
        String[] codes = fieldCode.split("\\.");
        DynamicProperty property = null;
        for (int i = 1; i < codes.length; ++i) {
            String code = codes[i];
            property = entityType.getProperty(code);
            if (property instanceof BasedataProp) {
                if (!isExport && i == 1) {
                    field.setMustInput(((BasedataProp)property).isMustInput());
                }
                if (i == codes.length - 2) {
                    field.setBaseData(true);
                    if (dropDownFields.contains(fieldCode)) {
                        field.setDropDown(true);
                    }
                }
                entityType = (BasedataEntityType)((BasedataProp)property).getComplexType();
                continue;
            }
            if (!isExport && i == 1) {
                field.setMustInput(((FieldProp)property).isMustInput());
            }
            if (i != codes.length - 1) continue;
            field.setProperty(property);
            if (property instanceof ComboProp) {
                TaxExportHelper.dealComboProp(field, property);
                continue;
            }
            if (property instanceof BooleanProp) {
                TaxExportHelper.dealBooleanProp(field, property);
                continue;
            }
            if (isExport || !(property instanceof MuliLangTextProp)) continue;
            TaxExportHelper.dealMuliLangTextProp(field);
        }
        if (field.isBaseData() && field.isDropDown()) {
            TaxExportHelper.dealDropDownBaseData(field, property);
        }
        return field;
    }

    private static void dealMuliLangTextProp(ImportField field) {
        String langTig = Lang.get().toString();
        field.setFieldCode(field.getFieldCode() + "." + langTig);
        field.setFieldName(field.getFieldName() + "." + langMap.get(langTig));
    }

    private static void dealDropDownBaseData(ImportField field, DynamicProperty property) {
        String baseData = property.getParent().getName();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(baseData);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        String orderBy = "";
        if (StringUtils.equals((CharSequence)baseData, (CharSequence)"itc_taxreason")) {
            orderBy = "number";
        }
        DynamicObject[] dynamicObjects = serviceHelper.query(new QFilter[]{filter}, orderBy);
        ArrayList<String> dropDownMenu = new ArrayList<String>(dynamicObjects.length);
        for (DynamicObject object : dynamicObjects) {
            dropDownMenu.add(object.getString("name"));
        }
        field.setDropDownVals(dropDownMenu);
    }

    private static void dealBooleanProp(ImportField field, DynamicProperty property) {
        field.setDropDown(true);
        ArrayList<String> dropDownMenu = new ArrayList<String>(2);
        dropDownMenu.add(ResManager.loadKDString((String)"\u662f", (String)"TaxExportHelper_3", (String)"sit-itc-business", (Object[])new Object[0]));
        dropDownMenu.add(ResManager.loadKDString((String)"\u5426", (String)"TaxExportHelper_4", (String)"sit-itc-business", (Object[])new Object[0]));
        field.setDropDownVals(dropDownMenu);
    }

    private static void dealComboProp(ImportField field, DynamicProperty property) {
        field.setDropDown(true);
        List valueMapItemList = ((ComboProp)property).getComboItems();
        ArrayList<String> dropDownMenu = new ArrayList<String>(valueMapItemList.size());
        valueMapItemList.forEach(obj -> dropDownMenu.add(obj.getName().getLocaleValue()));
        field.setDropDownVals(dropDownMenu);
    }

    private static String getFileName() {
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%04d", now.getYear()) + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u5bfc\u5165_%s.xlsx", (String)"TaxExportHelper_5", (String)"sit-itc-business", (Object[])new Object[0]), date);
    }

    public static String getImportFileName(String url) {
        String[] splitUrl = url.split("\\/");
        return splitUrl[splitUrl.length - 1];
    }

    public static void removeImportCache(String entityId, String url) {
        IAppCache appCache = AppCache.get((String)"itc_import");
        String userId = RequestContext.get().getUserId();
        Set fileNames = (Set)appCache.get(userId, Set.class);
        fileNames.remove(entityId + "_" + TaxExportHelper.getImportFileName(url));
        if (!fileNames.isEmpty()) {
            appCache.put(userId, (Object)fileNames);
        } else {
            appCache.remove(userId);
        }
    }

    public static DynamicObject queryExportTemplate(Long templateId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxtemplate");
        String selectFileds = "asteriskposition,fieldkey,exportfield,ismustinput,index,isexport,name";
        QFilter qFilter = new QFilter("id", "=", (Object)templateId);
        DynamicObject templateObject = serviceHelper.queryOne(selectFileds, new QFilter[]{qFilter}, "index");
        return templateObject;
    }

    public static Set<String> parseExportFields(DynamicObject exportTemplate) {
        DynamicObjectCollection entryEntity = exportTemplate.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return null;
        }
        return entryEntity.stream().filter(obj -> obj.getBoolean("isexport")).map(obj -> obj.getString("fieldkey")).collect(Collectors.toSet());
    }

    public static Map<String, DynamicProperty> getDynamicPropertyMap(QueryEntityType queryEntityType, String selectFields) {
        String[] exportFieldArray = selectFields.split(",");
        HashMap<String, DynamicProperty> dynamicPropertyMap = new HashMap<String, DynamicProperty>(exportFieldArray.length);
        DynamicProperty dataEntityProperty = null;
        BasedataEntityType basedataEntityType = null;
        DynamicProperty dynamicProperty = null;
        for (String exportField : exportFieldArray) {
            String[] fieldCodes = exportField.split("\\.");
            for (int i = 0; i < fieldCodes.length; ++i) {
                String field = fieldCodes[i];
                if (i == 0) {
                    dataEntityProperty = queryEntityType.getProperty(field);
                } else if (basedataEntityType != null) {
                    dataEntityProperty = basedataEntityType.getProperty(field);
                }
                if (dataEntityProperty == null) {
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u5b9e\u4f53\u201c{0}\u201d\u4e2d\u627e\u4e0d\u5230\u201c{1}\u201d\u5b57\u6bb5\u3002", (String)"TaxExportHelper_6", (String)"sit-itc-business", (Object[])new Object[0]), queryEntityType.getName(), exportField));
                }
                if (dataEntityProperty instanceof BasedataProp) {
                    basedataEntityType = (BasedataEntityType)((BasedataProp)dataEntityProperty).getComplexType();
                    continue;
                }
                if (!(dataEntityProperty instanceof DynamicProperty)) continue;
                dynamicProperty = dataEntityProperty;
                break;
            }
            dynamicPropertyMap.put(exportField, dynamicProperty);
        }
        return dynamicPropertyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<?> getData(QueryEntityType queryEntityType, Map<String, DynamicProperty> dynamicPropertyMap, String exportFields, QFilter[] qfilter, String orderBy, int pageSize, int pageNum) {
        logger.info("\u6309\u6279\u83b7\u53d6\u6570\u636e\u5f00\u59cb");
        ArrayList dataList = null;
        try (DataSet exportDataSet = null;){
            exportDataSet = queryEntityType.getQueryDataSet(exportFields, qfilter, orderBy, true, pageSize * --pageNum, pageSize);
            String[] fieldCodes = exportFields.split(",");
            dataList = new ArrayList(pageSize);
            for (Row row : exportDataSet) {
                HashMap<String, Object> dataMap = new HashMap<String, Object>(fieldCodes.length);
                for (String fieldCode : fieldCodes) {
                    DynamicProperty dynProperty = dynamicPropertyMap.get(fieldCode);
                    Object value = TaxExportHelper.parseValue(row, fieldCode, dynProperty);
                    dataMap.put(fieldCode, value);
                }
                dataList.add(dataMap);
            }
        }
        logger.info("\u6309\u6279\u83b7\u53d6\u6570\u636e\u5b8c\u6210");
        return dataList;
    }

    public static Object parseValue(Row row, String fieldCode, DynamicProperty dynProperty) {
        Object value = null;
        if (dynProperty instanceof BooleanProp) {
            value = row.getBoolean(fieldCode) != null && row.getBoolean(fieldCode) != false ? ResManager.loadKDString((String)"\u662f", (String)"PersonDeclareExportTask_2", (String)"sit-itc-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"PersonDeclareExportTask_3", (String)"sit-itc-business", (Object[])new Object[0]);
        } else if (dynProperty instanceof ComboProp) {
            value = ((ComboProp)dynProperty).getItemByName(row.getString(fieldCode));
        } else if (dynProperty instanceof DateTimeProp || dynProperty instanceof TimeProp) {
            Date dateValue = row.getDate(fieldCode);
            if (dateValue != null) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                value = format.format(dateValue);
            }
        } else if (dynProperty instanceof IntegerProp) {
            value = row.getLong(fieldCode);
        } else if (dynProperty instanceof DecimalProp) {
            int scale = ((DecimalProp)dynProperty).getScale();
            BigDecimal decimalValue = row.getBigDecimal(fieldCode);
            if (decimalValue != null) {
                decimalValue = decimalValue.setScale(scale, 4);
                value = decimalValue.doubleValue();
            }
        } else {
            value = row.getString(fieldCode);
        }
        return value;
    }

    public static FieldProp createFieldProp(DynamicObject taxItemDy) {
        Long dataTypeId = taxItemDy.getLong("datatype.id");
        if (SitDataTypeEnum.NUMBER.getId() == dataTypeId.longValue()) {
            DecimalProp decimalProp = new DecimalProp();
            decimalProp.setName(taxItemDy.getString("id"));
            decimalProp.setAlias(taxItemDy.getString("name"));
            decimalProp.setScale(dataprecisionMap.get(taxItemDy.getLong("dataprecision.id")).intValue());
            return decimalProp;
        }
        if (SitDataTypeEnum.TEXT.getId() == dataTypeId.longValue()) {
            TextProp textProp = new TextProp();
            textProp.setName(taxItemDy.getString("id"));
            textProp.setAlias(taxItemDy.getString("name"));
            return textProp;
        }
        if (SitDataTypeEnum.INTEGER.getId() == dataTypeId.longValue()) {
            IntegerProp integerProp = new IntegerProp();
            integerProp.setName(taxItemDy.getString("id"));
            integerProp.setAlias(taxItemDy.getString("name"));
            return integerProp;
        }
        if (SitDataTypeEnum.DATE.getId() == dataTypeId.longValue()) {
            DateTimeProp dateTimeProp = new DateTimeProp();
            dateTimeProp.setName(taxItemDy.getString("id"));
            dateTimeProp.setAlias(taxItemDy.getString("name"));
            return dateTimeProp;
        }
        if (SitDataTypeEnum.BOOLEAN.getId() == dataTypeId.longValue()) {
            BooleanProp booleanProp = new BooleanProp();
            booleanProp.setName(taxItemDy.getString("id"));
            booleanProp.setAlias(taxItemDy.getString("name"));
            return booleanProp;
        }
        DecimalProp decimalProp = new DecimalProp();
        decimalProp.setName(taxItemDy.getString("id"));
        decimalProp.setAlias(taxItemDy.getString("name"));
        decimalProp.setScale(taxItemDy.getInt("currency.amtprecision"));
        return decimalProp;
    }

    public static boolean checkTaxTemplateExportField(Long taxTemplateId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxtemplate");
        String selectFileds = "isexport";
        QFilter qFilter = new QFilter("id", "=", (Object)taxTemplateId);
        DynamicObject templateObject = serviceHelper.queryOne(selectFileds, new QFilter[]{qFilter}, "index");
        DynamicObjectCollection entryEntity = templateObject.getDynamicObjectCollection("entryentity");
        boolean hasExportField = false;
        for (DynamicObject entity : entryEntity) {
            if (!entity.getBoolean("isexport")) continue;
            hasExportField = true;
            break;
        }
        return hasExportField;
    }

    public static String getBillListOrderBy(IFormView view, BillList billList) {
        String orderBy = billList.generalFilterParameter().getOrderBy();
        if (!StringUtils.isEmpty((CharSequence)orderBy)) {
            return orderBy;
        }
        StringBuilder defaultOrderBuilder = new StringBuilder();
        ListGridView listGridView = (ListGridView)view.getControl(billList.getListGridViewKey());
        List items = listGridView.getItems();
        for (int i = 0; i < items.size(); ++i) {
            String tempOrder;
            IListColumn column = (IListColumn)items.get(i);
            if (column instanceof ListOperationColumn || StringUtils.equals((CharSequence)(tempOrder = column.getOrder()), (CharSequence)"NotOrder")) continue;
            defaultOrderBuilder.append(column.getListFieldKey()).append(' ').append(tempOrder).append(',');
        }
        String defaultOrder = defaultOrderBuilder.toString();
        if (!StringUtils.isEmpty((CharSequence)defaultOrder)) {
            defaultOrder = defaultOrder.substring(0, defaultOrderBuilder.length() - 1);
        }
        return defaultOrder;
    }

    static {
        langMap.put("zh_CN", ResManager.loadKDString((String)"\u7b80\u4f53\u4e2d\u6587", (String)"TaxExportHelper_0", (String)"sit-itc-business", (Object[])new Object[0]));
        langMap.put("en_US", ResManager.loadKDString((String)"English", (String)"TaxExportHelper_1", (String)"sit-itc-business", (Object[])new Object[0]));
        langMap.put("zh_TW", ResManager.loadKDString((String)"\u7e41\u4f53\u4e2d\u6587", (String)"TaxExportHelper_2", (String)"sit-itc-business", (Object[])new Object[0]));
        dataprecisionMap.put(1010L, 0);
        dataprecisionMap.put(1020L, 1);
        dataprecisionMap.put(1030L, 2);
        dataprecisionMap.put(1040L, 3);
        dataprecisionMap.put(1050L, 4);
        dataprecisionMap.put(1060L, 5);
        dataprecisionMap.put(1070L, 6);
        dataprecisionMap.put(1080L, 7);
        dataprecisionMap.put(1090L, 8);
        dataprecisionMap.put(1100L, 9);
        dataprecisionMap.put(1110L, 10);
    }
}

