/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.imports;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.formplugin.web.newhismodel.impt.HisBatchImportPlugin;
import kd.sit.sitbp.common.cache.ISITAppCache;
import kd.sit.sitbp.common.cache.SITAppCache;
import kd.sit.sitbp.common.model.EffectLogger;

public class TaxFileBatchImportPlugin
extends HisBatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(TaxFileBatchImportPlugin.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);
    private final List<String> entityCodes = Lists.newArrayList((Object[])new String[]{"itc_taxcontact", "itc_employment", "itc_bankcard", "itc_investor", "itc_overseasperson", "itc_specialinfo"});
    private final Set<String> numbers = new HashSet<String>(16);
    private final String numberMsg = ResManager.loadKDString((String)"{0}: excel\u4e2d\u5df2\u5b58\u5728\u6863\u6848\u7f16\u7801\u4e3a{1}\u7684\u6570\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u4f7f\u7528\u6b64\u6863\u6848\u7f16\u53f7\u3002", (String)"TaxFileBatchImportPlugin_0", (String)"sit-itc-business", (Object[])new Object[0]);
    private final String rowNumberMsg = ResManager.loadKDString((String)"\u8bf7\u52ff\u5728\u76f8\u8fde\u4e24\u884c\u7ef4\u62a4\u540c\u4e00\u4e2a\u4e2a\u7a0e\u6863\u6848\u3002", (String)"TaxFileBatchImportPlugin_1", (String)"sit-itc-business", (Object[])new Object[0]);

    public String getDefaultKeyFields() {
        return "number";
    }

    public String getDefaultImportType() {
        return "overridenew";
    }

    protected void resolveExcel() {
        this.effectLogger.start("TaxFileBatchImportPlugin resolveExcel");
        super.resolveExcel();
        this.effectLogger.end("TaxFileBatchImportPlugin resolveExcel");
    }

    protected int getBatchImportSize() {
        return 5000;
    }

    protected void importData() throws Throwable {
        this.effectLogger.start("TaxFileBatchImportPlugin importData");
        super.importData();
        this.effectLogger.end("TaxFileBatchImportPlugin importData");
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        this.effectLogger.start("TaxFileBatchImportPlugin importData beforeSave");
        super.beforeSave(billDatas, logger);
        this.validBillDatas(billDatas, logger);
        this.addCache();
        this.effectLogger.end("TaxFileBatchImportPlugin importData beforeSave");
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        this.effectLogger.start("TaxFileBatchImportPlugin importData save");
        this.cacheNullField(rowdatas);
        ApiResult apiResult = super.save(rowdatas, logger);
        this.clearImportCache();
        this.effectLogger.end("TaxFileBatchImportPlugin importData save");
        return apiResult;
    }

    private void cacheNullField(List<ImportBillData> rowDatas) {
        Map<String, Map<String, Set<String>>> fileNullFieldMap = this.collectNullInfo(rowDatas);
        if (CollectionUtils.isEmpty(fileNullFieldMap)) {
            return;
        }
        ISITAppCache cache = SITAppCache.get((String)"itc");
        Long userId = RequestContext.get().getCurrUserId();
        String cacheKey = String.format(Locale.ROOT, "ItcTaxFileImport_%s_NullFieldMap", userId);
        cache.put(cacheKey, (Object)SerializationUtils.serializeToBase64(fileNullFieldMap));
    }

    private Map<String, Map<String, Set<String>>> collectNullInfo(List<ImportBillData> rowdatas) {
        if (CollectionUtils.isEmpty(rowdatas)) {
            return null;
        }
        ImportBillData importBillData = rowdatas.get(0);
        Map entries = importBillData.getEntityMapping().getEntries();
        HashMap fileNullFieldMap = Maps.newHashMapWithExpectedSize((int)rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            HashMap nullFieldMap = Maps.newHashMapWithExpectedSize((int)16);
            for (Map.Entry mappingEntry : entries.entrySet()) {
                JSONArray subEntityJsonArr;
                String subEntityCode = (String)mappingEntry.getKey();
                Object subEntityObj = data.get((Object)subEntityCode);
                if (subEntityCode == null || (subEntityJsonArr = (JSONArray)subEntityObj).size() == 0) continue;
                JSONObject subEntityJsonObj = (JSONObject)subEntityJsonArr.get(0);
                Map cols = ((ImportEntityMapping)mappingEntry.getValue()).getCols();
                for (Map.Entry colInfoEntry : cols.entrySet()) {
                    String fieldCode = (String)colInfoEntry.getKey();
                    ImportEntityMapping.ColInfo colInfo = (ImportEntityMapping.ColInfo)colInfoEntry.getValue();
                    IDataEntityProperty property = null;
                    if (colInfo != null) {
                        property = colInfo.getProperty();
                    }
                    if (!subEntityJsonObj.containsKey((Object)fieldCode)) continue;
                    Object fieldValue = subEntityJsonObj.get((Object)fieldCode);
                    if (fieldValue == null) {
                        Set nullFieldSet = nullFieldMap.computeIfAbsent(subEntityCode, k1 -> Sets.newHashSetWithExpectedSize((int)cols.size()));
                        nullFieldSet.add(fieldCode);
                        continue;
                    }
                    if (!(property instanceof MuliLangTextProp) || fieldValue == null) continue;
                    Map fieldValueMap = (Map)fieldValue;
                    for (Map.Entry valueEntry : fieldValueMap.entrySet()) {
                        Object value = valueEntry.getValue();
                        if (value != null) continue;
                        Set nullFieldSet = nullFieldMap.computeIfAbsent(subEntityCode, k1 -> Sets.newHashSetWithExpectedSize((int)cols.size()));
                        nullFieldSet.add(fieldCode);
                    }
                }
            }
            if (CollectionUtils.isEmpty((Map)nullFieldMap)) continue;
            String taxFileNumber = data.getString("number");
            if (StringUtils.isEmpty((Object)taxFileNumber)) {
                log.info("TaxFileBatchImportPlugin cacheNullField : taxFileNumber is null, index is " + rowdata.getDataIndex());
                continue;
            }
            fileNullFieldMap.put(taxFileNumber, nullFieldMap);
        }
        return fileNullFieldMap;
    }

    private void validBillDatas(List<ImportBillData> billDatas, ImportLogger logger) {
        ArrayList<ImportBillData> invalidBillDatas = new ArrayList<ImportBillData>(billDatas.size());
        for (ImportBillData billData : billDatas) {
            String number;
            int endIndex;
            int startIndex = billData.getStartIndex();
            if (startIndex != (endIndex = billData.getEndIndex())) {
                int validNum = this.getValidNum(billData);
                for (int i = startIndex + 1; i < startIndex + validNum; ++i) {
                    logger.log(Integer.valueOf(i), this.rowNumberMsg).fail();
                }
                billData.setEndIndex(startIndex);
            }
            if (StringUtils.isEmpty((Object)(number = (String)billData.getData().get((Object)"number"))) || this.numbers.add(number)) continue;
            logger.log(Integer.valueOf(startIndex), MessageFormat.format(this.numberMsg, number, number)).fail();
            invalidBillDatas.add(billData);
        }
        invalidBillDatas.forEach(billDatas::remove);
    }

    private int getValidNum(ImportBillData billData) {
        int validNum = 0;
        JSONObject data = billData.getData();
        ImportEntityMapping entityMapping = billData.getEntityMapping();
        Map entries = entityMapping.getEntries();
        if (CollectionUtils.isEmpty((Map)entries)) {
            return validNum;
        }
        for (String childEntity : entries.keySet()) {
            Object entityJson = data.get((Object)childEntity);
            if (!(entityJson instanceof JSONArray)) continue;
            validNum = Math.max(validNum, ((JSONArray)entityJson).size());
        }
        return validNum;
    }

    private void clearImportCache() {
        IHRAppCache hbpCache = HRAppCache.get((String)"hbp");
        String url = this.ctx.getAllUrls().toArray(new String[0])[0];
        Long userId = RequestContext.get().getCurrUserId();
        if (this.ctx.isResolveComplete(url) && this.ctx.getDataQueue(url).isEmpty()) {
            for (String entityCode : this.entityCodes) {
                String cacheKey = String.format("HRHisModelImport_%s_%s_UpdateType", entityCode, userId);
                hbpCache.remove(cacheKey);
            }
        }
        IHRAppCache itcCache = HRAppCache.get((String)"itc");
        String cacheKey = String.format(Locale.ROOT, "ItcTaxFileImport_%s_NullFieldMap", userId);
        itcCache.remove(cacheKey);
    }

    private void addCache() {
        IHRAppCache cache = HRAppCache.get((String)"hbp");
        String mainEntityId = this.getBillFormId();
        Long userId = RequestContext.get().getCurrUserId();
        String updateType = (String)cache.get(String.format("HRHisModelImport_%s_%s_UpdateType", mainEntityId, userId), String.class);
        for (String entityCode : this.entityCodes) {
            String cacheKey = String.format("HRHisModelImport_%s_%s_UpdateType", entityCode, userId);
            cache.put(cacheKey, (Object)updateType);
        }
    }
}

