/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.imports.plugin;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.itc.business.taxfile.imports.plugin.ITaxImportPlugin;

public class ImportPluginGenerate {
    private static Log log = LogFactory.getLog(ImportPluginGenerate.class);

    private static List<String> getPluginNameList(String entityId) {
        ArrayList<String> pluginNameList = new ArrayList<String>(10);
        switch (entityId) {
            case "itc_taxfile": {
                pluginNameList.add("kd.sit.itc.business.taxfile.imports.plugin.TaxFileImportPlugin");
                break;
            }
        }
        return pluginNameList;
    }

    public static List<ITaxImportPlugin> generate(String entityId) {
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return null;
        }
        List<String> pluginNameList = ImportPluginGenerate.getPluginNameList(entityId);
        ArrayList<ITaxImportPlugin> pluginList = new ArrayList<ITaxImportPlugin>(pluginNameList.size());
        for (String pluginName : pluginNameList) {
            try {
                ITaxImportPlugin plugin = (ITaxImportPlugin)Class.forName(pluginName).newInstance();
                pluginList.add(plugin);
            }
            catch (Throwable e) {
                log.error(e);
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u63d2\u4ef6%s\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff1a{0}\u3002", (String)"ImportPluginGenerate_0", (String)"sit-itc-business", (Object[])new Object[]{pluginName, ImportLogger.formatException((Throwable)e)}));
            }
        }
        return pluginList;
    }
}

