/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.imports.sheethandler;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.sit.itc.business.taxtaskguide.imports.TaxResultImportConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.xml.sax.SAXException;

public class TaxResultImportFailedSheetHandler
extends SheetHandler {
    private static Log log = LogFactory.getLog(TaxResultImportFailedSheetHandler.class);
    private SXSSFWorkbook book;
    private SXSSFSheet sheet;
    private Map<String, CellStyle> styles = new HashMap<String, CellStyle>();
    private TaxResultImportConfig conf;
    private FileService service;
    private ImportLogger importLogger;
    private int cursorRowNum;
    private SheetHandler.ParsedRow currentRow;
    private Map<String, Integer> logsHash = new HashMap<String, Integer>();

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public TaxResultImportFailedSheetHandler(TaxResultImportConfig conf, FileService service) {
        this.conf = conf;
        this.importLogger = conf.getImportLogger();
        this.service = service;
        this.importLogger.getDelRows().sort((o1, o2) -> o1[0] - o2[0]);
        this.cursorRowNum = 0;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        JSONObject styleObj;
        SXSSFCell cell;
        this.currentRow = row;
        int currRowIndex = this.currentRow.getRowNum();
        if (currRowIndex == this.conf.getHeaderLineNumber()) {
            this.book = new SXSSFWorkbook(1000);
            this.book.setCompressTempFiles(true);
            this.sheet = this.book.createSheet("sheet1");
            this.sheet.setColumnWidth(0, 10000);
        }
        StringBuilder sb = new StringBuilder();
        List logs = (List)this.importLogger.getLogCache().get(currRowIndex);
        if (logs != null && !logs.isEmpty()) {
            String mergeLogStr;
            Integer logCursorRow;
            sb.setLength(0);
            for (ImportLogger.ImportLog log : logs) {
                sb.append(log).append("\n\t");
                if (sb.length() <= 4000) continue;
                sb.replace(3997, 4000, "...").setLength(4000);
                break;
            }
            if ((logCursorRow = this.logsHash.get(mergeLogStr = sb.toString())) != null) {
                mergeLogStr = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u540c\u7b2c%s\u884c", (String)"TaxResultImportFailedSheetHandler_0", (String)"sit-itc-business", (Object[])new Object[0]), logCursorRow);
                logs.clear();
                logs.add(new ImportLogger.ImportLog(mergeLogStr));
            } else {
                int num = this.cursorRowNum + 1;
                this.logsHash.put(mergeLogStr, num);
            }
            cell = this.getRow(this.sheet, this.cursorRowNum).createCell(0);
            styleObj = new JSONObject();
            styleObj.put("color", (Object)IndexedColors.RED.getIndex());
            cell.setCellStyle(this.getCellStyle(styleObj));
            cell.setCellValue(mergeLogStr);
        }
        for (Map.Entry entry : this.currentRow.getData().entrySet()) {
            String fmt;
            CellStyle style;
            styleObj = (JSONObject)this.currentRow.getStyles().get(entry.getKey());
            cell = this.getRow(this.sheet, this.cursorRowNum).createCell((Integer)entry.getKey() + 1);
            if (currRowIndex == 0) {
                styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
                if (((String)entry.getValue()).startsWith("*")) {
                    styleObj.put("color", (Object)IndexedColors.RED.getIndex());
                }
                this.sheet.setColumnWidth((Integer)entry.getKey() + 1, ((String)entry.getValue()).getBytes(Charset.forName("utf-8")).length * 2 * 160);
            }
            if ((style = this.getCellStyle(styleObj)) != null) {
                cell.setCellStyle(style);
            }
            if (StringUtils.isNotBlank((CharSequence)(fmt = styleObj.getString("fmt")))) {
                try {
                    cell.setCellValue(new BigDecimal((String)entry.getValue()).doubleValue());
                }
                catch (Throwable e) {
                    cell.setCellValue((String)entry.getValue());
                }
                continue;
            }
            cell.setCellValue((String)entry.getValue());
        }
        ++this.cursorRowNum;
    }

    private CellStyle getCellStyle(JSONObject style) {
        String fmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short bg = style.getShort("bg");
        Short color = style.getShort("color");
        String styleStr = String.format("%s_-_%d_-_%d_-_%s", fmt, bg, color, align);
        CellStyle cellStyle = this.styles.get(styleStr);
        if (cellStyle == null) {
            cellStyle = this.book.createCellStyle();
            this.styles.put(styleStr, cellStyle);
            cellStyle.setDataFormat(this.book.createDataFormat().getFormat(fmt));
            if (bg != null) {
                cellStyle.setFillForegroundColor(bg.shortValue());
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (color != null) {
                Font font = this.book.createFont();
                font.setColor(color.shortValue());
                cellStyle.setFont(font);
            }
            cellStyle.setAlignment(this.getAlignment(align));
        }
        return cellStyle;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private CellType convertCellType(SheetHandler.XSSFDataType xssfDataType, String fmt) {
        if (xssfDataType != null) {
            switch (xssfDataType) {
                case BOOL: {
                    return CellType.BOOLEAN;
                }
                case ERROR: {
                    return CellType.ERROR;
                }
                case FORMULA: {
                    return CellType.FORMULA;
                }
                case INLINESTR: 
                case SSTINDEX: {
                    if (StringUtils.isNotBlank((CharSequence)fmt)) {
                        return CellType.NUMERIC;
                    }
                    return CellType.STRING;
                }
                case NUMBER: {
                    return CellType.NUMERIC;
                }
            }
        }
        return CellType.BLANK;
    }

    private boolean isRowSucceed(List<int[]> delRows, int currRowNum) {
        for (int[] rs : delRows) {
            if (currRowNum != rs[0]) continue;
            return true;
        }
        return false;
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int r1) {
        SXSSFRow row = sheet.getRow(r1);
        if (row == null) {
            row = sheet.createRow(r1);
        }
        return row;
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (this.book == null) {
            return;
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.book.write((OutputStream)os);
            byte[] data = os.toByteArray();
            TempFileCache tempFile = CacheFactory.getCommonCacheFactory().getTempFileCache();
            LocalDate now = LocalDate.now();
            String fileName1 = this.conf.getEntityType().getDisplayName() + "_" + String.format("%02d%02d", now.getMonthValue(), now.getDayOfMonth());
            String fileName = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_{0}.xlsx", (String)"TaxResultImportFailedSheetHandler_1", (String)"sit-itc-business", (Object[])new Object[]{fileName1});
            String url = tempFile.saveAsUrl(fileName, data, data.length);
            RequestContext ctx = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)"itc", (String)(this.conf.getEntityType().getName() + UUID.randomUUID().toString()), (String)fileName);
            String uploadUrl = this.service.upload(new FileItem(fileName, path, tempFile.getInputStream(url)));
            this.importLogger.setErrFile(UrlService.getAttachmentFullUrl((String)uploadUrl));
            this.conf.feedbackProgress(0, this.importLogger, "", 0, 0, false);
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", e.toString()), new Object[0]);
        }
        finally {
            try {
                if (this.book != null) {
                    this.book.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            this.conf = null;
            this.sheet = null;
            this.book = null;
            this.importLogger = null;
        }
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        DataValidationHelper helper = this.sheet.getDataValidationHelper();
        for (SheetHandler.CellValidation validation : cellValidations) {
            String[] items = validation.getValidation().split(",", -1);
            for (String range : validation.getRange().split(" ")) {
                AreaReference ref = new AreaReference(range, SpreadsheetVersion.EXCEL2007);
                CellRangeAddressList addressList = new CellRangeAddressList(ref.getFirstCell().getRow(), ref.getLastCell().getRow(), ref.getFirstCell().getCol() + 1, ref.getLastCell().getCol() + 1);
                DataValidationConstraint constraint = helper.createExplicitListConstraint(items);
                DataValidation dataValidation = helper.createValidation(constraint, addressList);
                if (dataValidation instanceof XSSFDataValidation) {
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                } else {
                    dataValidation.setSuppressDropDownArrow(false);
                }
                this.sheet.addValidationData(dataValidation);
            }
        }
    }
}

