/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxfile.imports.sheethandler;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.itc.business.taxtaskguide.imports.TaxResultImportConfig;
import kd.sit.itc.business.taxtaskguide.imports.TaxResultImportEntityMapping;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class TaxResultImportSheetHandler
extends SheetHandler {
    private static Log log = LogFactory.getLog(TaxResultImportSheetHandler.class);
    private TaxResultImportConfig conf;
    private String url;
    public static final int BATCH_IMPORT_SIZE = 500;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private int startRowNum = 0;
    private int lastStartRowNum = 0;
    private SheetHandler.ParsedRow currentRow;
    private JSONObject data;

    public TaxResultImportSheetHandler(TaxResultImportConfig conf) {
        this.conf = conf;
        this.url = conf.getUrl();
        this.dataQueue = conf.getDataQueue();
    }

    public SheetHandler.ParsedRow getCurrentRow() {
        return this.currentRow;
    }

    public void setCurrentRow(SheetHandler.ParsedRow currentRow) {
        this.currentRow = currentRow;
    }

    public void handleRow(SheetHandler.ParsedRow parsedRow) {
        String appId = EntityMetadataCache.getDataEntityType((String)"itc_taxdata").getAppId();
        String suspendCache = (String)AppCache.get((String)appId).get("IMPT_SUSPEND_itc_taxdata", String.class);
        if (StringUtils.isNotBlank((CharSequence)suspendCache) && "IMPT_SUSPEND_itc_taxdata".equals(suspendCache)) {
            return;
        }
        this.currentRow = parsedRow;
        int currRowIndex = this.currentRow.getRowNum();
        ImportLogger importLogger = this.conf.getImportLogger();
        importLogger.setRowIndex(currRowIndex);
        if (currRowIndex > this.conf.getHeaderLineNumber() && !parsedRow.isEmpty()) {
            this.data = new JSONObject();
            this.startRowNum = currRowIndex;
            Set<String> errMsgs = TaxResultImportEntityMapping.resolveDataRow(parsedRow, this.data, this.conf);
            if (!errMsgs.isEmpty()) {
                ArrayList msg = new ArrayList(errMsgs.size());
                errMsgs.forEach(obj -> msg.add(new ImportLogger.ImportLog("", obj)));
                int rowIndex = currRowIndex + 1;
                importLogger.logAll(Integer.valueOf(rowIndex), msg);
            }
            if (currRowIndex + 1 > importLogger.getLastRowIndex()) {
                int rowIndex = currRowIndex + 1;
                importLogger.setLastRowIndex(rowIndex);
            }
            this.addBillData(new ImportBillData(this.data, this.startRowNum, currRowIndex, null));
            log.info("{}...import analyze Excel first data\uff1a", (Object)this.conf.getFormView().getPageId());
            importLogger.setRowIndex(currRowIndex);
        }
        if (currRowIndex == this.conf.getHeaderLineNumber()) {
            importLogger.setLastRowIndex(this.getRowCount());
        }
    }

    private void addBillData(ImportBillData billData) {
        try {
            this.dataQueue.put(billData);
        }
        catch (Throwable e) {
            log.error("error\u3002", e);
            throw new KDBizException(e, new ErrorCode("", ResManager.loadKDString((String)"\u89e3\u6790\u7ebf\u7a0b\u5f02\u5e38\u3002", (String)"TaxResultImportSheetHandler_0", (String)"sit-itc-business", (Object[])new Object[0])), new Object[0]);
        }
        if (this.lastStartRowNum == 0 || billData.getEndIndex() - this.lastStartRowNum >= 500) {
            this.lastStartRowNum = billData.getEndIndex();
        }
    }

    public void endDocument() throws SAXException {
        this.setInterrupt(this.currentRow != null);
        this.conf.setComplete(true);
        log.info("{}...doAfterAllAnalysed...", (Object)this.conf.getFormView().getPageId());
    }
}

