/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxperiod;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxPeriodServiceHelper {
    public static TaxPeriodEntity matchTaxPeriod(Date date) {
        try {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxperiod");
            QFilter startFilter = new QFilter("startdate", "<=", (Object)date);
            QFilter endFilter = new QFilter("enddate", ">=", (Object)date);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            DynamicObject query = serviceHelper.queryOne("id,number,name,startdate,enddate,perioddate", new QFilter[]{startFilter, endFilter, statusFilter});
            return new TaxPeriodEntity(query);
        }
        catch (Exception e) {
            return TaxPeriodServiceHelper.mockTaxPeriod();
        }
    }

    public static TaxPeriodEntity matchTaxPeriod(Object dateOrId, Map<Object, TaxPeriodEntity> existsMap) {
        TaxPeriodEntity taxPeriodEntity = existsMap.get(dateOrId);
        if (taxPeriodEntity != null) {
            return taxPeriodEntity;
        }
        if (dateOrId instanceof Date) {
            Date date = SitDateUtil.ceil((Object)dateOrId);
            for (TaxPeriodEntity tpe : existsMap.values()) {
                if (!SitDateUtil.isCover((Date)date, (Date)tpe.getStartDate(), (Date)tpe.getEndDate())) continue;
                existsMap.put(date, tpe);
                return tpe;
            }
            taxPeriodEntity = TaxPeriodServiceHelper.matchTaxPeriod(date);
        } else if (dateOrId instanceof Long) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxperiod");
            QFilter idFilter = new QFilter("id", "=", dateOrId);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            DynamicObject query = serviceHelper.queryOne("id,number,name,startdate,enddate,perioddate", new QFilter[]{idFilter, statusFilter});
            taxPeriodEntity = new TaxPeriodEntity(query);
        } else {
            taxPeriodEntity = new TaxPeriodEntity();
        }
        return taxPeriodEntity;
    }

    public static TaxPeriodEntity mockTaxPeriod() {
        TaxPeriodEntity taxPeriodEntity = new TaxPeriodEntity();
        taxPeriodEntity.setId(1000001L);
        taxPeriodEntity.setPeriodDate((Date)BaseDataConverter.convert((Object)"2021-04-01", Date.class));
        taxPeriodEntity.setStartDate((Date)BaseDataConverter.convert((Object)"2021-04-01", Date.class));
        taxPeriodEntity.setEndDate((Date)BaseDataConverter.convert((Object)"2021-04-30", Date.class));
        return taxPeriodEntity;
    }
}

