/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxsrcdata;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;

public class TaxSrcDataViewHelper {
    private TaxSrcDataViewHelper() {
    }

    public static List<QFilter> allFilters(List<QFilter> allFilters, IFormView formView, BillList billList) {
        BaseResult<TaxTaskEntity> taskRes;
        Long taxTaskId;
        JSONArray taxUnitIds;
        Long taxpayerTypeId;
        FormShowParameter formShowParameter;
        Long categoryId;
        AbstractGrid.GridState entryState = billList.getEntryState();
        String columnQFilter = entryState.getColumnQFilter();
        if (!StringUtils.isEmpty((Object)columnQFilter)) {
            List qFilters = (List)SerializationUtils.deSerializeFromBase64((String)columnQFilter);
            allFilters.addAll(qFilters);
        }
        if (!ObjectUtils.isEmpty((Object)(categoryId = (Long)(formShowParameter = formView.getFormShowParameter()).getCustomParam("categoryId")))) {
            allFilters.add(new QFilter("taxcategory.id", "=", (Object)categoryId));
        }
        if (!ObjectUtils.isEmpty((Object)(taxpayerTypeId = (Long)formShowParameter.getCustomParam("taxpayerTypeId")))) {
            allFilters.add(new QFilter("employment.taxpayertype.id", "=", (Object)taxpayerTypeId));
        }
        if (!CollectionUtils.isEmpty((Collection)(taxUnitIds = (JSONArray)formShowParameter.getCustomParam("taxUnitIds")))) {
            allFilters.add(new QFilter("taxfile.taxunit.id", "in", (Object)taxUnitIds.toArray()));
        }
        if (!ObjectUtils.isEmpty((Object)(taxTaskId = (Long)formShowParameter.getCustomParam("taxTaskId"))) && (taskRes = TaxTaskServiceHelper.loadTaxTaskEntity(taxTaskId)).isSuccess()) {
            TaxTaskEntity taskEntity = (TaxTaskEntity)taskRes.getData();
            allFilters.add(new QFilter("yearMonth", "in", (Object)new Integer[]{taskEntity.yearMonth(), 0}));
            allFilters.add(new QFilter("taxdatabasic.paydate", ">=", (Object)taskEntity.getStartDate()));
            allFilters.add(new QFilter("taxdatabasic.paydate", "<=", (Object)taskEntity.getEndDate()));
            SitCommonServiceHelper.addComputeFilter(allFilters);
        }
        allFilters.add(new QFilter("status", "not in", (Object)new String[]{"D", "E"}));
        return allFilters;
    }
}

