/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtask;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxtask.KeyBizInfoChangedHelper;
import kd.sit.itc.business.taxtask.PreTaxDataBasicUnit;
import kd.sit.itc.business.taxtaskguide.task.UpdateAssignTaxDataBasicTask;
import kd.sit.itc.business.taxtaskguide.task.UpdateTaxDataBasicTask;
import kd.sit.itc.common.enums.ChangeTypeEnums;
import kd.sit.itc.common.enums.DeclareStatusEnums;
import kd.sit.itc.common.enums.SrcRefNumEnums;
import kd.sit.itc.common.model.changetypemodel.InfoChangeDo;
import kd.sit.itc.common.model.changetypemodel.OldNewValue;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.TaxFileInfoServiceFactory;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.SitBaseUtil;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;

public class InitTaxDataBasicHelper {
    private static final Log LOGGER = LogFactory.getLog(InitTaxDataBasicHelper.class);
    public static final String SELECTED_PROPS = "id,boid,person,taxunit,org,employment,percre,pereduexp,pertsprop,pernontsprop,personversion,empposorgrel,taxstatus,declarestatus,bsed,bsled,declaremonth";
    public static final String TAX_FILE = "taxfile";
    public static final String TAX_PERSON = "taxperson";
    public static final String YEAR_MONTH = "yearmonth";
    public static final String BIZ_STATUS = "bizstatus";
    public static final String STATUS = "status";
    public static final String TAXUNIT = "taxunit";
    public static final String TAXTASK = "taxtask";
    public static final String DECLARESTATUS = "declarestatus";
    public static final String CALSTATUS = "calstatus";
    public static final String SRCREFNUM = "srcrefnum";
    public static final String ORG = "org";
    public static final String CHANGE_TYPE = "changetype";
    public static final String PREPARE_STATUS = "preparestatus";
    public static final String EMPPOSORGREL = "empposorgrel";
    public static final String PERCRE = "percre";
    public static final String PERNONTSPROP = "pernontsprop";
    public static final String PEREDUEXP = "pereduexp";
    public static final String PERTSPROP = "pertsprop";
    public static final String TAXFILE_BOID = "taxfileboid";
    public static final String PERSON_STATUS = "personstatus";
    public static final String DECLARE_RECORD_SELECTED_PROPS = "changetype,declaremonth,declarestatus,taxfile,modifytime,taxdatabasicid.taxfile,taxdatabasicid.taxcontact,taxdatabasicid.employment,taxdatabasicid.bankcard,taxdatabasicid.investor,taxdatabasicid.overseasperson,taxdatabasicid.specialinfo";
    public static final String[] TAXFILE_PROPS = new String[]{"taxfile", "taxcontact", "employment", "bankcard", "investor", "overseasperson", "specialinfo"};
    public static final String EXISTED_TAXDATABASIC_SELECTED_PROPS = "id,changetype,declarestatus,srcrefnum,taxfile.boid,taxfileboid,status,modifier,modifytime,taxfile,taxperson,percre,pernontsprop,pereduexp,pertsprop,empposorgrel,taxunit,org,personstatus,taxfile.taxstatus,taxcontact,employment,bankcard,investor,overseasperson,specialinfo,yearmonth";

    public static void confirmVersion(TaxTaskEntity taxTaskEntity, IFormView view, boolean async) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOGGER.info("1---thread is [{}], confirmVersion begin", (Object)Thread.currentThread().getName());
        Map<Long, Long> allTaxFileIdMap = InitTaxDataBasicHelper.getInitedTaxFileIdMap(taxTaskEntity);
        LOGGER.info("2---thread is [{}], task number is [{}], getInitedTaxFileIdMap finish size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), allTaxFileIdMap.size(), stopwatch.elapsed().toMillis()});
        Map<String, List<Long>> existedTaxDataBasicIdMap = InitTaxDataBasicHelper.getExistedTaxDataBasicIdMapList(taxTaskEntity);
        LOGGER.info("3---thread is [{}], task number is [{}], existedTaxDataBasicIdMap finish size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), existedTaxDataBasicIdMap.size(), stopwatch.elapsed().toMillis()});
        HashSet existedTaxFileBoid = Sets.newHashSet((Iterable)existedTaxDataBasicIdMap.get("taxFileBoIdList"));
        List<Long> taxDataBasicIdList = existedTaxDataBasicIdMap.get("taxDataBasicIdList");
        ArrayList newTaxFileVIdList = Lists.newArrayListWithExpectedSize((int)allTaxFileIdMap.size());
        allTaxFileIdMap.entrySet().stream().filter(entry -> !existedTaxFileBoid.contains(entry.getKey())).forEach(entry -> newTaxFileVIdList.add(entry.getValue()));
        LOGGER.info("4---thread is [{}],task number is [{}], get newTaxFileVIdList finish size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), newTaxFileVIdList.size(), stopwatch.elapsed().toMillis()});
        UpdateTaxDataBasicTask updateTaxDataBasicTask = new UpdateTaxDataBasicTask(view, taxTaskEntity, allTaxFileIdMap);
        if (!CollectionUtils.isEmpty(taxDataBasicIdList)) {
            updateTaxDataBasicTask.addData("existedTaxDataBasicList", 500, taxDataBasicIdList, 1);
        }
        if (!CollectionUtils.isEmpty((Collection)newTaxFileVIdList)) {
            updateTaxDataBasicTask.addData("newTaxFileIdMap", 500, newTaxFileVIdList, 1);
        }
        if (!CollectionUtils.isEmpty(taxDataBasicIdList) || !CollectionUtils.isEmpty((Collection)newTaxFileVIdList)) {
            LOGGER.info("5---thread is [{}], task number is [{}], updateTaxDataBasicTask begin, time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            MultiThreadTaskExecutor.execute((MultiThreadTask)updateTaxDataBasicTask, (boolean)async, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
            LOGGER.info("6---thread is [{}], task number is [{}], updateTaxDataBasicTask finish, time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        }
        stopwatch.stop();
    }

    private static String getKey(String originalKey) {
        if (Strings.isNullOrEmpty((String)originalKey)) {
            return "";
        }
        Object[] keyArr = originalKey.split("_");
        if (ArrayUtils.isEmpty((Object[])keyArr)) {
            return "";
        }
        return keyArr[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DynamicObject> createNewTaxDataBasic(TaxTaskEntity taxTaskEntity, List<Long> taxFileBoidList) {
        ArrayList otherQFilters = Lists.newArrayList((Object[])new QFilter[]{new QFilter("boid", "in", taxFileBoidList)});
        Map<Long, Long> initedTaxFileIdMap = InitTaxDataBasicHelper.getInitedTaxFileIdMapByOtherQFilter(taxTaskEntity, otherQFilters);
        ArrayList taxFileFidList = Lists.newArrayList(initedTaxFileIdMap.values());
        Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap = InitTaxDataBasicHelper.getPreTaxDataBasicUnitMap(taxFileFidList);
        ArrayList preTaxDataBasicUnitList = Lists.newArrayList(preTaxDataBasicUnitMap.values());
        LOGGER.info("task number is {}, invoke createNewTaxDataBasic and the preTaxDataBasicUnitList size is {}", (Object)taxTaskEntity.getNumber(), (Object)preTaxDataBasicUnitList.size());
        HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        HRBaseServiceHelper taxTaskHelper = new HRBaseServiceHelper("itc_taxtask");
        DynamicObject newTaxDataBasic = InitTaxDataBasicHelper.createNewTaxDataBasic(taxTaskEntity, preTaxDataBasicUnitList, null);
        try (TXHandle txHandle = TX.requiresNew();){
            DynamicObject taskDy;
            taxDataBasicHelper.save(newTaxDataBasic.toArray(new DynamicObject[0]));
            LOGGER.info("task number is {}, invoke createNewTaxDataBasic and newTaxDataBasic size is {}", (Object)taxTaskEntity.getNumber(), (Object)newTaxDataBasic.size());
            if (!CollectionUtils.isEmpty(newTaxDataBasic)) {
                taskDy = taxTaskHelper.queryOne("id,taskstatus", (Object)taxTaskEntity.getId());
                taskDy.set("taskstatus", (Object)TaxTaskStatusEnum.INIT_FINISH.getCode());
                taxTaskHelper.saveOne(taskDy);
            }
            taskDy = newTaxDataBasic;
            return taskDy;
        }
    }

    public static boolean isNeedToUpdateVersion(DynamicObject taxDataBasicDy) {
        if (!(ChangeTypeEnums.NO_CHANGE.getCode() == taxDataBasicDy.getInt(CHANGE_TYPE) || DeclareStatusEnums.DECLARED.getCode() != taxDataBasicDy.getInt(DECLARESTATUS) && SrcRefNumEnums.NO_REF.getCode().equals(taxDataBasicDy.getString(SRCREFNUM)))) {
            return false;
        }
        return ChangeTypeEnums.NO_CHANGE.getCode() != taxDataBasicDy.getInt(CHANGE_TYPE) || SrcRefNumEnums.NO_REF.getCode().equals(taxDataBasicDy.getString(SRCREFNUM));
    }

    public static Map<Long, Long> getInitedTaxFileIdMap(TaxTaskEntity taxTaskEntity) {
        return InitTaxDataBasicHelper.getInitedTaxFileIdMapByOtherQFilter(taxTaskEntity, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, Long> getInitedTaxFileIdMapByOtherQFilter(TaxTaskEntity taxTaskEntity, List<QFilter> otherQFilters) {
        QFilter taxUnitFilter = new QFilter("taxunit.id", "in", taxTaskEntity.getTaxUnitMap().keySet());
        ArrayList<QFilter> otherQfilterList = new ArrayList<QFilter>(10);
        otherQfilterList.add(taxUnitFilter);
        if (!CollectionUtils.isEmpty(otherQFilters)) {
            otherQfilterList.addAll(otherQFilters);
        }
        List<QFilter> qFilters = InitTaxDataBasicHelper.packageQFilterList(taxTaskEntity, otherQfilterList);
        DataSet dataSet = null;
        DataSet countDataSet = null;
        HashMap taxFileMap = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)SitCommonServiceHelper.class.getName(), (String)"itc_taxfile", (String)"id,boid,bsed", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"bsed desc");
            countDataSet = dataSet.copy();
            int total = countDataSet.count("boid", false);
            taxFileMap = Maps.newHashMapWithExpectedSize((int)total);
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                Long boid = row.getLong("boid");
                taxFileMap.putIfAbsent(boid, id);
            }
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (countDataSet != null) {
                countDataSet.close();
            }
        }
        return taxFileMap;
    }

    public static List<QFilter> packageQFilterList(TaxTaskEntity taxTaskEntity, List<QFilter> otherQFilterList) {
        if (Objects.isNull(taxTaskEntity)) {
            return otherQFilterList;
        }
        TaxPeriodEntity taxPeriodEntity = taxTaskEntity.getTaxPeriodEntity();
        QFilter filter = new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.NO.getCode());
        QFilter bsedFilter = new QFilter("bsed", "<", (Object)taxPeriodEntity.getEndDate());
        QFilter bsledFilter = new QFilter("bsled", ">", (Object)taxPeriodEntity.getStartDate());
        QFilter statusFilter = new QFilter(STATUS, "=", (Object)"C");
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"});
        ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{filter, bsedFilter, bsledFilter, statusFilter, dataStatusFilter});
        if (!CollectionUtils.isEmpty(otherQFilterList)) {
            qFilters.addAll(otherQFilterList);
        }
        return qFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<Long>> getExistedTaxDataBasicIdMapList(TaxTaskEntity taxTaskEntity) {
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId());
        QFilter statusFilter = new QFilter(STATUS, "not in", Arrays.asList("D", "E"));
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{taxTaskFilter, statusFilter});
        DataSet dataSet = null;
        DataSet copy = null;
        HashMap existedTaxDataBasicIdMap = Maps.newHashMapWithExpectedSize((int)2);
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)SitCommonServiceHelper.class.getName(), (String)"itc_taxdatabasic", (String)"id,taxfile.boid", (QFilter[])filters.toArray(new QFilter[0]), (String)"");
            copy = dataSet.copy();
            int totalNum = copy.count("id", true);
            copy.close();
            ArrayList taxDataBasicIdList = Lists.newArrayListWithExpectedSize((int)totalNum);
            ArrayList taxFileBoIdList = Lists.newArrayListWithExpectedSize((int)totalNum);
            existedTaxDataBasicIdMap.put("taxDataBasicIdList", taxDataBasicIdList);
            existedTaxDataBasicIdMap.put("taxFileBoIdList", taxFileBoIdList);
            for (Row row : dataSet) {
                Long id = row.getLong("id");
                Long taxFileBoId = row.getLong("taxfile.boid");
                taxDataBasicIdList.add(id);
                taxFileBoIdList.add(taxFileBoId);
            }
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (copy != null) {
                copy.close();
            }
        }
        return existedTaxDataBasicIdMap;
    }

    public static List<DynamicObject> updateAssignTaxDataBasicDys(IFormView view, TaxTaskEntity taxTaskEntity, List<DynamicObject> taxDataBasicDys) {
        if (CollectionUtils.isEmpty(taxDataBasicDys)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        Map<Long, Long> allTaxFileIdMap = InitTaxDataBasicHelper.getInitedTaxFileIdMap(taxTaskEntity);
        UpdateAssignTaxDataBasicTask updateAssignTaxDataBasicTask = new UpdateAssignTaxDataBasicTask(view, taxTaskEntity, allTaxFileIdMap);
        updateAssignTaxDataBasicTask.addData(500, taxDataBasicDys);
        LOGGER.info("Trace By Quinn: start updateAssignTaxDataBasicTask");
        BatchResult batchResult = MultiThreadTaskExecutor.execute((MultiThreadTask)updateAssignTaxDataBasicTask, (boolean)false, (ThreadPool)SITThreadPoolFactory.getTaxtaskPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getTaxtaskHanddataThreadPool());
        LOGGER.info("Trace By Quinn: end updateAssignTaxDataBasicTask");
        if (batchResult.isSuccess()) {
            List successResult = batchResult.getSuccessResult();
            return successResult.stream().map(PreTaxDataBasicUnit::getTaxDataBasic).collect(Collectors.toList());
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public static void filterUpdatedTaxDataBasic(Map<Long, DynamicObject> updateTaxDataBasicMap, Map<Long, DynamicObject> unUpdatedTaxDataBasic) {
        if (CollectionUtils.isEmpty(updateTaxDataBasicMap)) {
            return;
        }
        Iterator<Map.Entry<Long, DynamicObject>> iterator = updateTaxDataBasicMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, DynamicObject> entry = iterator.next();
            Long taxFileBoid = entry.getKey();
            DynamicObject taxDataBasicDy = entry.getValue();
            if (InitTaxDataBasicHelper.isNeedToUpdateVersion(taxDataBasicDy)) continue;
            unUpdatedTaxDataBasic.put(taxFileBoid, taxDataBasicDy);
            iterator.remove();
        }
    }

    public static Map<Long, List<DynamicObject>> getDeclareRecordMap(List<Long> taxFileBoidList) {
        HRBaseServiceHelper declareRecordHelper = new HRBaseServiceHelper("itc_persondeclarerecord");
        QFilter taxFileBoidFilter = new QFilter("taxfile.id", "in", taxFileBoidList);
        QFilter declareStatusFilter = new QFilter(DECLARESTATUS, "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter taxDataBasicFilter = new QFilter("taxdatabasicid.status", "not in", Arrays.asList("D", "E"));
        ArrayList qFilters = Lists.newArrayList((Object[])new QFilter[]{declareStatusFilter, taxFileBoidFilter, taxDataBasicFilter});
        DynamicObject[] dynamicObjects = declareRecordHelper.query(DECLARE_RECORD_SELECTED_PROPS, qFilters.toArray(new QFilter[0]), "modifytime desc");
        HashMap result = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            List declareRecords = result.computeIfAbsent(dynamicObject.getLong("taxfile.id"), key -> new ArrayList(10));
            declareRecords.add(dynamicObject);
        }
        return result;
    }

    public static List<DynamicObject> createNewTaxDataBasic(TaxTaskEntity taxTaskEntity, List<PreTaxDataBasicUnit> preTaxDataBasicUnits, DynamicObjectType dynamicObjectType) {
        LOGGER.info("Trace By Quinn: createNewTaxDataBasic start");
        HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        List taxFileDys = preTaxDataBasicUnits.stream().map(PreTaxDataBasicUnit::getTaxFileDy).collect(Collectors.toList());
        Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap = preTaxDataBasicUnits.stream().collect(Collectors.toMap(PreTaxDataBasicUnit::getTaxFileBoid, unit -> unit, (k1, k2) -> k1));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)preTaxDataBasicUnits.size());
        ArrayList infoChangeDos = Lists.newArrayListWithExpectedSize((int)preTaxDataBasicUnits.size());
        HashSet noChangeTaxFileBoids = Sets.newHashSetWithExpectedSize((int)preTaxDataBasicUnits.size());
        TaxPeriodEntity taxPeriodEntity = taxTaskEntity.getTaxPeriodEntity();
        Map versionMap = TaxFileInfoServiceFactory.findLatestVersionByFileBoIdsAndDate((String)"itc", (List)Lists.newArrayList(preTaxDataBasicUnitMap.keySet()), (Date)taxPeriodEntity.getStartDate(), (Date)taxPeriodEntity.getEndDate());
        LOGGER.info("Trace By Quinn: createNewTaxDataBasic findLatestVersionByFileBoIdsAndDate {0}", (Object)taxFileDys.size());
        for (DynamicObject taxFileDy : taxFileDys) {
            DynamicObject taxDataBasicDy = Objects.isNull(dynamicObjectType) ? taxDataBasicHelper.generateEmptyDynamicObject() : (DynamicObject)dynamicObjectType.createInstance();
            SitBaseUtil.initSystemProp((DynamicObject)taxDataBasicDy);
            taxDataBasicDy.set(TAXTASK, (Object)taxTaskEntity.getId());
            taxDataBasicDy.set(YEAR_MONTH, (Object)taxTaskEntity.yearMonth());
            taxDataBasicDy.set(BIZ_STATUS, (Object)YesOrNoEnum.NO.getCode());
            taxDataBasicDy.set(CALSTATUS, (Object)YesOrNoEnum.NO.getCode());
            taxDataBasicDy.set(STATUS, (Object)"C");
            taxDataBasicDy.set(PREPARE_STATUS, (Object)YesOrNoEnum.NO.getCode());
            taxDataBasicDy.set(SRCREFNUM, (Object)SrcRefNumEnums.NO_REF.getCode());
            InitTaxDataBasicHelper.setTaxDataBasicProperties(preTaxDataBasicUnitMap, infoChangeDos, noChangeTaxFileBoids, versionMap, taxFileDy, taxDataBasicDy);
            result.add(taxDataBasicDy);
        }
        InitTaxDataBasicHelper.determineChangeType(result, infoChangeDos, noChangeTaxFileBoids, preTaxDataBasicUnitMap);
        LOGGER.info("Trace By Quinn: createNewTaxDataBasic determineChangeType");
        return result;
    }

    private static void setTaxDataBasicProperties(Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap, List<InfoChangeDo> infoChangeDos, Set<Long> noChangeTaxFileBoids, Map<String, Map<Long, Long>> versionMap, DynamicObject taxFileDy, DynamicObject taxDataBasicDy) {
        taxDataBasicDy.set(TAX_FILE, (Object)taxFileDy);
        taxDataBasicDy.set(TAXFILE_BOID, (Object)taxFileDy.getLong("boid"));
        taxDataBasicDy.set(TAX_PERSON, (Object)taxFileDy.getLong("personversion.id"));
        taxDataBasicDy.set(PERCRE, (Object)taxFileDy.getLong("percre.id"));
        taxDataBasicDy.set(PERNONTSPROP, (Object)taxFileDy.getLong("pernontsprop.id"));
        taxDataBasicDy.set(PEREDUEXP, (Object)taxFileDy.getLong("pereduexp.id"));
        taxDataBasicDy.set(PERTSPROP, (Object)taxFileDy.getLong("pertsprop.id"));
        taxDataBasicDy.set(EMPPOSORGREL, (Object)taxFileDy.getLong("empposorgrel.id"));
        taxDataBasicDy.set(TAXUNIT, (Object)taxFileDy.getLong("taxunit.id"));
        taxDataBasicDy.set(ORG, (Object)taxFileDy.getLong("org.id"));
        taxDataBasicDy.set(PERSON_STATUS, (Object)taxFileDy.getString("taxstatus"));
        if (!CollectionUtils.isEmpty(versionMap)) {
            for (Map.Entry<String, Map<Long, Long>> versionEntry : versionMap.entrySet()) {
                String key = InitTaxDataBasicHelper.getKey(versionEntry.getKey());
                Long versionDyId = versionEntry.getValue().get(taxFileDy.getLong("boid"));
                if (!Objects.nonNull(versionDyId)) continue;
                taxDataBasicDy.set(key, (Object)versionDyId);
            }
        }
        InitTaxDataBasicHelper.versionComparison(preTaxDataBasicUnitMap, infoChangeDos, noChangeTaxFileBoids, taxDataBasicDy);
    }

    private static void determineChangeType(List<DynamicObject> taxDataBasicDys, List<InfoChangeDo> infoChangeDos, Set<Long> noChangeTaxFileBoids, Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap) {
        LOGGER.info("in determineChangeType, preTaxDataBasicUnitMap value is:{}", (Object)preTaxDataBasicUnitMap.values().toString());
        LOGGER.info("invoke KeyBizInfoChangedHelper.judgeKeyBizInfoChanged boids is :{}", (Object)infoChangeDos.toString());
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOGGER.info("1---thread is [{}], judgeKeyBizInfoChanged begin", (Object)Thread.currentThread().getName());
        KeyBizInfoChangedHelper.judgeKeyBizInfoChanged(infoChangeDos);
        LOGGER.info("2---thread is [{}], judgeKeyBizInfoChanged finish, time is [{}]", (Object)Thread.currentThread().getName(), (Object)stopwatch.elapsed().toMillis());
        stopwatch.stop();
        Map<Long, InfoChangeDo> infoChangeDoMap = infoChangeDos.stream().collect(Collectors.toMap(InfoChangeDo::getTaxFileBoId, res -> res, (k1, k2) -> k1));
        for (DynamicObject taxDataBasicDy : taxDataBasicDys) {
            Long taxFileBoid = taxDataBasicDy.getLong("taxfile.boid");
            PreTaxDataBasicUnit preTaxDataBasicUnit = preTaxDataBasicUnitMap.get(taxFileBoid);
            preTaxDataBasicUnit.setTaxDataBasic(taxDataBasicDy);
            DynamicObject lastDeclareRecord = preTaxDataBasicUnit.getLastDeclareRecord();
            DynamicObject taxFileDy = preTaxDataBasicUnit.getTaxFileDy();
            if (null == lastDeclareRecord) {
                taxDataBasicDy.set(CHANGE_TYPE, (Object)ChangeTypeEnums.NEW.getCode());
                InitTaxDataBasicHelper.setDeclareStatus(taxDataBasicDy);
                continue;
            }
            int lastChangeType = lastDeclareRecord.getInt(CHANGE_TYPE);
            String taxStatus = taxFileDy.getString("taxstatus");
            if (ChangeTypeEnums.DECREASE.getCode() == lastChangeType && YesOrNoEnum.YES.getCode().equals(taxStatus)) {
                taxDataBasicDy.set(CHANGE_TYPE, (Object)ChangeTypeEnums.NEW.getCode());
                InitTaxDataBasicHelper.setDeclareStatus(taxDataBasicDy);
                continue;
            }
            if (ChangeTypeEnums.DECREASE.getCode() != lastChangeType && YesOrNoEnum.NO.getCode().equals(taxStatus)) {
                taxDataBasicDy.set(CHANGE_TYPE, (Object)ChangeTypeEnums.DECREASE.getCode());
                InitTaxDataBasicHelper.setDeclareStatus(taxDataBasicDy);
                continue;
            }
            if (noChangeTaxFileBoids.contains(taxFileBoid)) {
                taxDataBasicDy.set(CHANGE_TYPE, (Object)ChangeTypeEnums.NO_CHANGE.getCode());
                InitTaxDataBasicHelper.setDeclareStatus(taxDataBasicDy);
                continue;
            }
            InfoChangeDo infoChangeDo = infoChangeDoMap.get(taxFileBoid);
            if (Objects.nonNull(infoChangeDo)) {
                boolean infoChange = infoChangeDo.getInfoChange();
                if (infoChange) {
                    taxDataBasicDy.set(CHANGE_TYPE, (Object)ChangeTypeEnums.CHANGED.getCode());
                } else {
                    taxDataBasicDy.set(CHANGE_TYPE, (Object)ChangeTypeEnums.NO_CHANGE.getCode());
                }
            } else {
                taxDataBasicDy.set(CHANGE_TYPE, (Object)ChangeTypeEnums.ALL.getCode());
            }
            InitTaxDataBasicHelper.setDeclareStatus(taxDataBasicDy);
        }
    }

    private static void setDeclareStatus(DynamicObject taxDataBasicDy) {
        int changeType = taxDataBasicDy.getInt(CHANGE_TYPE);
        if (ChangeTypeEnums.NO_CHANGE.getCode() == changeType) {
            taxDataBasicDy.set(DECLARESTATUS, (Object)YesOrNoEnum.YES.getCode());
        } else {
            taxDataBasicDy.set(DECLARESTATUS, (Object)YesOrNoEnum.NO.getCode());
        }
    }

    public static Map<Long, PreTaxDataBasicUnit> getPreTaxDataBasicUnitMap(List<Long> taxFileFidList) {
        return InitTaxDataBasicHelper.getPreTaxDataBasicUnitMap(taxFileFidList, Sets.newHashSetWithExpectedSize((int)0));
    }

    public static Map<Long, PreTaxDataBasicUnit> getPreTaxDataBasicUnitMap(List<Long> taxFileFidList, Set<Long> unUpdatedTaxFileVIds) {
        if (!CollectionUtils.isEmpty(unUpdatedTaxFileVIds)) {
            taxFileFidList.addAll(unUpdatedTaxFileVIds);
        }
        HRBaseServiceHelper taxFileHelper = new HRBaseServiceHelper("itc_taxfile");
        HashMap map = Maps.newHashMapWithExpectedSize((int)taxFileFidList.size());
        DynamicObject[] taxFileDys = taxFileHelper.query(SELECTED_PROPS, new QFilter[]{new QFilter("id", "in", taxFileFidList)});
        Arrays.stream(taxFileDys).forEach(dy -> {
            Long taxFileFid = dy.getLong("id");
            Long taxFileBoid = dy.getLong("boid");
            PreTaxDataBasicUnit preTaxDataBasicUnit = new PreTaxDataBasicUnit();
            preTaxDataBasicUnit.setTaxFileVId(taxFileFid);
            preTaxDataBasicUnit.setTaxFileBoid(taxFileBoid);
            preTaxDataBasicUnit.setTaxFileDy((DynamicObject)dy);
            map.put(taxFileBoid, preTaxDataBasicUnit);
        });
        Map<Long, List<DynamicObject>> declareRecordMap = InitTaxDataBasicHelper.getDeclareRecordMap(Lists.newArrayList(map.keySet()));
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Boolean currentVersionIsDeclared;
            Map.Entry entry = iterator.next();
            Long taxFileBoid = (Long)entry.getKey();
            PreTaxDataBasicUnit preTaxDataBasicUnit = (PreTaxDataBasicUnit)entry.getValue();
            Long taxFileVId = preTaxDataBasicUnit.getTaxFileVId();
            List<DynamicObject> declareRecords = declareRecordMap.get(taxFileBoid);
            if (CollectionUtils.isEmpty(declareRecords)) {
                preTaxDataBasicUnit.setCurrentVersionIsDeclared(Boolean.FALSE);
                preTaxDataBasicUnit.setLastDeclareRecord(null);
                continue;
            }
            DynamicObject lastDeclareRecord = declareRecords.get(0);
            preTaxDataBasicUnit.setLastDeclareRecord(lastDeclareRecord);
            for (DynamicObject declareRecord : declareRecords) {
                Long declareRecordTaxFileVId = declareRecord.getLong("taxdatabasicid.taxfile.id");
                if (!taxFileVId.equals(declareRecordTaxFileVId)) continue;
                preTaxDataBasicUnit.setCurrentVersionIsDeclared(Boolean.TRUE);
                break;
            }
            if (null == (currentVersionIsDeclared = preTaxDataBasicUnit.getCurrentVersionIsDeclared())) {
                preTaxDataBasicUnit.setCurrentVersionIsDeclared(Boolean.FALSE);
            }
            String taxStatus = preTaxDataBasicUnit.getTaxFileDy().getString("taxstatus");
            if (null == currentVersionIsDeclared || !YesOrNoEnum.NO.getCode().equals(taxStatus) || !currentVersionIsDeclared.booleanValue() || !CollectionUtils.isEmpty(unUpdatedTaxFileVIds) && unUpdatedTaxFileVIds.contains(taxFileVId)) continue;
            iterator.remove();
        }
        return map;
    }

    public static void doUpdateTaxDataBasic(TaxTaskEntity taxTaskEntity, Map<Long, DynamicObject> updateTaxDataBasicMap, Map<Long, Long> updatedTaxFileIdMap, List<DynamicObject> abandonedTaxDataBasicDys, Map<Long, DynamicObject> unUpdatedTaxDataBasic) {
        if (CollectionUtils.isEmpty(updatedTaxFileIdMap) && CollectionUtils.isEmpty(unUpdatedTaxDataBasic)) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOGGER.info("1---thread is [{}], doUpdateTaxDataBasic begin, updatedTaxFileIdMap size is [{}]", (Object)Thread.currentThread().getName(), (Object)updatedTaxFileIdMap.size());
        Map<Object, Object> unUpdatedTaxFileIdMap = Maps.newHashMapWithExpectedSize((int)0);
        if (!CollectionUtils.isEmpty(unUpdatedTaxDataBasic)) {
            unUpdatedTaxFileIdMap = unUpdatedTaxDataBasic.values().stream().collect(Collectors.toMap(dy -> dy.getLong("taxfile.boid"), dy -> dy.getLong("taxfile.id"), (k1, k2) -> k1));
        }
        Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap = InitTaxDataBasicHelper.getPreTaxDataBasicUnitMap(Lists.newArrayList(updatedTaxFileIdMap.values()), Sets.newHashSet(unUpdatedTaxFileIdMap.values()));
        ArrayList preTaxDataBasicUnits = Lists.newArrayList(preTaxDataBasicUnitMap.values());
        LOGGER.info("2---thread is [{}], task number is [{}], getPreTaxDataBasicUnitMap finish size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), preTaxDataBasicUnitMap.size(), stopwatch.elapsed().toMillis()});
        HashSet updateBoidSet = Sets.newHashSet(preTaxDataBasicUnitMap.keySet());
        HashSet abandonBoidSet = Sets.newHashSet(updatedTaxFileIdMap.keySet());
        abandonBoidSet.removeAll(updateBoidSet);
        Iterator<Map.Entry<Long, DynamicObject>> it = updateTaxDataBasicMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, DynamicObject> entry = it.next();
            if (!abandonBoidSet.contains(entry.getKey())) continue;
            abandonedTaxDataBasicDys.add(entry.getValue());
            it.remove();
        }
        ArrayList infoChangeDos = Lists.newArrayListWithExpectedSize((int)preTaxDataBasicUnits.size());
        HashSet noChangeTaxFileBoids = Sets.newHashSetWithExpectedSize((int)preTaxDataBasicUnits.size());
        LOGGER.info("3---thread is [{}], task number is [{}], before findLatestVersionByFileBoIdsAndDate, time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        ArrayList taxFileBoIds = Lists.newArrayList(preTaxDataBasicUnitMap.keySet());
        if (!CollectionUtils.isEmpty((Map)unUpdatedTaxFileIdMap)) {
            taxFileBoIds.removeAll(unUpdatedTaxFileIdMap.keySet());
        }
        TaxPeriodEntity taxPeriodEntity = taxTaskEntity.getTaxPeriodEntity();
        Map versionMap = TaxFileInfoServiceFactory.findLatestVersionByFileBoIdsAndDate((String)"itc", (List)taxFileBoIds, (Date)taxPeriodEntity.getStartDate(), (Date)taxPeriodEntity.getEndDate());
        LOGGER.info("4---thread is [{}], task number is [{}], after findLatestVersionByFileBoIdsAndDate, time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        for (Map.Entry<Long, DynamicObject> entry : updateTaxDataBasicMap.entrySet()) {
            Long taxFileBoid = entry.getKey();
            DynamicObject taxDataBasicDy = entry.getValue();
            DynamicObject taxFileDy = preTaxDataBasicUnitMap.get(taxFileBoid).getTaxFileDy();
            SitBaseUtil.initSystemProp4Update((DynamicObject)taxDataBasicDy);
            InitTaxDataBasicHelper.setTaxDataBasicProperties(preTaxDataBasicUnitMap, infoChangeDos, noChangeTaxFileBoids, versionMap, taxFileDy, taxDataBasicDy);
        }
        for (Map.Entry<Long, DynamicObject> entry : unUpdatedTaxDataBasic.entrySet()) {
            DynamicObject taxDataBasicDy = entry.getValue();
            SitBaseUtil.initSystemProp4Update((DynamicObject)taxDataBasicDy);
            InitTaxDataBasicHelper.versionComparison(preTaxDataBasicUnitMap, infoChangeDos, noChangeTaxFileBoids, taxDataBasicDy);
        }
        LOGGER.info("5---thread is [{}], task number is [{}], after updating taxdatabasic dys, time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        LOGGER.info("in doUpdateTaxDataBasic, updateTaxDataBasicMap.values() is:{}", updateTaxDataBasicMap.values().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        LOGGER.info("in doUpdateTaxDataBasic, infoChangeDos is:{}", (Object)((Object)infoChangeDos).toString());
        LOGGER.info("in doUpdateTaxDataBasic, noChangeTaxFileBoids is:{}", (Object)((Object)noChangeTaxFileBoids).toString());
        LOGGER.info("in doUpdateTaxDataBasic, preTaxDataBasicUnitMap. is:{}", (Object)preTaxDataBasicUnitMap.values().toString());
        ArrayList taxDataBasicDys = Lists.newArrayList(updateTaxDataBasicMap.values());
        if (!CollectionUtils.isEmpty(unUpdatedTaxDataBasic)) {
            taxDataBasicDys.addAll(unUpdatedTaxDataBasic.values());
        }
        InitTaxDataBasicHelper.determineChangeType(taxDataBasicDys, infoChangeDos, noChangeTaxFileBoids, preTaxDataBasicUnitMap);
        LOGGER.info("6---thread is [{}], task number is [{}], after determineChangeType, time is [{}]", new Object[]{Thread.currentThread().getName(), taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        stopwatch.stop();
    }

    private static void versionComparison(Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap, List<InfoChangeDo> infoChangeDos, Set<Long> noChangeTaxFileBoids, DynamicObject taxDataBasicDy) {
        Long taxFileBoid = taxDataBasicDy.getLong("taxfile.boid");
        String taxStatus = taxDataBasicDy.getString("taxfile.taxstatus");
        PreTaxDataBasicUnit preTaxDataBasicUnit = preTaxDataBasicUnitMap.get(taxFileBoid);
        DynamicObject lastDeclareRecord = preTaxDataBasicUnit.getLastDeclareRecord();
        if (Objects.nonNull(lastDeclareRecord)) {
            InfoChangeDo infoChangeDo = new InfoChangeDo();
            infoChangeDo.setTaxFileBoId(taxFileBoid);
            HashMap data = Maps.newHashMapWithExpectedSize((int)TAXFILE_PROPS.length);
            boolean allEqual = true;
            for (String key : TAXFILE_PROPS) {
                OldNewValue oldNewValue = new OldNewValue();
                oldNewValue.setKey(key);
                Long currVId = 0L;
                Object obj = taxDataBasicDy.get(key);
                if (obj instanceof DynamicObject) {
                    currVId = ((DynamicObject)obj).getLong("id");
                } else if (obj instanceof Long) {
                    currVId = (Long)obj;
                }
                Long lastVId = lastDeclareRecord.getLong("taxdatabasicid." + key + ".id");
                if (!currVId.equals(lastVId)) {
                    allEqual = false;
                }
                oldNewValue.setNewId(currVId);
                oldNewValue.setLastId(lastVId);
                data.put("itc_" + key, oldNewValue);
            }
            if (allEqual && YesOrNoEnum.YES.getCode().equals(taxStatus)) {
                noChangeTaxFileBoids.add(taxFileBoid);
            } else {
                infoChangeDo.setData((Map)data);
                infoChangeDos.add(infoChangeDo);
            }
        }
    }

    public static List<PreTaxDataBasicUnit> taxDataBasicDyList2PreTaxDataBasicUnitList(List<?> data) {
        if (CollectionUtils.isEmpty(data)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList taxDataBasicDyList = Lists.newArrayListWithExpectedSize((int)data.size());
        for (Object obj : data) {
            taxDataBasicDyList.add((DynamicObject)obj);
        }
        ArrayList preTaxDataBasicUnitList = Lists.newArrayListWithExpectedSize((int)taxDataBasicDyList.size());
        for (DynamicObject taxDataBasicDy : taxDataBasicDyList) {
            PreTaxDataBasicUnit preTaxDataBasicUnit = new PreTaxDataBasicUnit();
            preTaxDataBasicUnit.setTaxDataBasic(taxDataBasicDy);
            preTaxDataBasicUnitList.add(preTaxDataBasicUnit);
        }
        return preTaxDataBasicUnitList;
    }

    public static void filterUpdatedChangeTypeAndDeclareStatusTaxDataBasic(Map<Long, DynamicObject> unUpdatedTaxDataBasic) {
        if (CollectionUtils.isEmpty(unUpdatedTaxDataBasic)) {
            return;
        }
        Iterator<Map.Entry<Long, DynamicObject>> iterator = unUpdatedTaxDataBasic.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, DynamicObject> entry = iterator.next();
            DynamicObject taxDataBasicDy = entry.getValue();
            if (!InitTaxDataBasicHelper.isDeclared(taxDataBasicDy)) continue;
            iterator.remove();
        }
    }

    private static boolean isDeclared(DynamicObject taxDataBasicDy) {
        return DeclareStatusEnums.DECLARED.getCode() == taxDataBasicDy.getInt(DECLARESTATUS);
    }
}

