/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtask;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.common.model.changetypemodel.InfoChangeDo;
import kd.sit.itc.common.model.changetypemodel.JudgeKeyBizInfoChangedContext;
import kd.sit.itc.common.model.changetypemodel.OldNewValue;
import kd.sit.sitbp.business.servicehelper.SITBaseDataHelper;

public class KeyBizInfoChangedHelper {
    private static final Log LOGGER = LogFactory.getLog(KeyBizInfoChangedHelper.class);

    public static void judgeKeyBizInfoChanged(List<InfoChangeDo> infos) {
        if (CollectionUtils.isEmpty(infos)) {
            return;
        }
        HashMap taxFileSubInfoIds = Maps.newHashMapWithExpectedSize((int)16);
        HashMap taxFileSubInfoAndTaxFileIds = Maps.newHashMapWithExpectedSize((int)16);
        HashMap newAndLastIds = Maps.newHashMapWithExpectedSize((int)16);
        HashMap newIdLasIdAndTaxFileBoIds = Maps.newHashMapWithExpectedSize((int)16);
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"itc_taxfilekeybizinfochanged");
        List selectFields = queryEntityType.getSelectFields();
        List joinEntitys = queryEntityType.getJoinEntitys();
        Set entityNames = joinEntitys.stream().map(JoinEntity::getEntityName).collect(Collectors.toSet());
        String alias = queryEntityType.getEntityAlias();
        entityNames.add(alias);
        HashSet changeIds = Sets.newHashSetWithExpectedSize((int)16);
        HashMap selectFieldMap = Maps.newHashMapWithExpectedSize((int)entityNames.size());
        HashSet aliasFieldSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet notAliasFieldSet = Sets.newHashSetWithExpectedSize((int)16);
        for (String entityName : entityNames) {
            HashSet fields = Sets.newHashSetWithExpectedSize((int)16);
            for (QuerySelectField querySelectField : selectFields) {
                String fieldName = querySelectField.getAlias();
                if (fieldName.contains(entityName)) {
                    String str = fieldName.replace(entityName + ".", "");
                    fields.add(str);
                    aliasFieldSet.remove(fieldName);
                    notAliasFieldSet.add(fieldName);
                    continue;
                }
                if (notAliasFieldSet.contains(fieldName)) continue;
                aliasFieldSet.add(fieldName);
            }
            selectFieldMap.put(entityName, fields);
        }
        selectFieldMap.put(alias, aliasFieldSet);
        for (InfoChangeDo info2 : infos) {
            Map data = info2.getData();
            for (Map.Entry entry : data.entrySet()) {
                HashSet subInfoIdSet;
                String key = (String)entry.getKey();
                if (!entityNames.contains(key) || !selectFieldMap.containsKey(key) || CollectionUtils.isEmpty((Collection)((Collection)selectFieldMap.get(key)))) continue;
                Set set = taxFileSubInfoIds.computeIfAbsent(key, k1 -> Sets.newHashSetWithExpectedSize((int)16));
                OldNewValue value = (OldNewValue)entry.getValue();
                if (!KeyBizInfoChangedHelper.isContinueAndSetIds(info2, value, set, changeIds, subInfoIdSet = Sets.newHashSetWithExpectedSize((int)2))) continue;
                Map map = taxFileSubInfoAndTaxFileIds.computeIfAbsent(entry.getKey(), k1 -> Maps.newHashMapWithExpectedSize((int)16));
                map.putIfAbsent(info2.getTaxFileBoId(), subInfoIdSet);
                taxFileSubInfoAndTaxFileIds.putIfAbsent(key, map);
                Map newAndLastIdMap = newAndLastIds.computeIfAbsent(entry.getKey(), k1 -> Maps.newHashMapWithExpectedSize((int)16));
                newAndLastIdMap.putIfAbsent(((OldNewValue)entry.getValue()).getNewId(), ((OldNewValue)entry.getValue()).getLastId());
                newIdLasIdAndTaxFileBoIds.put(((OldNewValue)entry.getValue()).getNewId(), info2.getTaxFileBoId());
                newIdLasIdAndTaxFileBoIds.put(((OldNewValue)entry.getValue()).getLastId(), info2.getTaxFileBoId());
            }
        }
        Map<Long, InfoChangeDo> infoChangeDoMap = infos.stream().collect(Collectors.toMap(InfoChangeDo::getTaxFileBoId, info -> info, (v1, v2) -> v1));
        JudgeKeyBizInfoChangedContext judgeKeyBizInfoChangedContext = new JudgeKeyBizInfoChangedContext((Set)changeIds, (Map)taxFileSubInfoAndTaxFileIds, (Map)taxFileSubInfoIds, (Map)selectFieldMap, (Map)newAndLastIds, (Map)newIdLasIdAndTaxFileBoIds);
        for (String entityName : entityNames) {
            Set changeSubInfoIds;
            Set set = judgeKeyBizInfoChangedContext.getIds(entityName);
            if (CollectionUtils.isEmpty((Collection)set)) {
                LOGGER.info("entityName is empty{}", (Object)entityName);
                continue;
            }
            LOGGER.info("KeyBizInfoChangedHelper WYF002 :{}---{}", (Object)entityName, (Object)set.toString());
            if (!CollectionUtils.isEmpty((Collection)changeIds) && !CollectionUtils.isEmpty((Collection)(changeSubInfoIds = judgeKeyBizInfoChangedContext.getIdsByChangeId((Set)changeIds, entityName)))) {
                set.removeAll(changeSubInfoIds);
            }
            if (CollectionUtils.isEmpty((Collection)set)) {
                LOGGER.info("KeyBizInfoChangedHelper WYF003331 ids empty :{}", (Object)entityName);
                LOGGER.info("KeyBizInfoChangedHelper WYF003332 ids empty changeIds :{}", (Object)((Object)changeIds).toString());
                continue;
            }
            LOGGER.info("KeyBizInfoChangedHelper WYF0033334 :{}----{}", (Object)entityName, (Object)set.toString());
            KeyBizInfoChangedHelper.doJudgeKeyBizInfoChanged(judgeKeyBizInfoChangedContext, entityName, set, changeIds);
        }
        for (Long changeId : changeIds) {
            InfoChangeDo infoChangeDo = infoChangeDoMap.get(changeId);
            LOGGER.info("KeyBizInfoChangedHelper WYF00020230207 :{}", (Object)changeId);
            infoChangeDo.setInfoChange(true);
        }
    }

    private static boolean isContinueAndSetIds(InfoChangeDo info, OldNewValue value, Set<Long> ids, Set<Long> changeIds, Set<Long> subInfoIdSet) {
        Long newId = value.getNewId();
        Long lastId = value.getLastId();
        if (null == newId && null == lastId) {
            return false;
        }
        if (null != newId && newId.equals(lastId)) {
            return false;
        }
        if (null != newId && null != lastId && newId != 0L && lastId != 0L) {
            ids.add(newId);
            subInfoIdSet.add(newId);
            ids.add(lastId);
            subInfoIdSet.add(lastId);
            return true;
        }
        changeIds.add(info.getTaxFileBoId());
        return false;
    }

    private static void doJudgeKeyBizInfoChanged(JudgeKeyBizInfoChangedContext judgeKeyBizInfoChangedContext, String entityName, Set<Long> ids, Set<Long> changeIds) {
        try {
            if (CollectionUtils.isEmpty(ids)) {
                LOGGER.info("KeyBizInfoChangedHelper WYF00331 :{}", (Object)entityName);
                return;
            }
            Set fieldSets = judgeKeyBizInfoChangedContext.getSelectFieldMapByName(entityName);
            DynamicObject[] dys = KeyBizInfoChangedHelper.getDatas(entityName, ids, String.join((CharSequence)",", fieldSets));
            if (null == dys || dys.length == 0) {
                return;
            }
            LOGGER.info("KeyBizInfoChangedHelper WYF0034 :{}---{}", (Object)entityName, (Object)ids.toString());
            KeyBizInfoChangedHelper.judgeChanged(dys, judgeKeyBizInfoChangedContext, entityName, changeIds);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
    }

    private static void judgeChanged(DynamicObject[] dys, JudgeKeyBizInfoChangedContext judgeContext, String entityName, Set<Long> changeIds) {
        Map<Long, DynamicObject> map = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        Map newAndLastIds = judgeContext.getNewAndLastIdsByEntityName(entityName);
        LOGGER.info("KeyBizInfoChangedHelper WYF0035 :{}", (Object)entityName);
        for (Map.Entry entry : newAndLastIds.entrySet()) {
            DynamicObject newDy = map.get(entry.getKey());
            DynamicObject lastDy = map.get(entry.getValue());
            LOGGER.info("KeyBizInfoChangedHelper WYF0035 :{}----{}", entry.getKey(), entry.getValue());
            if (null == newDy && null == lastDy) continue;
            if (null == newDy) {
                changeIds.add(judgeContext.getTaxFileBoId(lastDy.getLong("id")));
                continue;
            }
            if (null == lastDy) {
                changeIds.add(judgeContext.getTaxFileBoId(newDy.getLong("id")));
                continue;
            }
            Set fields = judgeContext.getSelectFieldMapByName(entityName);
            if (!KeyBizInfoChangedHelper.doJudge(newDy, lastDy, fields)) continue;
            changeIds.add(judgeContext.getTaxFileBoId(newDy.getLong("id")));
        }
    }

    private static boolean doJudge(DynamicObject newDy, DynamicObject lastDy, Set<String> fields) {
        boolean isChange = false;
        String s1 = "" + newDy.getLong("id") + "---" + lastDy.getLong("id") + fields.toString();
        LOGGER.info("KeyBizInfoChangedHelper Changed boids is :{}", (Object)s1);
        for (String field : fields) {
            if (field.contains(".")) {
                String[] split = field.split("\\.");
                DynamicObject newObj = null;
                DynamicObject oldDy = null;
                DynamicObject newObject = null;
                DynamicObject oldDyObject = null;
                String fieldCode = null;
                for (int i = 0; i < split.length - 1; ++i) {
                    newObject = null == newObject ? (newObj = newDy.getDynamicObject(split[i])) : (newObj = newObject.getDynamicObject(split[i]));
                    oldDyObject = null == oldDyObject ? (oldDy = lastDy.getDynamicObject(split[i])) : (oldDy = oldDyObject.getDynamicObject(split[i]));
                    if (null == newObj || null == oldDy) break;
                    fieldCode = split[i + 1];
                }
                if (null == newObj && null == oldDy) continue;
                if (null == newObj || null == oldDy) {
                    isChange = true;
                    break;
                }
                if (SITBaseDataHelper.fieldIsEqual((DynamicObject)newObj, oldDy, fieldCode)) continue;
                isChange = true;
                break;
            }
            if (SITBaseDataHelper.fieldIsEqual((DynamicObject)newDy, (DynamicObject)lastDy, (String)field)) continue;
            isChange = true;
            break;
        }
        String s2 = "" + newDy.getLong("id") + "---" + lastDy.getLong("id") + fields + "--" + isChange;
        LOGGER.info("KeyBizInfoChangedHelper Changed boids is :{}", (Object)s2);
        return isChange;
    }

    private static DynamicObject[] getDatas(String key, Set<Long> ids, String selectFields) {
        LOGGER.info("KeyBizInfoChangedHelper WYF0033 :{}----{}-----{}", new Object[]{key, ids.toString(), selectFields});
        HRBaseServiceHelper helper = new HRBaseServiceHelper(key);
        ids.remove(0L);
        QFilter filter = new QFilter("id", "in", ids);
        return helper.query(selectFields, new QFilter[]{filter});
    }
}

