/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.common.constants.ItcCommConstants;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.enums.TaxTaskCheckTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.SitDateUtil;

public class TaxTaskCheckTypeHelper {
    public static Map<Long, TaxTaskCheckTypeEnum> checkInfoOfCategory(DynamicObject taxTask, List<DynamicObject> categoryEntryList) {
        List<Long> categoryIds;
        int yearMonth;
        if (taxTask == null || CollectionUtils.isEmpty(categoryEntryList)) {
            return Maps.newHashMap();
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)categoryEntryList.size());
        for (DynamicObject entryDy : categoryEntryList) {
            int taxDataNum = entryDy.getInt("taxdatanum");
            if (taxDataNum <= 0) continue;
            resultMap.putIfAbsent(entryDy.getLong("taxcategory.id"), TaxTaskCheckTypeEnum.TAX_RECORD_TYPE);
        }
        if (CollectionUtils.isEmpty(categoryEntryList = categoryEntryList.stream().filter(dy -> !resultMap.containsKey(dy.getLong("taxcategory.id"))).collect(Collectors.toList()))) {
            return resultMap;
        }
        long taxTaskId = taxTask.getLong("id");
        Map<Long, TaxTaskCheckTypeEnum> rawDataOfCat = TaxTaskCheckTypeHelper.checkRawDataOfCat(taxTaskId, yearMonth = SitDateUtil.toYearMonth((Date)taxTask.getDate("taxperiod.perioddate")), categoryIds = categoryEntryList.stream().map(dy -> dy.getLong("taxcategory.id")).collect(Collectors.toList()));
        if (!CollectionUtils.isEmpty(rawDataOfCat)) {
            resultMap.putAll(rawDataOfCat);
            categoryEntryList = categoryEntryList.stream().filter(dy -> !rawDataOfCat.containsKey(dy.getLong("taxcategory.id"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(categoryEntryList)) {
            return resultMap;
        }
        Map<Long, TaxTaskCheckTypeEnum> deductOfCat = TaxTaskCheckTypeHelper.checkDeductOfCat(taxTaskId, yearMonth, categoryIds);
        if (!CollectionUtils.isEmpty(deductOfCat)) {
            resultMap.putAll(deductOfCat);
        }
        return resultMap;
    }

    public static TaxTaskCheckTypeEnum checkInfoOfTask(DynamicObject taxTask) {
        if (taxTask == null) {
            return null;
        }
        Map<Long, TaxTaskCheckTypeEnum> checkResult = TaxTaskCheckTypeHelper.checkInfoOfTaskList(Collections.singletonList(taxTask));
        if (!CollectionUtils.isEmpty(checkResult)) {
            return checkResult.get(taxTask.getLong("id"));
        }
        return null;
    }

    public static Map<Long, TaxTaskCheckTypeEnum> checkInfoOfTaskList(List<DynamicObject> taxTasks) {
        if (CollectionUtils.isEmpty(taxTasks)) {
            return Maps.newHashMap();
        }
        HashMap failMsgMap = Maps.newHashMapWithExpectedSize((int)taxTasks.size());
        Map<Long, TaxTaskCheckTypeEnum> taxRecordOfTask = TaxTaskCheckTypeHelper.checkTaxRecord(taxTasks);
        if (!CollectionUtils.isEmpty(taxRecordOfTask)) {
            failMsgMap.putAll(taxRecordOfTask);
            taxTasks = taxTasks.stream().filter(dy -> !taxRecordOfTask.containsKey(dy.getLong("id"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(taxTasks)) {
            return failMsgMap;
        }
        Map<Long, TaxTaskCheckTypeEnum> rawDataOfTask = TaxTaskCheckTypeHelper.checkRawDataOfTask(taxTasks);
        if (!CollectionUtils.isEmpty(rawDataOfTask)) {
            failMsgMap.putAll(rawDataOfTask);
            taxTasks = taxTasks.stream().filter(dy -> !rawDataOfTask.containsKey(dy.getLong("id"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(taxTasks)) {
            return failMsgMap;
        }
        Map<Long, TaxTaskCheckTypeEnum> declareOfTask = TaxTaskCheckTypeHelper.checkDeclareOfTask(taxTasks);
        if (!CollectionUtils.isEmpty(declareOfTask)) {
            failMsgMap.putAll(declareOfTask);
            taxTasks = taxTasks.stream().filter(dy -> !declareOfTask.containsKey(dy.getLong("id"))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(taxTasks)) {
            return failMsgMap;
        }
        Map<Long, TaxTaskCheckTypeEnum> dataBasicOfTask = TaxTaskCheckTypeHelper.checkTaxDataBasicOfTask(taxTasks);
        if (!CollectionUtils.isEmpty(dataBasicOfTask)) {
            failMsgMap.putAll(dataBasicOfTask);
        }
        return failMsgMap;
    }

    public static Map<Long, TaxTaskCheckTypeEnum> checkTaxRecord(List<DynamicObject> taxTasks) {
        if (CollectionUtils.isEmpty(taxTasks)) {
            return Maps.newHashMap();
        }
        HashMap taxRecordResult = Maps.newHashMapWithExpectedSize((int)taxTasks.size());
        for (DynamicObject taxTask : taxTasks) {
            if (!taxTask.getBoolean("isexisttaxrecord")) continue;
            taxRecordResult.putIfAbsent(taxTask.getLong("id"), TaxTaskCheckTypeEnum.TAX_RECORD_TYPE);
        }
        return taxRecordResult;
    }

    public static Map<Long, TaxTaskCheckTypeEnum> checkRawDataOfTask(List<DynamicObject> taxTasks) {
        if (CollectionUtils.isEmpty(taxTasks)) {
            return Maps.newHashMap();
        }
        List taxTaskIds = taxTasks.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Set yearMonth = taxTasks.stream().map(dy -> SitDateUtil.toYearMonth((Date)dy.getDate("taxperiod.perioddate"))).collect(Collectors.toSet());
        ArrayList rawDataFilters = Lists.newArrayList();
        rawDataFilters.add(new QFilter("taxtask.id", "in", taxTaskIds));
        rawDataFilters.add(new QFilter("yearmonth", "in", yearMonth));
        rawDataFilters.add(new QFilter("status", "not in", Arrays.asList("D", "E")));
        HashMap checkResult = Maps.newHashMap();
        if (taxTaskIds.size() == 1) {
            if (new HRBaseServiceHelper("itc_taxrawdata").isExists(rawDataFilters.toArray(new QFilter[0]))) {
                checkResult.put(taxTaskIds.get(0), TaxTaskCheckTypeEnum.RAW_DATA_TYPE);
            }
            return checkResult;
        }
        Map batchMap = SitDataServiceHelper.queryHaveDataByGroup((String)TaxTaskCheckTypeHelper.class.getName(), (String)"itc_taxrawdata", (String)"taxtask.id", (QFilter[])rawDataFilters.toArray(new QFilter[0]));
        batchMap.forEach((k1, v1) -> {
            if (v1.booleanValue()) {
                checkResult.putIfAbsent((Long)k1, TaxTaskCheckTypeEnum.RAW_DATA_TYPE);
            }
        });
        return checkResult;
    }

    public static Map<Long, TaxTaskCheckTypeEnum> checkDeclareOfTask(List<DynamicObject> taxTasks) {
        if (CollectionUtils.isEmpty(taxTasks)) {
            return Maps.newHashMap();
        }
        List taxTaskIds = taxTasks.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Set yearMonth = taxTasks.stream().map(dy -> SitDateUtil.toYearMonth((Date)dy.getDate("taxperiod.perioddate"))).collect(Collectors.toSet());
        ArrayList basicFilters = Lists.newArrayList();
        basicFilters.add(new QFilter("taxtask.id", "in", taxTaskIds));
        basicFilters.add(new QFilter("yearmonth", "in", yearMonth));
        basicFilters.add(new QFilter("status", "not in", Arrays.asList("D", "E")));
        HRBaseServiceHelper basicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        DynamicObject[] basicDys = basicHelper.query("id,taxtask.id", basicFilters.toArray(new QFilter[0]));
        if (basicDys == null || basicDys.length == 0) {
            return Maps.newHashMap();
        }
        HashMap basicIdsOfTask = Maps.newHashMapWithExpectedSize((int)taxTasks.size());
        for (DynamicObject basicDy : basicDys) {
            basicIdsOfTask.computeIfAbsent(basicDy.getLong("taxtask.id"), key -> Lists.newArrayList()).add(basicDy.getLong("id"));
        }
        List basicIds = Arrays.stream(basicDys).map(dy -> dy.getLong("id")).collect(Collectors.toList());
        QFilter declareFilter = new QFilter("taxdatabasicid", "in", basicIds);
        declareFilter.and("declarestatus", "=", (Object)YesOrNoEnum.YES.getCode());
        HRBaseServiceHelper declareHelper = new HRBaseServiceHelper("itc_persondeclarerecord");
        DynamicObject[] declareDys = declareHelper.query("taxdatabasicid", new QFilter[]{declareFilter});
        if (declareDys == null || declareDys.length == 0) {
            return Maps.newHashMap();
        }
        List declareBasicIds = Arrays.stream(declareDys).map(dy -> dy.getLong("taxdatabasicid.id")).collect(Collectors.toList());
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)taxTasks.size());
        for (Map.Entry entry : basicIdsOfTask.entrySet()) {
            if (!((List)entry.getValue()).containsAll(declareBasicIds)) continue;
            resultMap.put(entry.getKey(), TaxTaskCheckTypeEnum.DECLARE_TYPE);
        }
        return resultMap;
    }

    public static Map<Long, TaxTaskCheckTypeEnum> checkTaxDataBasicOfTask(List<DynamicObject> taxTasks) {
        if (CollectionUtils.isEmpty(taxTasks)) {
            return Maps.newHashMap();
        }
        List taxTaskIds = taxTasks.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Set yearMonth = taxTasks.stream().map(dy -> SitDateUtil.toYearMonth((Date)dy.getDate("taxperiod.perioddate"))).collect(Collectors.toSet());
        ArrayList basicFilters = Lists.newArrayList();
        basicFilters.add(new QFilter("taxtask.id", "in", taxTaskIds));
        basicFilters.add(new QFilter("yearmonth", "in", yearMonth));
        basicFilters.add(new QFilter("status", "not in", Arrays.asList("D", "E")));
        QFilter specificFilter = new QFilter("preparestatus", "=", (Object)YesOrNoEnum.YES.getCode());
        specificFilter.or("bizstatus", "=", (Object)YesOrNoEnum.YES.getCode());
        basicFilters.add(specificFilter);
        if (taxTaskIds.size() == 1) {
            HashMap result = Maps.newHashMap();
            DynamicObject taxDataBasic = new HRBaseServiceHelper("itc_taxdatabasic").queryOne("taxtask.id,preparestatus,bizstatus", basicFilters.toArray(new QFilter[0]), "preparestatus desc,bizstatus desc");
            if (taxDataBasic != null) {
                if (YesOrNoEnum.isYes((String)taxDataBasic.getString("preparestatus"))) {
                    result.put(taxDataBasic.getLong("taxtask.id"), TaxTaskCheckTypeEnum.PREPARE_DATA_TYPE);
                    return result;
                }
                if (YesOrNoEnum.isYes((String)taxDataBasic.getString("bizstatus"))) {
                    result.put(taxDataBasic.getLong("taxtask.id"), TaxTaskCheckTypeEnum.DEDUCT_TYPE);
                    return result;
                }
            }
        }
        return TaxTaskCheckTypeHelper.queryDataBasicByGroup(basicFilters.toArray(new QFilter[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Long, TaxTaskCheckTypeEnum> queryDataBasicByGroup(QFilter[] filters) {
        HashMap groupResult = Maps.newHashMap();
        DataSet copy4group = null;
        DataSet groupCount = null;
        try {
            copy4group = QueryServiceHelper.queryDataSet((String)TaxTaskCheckTypeHelper.class.getName(), (String)"itc_taxdatabasic", (String)"taxtask.id,preparestatus,bizstatus", (QFilter[])filters, (String)"");
            groupCount = copy4group.distinct().groupBy(new String[]{"taxtask.id", "preparestatus", "bizstatus"}, new boolean[]{false, true, true}).finish();
            for (Row row : groupCount) {
                if (groupResult.containsKey(row.getLong("taxtask.id"))) continue;
                if (YesOrNoEnum.isYes((String)row.getString("preparestatus"))) {
                    groupResult.put(row.getLong("taxtask.id"), TaxTaskCheckTypeEnum.PREPARE_DATA_TYPE);
                    continue;
                }
                if (!YesOrNoEnum.isYes((String)row.getString("bizstatus"))) continue;
                groupResult.put(row.getLong("taxtask.id"), TaxTaskCheckTypeEnum.DEDUCT_TYPE);
            }
        }
        finally {
            if (copy4group != null) {
                copy4group.close();
            }
            if (groupCount != null) {
                groupCount.close();
            }
        }
        return groupResult;
    }

    private static Map<Long, TaxTaskCheckTypeEnum> checkRawDataOfCat(long taxTaskId, int yearMonth, List<Long> categoryIds) {
        ArrayList rawDataFilters = Lists.newArrayList();
        rawDataFilters.add(new QFilter("taxtask.id", "=", (Object)taxTaskId));
        rawDataFilters.add(new QFilter("taxcategory.id", "in", categoryIds));
        rawDataFilters.add(new QFilter("yearmonth", "=", (Object)yearMonth));
        rawDataFilters.add(new QFilter("status", "not in", Arrays.asList("D", "E")));
        HashMap checkResult = Maps.newHashMap();
        Map batchMap = SitDataServiceHelper.queryHaveDataByGroup((String)TaxTaskCheckTypeHelper.class.getName(), (String)"itc_taxrawdata", (String)"taxcategory.id", (QFilter[])rawDataFilters.toArray(new QFilter[0]));
        batchMap.forEach((k1, v1) -> {
            if (v1.booleanValue()) {
                checkResult.putIfAbsent((Long)k1, TaxTaskCheckTypeEnum.RAW_DATA_TYPE);
            }
        });
        return checkResult;
    }

    private static Map<Long, TaxTaskCheckTypeEnum> checkDeductOfCat(long taxTaskId, int yearMonth, List<Long> categoryIds) {
        if (!categoryIds.contains(ItcCommConstants.NORMAL_SALARY_INCOME_ID)) {
            return Maps.newHashMap();
        }
        ArrayList deductFilters = Lists.newArrayList();
        deductFilters.add(new QFilter("taxtask.id", "=", (Object)taxTaskId));
        deductFilters.add(new QFilter("yearmonth", "=", (Object)yearMonth));
        deductFilters.add(new QFilter("status", "not in", Arrays.asList("D", "E")));
        deductFilters.add(new QFilter("bizstatus", "=", (Object)YesOrNoEnum.YES.getCode()));
        HashMap checkResult = Maps.newHashMap();
        if (new HRBaseServiceHelper("itc_taxdatabasic").isExists(deductFilters.toArray(new QFilter[0]))) {
            checkResult.put(ItcCommConstants.NORMAL_SALARY_INCOME_ID, TaxTaskCheckTypeEnum.DEDUCT_TYPE);
        }
        return checkResult;
    }
}

