/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtask;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxsrcdata.TaxSrcDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.util.MultiLangHelper;
import kd.sit.sitbp.common.constants.SITConstants;
import kd.sit.sitbp.common.entity.TaxGroupEntity;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.DataHolder;
import kd.sit.sitbp.common.util.GlobalParam;

public class TaxTaskServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskServiceHelper.class);

    public static BaseResult<TaxTaskEntity> loadTaxTaskEntity(Long taxTaskId) {
        if (ObjectUtils.isEmpty((Object)taxTaskId)) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u65e0\u6548\u7684\u4e2a\u7a0e\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaxTaskViewHelper_3", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        DynamicObject dynamicObject = TaxTaskServiceHelper.queryOne(taxTaskId);
        if (dynamicObject == null) {
            return BaseResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u53ef\u80fd\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaxTaskViewHelper_1", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        TaxTaskEntity taxTaskEntity = new TaxTaskEntity().initBy(dynamicObject);
        taxTaskEntity.setCountryId(Long.valueOf(1000001L));
        if (!taxTaskEntity.isAvailable()) {
            String msg = ResManager.loadKDString((String)"\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u53ef\u80fd\u5df2\u5931\u6548\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaxTaskViewHelper_2", (String)"sit-itc-business", (Object[])new Object[0]);
            BaseResult result = BaseResult.fail((String)msg);
            result.setData((Object)taxTaskEntity);
            return result;
        }
        DataHolder fromDb = new DataHolder((Object)Boolean.TRUE);
        TaxTaskServiceHelper.loadTaxGroups(taxTaskEntity, false, (DataHolder<Boolean>)fromDb);
        TaxTaskServiceHelper.loadTaxItemMap(taxTaskEntity);
        return BaseResult.success((Object)taxTaskEntity);
    }

    public static BaseResult<TaxTaskEntity> reInitFromBd(TaxTaskEntity taxTaskEntity) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtask");
        try {
            DynamicObject dynamicObject = serviceHelper.queryOne((Object)taxTaskEntity.getId());
            taxTaskEntity.initBy(dynamicObject);
            return BaseResult.success((Object)taxTaskEntity);
        }
        catch (Exception e) {
            BaseResult result = BaseResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u4e2a\u7a0e\u4efb\u52a1\u53ef\u80fd\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TaxTaskViewHelper_1", (String)"sit-itc-business", (Object[])new Object[0]));
            result.setData((Object)taxTaskEntity);
            return result;
        }
    }

    public static DynamicObject queryOne(Long taxTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtask");
        try {
            return serviceHelper.queryOne((Object)taxTaskId);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return null;
        }
    }

    public static void clearCache(Long taxTaskId) {
        IHRAppCache cache = HRAppCache.get((String)"itc_taxtask");
        String cacheKey = TaxTaskEntity.cacheKey((Long)taxTaskId);
        cache.remove(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseResult<TaxTaskEntity> countFileForTask(TaxTaskEntity taxTaskEntity) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtask");
        DynamicObject taskObj = taxTaskEntity.taxTask();
        if (taskObj == null) {
            BaseResult<TaxTaskEntity> result = TaxTaskServiceHelper.reInitFromBd(taxTaskEntity);
            if (!result.isSuccess()) {
                return result;
            }
            taskObj = taxTaskEntity.taxTask();
        }
        QFilter[] filters = new QFilter[]{new QFilter("taxtask", "=", (Object)taxTaskEntity.getId()), new QFilter("yearmonth", "=", (Object)taxTaskEntity.yearMonth()), new QFilter("status", "!=", (Object)"E"), new QFilter("taxdatabasic.calstatus", "=", (Object)YesOrNoEnum.YES.getCode())};
        DataSet dataSet = null;
        DataSet copy4Category = null;
        DataSet count = null;
        DataSet copy4TaxUnit = null;
        DataSet num = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)TaxSrcDataServiceHelper.class.getName(), (String)"itc_taxdata", (String)"taxcategory.id,taxfile.id", (QFilter[])filters, (String)"");
            copy4Category = dataSet.copy();
            int taxPersonCount = dataSet.count("taxfile.id", true);
            taskObj.set("taxpersoncount", (Object)taxPersonCount);
            taskObj.set("isexisttaxrecord", (Object)(taxPersonCount > 0 ? 1 : 0));
            count = copy4Category.groupBy(new String[]{"taxcategory.id"}).count("num").finish();
            DynamicObjectCollection taxTaskCatgEntry = taskObj.getDynamicObjectCollection("taxtaskcatgentry");
            for (DynamicObject cat : taxTaskCatgEntry) {
                cat.set("taxdatanum", (Object)0);
            }
            block4: for (Row row : count) {
                Long catId = row.getLong("taxcategory.id");
                for (DynamicObject cat : taxTaskCatgEntry) {
                    if (catId.longValue() != cat.getLong("taxcategory.id")) continue;
                    cat.set("taxdatanum", (Object)row.getInteger("num"));
                    continue block4;
                }
            }
            copy4TaxUnit = QueryServiceHelper.queryDataSet((String)TaxSrcDataServiceHelper.class.getName(), (String)"itc_taxdata", (String)"taxfile.id,taxfile.taxunit.id", (QFilter[])filters, (String)"");
            num = copy4TaxUnit.distinct().groupBy(new String[]{"taxfile.taxunit.id"}).count("num").finish();
            DynamicObjectCollection taxTaskUnitEntry = taskObj.getDynamicObjectCollection("taxtaskunitentry");
            for (DynamicObject unit : taxTaskUnitEntry) {
                unit.set("taxfilenum", (Object)0);
            }
            block7: for (Row row : num) {
                Long catId = row.getLong("taxfile.taxunit.id");
                for (DynamicObject unit : taxTaskUnitEntry) {
                    if (catId.longValue() != unit.getLong("taxunit.id")) continue;
                    unit.set("taxfilenum", (Object)row.getInteger("num"));
                    continue block7;
                }
            }
            serviceHelper.saveOne(taskObj);
            Iterator iterator = BaseResult.success(null);
            return iterator;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (copy4Category != null) {
                copy4Category.close();
            }
            if (count != null) {
                count.close();
            }
            if (copy4TaxUnit != null) {
                copy4TaxUnit.close();
            }
            if (num != null) {
                num.close();
            }
        }
    }

    public static List<TaxGroupEntity> loadTaxGroups(TaxTaskEntity taxTaskEntity) {
        return TaxTaskServiceHelper.loadTaxGroups(taxTaskEntity, true, (DataHolder<Boolean>)new DataHolder((Object)Boolean.TRUE));
    }

    private static List<TaxGroupEntity> loadTaxGroups(TaxTaskEntity taxTaskEntity, boolean updateCache, DataHolder<Boolean> fromDb) {
        if (!CollectionUtils.isEmpty((Collection)taxTaskEntity.getTaxGroupList())) {
            fromDb.set((Object)Boolean.FALSE);
            return taxTaskEntity.getTaxGroupList();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxgroup");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        QFilter countFilter = new QFilter("country.id", "=", (Object)taxTaskEntity.getCountryId());
        Object[] query = serviceHelper.query("id,number,name", new QFilter[]{filter, countFilter});
        if (ArrayUtils.isEmpty((Object[])query)) {
            return null;
        }
        ArrayList<TaxGroupEntity> result = new ArrayList<TaxGroupEntity>(query.length);
        for (Object obj : query) {
            TaxGroupEntity taxGroup = new TaxGroupEntity();
            result.add(taxGroup);
            taxGroup.setNumber(obj.getString("number"));
            taxGroup.setName((Map)obj.getLocaleString("name"));
        }
        taxTaskEntity.setTaxGroupList(result);
        if (updateCache) {
            IHRAppCache cache = HRAppCache.get((String)"itc_taxtask");
            cache.put(taxTaskEntity.cacheKey(), (Object)taxTaskEntity);
        }
        return result;
    }

    public static Map<Long, String> loadNetTaxAlgoMap(TaxTaskEntity taxTaskEntity) {
        return TaxTaskServiceHelper.loadNetTaxAlgoMap(taxTaskEntity, true, (DataHolder<Boolean>)new DataHolder((Object)Boolean.TRUE));
    }

    private static Map<Long, String> loadNetTaxAlgoMap(TaxTaskEntity taxTaskEntity, boolean updateCache, DataHolder<Boolean> fromDb) {
        if (!CollectionUtils.isEmpty((Map)taxTaskEntity.getNetTaxAlgoMap())) {
            fromDb.set((Object)Boolean.FALSE);
            return taxTaskEntity.getNetTaxAlgoMap();
        }
        HashMap<Long, String> netTaxAlgoMap = new HashMap<Long, String>(16);
        DynamicObject taxTaskObj = TaxTaskServiceHelper.queryTaxTaskSnapShot(taxTaskEntity.getId());
        DynamicObjectCollection enjoys = taxTaskObj.getDynamicObjectCollection("taxtasksnapent");
        for (DynamicObject entry : enjoys) {
            long taxCategoryId = entry.getDynamicObject("taxcategory").getLong("id");
            String expression = entry.getString("expression");
            netTaxAlgoMap.put(taxCategoryId, expression);
        }
        taxTaskEntity.setNetTaxAlgoMap(netTaxAlgoMap);
        if (updateCache) {
            IHRAppCache cache = HRAppCache.get((String)"itc_taxtask");
            cache.put(taxTaskEntity.cacheKey(), (Object)taxTaskEntity);
        }
        return netTaxAlgoMap;
    }

    public static Map<Long, TaxItemEntity> loadTaxItemMap(TaxTaskEntity taxTaskEntity) {
        return TaxTaskServiceHelper.loadTaxItemMap(taxTaskEntity, true, (DataHolder<Boolean>)new DataHolder((Object)Boolean.TRUE));
    }

    private static Map<Long, TaxItemEntity> loadTaxItemMap(TaxTaskEntity taxTaskEntity, boolean updateCache, DataHolder<Boolean> fromDb) {
        if (!CollectionUtils.isEmpty((Map)taxTaskEntity.getTaxItemMap())) {
            fromDb.set((Object)Boolean.FALSE);
            return taxTaskEntity.getTaxItemMap();
        }
        DynamicObject taxTaskSnapShot = TaxTaskServiceHelper.queryTaxTaskSnapShot(taxTaskEntity.getId());
        if (taxTaskSnapShot == null) {
            return new HashMap<Long, TaxItemEntity>(0);
        }
        DynamicObjectCollection enjoys = taxTaskSnapShot.getDynamicObjectCollection("taxtasksnapent");
        HashSet<Long> taxItemIds = new HashSet<Long>(16);
        for (DynamicObject entry : enjoys) {
            DynamicObjectCollection taxItemList = entry.getDynamicObjectCollection("taxitem");
            taxItemList.forEach(obj -> taxItemIds.add(obj.getLong("fbasedataid_id")));
        }
        if (CollectionUtils.isEmpty(taxItemIds)) {
            return null;
        }
        Map<Long, TaxItemEntity> taxItemMap = SitCommonServiceHelper.loadTaxItems(taxTaskEntity.getCountryId(), taxItemIds);
        if (updateCache) {
            IHRAppCache cache = HRAppCache.get((String)"itc_taxtask");
            cache.put(taxTaskEntity.cacheKey(), (Object)taxTaskEntity);
        }
        taxTaskEntity.setTaxItemMap(taxItemMap);
        return taxItemMap;
    }

    public static List<Long> loadRawCalTaskIds(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        return TaxTaskServiceHelper.loadRawCalTaskIds(taxTaskEntity, stepCaseInfo, true, (DataHolder<Boolean>)new DataHolder((Object)Boolean.TRUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Long> loadRawCalTaskIds(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, boolean updateCache, DataHolder<Boolean> fromDb) {
        if (!CollectionUtils.isEmpty((Collection)taxTaskEntity.getRawCalTaskIds())) {
            fromDb.set((Object)Boolean.FALSE);
            return taxTaskEntity.getRawCalTaskIds();
        }
        QFilter filter = new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId());
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{filter});
        TaxTaskGuideServiceHelper.packageTaxCatGroupFilter4SrcData(taxTaskEntity, stepCaseInfo, filters);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxSrcDataServiceHelper.class.getName(), (String)"itc_taxrawdata", (String)"taxdatabasic.rawcaltask.id", (QFilter[])filters.toArray(new QFilter[0]), (String)"");
            ArrayList<Long> ids = new ArrayList<Long>(10);
            dataSet.distinct().forEach(e1 -> ids.add(e1.getLong("taxdatabasic.rawcaltask.id")));
            if (CollectionUtils.isEmpty(ids)) {
                List<Long> list = Collections.emptyList();
                return list;
            }
            if (updateCache) {
                IHRAppCache cache = HRAppCache.get((String)"itc_taxtask");
                cache.put(taxTaskEntity.cacheKey(), (Object)taxTaskEntity);
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
    }

    public static Map<Long, Set<Long>> checkTaxCategoryByTaxUnitAndTaxPeriod(Object[] newTaxCategoryIds, IDataModel model) {
        long taxTaskId = model.getDataEntity().getLong("id");
        List<Object> objectsList = Arrays.asList(newTaxCategoryIds);
        List newTaxCategoryIdList = objectsList.stream().map(o1 -> (Long)o1).collect(Collectors.toList());
        List taxUnitDys = model.getEntryEntity("taxtaskunitentry").stream().map(dy -> dy.getDynamicObject("taxunit")).collect(Collectors.toList());
        long taxPeriodId = model.getDataEntity().getLong("taxperiod.id");
        Date startDate = model.getDataEntity().getDate("taxperiod.startdate");
        Date endDate = model.getDataEntity().getDate("taxperiod.enddate");
        Set<Long> taxPeriodIds = TaxTaskServiceHelper.getSameOrTimeOverlapTaxPeriodIds(taxPeriodId, startDate, endDate);
        Set taxUnitIds = taxUnitDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        QFilter qFilter = new QFilter("taxperiod.id", "in", taxPeriodIds);
        qFilter.and("taxtaskunitentry.taxunit.id", "in", taxUnitIds);
        qFilter.and("taxtaskcatgentry.taxcategory.id", "in", (Object)newTaxCategoryIds);
        qFilter.and("id", "!=", (Object)taxTaskId);
        DynamicObject[] taxTaskDys = helper.query("id,taxtaskunitentry.taxunit,taxtaskcatgentry.taxcategory", new QFilter[]{qFilter});
        Map<Long, String> taxUnitNameMap = null;
        HashMap<Long, String> taxCategoryNameMap = new HashMap<Long, String>(16);
        taxUnitNameMap = taxUnitDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
        for (DynamicObject taxTaskDy : taxTaskDys) {
            List taxCategoryDys = taxTaskDy.getDynamicObjectCollection("taxtaskcatgentry").stream().map(dy -> dy.getDynamicObject("taxcategory")).collect(Collectors.toList());
            for (DynamicObject taxCategoryDy : taxCategoryDys) {
                long taxCategoryId = taxCategoryDy.getLong("id");
                if (!newTaxCategoryIdList.contains(taxCategoryId) || taxCategoryNameMap.containsKey(taxCategoryId)) continue;
                taxCategoryNameMap.put(taxCategoryId, taxCategoryDy.getString("name"));
            }
        }
        GlobalParam.set((String)"taxUnitNameMap", taxUnitNameMap);
        GlobalParam.set((String)"taxCategoryNameMap", taxCategoryNameMap);
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject taxTaskDy : taxTaskDys) {
            Set taxUnitIdsInTaxTaskDy = taxTaskDy.getDynamicObjectCollection("taxtaskunitentry").stream().filter(dy -> taxUnitIds.contains(dy.getDynamicObject("taxunit").getLong("id"))).map(dy -> dy.getDynamicObject("taxunit").getLong("id")).collect(Collectors.toSet());
            Set taxCategoryIdsInTaxTaskDy = taxTaskDy.getDynamicObjectCollection("taxtaskcatgentry").stream().filter(dy -> newTaxCategoryIdList.contains(dy.getDynamicObject("taxcategory").getLong("id"))).map(dy -> dy.getDynamicObject("taxcategory").getLong("id")).collect(Collectors.toSet());
            for (Long taxUnitId : taxUnitIdsInTaxTaskDy) {
                if (resultMap.get(taxUnitId) != null) {
                    Set existIds = (Set)resultMap.get(taxUnitId);
                    existIds.addAll(taxCategoryIdsInTaxTaskDy);
                    resultMap.put(taxUnitId, existIds);
                    continue;
                }
                resultMap.putIfAbsent(taxUnitId, taxCategoryIdsInTaxTaskDy);
            }
        }
        return resultMap;
    }

    public static Set<Long> getSameOrTimeOverlapTaxPeriodIds(long taxPeriodId, Date startDate, Date endDate) {
        HashSet<Long> taxPeriodsIds = new HashSet<Long>(16);
        taxPeriodsIds.add(taxPeriodId);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxperiod");
        QFilter qFilter = new QFilter("taxperiodprg.country.id", "in", (Object)Long.valueOf("1000001"));
        qFilter.and(new QFilter("taxperiodprg.enable", "=", (Object)"1"));
        qFilter.and(new QFilter("taxperiodprg.status", "=", (Object)"C"));
        qFilter.and(new QFilter("startdate", "<=", (Object)endDate));
        qFilter.and(new QFilter("enddate", ">=", (Object)startDate));
        DynamicObject[] dys = helper.query("id", new QFilter[]{qFilter});
        if (dys == null || dys.length == 0) {
            return taxPeriodsIds;
        }
        for (DynamicObject dy : dys) {
            long id = dy.getLong("id");
            taxPeriodsIds.add(id);
        }
        return taxPeriodsIds;
    }

    public static Map<Long, Set<Long>> checkTaxUnitByTaxCategoryAndTaxPeriod(Object[] newTaxUnitIds, IDataModel model) {
        long taxTaskId = model.getDataEntity().getLong("id");
        List<Object> objectsList = Arrays.asList(newTaxUnitIds);
        List newTaxUnitIdList = objectsList.stream().map(o1 -> (Long)o1).collect(Collectors.toList());
        List taxCategoryDys = model.getEntryEntity("taxtaskcatgentry").stream().map(dy -> dy.getDynamicObject("taxcategory")).collect(Collectors.toList());
        long taxPeriodId = model.getDataEntity().getLong("taxperiod.id");
        Date startDate = model.getDataEntity().getDate("taxperiod.startdate");
        Date endDate = model.getDataEntity().getDate("taxperiod.enddate");
        Set<Long> taxPeriodIds = TaxTaskServiceHelper.getSameOrTimeOverlapTaxPeriodIds(taxPeriodId, startDate, endDate);
        Set taxCategoryIds = taxCategoryDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        QFilter qFilter = new QFilter("taxperiod.id", "in", taxPeriodIds);
        qFilter.and("taxtaskunitentry.taxunit.id", "in", newTaxUnitIdList);
        qFilter.and("taxtaskcatgentry.taxcategory.id", "in", taxCategoryIds);
        qFilter.and("id", "!=", (Object)taxTaskId);
        DynamicObject[] taxTaskDys = helper.query("id,taxtaskunitentry.taxunit,taxtaskcatgentry.taxcategory", new QFilter[]{qFilter});
        if (taxTaskDys.length == 0) {
            return null;
        }
        HashMap<Long, String> taxUnitNameMap = new HashMap<Long, String>(16);
        Map<Long, String> taxCategoryNameMap = null;
        taxCategoryNameMap = taxCategoryDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("name")));
        for (DynamicObject taxTaskDy : taxTaskDys) {
            List taxUnitDys = taxTaskDy.getDynamicObjectCollection("taxtaskunitentry").stream().map(dy -> dy.getDynamicObject("taxunit")).collect(Collectors.toList());
            for (DynamicObject taxUnitDy : taxUnitDys) {
                long taxUnitId = taxUnitDy.getLong("id");
                if (!newTaxUnitIdList.contains(taxUnitId) || taxUnitNameMap.containsKey(taxUnitId)) continue;
                taxUnitNameMap.put(taxUnitId, taxUnitDy.getString("name"));
            }
        }
        GlobalParam.set((String)"taxUnitNameMap", taxUnitNameMap);
        GlobalParam.set((String)"taxCategoryNameMap", taxCategoryNameMap);
        HashMap<Long, Set<Long>> resultMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject taxTaskDy : taxTaskDys) {
            Set taxUnitIdsInTaxTaskDy = taxTaskDy.getDynamicObjectCollection("taxtaskunitentry").stream().filter(dy -> newTaxUnitIdList.contains(dy.getDynamicObject("taxunit").getLong("id"))).map(dy -> dy.getDynamicObject("taxunit").getLong("id")).collect(Collectors.toSet());
            Set taxCategoryIdsInTaxTaskDy = taxTaskDy.getDynamicObjectCollection("taxtaskcatgentry").stream().filter(dy -> taxCategoryIds.contains(dy.getDynamicObject("taxcategory").getLong("id"))).map(dy -> dy.getDynamicObject("taxcategory").getLong("id")).collect(Collectors.toSet());
            for (Long taxUnitId : taxUnitIdsInTaxTaskDy) {
                if (resultMap.get(taxUnitId) != null) {
                    Set existIds = (Set)resultMap.get(taxUnitId);
                    existIds.addAll(taxCategoryIdsInTaxTaskDy);
                    resultMap.put(taxUnitId, existIds);
                    continue;
                }
                resultMap.putIfAbsent(taxUnitId, taxCategoryIdsInTaxTaskDy);
            }
        }
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showTips(Map<Long, Set<Long>> resultMap, int total, int success, IFormView view, String operateType) {
        try {
            Map taxUnitNameMap = (Map)GlobalParam.get((String)"taxUnitNameMap");
            Map taxCategoryNameMap = (Map)GlobalParam.get((String)"taxCategoryNameMap");
            String totalMsg = null;
            String operationName = null;
            switch (operateType) {
                case "addTaxCategory": {
                    totalMsg = ResManager.loadKDString((String)"\u6dfb\u52a0\u4e2a\u7a0e\u79cd\u7c7b\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{0}\u6761\uff0c\u5931\u8d25{1}\u6761", (String)"TaxTaskServiceHelper_0", (String)"sit-itc-business", (Object[])new Object[]{success, total - success});
                    operationName = ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"TaxTaskServiceHelper_5", (String)"sit-itc-business", (Object[])new Object[0]);
                    break;
                }
                case "addTaxUnit": {
                    totalMsg = ResManager.loadKDString((String)"\u6dfb\u52a0\u7eb3\u7a0e\u5355\u4f4d\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{0}\u6761\uff0c\u5931\u8d25{1}\u6761", (String)"TaxTaskServiceHelper_1", (String)"sit-itc-business", (Object[])new Object[]{success, total - success});
                    operationName = ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"TaxTaskServiceHelper_5", (String)"sit-itc-business", (Object[])new Object[0]);
                    break;
                }
                case "savetaxtask": {
                    totalMsg = ResManager.loadKDString((String)"\u7eb3\u7a0e\u5355\u4f4d\u5728\u76f8\u540c\u7684\u671f\u95f4\u6216\u65f6\u95f4\u6bb5\u5185\u5df2\u7ecf\u5b58\u5728\u76f8\u540c\u7684\u4e2a\u7a0e\u79cd\u7c7b\uff0c\u65e0\u6cd5\u4fdd\u5b58", (String)"TaxTaskServiceHelper_2", (String)"sit-itc-business", (Object[])new Object[0]);
                    operationName = ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"TaxTaskServiceHelper_6", (String)"sit-itc-business", (Object[])new Object[0]);
                    break;
                }
            }
            ArrayList<String> errorMessageResult = new ArrayList<String>(16);
            for (Map.Entry<Long, Set<Long>> result : resultMap.entrySet()) {
                if (result.getKey() == 0L) continue;
                String errMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7eb3\u7a0e\u5355\u4f4d\u201c{0}\u201d\u5728\u76f8\u540c\u7684\u671f\u95f4\u6216\u65f6\u95f4\u6bb5\u5185\u5df2\u7ecf\u5b58\u5728{1}\u7684\u4e2a\u7a0e\u79cd\u7c7b\uff0c\u65e0\u6cd5\u6dfb\u52a0\u3002", (String)"TaxTaskServiceHelper_30", (String)"sit-itc-business", (Object[])new Object[0]), taxUnitNameMap.get(result.getKey()));
                ArrayList taxCategoryNameList = Lists.newArrayListWithExpectedSize((int)result.getValue().size());
                for (Long taxCategoryId : result.getValue()) {
                    taxCategoryNameList.add(String.format(Locale.ROOT, "\u201c%s\u201d", taxCategoryNameMap.get(taxCategoryId)));
                }
                String finalMessage = String.join((CharSequence)MultiLangHelper.getMultiLangCommaDelimiter(), taxCategoryNameList);
                errorMessageResult.add(finalMessage);
            }
            FormShowParameter parameters = SITShowFormServiceHelper.getOperationResultParameter((String)operationName, (String)totalMsg, errorMessageResult);
            view.showForm(parameters);
        }
        finally {
            GlobalParam.remove();
        }
    }

    public static void openProgressView(IFormView view, Object taxTaskId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdata");
        QFilter qFilter = new QFilter("taxtask.id", "=", taxTaskId);
        QFilter statusFilter = new QFilter("status", "not in", Arrays.asList("D", "E"));
        QFilter finishedFilter = new QFilter("endoprecord.optype", "=", (Object)TaxTaskGuideOpEnum.END.getCode());
        QFilter declaredFilter = new QFilter("reportoprecord.optype", "=", (Object)TaxTaskGuideOpEnum.DECLARE.getCode());
        int totalNum = helper.count(helper.getEntityName(), new QFilter[]{qFilter, statusFilter});
        int finishedNum = helper.count(helper.getEntityName(), new QFilter[]{qFilter, finishedFilter, statusFilter});
        int declaredNum = helper.count(helper.getEntityName(), new QFilter[]{qFilter, declaredFilter, statusFilter});
        int notdeclaredNum = totalNum - declaredNum;
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        result.put("finishedNum", finishedNum);
        result.put("notdeclaredNum", notdeclaredNum);
        result.put("declaredNum", declaredNum);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("itc_taxtaskprocessview");
        formShowParameter.setCustomParam("resultMap", result);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(formShowParameter);
    }

    public static void createTaxTaskSnapshot(DynamicObject[] dys) {
        Map<Long, DynamicObject> currTaxTaskDyMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtasksnapshot");
        QFilter filter = new QFilter("taxtask.id", "in", currTaxTaskDyMap.keySet());
        DynamicObject[] taxTaskSnapDys = helper.query("id,taxtask,taxtasksnapent.taxcategory,taxtasksnapent.expression,taxtasksnapent.taxitem,creator,createtime,modifier,modifytime", new QFilter[]{filter});
        Map<Long, DynamicObject> taxTaskSnapshotDyMap = Arrays.stream(taxTaskSnapDys).collect(Collectors.toMap(dy -> dy.getLong("taxtask.id"), dy -> dy, (k1, k2) -> k1));
        for (Map.Entry<Long, DynamicObject> entry : currTaxTaskDyMap.entrySet()) {
            TaxTaskServiceHelper.createSnapshot(entry.getValue(), taxTaskSnapshotDyMap.getOrDefault(entry.getKey(), null), helper);
        }
    }

    public static void createSnapshot(DynamicObject currTaxTaskDy, DynamicObject taxTaskSnapshotDy, HRBaseServiceHelper helper) {
        if (null == taxTaskSnapshotDy) {
            List<DynamicObject> taxCategories = currTaxTaskDy.getDynamicObjectCollection("taxtaskcatgentry").stream().map(dy -> dy.getDynamicObject("taxcategory")).collect(Collectors.toList());
            Map<Long, String> splitAlgoMap = TaxTaskServiceHelper.getSplitAlgoByTaxCategory(taxCategories);
            Map<Long, List<DynamicObject>> taxItemsMap = TaxTaskServiceHelper.getTaxCategoryAndTaxItemMap(taxCategories);
            TaxTaskServiceHelper.doFirstCreateSnapShot(currTaxTaskDy, taxCategories, splitAlgoMap, taxItemsMap, helper);
        } else {
            TaxTaskServiceHelper.modifySnapShot(currTaxTaskDy, taxTaskSnapshotDy, helper);
        }
    }

    private static void modifySnapShot(DynamicObject currTaxTaskDy, DynamicObject taxTaskSnapshotDy, HRBaseServiceHelper helper) {
        List oldTaxCategoryList = taxTaskSnapshotDy.getDynamicObjectCollection("taxtasksnapent").stream().map(dy -> dy.getDynamicObject("taxcategory")).collect(Collectors.toList());
        Map<Long, DynamicObject> oldTaxCategoryDys = oldTaxCategoryList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        List<DynamicObject> newTaxCategoryList = currTaxTaskDy.getDynamicObjectCollection("taxtaskcatgentry").stream().map(dy -> dy.getDynamicObject("taxcategory")).collect(Collectors.toList());
        Map<Long, DynamicObject> newTaxCategoryDys = newTaxCategoryList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        List updateTaxCategoryList = currTaxTaskDy.getDynamicObjectCollection("taxtaskcatgentry").stream().filter(entry -> entry.getInt("taxdatanum") == 0).map(e1 -> e1.getDynamicObject("taxcategory")).collect(Collectors.toList());
        Map<Long, DynamicObject> updateTaxCategoryDys = updateTaxCategoryList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        HRBaseServiceHelper splitAlgoHelper = new HRBaseServiceHelper("sitbs_nettaxalgo");
        Map<Long, String> addTaxCategoryAndSplitAlgoMap = TaxTaskServiceHelper.getAddTaxCategoryAndSplitAlgoMap(oldTaxCategoryDys, newTaxCategoryDys, updateTaxCategoryDys, splitAlgoHelper);
        Set<Long> deleteTaxCategoryIds = TaxTaskServiceHelper.getDeleteTaxCategoryIds(oldTaxCategoryDys, newTaxCategoryDys);
        Map<Long, List<DynamicObject>> addTaxCategoryAndTaxItemMap = null;
        if (!CollectionUtils.isEmpty(addTaxCategoryAndSplitAlgoMap)) {
            addTaxCategoryAndTaxItemMap = TaxTaskServiceHelper.getTaxCategoryAndTaxItemMap(newTaxCategoryList);
            addTaxCategoryAndTaxItemMap.entrySet().removeIf(entry -> !addTaxCategoryAndSplitAlgoMap.containsKey(entry.getKey()));
        }
        TaxTaskServiceHelper.doModifySnapShot(currTaxTaskDy, addTaxCategoryAndSplitAlgoMap, addTaxCategoryAndTaxItemMap, deleteTaxCategoryIds, helper);
    }

    private static void doModifySnapShot(DynamicObject currTaxTaskDy, Map<Long, String> addTaxCategoryAndSplitAlgoMap, Map<Long, List<DynamicObject>> addTaxCategoryAndTaxItemMap, Set<Long> deleteTaxCategoryIds, HRBaseServiceHelper helper) {
        Date currDate = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        long taxTaskId = currTaxTaskDy.getLong("id");
        QFilter qFilter = new QFilter("taxtask.id", "=", (Object)taxTaskId);
        DynamicObject taxTaskSnapShotDy = helper.queryOne("id,modifier,modifytime,taxtasksnapent.seq,taxtasksnapent.taxcategory,taxtasksnapent.expression,taxtasksnapent.taxitem", new QFilter[]{qFilter});
        taxTaskSnapShotDy.set("modifier", (Object)userId);
        taxTaskSnapShotDy.set("modifytime", (Object)currDate);
        DynamicObjectCollection taxCategoryEntryDys = taxTaskSnapShotDy.getDynamicObjectCollection("taxtasksnapent");
        DynamicObjectType dynamicObjectType = taxCategoryEntryDys.getDynamicObjectType();
        Iterator it = taxCategoryEntryDys.iterator();
        while (it.hasNext()) {
            DynamicObject taxCategoryEntryDy = (DynamicObject)it.next();
            Long taxCategoryId = taxCategoryEntryDy.getLong("taxcategory.id");
            if (CollectionUtils.isEmpty(deleteTaxCategoryIds) || !deleteTaxCategoryIds.contains(taxCategoryId)) continue;
            it.remove();
        }
        int index = 1;
        for (DynamicObject taxCategoryEntryDy : taxCategoryEntryDys) {
            taxCategoryEntryDy.set("seq", (Object)index++);
        }
        if (!CollectionUtils.isEmpty(addTaxCategoryAndSplitAlgoMap)) {
            for (DynamicObject taxCategoryEntryDy : taxCategoryEntryDys) {
                long taxCategoryId = taxCategoryEntryDy.getLong("taxcategory.id");
                String expression = addTaxCategoryAndSplitAlgoMap.get(taxCategoryId);
                if (expression == null) continue;
                taxCategoryEntryDy.set("expression", (Object)expression);
                addTaxCategoryAndSplitAlgoMap.remove(taxCategoryId);
                List<DynamicObject> taxItemList = addTaxCategoryAndTaxItemMap.get(taxCategoryId);
                DynamicObjectCollection taxItemDys = taxCategoryEntryDy.getDynamicObjectCollection("taxitem");
                taxItemDys.clear();
                for (DynamicObject taxItem : taxItemList) {
                    DynamicObject dy = taxItemDys.addNew();
                    dy.set("fbasedataid_id", (Object)taxItem.getLong("id"));
                }
                taxCategoryEntryDy.set("taxitem", (Object)taxItemDys);
                addTaxCategoryAndTaxItemMap.remove(taxCategoryId);
            }
        }
        if (!CollectionUtils.isEmpty(addTaxCategoryAndSplitAlgoMap)) {
            for (Map.Entry<Long, String> entry : addTaxCategoryAndSplitAlgoMap.entrySet()) {
                DynamicObject taxCategoryEntryDy = new DynamicObject(dynamicObjectType);
                Long taxCategoryId = entry.getKey();
                taxCategoryEntryDy.set("taxcategory", (Object)taxCategoryId);
                taxCategoryEntryDy.set("expression", (Object)entry.getValue());
                List<DynamicObject> taxItemList = addTaxCategoryAndTaxItemMap.get(taxCategoryId);
                DynamicObjectCollection taxItemDys = taxCategoryEntryDy.getDynamicObjectCollection("taxitem");
                for (DynamicObject taxItem : taxItemList) {
                    DynamicObject dy = taxItemDys.addNew();
                    dy.set("fbasedataid_id", (Object)taxItem.getLong("id"));
                }
                taxCategoryEntryDy.set("taxitem", (Object)taxItemDys);
                taxCategoryEntryDy.set("seq", (Object)index++);
                taxCategoryEntryDys.add((Object)taxCategoryEntryDy);
            }
        }
        helper.saveOne(taxTaskSnapShotDy);
    }

    private static DynamicObject[] getTaxItemsByTaxCategoryIds(Set<Long> taxCategoryIds) {
        HRBaseServiceHelper taxItemHelper = new HRBaseServiceHelper("sitbs_taxitem");
        QFilter qFilter = new QFilter("taxcategories.fbasedataid_id", "in", taxCategoryIds);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("country.id", "=", (Object)Long.valueOf("1000001"));
        return taxItemHelper.query("id,taxcategories", new QFilter[]{qFilter});
    }

    private static Set<Long> getDeleteTaxCategoryIds(Map<Long, DynamicObject> oldTaxCategoryDys, Map<Long, DynamicObject> newTaxCategoryDys) {
        Set<Long> deleteTaxCategoryIds = oldTaxCategoryDys.keySet().stream().filter(e1 -> !newTaxCategoryDys.containsKey(e1)).collect(Collectors.toSet());
        if (deleteTaxCategoryIds.size() == 0) {
            return null;
        }
        return deleteTaxCategoryIds;
    }

    private static Map<Long, String> getAddTaxCategoryAndSplitAlgoMap(Map<Long, DynamicObject> oldTaxCategoryDys, Map<Long, DynamicObject> newTaxCategoryDys, Map<Long, DynamicObject> updateTaxCategoryDys, HRBaseServiceHelper splitAlgoHelper) {
        Set addTaxCategoryIds = newTaxCategoryDys.keySet().stream().filter(e1 -> !oldTaxCategoryDys.containsKey(e1)).collect(Collectors.toSet());
        for (Map.Entry<Long, DynamicObject> entry : updateTaxCategoryDys.entrySet()) {
            if (!oldTaxCategoryDys.containsKey(entry.getKey())) continue;
            addTaxCategoryIds.add(entry.getKey());
        }
        if (addTaxCategoryIds.size() == 0) {
            return null;
        }
        QFilter filter = new QFilter("taxcategory.id", "in", addTaxCategoryIds);
        DynamicObject[] splitAlgoDys = splitAlgoHelper.query("id,taxcategory,expression", new QFilter[]{filter});
        return Arrays.stream(splitAlgoDys).collect(Collectors.toMap(dy -> dy.getLong("taxcategory.id"), dy -> dy.getString("expression"), (k1, k2) -> k1));
    }

    public static void doFirstCreateSnapShot(DynamicObject currTaxTaskDy, List<DynamicObject> taxCategories, Map<Long, String> splitAlgoMap, Map<Long, List<DynamicObject>> taxItemsMap, HRBaseServiceHelper helper) {
        Date currDate = new Date();
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject newSnapshot = helper.generateEmptyDynamicObject();
        newSnapshot.set("creator", (Object)userId);
        newSnapshot.set("createtime", (Object)currDate);
        newSnapshot.set("taxtask", (Object)currTaxTaskDy);
        DynamicObjectCollection taxCategoryEntryDys = newSnapshot.getDynamicObjectCollection("taxtasksnapent");
        int index = 1;
        for (DynamicObject taxCategory : taxCategories) {
            DynamicObject taxCategoryEntryDy = helper.generateEmptyEntryDynamicObject("taxtasksnapent");
            taxCategoryEntryDy.set("taxcategory", (Object)taxCategory.getLong("id"));
            taxCategoryEntryDy.set("expression", splitAlgoMap.getOrDefault(taxCategory.getLong("id"), null));
            DynamicObjectCollection taxItemDys = taxCategoryEntryDy.getDynamicObjectCollection("taxitem");
            List<DynamicObject> taxItemList = taxItemsMap.get(taxCategory.getLong("id"));
            for (DynamicObject taxItem : taxItemList) {
                DynamicObject dy = taxItemDys.addNew();
                dy.set("fbasedataid_id", (Object)taxItem.getLong("id"));
            }
            taxCategoryEntryDy.set("taxitem", (Object)taxItemDys);
            taxCategoryEntryDy.set("seq", (Object)index++);
            taxCategoryEntryDys.add((Object)taxCategoryEntryDy);
        }
        helper.saveOne(newSnapshot);
    }

    public static Map<Long, List<DynamicObject>> getTaxCategoryAndTaxItemMap(List<DynamicObject> taxCategories) {
        Map<Long, DynamicObject> taxCategoryMap = taxCategories.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        DynamicObject[] taxItemDys = TaxTaskServiceHelper.getTaxItemsByTaxCategoryIds(taxCategoryMap.keySet());
        Map<Long, Map<Long, DynamicObject>> taxCateToTaxItemMap = TaxTaskServiceHelper.handleTaxItemDys(taxItemDys);
        HashMap<Long, List<DynamicObject>> result = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry<Long, DynamicObject> entry : taxCategoryMap.entrySet()) {
            Long taxCategoryId = entry.getKey();
            Map<Long, DynamicObject> taxItemMap = taxCateToTaxItemMap.get(taxCategoryId);
            if (taxItemMap != null) {
                ArrayList<DynamicObject> taxItemList = new ArrayList<DynamicObject>(taxItemMap.values());
                result.put(taxCategoryId, taxItemList);
                continue;
            }
            result.put(taxCategoryId, null);
        }
        return result;
    }

    public static Map<Long, Map<Long, DynamicObject>> handleTaxItemDys(DynamicObject[] taxItemDys) {
        HashMap<Long, Map<Long, DynamicObject>> map = new HashMap<Long, Map<Long, DynamicObject>>(16);
        if (null == taxItemDys || taxItemDys.length == 0) {
            return map;
        }
        for (DynamicObject taxItemDy : taxItemDys) {
            Long taxItemId = taxItemDy.getLong("id");
            DynamicObjectCollection taxcategories = taxItemDy.getDynamicObjectCollection("taxcategories");
            for (DynamicObject taxcategory : taxcategories) {
                Long taxCategoryId = taxcategory.getLong("fbasedataid_id");
                Map taxItemMap = (Map)map.get(taxCategoryId);
                if (taxItemMap != null) {
                    if (taxItemMap.containsKey(taxItemId)) continue;
                    taxItemMap.put(taxItemId, taxItemDy);
                    continue;
                }
                HashMap<Long, DynamicObject> newTaxItemMap = new HashMap<Long, DynamicObject>(16);
                newTaxItemMap.put(taxItemId, taxItemDy);
                map.put(taxCategoryId, newTaxItemMap);
            }
        }
        return map;
    }

    public static Map<Long, String> getSplitAlgoByTaxCategory(List<DynamicObject> taxCategories) {
        Set taxCategoryIds = taxCategories.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper splitAlgoHelper = new HRBaseServiceHelper("sitbs_nettaxalgo");
        QFilter filter = new QFilter("taxcategory.id", "in", taxCategoryIds);
        DynamicObject[] splitAlgoDys = splitAlgoHelper.query("id,taxcategory,expression", new QFilter[]{filter});
        return Arrays.stream(splitAlgoDys).collect(Collectors.toMap(dy -> dy.getLong("taxcategory.id"), dy -> dy.getString("expression"), (k1, k2) -> k1));
    }

    public static Set<Long> getAllTaxItemSnapShot() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT");
        sql.append(" DISTINCT");
        sql.append(" FBASEDATAID fbasedataid");
        sql.append(" FROM T_ITC_TAXITEMSNAP");
        Set taxItemIds = (Set)HRDBUtil.query((DBRoute)SITConstants.SIT_ROUTE, (String)sql.toString(), null, (ResultSetHandler)new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws Exception {
                HashSet<Long> taxItemIds = new HashSet<Long>(16);
                while (rs.next()) {
                    taxItemIds.add(rs.getLong("fbasedataid"));
                }
                return taxItemIds;
            }
        });
        return taxItemIds;
    }

    public static void openCountDownF7(IFormPlugin plugin, IFormView view) {
        String content = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u7ed3\u675f\u540e\u5c06\u4e0d\u80fd\u518d\u6dfb\u52a0\u4e2a\u7a0e\u8bb0\u5f55\uff0c\u5e76\u4e14\u4e0d\u80fd\u505a\u4e2a\u7a0e\u8bb0\u5f55\u64a4\u9500\u6807\u8bb0\u7533\u62a5\uff0c\u786e\u5b9a\u8981\u7ee7\u7eed\u5417\uff1f", (String)"TaxTaskServiceHelper_7", (String)"sit-itc-business", (Object[])new Object[0]);
        CloseCallBack cb = new CloseCallBack(plugin, "sitbp_countdown");
        FormShowParameter formShowParameter = SITShowFormServiceHelper.getCountDownConfirmParameter((CloseCallBack)cb, null, (boolean)false, (String)content);
        view.showForm(formShowParameter);
    }

    public static void rollbackEndTip(IFormView view, IFormPlugin plugin) {
        String message = ResManager.loadKDString((String)"\u662f\u5426\u64a4\u9500\u7ed3\u675f\u4e2a\u7a0e\u4efb\u52a1\uff1f", (String)"TaxTaskServiceHelper_8", (String)"sit-itc-business", (Object[])new Object[0]);
        view.showConfirm(message, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(TaxTaskGuideOpEnum.ROLLBACK_END.getCode(), plugin));
    }

    public static void viewMore(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, String actionId, IFormView view) {
        List<DynamicObject> dynamicObjects = TaxTaskGuideServiceHelper.queryData(taxTaskEntity, stepCaseInfo, false, actionId);
        Set failList = null;
        failList = TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskEntity.getTaxTaskType()) ? dynamicObjects.stream().distinct().map(dy -> MessageFormat.format(ResManager.loadKDString((String)"{0}\uff0c{1}\u8fd8\u672a\u8fdb\u884c\u7ed3\u679c\u786e\u8ba4\uff0c\u65e0\u6cd5\u7ed3\u675f\u3002", (String)"TaxFileServiceHelper_17", (String)"sit-itc-business", (Object[])new Object[0]), dy.getString("taxfile.number"), dy.getString("taxfile.person.name"))).collect(Collectors.toSet()) : dynamicObjects.stream().distinct().map(dy -> MessageFormat.format(ResManager.loadKDString((String)"{0}\uff0c{1}\u8fd8\u672a\u8fdb\u884c\u6807\u8bb0\u7533\u62a5\uff0c\u65e0\u6cd5\u7ed3\u675f\u3002", (String)"TaxFileServiceHelper_16", (String)"sit-itc-business", (Object[])new Object[0]), dy.getString("taxfile.number"), dy.getString("taxfile.person.name"))).collect(Collectors.toSet());
        TaxTaskServiceHelper.showMore(new ArrayList<String>(failList), TaxTaskGuideOpEnum.END.loadKDString(), view);
    }

    private static void showMore(List<String> failList, String operateName, IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("ide_showoperationresult");
        parameter.setCustomParam("operateName", (Object)operateName);
        parameter.setCustomParam("failList", failList);
        TaxTaskServiceHelper.setFailMessageToCache(operateName, failList, view);
        view.showForm(parameter);
    }

    private static void setFailMessageToCache(String operateName, List<String> failList, IFormView view) {
        IPageCache pageCache = (IPageCache)view.getService(IPageCache.class);
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        OperationResult operationResult = new OperationResult();
        List allErrorInfo = operationResult.getAllErrorInfo();
        if (!CollectionUtils.isEmpty(failList)) {
            for (String message : failList) {
                OperateErrorInfo errorInfo = new OperateErrorInfo();
                errorInfo.setMessage(message);
                if (operateName != null) {
                    errorInfo.setTitle(operateName);
                }
                errorInfo.setErrorLevel(String.valueOf(ErrorLevel.Error));
                allErrorInfo.add(errorInfo);
            }
        }
        String serialResult = DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option);
        pageCache.put("operationresult", serialResult);
    }

    public static DynamicObject queryTaxTaskSnapShot(Long taxTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtasksnapshot");
        String fields = "taxtasksnapent,taxtask,taxcategory,expression,taxitem,taxitem.id";
        return serviceHelper.queryOne(fields, new QFilter[]{new QFilter("taxtask", "in", (Object)taxTaskId)});
    }

    public static String getTaxTaskType(Long taxTaskId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtask");
        String fields = "id,taxtasktype";
        DynamicObject taxTaskDy = serviceHelper.queryOne(fields, new QFilter[]{new QFilter("id", "=", (Object)taxTaskId)});
        return taxTaskDy.getString("taxtasktype");
    }

    public static Object[] filterTaxCategoryId(Object[] newTaxCategoryIds, Map<Long, Set<Long>> resultMap) {
        HashSet<Long> notPassTaxCategoryIds = new HashSet<Long>(newTaxCategoryIds.length);
        for (Set<Long> taxCategoryIds : resultMap.values()) {
            notPassTaxCategoryIds.addAll(taxCategoryIds);
        }
        ArrayList<Long> newTaxCategoryIdList = new ArrayList<Long>(newTaxCategoryIds.length);
        for (Object newTaxCategoryId : newTaxCategoryIds) {
            newTaxCategoryIdList.add((Long)newTaxCategoryId);
        }
        return newTaxCategoryIdList.stream().filter(id -> !notPassTaxCategoryIds.contains(id)).toArray();
    }

    public static Object[] filterTaxUnitId(Object[] newTaxUnitIds, Map<Long, Set<Long>> resultMap) {
        Set<Long> notPassTaxUnitIds = resultMap.keySet();
        ArrayList<Long> newTaxUnitIdList = new ArrayList<Long>(newTaxUnitIds.length);
        for (Object newTaxUnitId : newTaxUnitIds) {
            newTaxUnitIdList.add((Long)newTaxUnitId);
        }
        return newTaxUnitIdList.stream().filter(id -> !notPassTaxUnitIds.contains(id)).toArray();
    }

    public static List<DynamicObject> checkSameTaxPeriodTaxUnit(IDataModel model) {
        long id = model.getDataEntity().getLong("id");
        long taxPeriodId = model.getDataEntity().getLong("taxperiod.id");
        Date startDate = model.getDataEntity().getDate("taxperiod.startdate");
        Date endDate = model.getDataEntity().getDate("taxperiod.enddate");
        Set<Long> taxPeriodIds = TaxTaskServiceHelper.getSameOrTimeOverlapTaxPeriodIds(taxPeriodId, startDate, endDate);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        QFilter qFilter = new QFilter("taxperiod.id", "in", taxPeriodIds);
        qFilter.and("id", "!=", (Object)id);
        DynamicObject[] taxTaskDys = helper.query("id,taxtaskunitentry.taxunit", new QFilter[]{qFilter});
        if (taxTaskDys.length == 0) {
            return null;
        }
        HashSet<Long> existTaxUnitIds = new HashSet<Long>(16);
        for (DynamicObject taxTaskDy : taxTaskDys) {
            DynamicObjectCollection taxUnitDys = taxTaskDy.getDynamicObjectCollection("taxtaskunitentry");
            for (DynamicObject taxUnitDy : taxUnitDys) {
                Long taxUnitId = taxUnitDy.getLong("taxunit.id");
                existTaxUnitIds.add(taxUnitId);
            }
        }
        DynamicObjectCollection localTaxUnitEntries = model.getDataEntity().getDynamicObjectCollection("taxtaskunitentry");
        ArrayList<DynamicObject> unpassTaxUnitDys = new ArrayList<DynamicObject>(localTaxUnitEntries.size());
        for (DynamicObject localTaxUnitEntry : localTaxUnitEntries) {
            Long localTaxUnitId = localTaxUnitEntry.getLong("taxunit.id");
            if (!existTaxUnitIds.contains(localTaxUnitId)) continue;
            unpassTaxUnitDys.add(localTaxUnitEntry.getDynamicObject("taxunit"));
        }
        return unpassTaxUnitDys;
    }

    public static void validateCurrency(long excTable, Date exRateDate, Set<Long> curSet) {
        DynamicObject[] exRates;
        for (DynamicObject exRate : exRates = TaxTaskServiceHelper.getSelectedExRate(excTable, exRateDate)) {
            Long orgCur = exRate.getDynamicObject("orgcur").getLong("id");
            Long cur = exRate.getDynamicObject("cur").getLong("id");
            boolean contain = false;
            if (cur.equals(1L)) {
                contain = curSet.remove(orgCur);
            }
            if (contain || !orgCur.equals(1L)) continue;
            curSet.remove(cur);
        }
    }

    public static DynamicObject[] getSelectedExRate(long excTable, Date exRateDate) {
        HRBaseServiceHelper exRateHelper = new HRBaseServiceHelper("bd_exrate_tree");
        QFilter exRateFilter = new QFilter("exctable", "=", (Object)excTable);
        exRateFilter.and("effectdate", "<=", (Object)exRateDate);
        exRateFilter.and("enable", "=", (Object)"1");
        QFilter currencyFilter = new QFilter("orgcur", "=", (Object)1L);
        currencyFilter.or("cur", "=", (Object)1L);
        DynamicObject[] exRates = exRateHelper.query("orgcur, cur, effectdate, enable, exctable", new QFilter[]{exRateFilter, currencyFilter});
        return exRates;
    }

    public static Map<Long, String> validateCurQuoted(Long taxTaskId, Map<Long, String> foreignCurMap) {
        return TaxTaskServiceHelper.validateCurQuoted(taxTaskId, foreignCurMap, 0);
    }

    public static Map<Long, String> validateCurQuoted(Long taxTaskId, Map<Long, String> foreignCurMap, int yearMonth) {
        Set<Long> foreignCurSet = foreignCurMap.keySet();
        HRBaseServiceHelper taxRawDataHelper = new HRBaseServiceHelper("itc_taxrawdatabasic");
        QFilter taxRawDataFilter = new QFilter("taxtask", "=", (Object)taxTaskId);
        taxRawDataFilter.and(new QFilter("status", "!=", (Object)"E"));
        taxRawDataFilter.and(new QFilter("currency.id", "!=", (Object)0L));
        taxRawDataFilter.and(new QFilter("currency.id", "!=", (Object)1L));
        if (yearMonth != 0) {
            taxRawDataFilter = taxRawDataFilter.and(new QFilter("yearmonth", "=", (Object)yearMonth));
        }
        HashMap<Long, String> failCurMap = new HashMap<Long, String>(16);
        try (DataSet dataSet = taxRawDataHelper.queryDataSet("TaxTaskServiceHelper.validateCurQuoted", "currency.id", taxRawDataFilter.toArray());){
            DataSet distinct = dataSet.distinct();
            while (distinct.hasNext()) {
                Row next = distinct.next();
                Long curId = next.getLong("currency.id");
                if (foreignCurSet.contains(curId)) continue;
                failCurMap.put(curId, next.getString("currency.id"));
            }
        }
        if (!failCurMap.isEmpty()) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("bd_currency");
            DynamicObject[] query = helper.query("id,name", new QFilter("id", "in", failCurMap.keySet()).toArray());
            failCurMap.clear();
            for (DynamicObject object : query) {
                failCurMap.put(object.getLong("id"), object.getString("name"));
            }
        }
        return failCurMap;
    }

    public static boolean taskIsExist(long taxtaskId) {
        if (taxtaskId == 0L) {
            return false;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        return helper.isExists((Object)taxtaskId);
    }

    public static DynamicObject[] getSrcProportionTaxItemsByTaxCategoryId(Object[] newTaxCategoryIds) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxitem");
        QFilter qFilter = new QFilter("taxcategories.fbasedataid_id", "in", (Object)newTaxCategoryIds);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("country.id", "=", (Object)Long.valueOf("1000001"));
        qFilter.and("splitalgo.id", "=", (Object)1194194795812110336L);
        return helper.query("id,taxcategories,splitalgo", new QFilter[]{qFilter});
    }

    public static Map<Long, Set<Long>> getCalRuleMapByTaxCategoryIdsAndOrgId(Object[] newTaxCategoryIds, Long createOrgId) {
        Object[] calRuleDys;
        if (Objects.isNull(createOrgId)) {
            return Maps.newHashMap();
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_calrule");
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("taxcategory.id", "in", (Object)newTaxCategoryIds));
        qFilter.and(new QFilter("iscurrentversion", "=", (Object)YesOrNoEnum.YES.getCode()));
        QFilter useOrgFilter = SITPermissionServiceHelper.getBaseDataFilter((String)"sitbs_calrule", (Long)createOrgId);
        if (useOrgFilter != null) {
            qFilter.and(useOrgFilter);
        }
        if (ArrayUtils.isEmpty((Object[])(calRuleDys = helper.query("id,taxcategory", new QFilter[]{qFilter})))) {
            return Maps.newHashMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)calRuleDys.length);
        for (Object calRuleDy : calRuleDys) {
            Long id = calRuleDy.getLong("id");
            Long taxCategoryId = calRuleDy.getLong("taxcategory.id");
            Set calRuleBoIds = result.computeIfAbsent(taxCategoryId, key -> Sets.newHashSet());
            calRuleBoIds.add(id);
        }
        return result;
    }
}

