/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.model.SrcStatus;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.SitLogServiceHelper;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideReportExportTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.servicehelper.SITCertCommonHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.DataHolder;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.async.enums.MultiThreadCase;

public class TaxTaskDataExportViewHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskDataExportViewHelper.class);
    private static final String CACHE_KEY_BETWEEN_REQUEST = "dataOfPrevRequest";

    public static BatchResult<DynamicObject> validateExport(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, ListSelectedRowCollection selectedRows, DataHolder<Boolean> deal, AbstractFormPlugin plugin) {
        IPageCache pageCache = plugin.getPageCache();
        int count = selectedRows.size();
        BillList billList = (BillList)view.getControl("billlistap");
        if (count == 0) {
            List<DynamicObject> taxDataDys = TaxTaskGuideViewHelper.loadTaxData(taxTaskEntity, stepCaseInfo, billList, false);
            count = taxDataDys.size();
            if (count == 0) {
                return new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"TaxTaskDataExportViewHelper_0", (String)"sit-itc-business", (Object[])new Object[0]));
            }
            pageCache.put("exportTotal", String.valueOf(count));
            return TaxTaskDataExportViewHelper.showTips(view, taxTaskEntity, stepCaseInfo, deal, plugin, taxDataDys);
        }
        List<DynamicObject> taxDataDys = TaxTaskGuideViewHelper.loadTaxData(taxTaskEntity, stepCaseInfo, billList, true);
        pageCache.put("exportTotal", String.valueOf(count));
        return TaxTaskDataExportViewHelper.showTips(view, taxTaskEntity, stepCaseInfo, deal, plugin, taxDataDys);
    }

    public static BatchResult<DynamicObject> showTips(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, DataHolder<Boolean> deal, AbstractFormPlugin plugin, List<DynamicObject> taxDataDys) {
        ArrayList releasePersonIndexIds = Lists.newArrayListWithExpectedSize((int)taxDataDys.size());
        for (DynamicObject dy : taxDataDys) {
            if (!"C".equals(dy.getString("taxfile.status"))) continue;
            releasePersonIndexIds.add(dy.getLong("taxperson.personindexid"));
        }
        if (CollectionUtils.isEmpty((Collection)releasePersonIndexIds)) {
            return null;
        }
        DynamicObject appInfo = SITCertCommonHelper.queryAppInfoByCountryId((Long)1000001L);
        if (appInfo == null) {
            return null;
        }
        TaxTaskGuideCacheData from = TaxTaskGuideCacheData.from((BatchResult<DynamicObject>)new BatchResult(true, null), taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.EXPORT_REPORT);
        plugin.getPageCache().put(CACHE_KEY_BETWEEN_REQUEST, SerializationUtils.toJsonString((Object)from));
        LinkedHashMap declaredTaxDataMap = Maps.newLinkedHashMapWithExpectedSize((int)taxDataDys.size());
        HashMap<String, List> declaredTaxUnitDataMap = new HashMap<String, List>();
        HashSet<Long> taxUnitIds = new HashSet<Long>();
        if (!CollectionUtils.isEmpty(taxDataDys)) {
            for (DynamicObject taxDataDy : taxDataDys) {
                String taxDataId = taxDataDy.getString("id");
                Long taxFileId = taxDataDy.getLong("taxfile.id");
                declaredTaxDataMap.put(taxDataId, taxFileId);
                String taxUnitName = taxDataDy.getString("taxunit.name");
                List taxDataIds = declaredTaxUnitDataMap.computeIfAbsent(taxUnitName, k1 -> new ArrayList());
                taxDataIds.add(Long.parseLong(taxDataId));
                Long taxUnitId = taxDataDy.getLong("taxunit.id");
                taxUnitIds.add(taxUnitId);
            }
            plugin.getPageCache().put("declaredPersonMap", SerializationUtils.toJsonString((Object)declaredTaxDataMap));
            plugin.getPageCache().put("declaredTaxUnitDataMap", SerializationUtils.toJsonString(declaredTaxUnitDataMap));
            plugin.getPageCache().put("taxUnitIds", SerializationUtils.toJsonString(taxUnitIds));
            view.showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u64cd\u4f5c\u5c06\u4f1a\u9501\u5b9a\u4e2a\u7a0e\u8bb0\u5f55\u5e76\u5bfc\u51fa\u7533\u62a5\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxTaskDataExportViewHelper_1", (String)"sit-itc-business", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + TaxTaskGuideOpEnum.EXPORT_REPORT.getCode(), (IFormPlugin)plugin), null, "Tips");
        }
        deal.set((Object)Boolean.FALSE);
        return null;
    }

    public static BatchResult<DynamicObject> confirmCallBackMethods(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, String customVaule, AbstractFormPlugin plugin) {
        BatchResult<DynamicObject> result = null;
        DataHolder dealReport = new DataHolder((Object)Boolean.FALSE);
        switch (customVaule) {
            case "updateTaxDataComfirm": {
                String taxSrcDataIdsJson = plugin.getPageCache().get("updateTaxSrcDataIds");
                Set taxSrcDataIds = (Set)SerializationUtils.fromJsonString((String)taxSrcDataIdsJson, Set.class);
                result = TaxTaskDataExportViewHelper.doReferTaxSrcData(view, taxTaskEntity, stepCaseInfo, taxSrcDataIds, (DataHolder<Boolean>)dealReport, plugin);
                break;
            }
            case "confirmReferedAndSelected": {
                DataHolder dealEx = new DataHolder((Object)Boolean.FALSE);
                TaxTaskDataExportViewHelper.openExportReportProgressBar(view, taxTaskEntity, (DataHolder<Boolean>)dealEx, stepCaseInfo, plugin);
                break;
            }
            case "Tips": {
                String personMapJson = plugin.getPageCache().get("declaredPersonMap");
                Map declaredTaxDataMap = (Map)SerializationUtils.fromJsonString((String)personMapJson, Map.class);
                if (declaredTaxDataMap.size() == 0) {
                    return null;
                }
                if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(taxTaskEntity.getTaxTaskType())) {
                    TaxTaskDataExportViewHelper.validateTaxDataVersion(view, taxTaskEntity, stepCaseInfo, declaredTaxDataMap, (DataHolder<Boolean>)dealReport, plugin);
                    break;
                }
                TaxTaskDataExportViewHelper.validateCalFailData(view, taxTaskEntity, stepCaseInfo, declaredTaxDataMap, (DataHolder<Boolean>)dealReport, plugin);
                break;
            }
        }
        return result;
    }

    private static BatchResult<DynamicObject> doReferTaxSrcData(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Set<Long> taxSrcDataIds, DataHolder<Boolean> deal, AbstractFormPlugin plugin) {
        TaxTaskGuideViewHelper.refRawData(view, taxTaskEntity, stepCaseInfo, new ArrayList<Long>(taxSrcDataIds));
        String personMapJson = plugin.getPageCache().get("declaredPersonMap");
        Map declaredTaxDataMap = (Map)SerializationUtils.fromJsonString((String)personMapJson, Map.class);
        return TaxTaskDataExportViewHelper.openTaxTemplateWindow(view, taxTaskEntity, stepCaseInfo, declaredTaxDataMap, deal, plugin, true);
    }

    public static BatchResult<DynamicObject> validateTaxDataVersion(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Map<String, Long> declaredTaxDataMap, DataHolder<Boolean> deal, AbstractFormPlugin plugin) {
        HashSet<Long> taxFileIds = new HashSet<Long>(declaredTaxDataMap.values());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxfile.id", "in", taxFileIds));
        qFilters.add(new QFilter("status", "=", (Object)"D").or(new QFilter("bizstatus", "<", (Object)TaxDataBizStatusEnum.REFER.getCode())));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, stepCaseInfo);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxrawdata");
        Object[] taxSrcDataDys = helper.query("id,taxfile.id,status,bizstatus", qFilters.toArray(new QFilter[0]));
        if (!ArrayUtils.isEmpty((Object[])taxSrcDataDys)) {
            HashSet needTobeUpdatedSrcDataIds = Sets.newHashSetWithExpectedSize((int)taxSrcDataDys.length);
            HashSet logNeedTobeUpdatedSrcDataIds = Sets.newHashSetWithExpectedSize((int)taxSrcDataDys.length);
            for (Object taxSrcDataDy : taxSrcDataDys) {
                needTobeUpdatedSrcDataIds.add(taxSrcDataDy.getLong("taxfile.id"));
                logNeedTobeUpdatedSrcDataIds.add(taxSrcDataDy.getLong("id"));
            }
            LOGGER.info("logNeedTobeUpdatedSrcDataIds is {}", (Object)logNeedTobeUpdatedSrcDataIds);
            view.showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u4f7f\u7528\u4e2a\u7a0e\u6e90\u6570\u636e\u7684\u6700\u65b0\u7248\u672c\u5bfc\u51fa\u7533\u62a5\u8868\uff1f", (String)"TaxTaskDataExportViewHelper_2", (String)"sit-itc-business", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + TaxTaskGuideOpEnum.EXPORT_REPORT.getCode(), (IFormPlugin)plugin), null, "updateTaxDataComfirm");
            plugin.getPageCache().put("updateTaxSrcDataIds", SerializationUtils.toJsonString((Object)needTobeUpdatedSrcDataIds));
            deal.set((Object)Boolean.FALSE);
            return null;
        }
        return TaxTaskDataExportViewHelper.openTaxTemplateWindow(view, taxTaskEntity, stepCaseInfo, declaredTaxDataMap, deal, plugin, false);
    }

    private static BatchResult<DynamicObject> openTaxTemplateWindow(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Map<String, Long> declaredTaxDataMap, DataHolder<Boolean> deal, AbstractFormPlugin plugin, boolean countTipsFlag) {
        Long taxCategoryId = stepCaseInfo.getTabValue();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("sitbs_usetaxtemplate");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("scene", (Object)"2");
        formShowParameter.setCustomParam("taxcategory", (Object)taxCategoryId);
        formShowParameter.setCustomParam("count", (Object)declaredTaxDataMap.size());
        formShowParameter.setCustomParam("countTipsFlag", (Object)String.valueOf(countTipsFlag));
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "confirmTaxExportTemplate"));
        view.showForm(formShowParameter);
        deal.set((Object)Boolean.FALSE);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static void validateAllReferedAndChecked(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, AbstractFormPlugin plugin) {
        String personMapJson = plugin.getPageCache().get("declaredPersonMap");
        Map declaredTaxDataMap = (Map)SerializationUtils.fromJsonString((String)personMapJson, Map.class);
        String taxUnitIdsJson = plugin.getPageCache().get("taxUnitIds");
        Set taxUnitIds = (Set)SerializationUtils.fromJsonString((String)taxUnitIdsJson, Set.class);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxfile.id", "in", declaredTaxDataMap.values()));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, stepCaseInfo);
        qFilters.add(new QFilter("bizstatus", "<", (Object)TaxDataBizStatusEnum.REFER.getCode()));
        HRBaseServiceHelper rawDataHelper = new HRBaseServiceHelper("itc_taxrawdata");
        DynamicObject[] taxSrcDataDys = rawDataHelper.query("id,taxunit", qFilters.toArray(new QFilter[0]));
        List needTobeReferedTaxSrcDatas = Arrays.stream(taxSrcDataDys).collect(Collectors.toList());
        TaxCategoryEntity taxCategoryEntity = taxTaskEntity.getTaxCategory(stepCaseInfo.getTabValue());
        HRBaseServiceHelper taxDataHelper = new HRBaseServiceHelper("itc_taxdata");
        QFilter taxDataFilter = new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId());
        taxDataFilter.and(new QFilter("taxfile.taxunit.id", "in", (Object)taxUnitIds));
        taxDataFilter.and(new QFilter("taxcategory.id", "=", (Object)taxCategoryEntity.getId()));
        taxDataFilter.and(new QFilter("status", "!=", (Object)"E"));
        Object[] taxDataDys = taxDataHelper.query("id,taxfile.taxunit,taxcategory", new QFilter[]{taxDataFilter});
        ArrayList<Object> needTobeSelectedTaxDatas = new ArrayList<Object>();
        if (!ArrayUtils.isEmpty((Object[])taxDataDys)) {
            void var19_23;
            Object[] objectArray = taxDataDys;
            int n = objectArray.length;
            boolean bl = false;
            while (var19_23 < n) {
                Object taxDataDy = objectArray[var19_23];
                if (!declaredTaxDataMap.containsKey(taxDataDy.getString("id"))) {
                    needTobeSelectedTaxDatas.add(taxDataDy);
                }
                ++var19_23;
            }
        }
        if (needTobeReferedTaxSrcDatas.size() != 0 || needTobeSelectedTaxDatas.size() != 0) {
            Object taUnit;
            LOGGER.info("needTobeReferedTaxSrcDatas size is {}", (Object)needTobeReferedTaxSrcDatas.size());
            LOGGER.info("needTobeSelectedTaxDatas size is {}", (Object)needTobeSelectedTaxDatas.size());
            HashMap<Long, Object> showTipsTaxUnitMap = new HashMap<Long, Object>();
            if (needTobeReferedTaxSrcDatas.size() != 0) {
                for (DynamicObject dynamicObject : needTobeReferedTaxSrcDatas) {
                    taUnit = dynamicObject.getDynamicObject("taxunit");
                    showTipsTaxUnitMap.put(taUnit.getLong("id"), taUnit);
                }
            }
            if (needTobeSelectedTaxDatas.size() != 0) {
                for (DynamicObject dynamicObject : needTobeSelectedTaxDatas) {
                    taUnit = dynamicObject.getDynamicObject("taxfile.taxunit");
                    showTipsTaxUnitMap.put(taUnit.getLong("id"), taUnit);
                }
            }
            List taxUnitNames = showTipsTaxUnitMap.values().stream().map(dy -> dy.getString("name")).collect(Collectors.toList());
            StringJoiner stringJoiner = new StringJoiner("\u201d\u3001\u201c", "\u201c", "\u201d");
            for (String taxUnitName : taxUnitNames) {
                stringJoiner.add(taxUnitName);
            }
            String msg = ResManager.loadKDString((String)"\u7eb3\u7a0e\u5355\u4f4d%s\u4e2d\u7684\u4e2a\u7a0e\u6e90\u6570\u636e\u6ca1\u6709\u5168\u90e8\u5bfc\u5165\u5230\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u6216\u8005\u6ca1\u6709\u5168\u90e8\u9009\u62e9\u5bfc\u51fa\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"TaxTaskDataExportViewHelper_3", (String)"sit-itc-business", (Object[])new Object[0]);
            String tip = String.format(Locale.ROOT, msg, stringJoiner.toString());
            TaxTaskGuideCacheData from = TaxTaskGuideCacheData.from((BatchResult<DynamicObject>)new BatchResult(true, null), taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.EXPORT_REPORT);
            plugin.getPageCache().put(CACHE_KEY_BETWEEN_REQUEST, SerializationUtils.toJsonString((Object)from));
            view.showConfirm(tip, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("confirm:" + TaxTaskGuideOpEnum.EXPORT_REPORT.getCode(), (IFormPlugin)plugin), null, "confirmReferedAndSelected");
            return;
        }
        DataHolder dealEx = new DataHolder((Object)Boolean.FALSE);
        TaxTaskDataExportViewHelper.openExportReportProgressBar(view, taxTaskEntity, (DataHolder<Boolean>)dealEx, stepCaseInfo, plugin);
    }

    public static BatchResult<DynamicObject> openExportReportProgressBar(IFormView view, TaxTaskEntity taxTaskEntity, DataHolder<Boolean> dealEx, TaxTaskGuideStepCaseInfo stepCaseInfo, AbstractFormPlugin plugin) {
        String declaredTaxUnitDataMapJson = plugin.getPageCache().get("declaredTaxUnitDataMap");
        Map declaredTaxUnitDataMap = (Map)SerializationUtils.fromJsonString((String)declaredTaxUnitDataMapJson, Map.class);
        LOGGER.info("declaredTaxUnitDataMap is {}", (Object)declaredTaxUnitDataMap.toString());
        TaskGuideReportExportTask task = new TaskGuideReportExportTask(view, taxTaskEntity, stepCaseInfo, plugin);
        task.setHandleCase(MultiThreadCase.BY_PROVIDER);
        task.prepareDataItem(declaredTaxUnitDataMap);
        MultiThreadTaskExecutor.execute((MultiThreadTask)task, (boolean)true, (ThreadPool)SITThreadPoolFactory.getExportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getExportHanddataThreadPool());
        dealEx.set((Object)Boolean.FALSE);
        return null;
    }

    public static void showResultMsgAfterOp(BatchResult<Map<String, Object>> result, String option, IFormView view) {
        int failSize;
        if (!result.isSuccess()) {
            view.showErrorNotification(result.getMessage());
            return;
        }
        List failResult = result.getFailResultOriginal();
        List successResult = result.getSuccessResult();
        if (CollectionUtils.isEmpty((Collection)failResult)) {
            String msg = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u6210\u529f{1}\u6761\u3002", (String)"TaxTaskDataExportViewHelper_8", (String)"sit-itc-business", (Object[])new Object[]{option, successResult.size()});
            view.showSuccessNotification(msg);
            SitLogServiceHelper.addLog(view, option, msg);
            return;
        }
        int successSize = successResult.size();
        int failSizeOld = failSize = failResult.size();
        int totalSize = failSize + successSize;
        Map status = result.failDataGroupByStatus();
        for (Map.Entry entry : status.entrySet()) {
            if ((Integer)entry.getKey() >= ResultStatusEnum.ERROR.getCode()) continue;
            int size = ((List)entry.getValue()).size();
            failSize -= size;
            successSize += size;
        }
        String title = ResManager.loadKDString((String)"{0}\u64cd\u4f5c\u5b8c\u6210\uff0c\u5171{1}\u6761\uff0c\u6210\u529f{2}\u6761\uff0c\u5931\u8d25{3}\u6761\u3002", (String)"TaxTaskDataExportViewHelper_9", (String)"sit-itc-business", (Object[])new Object[]{option, totalSize, successSize, failSize});
        SitLogServiceHelper.addLog(view, option, title);
        ArrayList<String> allMsg = new ArrayList<String>(failSizeOld);
        for (int i = 0; i < failSizeOld; ++i) {
            String message = ((ResultItem)failResult.get(i)).getMessage();
            allMsg.add(message);
        }
        FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultParameter((String)option, (String)title, allMsg);
        view.showForm(parameter);
    }

    private static BatchResult<DynamicObject> validateCalFailData(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Map<String, Long> declaredTaxDataMap, DataHolder<Boolean> dealReport, AbstractFormPlugin plugin) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxfile.id", "in", declaredTaxDataMap.values()));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, stepCaseInfo);
        qFilters.removeIf(qFilter -> "taxdatabasic.calstatus".equals(qFilter.getProperty()));
        QFilter calFilter = new QFilter("taxdatabasic.calstatus", "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter notRecFilter = new QFilter("taxdatabasic.srcstatus", "<", (Object)SrcStatus.RECEIVED.getCode());
        QFilter notCalFilter = new QFilter("taxdatabasic.calstatus", "=", (Object)YesOrNoEnum.NO.getCode());
        QFilter calNotRecFilter = calFilter.and(notRecFilter);
        notCalFilter.or(calNotRecFilter);
        qFilters.add(notCalFilter);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxrawdata");
        Object[] calFailDys = helper.query("id,taxdatabasic.calstatus,taxdatabasic.calstatus,taxfile.number,taxperson.name,taxdatabasic.rawcaltask.number,taxdatabasic.rawcaltask.name", qFilters.toArray(new QFilter[0]));
        if (!ArrayUtils.isEmpty((Object[])calFailDys)) {
            ArrayList<String> errorMessageResult = new ArrayList<String>(16);
            String totalMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u4efb\u52a1\u4e2d\u8fd8\u6709\u672a\u8ba1\u7b97\u6210\u529f\u7684\u8bb0\u5f55\uff0c\u65e0\u6cd5\u5bfc\u51fa\u7533\u62a5\u8868\u3002", (String)"TaxTaskDataExportViewHelper_10", (String)"sit-itc-business", (Object[])new Object[0]);
            String operationName = ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2a\u7a0e\u7533\u62a5\u8868", (String)"TaxTaskDataExportViewHelper_7", (String)"sit-itc-business", (Object[])new Object[0]);
            for (Object calFailDy : calFailDys) {
                StringBuilder tipBuilder = new StringBuilder();
                String taxFileNumber = calFailDy.getString("taxfile.number");
                String taxPersonName = calFailDy.getString("taxperson.name");
                String calTaskNumber = calFailDy.getString("taxdatabasic.rawcaltask.number");
                String calTaskName = calFailDy.getString("taxdatabasic.rawcaltask.name");
                tipBuilder.append(MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u5728{2}{3}\u5b58\u5728\u8ba1\u7b97\u5931\u8d25\u7684\u8bb0\u5f55\u3002", (String)"TaxTaskDataExportViewHelper_11", (String)"sit-itc-business", (Object[])new Object[0]), taxFileNumber, taxPersonName, calTaskNumber, calTaskName));
                errorMessageResult.add(tipBuilder.toString());
            }
            FormShowParameter parameters = SITShowFormServiceHelper.getOperationResultParameter((String)operationName, (String)totalMsg, errorMessageResult);
            view.showForm(parameters);
            dealReport.set((Object)Boolean.FALSE);
            return null;
        }
        return TaxTaskDataExportViewHelper.openTaxTemplateWindow(view, taxTaskEntity, stepCaseInfo, declaredTaxDataMap, dealReport, plugin, false);
    }
}

