/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sit.itc.business.common.SitCommonServiceHelper;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxsrcdata.TaxSrcDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.common.enums.SrcRefNumEnums;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.api.StepSwitcher;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITShowFormServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxGroupEntity;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.entity.TaxUnitEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.TaxPayerTypeEnum;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxDataSrcGroup;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.SitBaseUtil;

public class TaxTaskGuideServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskGuideServiceHelper.class);
    private static final String[] STATUS_NOT_EFFECT = new String[]{"D", "E"};

    private TaxTaskGuideServiceHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateReferSrcDataBasic(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Object[] srcDataIds) {
        Set taxUnitIds;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (ArrayUtils.isNotEmpty((Object[])srcDataIds)) {
            qFilters.add(new QFilter("id", "in", (Object)srcDataIds));
        }
        if (!SITPermissionServiceHelper.isSuperUser() && (taxUnitIds = SITPermissionServiceHelper.getTaxUnitSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxdata", (String)"47150e89000000ac")) != null) {
            qFilters.add(new QFilter("taxunit.id", "in", (Object)taxUnitIds));
        }
        GlobalParam.set((String)"_forRefData", (Object)Boolean.TRUE);
        try {
            TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, stepCaseInfo);
            List<Long> taxFileIdList = TaxSrcDataServiceHelper.findTaxFileIdFromSrcData(qFilters);
            if (CollectionUtils.isEmpty(taxFileIdList)) {
                String msg = !ArrayUtils.isEmpty((Object[])srcDataIds) ? ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u7b26\u5408\u5bfc\u5165\u6761\u4ef6\u3002", (String)"TaxTaskGuideServiceHelper_2", (String)"sit-itc-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxTaskGuideServiceHelper_1", (String)"sit-itc-business", (Object[])new Object[0]);
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(msg);
                return batchResult;
            }
            BatchResult batchResult = new BatchResult(true, taxFileIdList);
            return batchResult;
        }
        finally {
            GlobalParam.remove((String)"_forRefData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateRollbackReferSrcDataByPerson(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Object[] taxDataIds) {
        int expectSize;
        if (taxDataIds != null && taxDataIds.length == 0) {
            return new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55\u3002", (String)"TaxTaskGuideStep1Plugin_1", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (taxDataIds != null) {
            qFilters.add(new QFilter("yearmonth", "=", (Object)taxTaskEntity.yearMonth()));
            qFilters.add(new QFilter("id", "in", (Object)taxDataIds));
            expectSize = taxDataIds.length;
        } else {
            TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, null);
            expectSize = 2048;
        }
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxdata", (String)"taxfile.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u7b26\u5408\u9000\u56de\u6761\u4ef6\u3002", (String)"TaxTaskGuideServiceHelper_3", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            ArrayList taxFileList = new ArrayList(expectSize);
            dataSet.distinct().forEach(e1 -> taxFileList.add(e1.getLong("taxfile.id")));
            BatchResult batchResult = new BatchResult(true, taxFileList);
            return batchResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateRollbackReferSrcDataByTask(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long rawCalTaskId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxdatabasic.rawcaltask.id", "=", (Object)rawCalTaskId));
        qFilters.add(new QFilter("taxdata", "!=", (Object)0L));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, stepCaseInfo);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxrawdata", (String)"taxfile.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4efb\u52a1\u6ca1\u6709\u7b26\u5408\u9000\u56de\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"TaxTaskGuideServiceHelper_4", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            ArrayList taxFileList = new ArrayList(2048);
            dataSet.distinct().forEach(e1 -> taxFileList.add(e1.getLong("taxfile.id")));
            BatchResult batchResult = new BatchResult(true, taxFileList);
            return batchResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> basicValidateForRollbackFeedBackByTask(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long rawCalTaskId, Map<Long, Set<Long>> fileAndTaxDataIdMap) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxdatabasic.rawcaltask.id", "=", (Object)rawCalTaskId));
        qFilters.add(new QFilter("taxdata", "!=", (Object)0L));
        qFilters.add(new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId()));
        TaxTaskGuideServiceHelper.packageStatueFilter4SrcData(stepCaseInfo, qFilters, taxTaskEntity);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxrawdata", (String)"taxdata,taxfile.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u7b26\u5408\u5bfc\u5165\u6761\u4ef6\u3002", (String)"TaxTaskGuideServiceHelper_2", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            for (Row row : dataSet) {
                Long taxDataId = row.getLong("taxdata");
                Long taxFileId = row.getLong("taxfile.id");
                Set taxDataIds = fileAndTaxDataIdMap.computeIfAbsent(taxFileId, obj -> Sets.newHashSetWithExpectedSize((int)16));
                taxDataIds.add(taxDataId);
            }
            Iterator iterator = new BatchResult(true, new ArrayList<Long>(fileAndTaxDataIdMap.keySet()));
            return iterator;
        }
    }

    public static List<DynamicObject> loadTaxData(List<QFilter> qFilters) {
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdata").subProp("entryentity", new String[]{"entryyearmonth", "taxitem", "taxitem.caltaxtype", "taxitem.name", "taxcategory", "entrystatus", "entrymodifytime", "itemvalue", "calvalue", "diffvalue"}).subProp("taxdatabasic", new String[]{"calstatus", "taxtask.isneeddeclare"});
        Boolean forRefData = (Boolean)GlobalParam.getOrDefault((String)"_forRefData", (Object)Boolean.FALSE);
        if (forRefData.booleanValue()) {
            info.subProp("taxdatabasic", new String[]{"id"});
        }
        String prop = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, e1 -> !e1.contains("_"));
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
        DynamicObject[] taxDataArr = dataServiceHelper.query(prop, qFilters.toArray(new QFilter[0]));
        return new ArrayList<DynamicObject>(Arrays.asList(taxDataArr));
    }

    public static void packageTaxCatGroupFilter4SrcData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, List<QFilter> allFilters) {
        TaxTaskGuideServiceHelper.packageStatueFilter4SrcData(stepCaseInfo, allFilters, taxTaskEntity);
        Boolean forRefData = (Boolean)GlobalParam.getOrDefault((String)"_forRefData", (Object)Boolean.FALSE);
        if (!forRefData.booleanValue()) {
            if (stepCaseInfo.tabByGroup()) {
                TaxGroupEntity grp = taxTaskEntity.getTaxGroup(stepCaseInfo.getTabValue());
                GlobalParam.set((String)"groupId", (Object)grp.getId());
                QFilter grpFilter = new QFilter("taxcategory.group.id", "=", (Object)grp.getId());
                allFilters.add(grpFilter);
            } else {
                TaxCategoryEntity cat = taxTaskEntity.getTaxCategory(stepCaseInfo.getTabValue());
                GlobalParam.set((String)"categoryId", (Object)cat.getId());
                QFilter catFilter = new QFilter("taxcategory.id", "=", (Object)cat.getId());
                allFilters.add(catFilter);
            }
        }
        TaxTaskGuideOpEnum.convertFilters(allFilters);
    }

    public static void packageStatueFilter4SrcData(TaxTaskGuideStepCaseInfo stepCaseInfo, List<QFilter> allFilters, TaxTaskEntity taskEntity) {
        String stepCode;
        StepSwitcher switcher;
        Boolean forRefData = (Boolean)GlobalParam.getOrDefault((String)"_forRefData", (Object)Boolean.FALSE);
        if (!forRefData.booleanValue() && (switcher = StepSwitcher.getInstanceBy((String)(stepCode = stepCaseInfo.getStepCode()))) != null) {
            switcher.decorateFilterParameter(allFilters, taskEntity);
        }
        allFilters.add(new QFilter("status", "not in", (Object)STATUS_NOT_EFFECT));
    }

    public static void packageTaxCatGroupFilter4Data(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, List<QFilter> allFilters, Object[] ids) {
        TaxTaskGuideServiceHelper.packageFiltersForData(allFilters, taxTaskEntity, stepCaseInfo, ids);
        TaxTaskGuideServiceHelper.packageStatueFilter4Data(taxTaskEntity, stepCaseInfo, allFilters);
    }

    public static void packageStatueFilter4Data(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, List<QFilter> allFilters) {
        Boolean forRefData = (Boolean)GlobalParam.getOrDefault((String)"_forRefData", (Object)Boolean.FALSE);
        if (!forRefData.booleanValue()) {
            String stepCode = stepCaseInfo.getStepCode();
            StepSwitcher switcher = StepSwitcher.getInstanceBy((String)stepCode);
            switcher.decorateFilterParameter(allFilters, taxTaskEntity);
        }
        TaxTaskGuideOpEnum.convertFilters(allFilters);
    }

    public static void packageFiltersForData(List<QFilter> allFilters, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Object[] ids) {
        Boolean forRefData;
        if (!ArrayUtils.isEmpty((Object[])ids)) {
            allFilters.add(new QFilter("id", "in", (Object)ids));
        }
        if (!(forRefData = (Boolean)GlobalParam.getOrDefault((String)"_forRefData", (Object)Boolean.FALSE)).booleanValue()) {
            if (stepCaseInfo.tabByGroup()) {
                TaxGroupEntity grp = taxTaskEntity.getTaxGroup(stepCaseInfo.getTabValue());
                GlobalParam.set((String)"groupId", (Object)grp.getId());
                QFilter grpFilter = new QFilter("taxcategory.group.id", "=", (Object)grp.getId());
                allFilters.add(grpFilter);
                QFilter taxpayerTypeFilter = new QFilter("employment.taxpayertype.id", "=", (Object)grp.getTaxpayerTypeId());
                allFilters.add(taxpayerTypeFilter);
            } else {
                TaxCategoryEntity cat = taxTaskEntity.getTaxCategory(stepCaseInfo.getTabValue());
                GlobalParam.set((String)"categoryId", (Object)cat.getId());
                QFilter catFilter = new QFilter("taxcategory.id", "=", (Object)cat.getId());
                allFilters.add(catFilter);
                QFilter taxpayerTypeFilter = new QFilter("employment.taxpayertype.id", "=", (Object)cat.getTaxpayerTypeId());
                allFilters.add(taxpayerTypeFilter);
            }
        }
        TaxTaskGuideServiceHelper.packageBasicFiltersForData(allFilters, taxTaskEntity);
        if (taxTaskEntity.isLocalCal()) {
            SitCommonServiceHelper.addComputeFilter(allFilters);
        }
    }

    public static void recoverDataFromDb(TaxTaskGuideCacheData from, TaxTaskGuideOpEnum opEnum, ListSelectedRowCollection selectedRows) {
        List<Long> taxDataIds = from.getTaxDataIds();
        if (!CollectionUtils.isEmpty(taxDataIds)) {
            selectedRows = new ListSelectedRowCollection();
            for (Long id : taxDataIds) {
                selectedRows.add((Object)new ListSelectedRow((Object)id));
            }
        }
    }

    public static void packageBasicFiltersForData(List<QFilter> allFilters, TaxTaskEntity taxTaskEntity) {
        allFilters.add(new QFilter("yearmonth", "=", (Object)taxTaskEntity.yearMonth()));
        allFilters.add(new QFilter("status", "not in", (Object)STATUS_NOT_EFFECT));
        allFilters.add(new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId()));
        allFilters.add(new QFilter("taxfile.taxunit.id", "in", (Object)taxTaskEntity.taxUnitIds()));
    }

    public static DynamicObject[] loadTaxSrcData(List<QFilter> qFilters) {
        return TaxTaskGuideServiceHelper.loadTaxSrcData(qFilters, "");
    }

    public static DynamicObject[] loadTaxSrcData(List<QFilter> qFilters, String orderBy) {
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxrawdata").subProp("entryentity", new String[]{"datadirect", "entryyearmonth", "taxitem", "taxitem.datatype", "taxitem.currency", "taxitem.dataprecision", "itemvalue", "calvalue", "diffvalue"}).subProp("taxfile", new String[]{"id", "number", "bsed", "bsled"}).subProp("taxdatabasic", new String[]{"id", "srcstatus", "calstatus", "taxtask.isneeddeclare", "rawcaltask", "rawdatakey"});
        return SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])qFilters.toArray(new QFilter[0]), (String)orderBy);
    }

    public static void packageFiltersForSrcData(List<QFilter> qFilters, TaxTaskEntity taxTaskEntity, Object[] ids) {
        if (!ArrayUtils.isEmpty((Object[])ids)) {
            qFilters.add(new QFilter("id", "in", (Object)ids));
        }
        qFilters.add(new QFilter("status", "!=", (Object)"E"));
        qFilters.add(new QFilter("taxdatabasic.status", "!=", (Object)"E"));
        qFilters.add(new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId()));
        qFilters.add(new QFilter("yearmonth", "in", (Object)new int[]{taxTaskEntity.yearMonth(), 0}));
        qFilters.add(new QFilter("taxfile.taxunit.id", "in", (Object)taxTaskEntity.taxUnitIds()));
    }

    public static void packageFiltersForSrcData(List<QFilter> qFilters, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, new Object[0]);
        Boolean forRefData = (Boolean)GlobalParam.getOrDefault((String)"_forRefData", (Object)Boolean.FALSE);
        if (!forRefData.booleanValue()) {
            if (stepCaseInfo.tabByGroup()) {
                TaxGroupEntity taxGroup = taxTaskEntity.getTaxGroup(stepCaseInfo.getTabValue());
                qFilters.add(new QFilter("taxcategory.group.id", "=", (Object)taxGroup.getId()));
                qFilters.add(new QFilter("taxcategory.taxpayertype.id", "=", (Object)taxGroup.getTaxpayerTypeId()));
                qFilters.add(new QFilter("employment.taxpayertype.id", "=", (Object)taxGroup.getTaxpayerTypeId()));
            } else {
                TaxCategoryEntity taxCategory = taxTaskEntity.getTaxCategory(stepCaseInfo.getTabValue());
                qFilters.add(new QFilter("taxcategory.id", "=", (Object)taxCategory.getId()));
                qFilters.add(new QFilter("taxcategory.taxpayertype.id", "=", (Object)taxCategory.getTaxpayerTypeId()));
                qFilters.add(new QFilter("employment.taxpayertype.id", "=", (Object)taxCategory.getTaxpayerTypeId()));
            }
        }
        SitCommonServiceHelper.addComputeFilter(qFilters);
    }

    public static BatchResult<DynamicObject> validateEnd(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, IFormView view, IFormPlugin plugin) {
        BatchResult<DynamicObject> result = TaxTaskGuideServiceHelper.validateIsExistUnRefSrcDataOrUnDeclareTaxData(taxTaskEntity, stepCaseInfo, "itc_taxrawdata");
        CloseCallBack cb = null;
        if (null != result) {
            cb = new CloseCallBack(plugin, "itc_taxrawdata");
            FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultsParameter((CloseCallBack)cb, null, null, Collections.singletonList(result.getMessage()));
            view.showForm(parameter);
            return result;
        }
        result = TaxTaskGuideServiceHelper.validateIsExistUnRefSrcDataOrUnDeclareTaxData(taxTaskEntity, stepCaseInfo, "itc_taxdata");
        if (null != result) {
            cb = new CloseCallBack(plugin, "itc_taxdata");
            FormShowParameter parameter = SITShowFormServiceHelper.getOperationResultsParameter((CloseCallBack)cb, null, null, Collections.singletonList(result.getMessage()));
            view.showForm(parameter);
            return result;
        }
        return null;
    }

    public static BatchResult<DynamicObject> endData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        BatchResult<DynamicObject> result = TaxTaskGuideServiceHelper.queryStep4AllTaxData(taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_END.getCode(), null);
        result = TaxTaskGuideServiceHelper.doSetTaxDataEndStatus2End(result, taxTaskEntity, stepCaseInfo, true);
        return result;
    }

    public static BatchResult<DynamicObject> rollbackEndData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        BatchResult<DynamicObject> result = TaxTaskGuideServiceHelper.queryStep4AllTaxData(taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.END.getCode(), null);
        BatchResult<DynamicObject> dynamicObjectBatchResult = null;
        Set<Long> taxFileIds = TaxTaskGuideServiceHelper.getUnlockedTaxFileId(result);
        dynamicObjectBatchResult = TaxDataServiceHelper.saveTaxData(result, taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_END, true, () -> {
            if (!CollectionUtils.isEmpty((Collection)taxFileIds)) {
                TaxTaskGuideServiceHelper.lockTaxFile(taxFileIds);
            }
        });
        return dynamicObjectBatchResult;
    }

    public static BatchResult<DynamicObject> validateRollbackDeclare(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long taxUnitId) {
        List confirmTaxDatas;
        List successResult;
        QFilter filter = new QFilter("reportoprecord.optype", "=", (Object)TaxTaskGuideOpEnum.DECLARE.getCode());
        filter.and(new QFilter("taxfile.taxunit.id", "=", (Object)taxUnitId));
        BatchResult<DynamicObject> result = TaxTaskGuideServiceHelper.queryStep4AllTaxData(taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_END.getCode(), filter);
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskEntity.getTaxTaskType()) && !CollectionUtils.isEmpty((Collection)(successResult = result.getSuccessResult())) && !CollectionUtils.isEmpty(confirmTaxDatas = successResult.stream().filter(dy -> YesOrNoEnum.isYes((String)dy.getString("confirmoprecord.result"))).collect(Collectors.toList()))) {
            result.setStatus(ResultStatusEnum.WARN.getCode());
        }
        return result;
    }

    public static BatchResult<DynamicObject> rollbackDeclareData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, BatchResult<DynamicObject> result) {
        return TaxDataServiceHelper.saveTaxData(result, taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_DECLARE, true, new CustomFunction[0]);
    }

    public static DynamicObject operateTaxTask(TaxTaskEntity taxTaskEntity, String endStatus) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtask");
        DynamicObject dynamicObject = serviceHelper.queryOne("id,endstatus", (Object)taxTaskEntity.getId());
        if (null != endStatus) {
            dynamicObject.set("endstatus", (Object)endStatus);
            serviceHelper.updateOne(dynamicObject);
        }
        return dynamicObject;
    }

    public static BatchResult<Long> validateDeclare(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long taxUnitId) {
        BatchResult<Long> result = TaxTaskGuideServiceHelper.validateForDeclareByTaskUnit(taxTaskEntity, stepCaseInfo, taxUnitId);
        if (!result.isSuccess()) {
            return result;
        }
        GlobalParam.set((String)"result", result);
        return result;
    }

    public static List<String> validatePrepareAndPersonDeclareForDeclare(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long taxUnitId) {
        ArrayList<String> list = new ArrayList<String>(16);
        HashSet personDeclareSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet prepareSet = Sets.newHashSetWithExpectedSize((int)16);
        List<DynamicObject> dys = TaxTaskGuideServiceHelper.queryStep30NoPersonDeclareTaxData(taxTaskEntity, stepCaseInfo, taxUnitId);
        for (DynamicObject dy : dys) {
            String msg = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7{0}\uff1a{1}\u4eba\u5458\u672a\u62a5\u9001\u3002", (String)"TaxTaskGuideServiceHelper_25", (String)"sit-itc-business", (Object[])new Object[]{dy.getString("taxfile.number"), dy.getString("taxperson.name")});
            if (personDeclareSet.contains(dy.getString("taxfile.number"))) continue;
            list.add(msg);
            personDeclareSet.add(dy.getString("taxfile.number"));
        }
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskEntity.getTaxTaskType())) {
            List<DynamicObject> datas = TaxTaskGuideServiceHelper.queryStep3OPrepareTaxData(taxTaskEntity, stepCaseInfo, taxUnitId);
            datas = TaxTaskGuideServiceHelper.getResidentData(datas);
            for (DynamicObject dy : datas) {
                String msg = ResManager.loadKDString((String)"\u6863\u6848\u7f16\u53f7{0}\uff1a{1}\u4eba\u5458\u7b97\u7a0e\u6570\u636e\u672a\u51c6\u5907\u5b8c\u6210\u3002", (String)"TaxTaskGuideServiceHelper_26", (String)"sit-itc-business", (Object[])new Object[]{dy.getString("taxfile.number"), dy.getString("taxperson.name")});
                if (prepareSet.contains(dy.getString("taxfile.number"))) continue;
                list.add(msg);
                prepareSet.add(dy.getString("taxfile.number"));
            }
        }
        return list;
    }

    private static List<DynamicObject> getResidentData(List<DynamicObject> datas) {
        HashSet employmentIds = Sets.newHashSetWithExpectedSize((int)datas.size());
        HashMap map = Maps.newHashMapWithExpectedSize((int)datas.size());
        for (DynamicObject data : datas) {
            long employmentId = data.getLong("taxdatabasic.employment.id");
            if (0L == employmentId) continue;
            employmentIds.add(employmentId);
            Set dynamicObjects = map.computeIfAbsent(employmentId, key -> Sets.newHashSetWithExpectedSize((int)8));
            dynamicObjects.add(data);
        }
        if (CollectionUtils.isEmpty((Collection)employmentIds)) {
            return datas;
        }
        QFilter qFilter = new QFilter("id", "in", (Object)employmentIds);
        QFilter taxPayerTypeFilter = new QFilter("taxpayertype.id", "=", (Object)TaxPayerTypeEnum.TAX_PAYER_TYPE_1010.getId());
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_employment");
        Object[] employmentArr = dataServiceHelper.query("taxpayertype.number", new QFilter[]{qFilter, taxPayerTypeFilter});
        if (ArrayUtils.isEmpty((Object[])employmentArr)) {
            return datas;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(datas.size());
        for (Object employmentDy : employmentArr) {
            Set dynamicObjects = (Set)map.get(employmentDy.getLong("id"));
            list.addAll(dynamicObjects);
        }
        return list;
    }

    public static Set<Long> getUnlockedTaxFileId(BatchResult<DynamicObject> result) {
        List taxDataDys = result.getSuccessResult();
        HashSet taxFileIds = Sets.newHashSetWithExpectedSize((int)taxDataDys.size());
        for (DynamicObject taxDataDy : taxDataDys) {
            String lockStatus = taxDataDy.getString("taxfile.lockstatus");
            if (YesOrNoEnum.YES.getCode().equals(lockStatus)) continue;
            taxFileIds.add(taxDataDy.getLong("taxfile.id"));
        }
        return taxFileIds;
    }

    public static void lockTaxFile(Set<Long> taxFileIds) {
        DynamicObject[] taxFileDys;
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxfile");
        QFilter qFilter = new QFilter("id", "in", taxFileIds);
        for (DynamicObject taxFileDy : taxFileDys = helper.query("id,lockstatus", new QFilter[]{qFilter})) {
            taxFileDy.set("lockstatus", (Object)YesOrNoEnum.YES.getCode());
        }
        helper.update(taxFileDys);
    }

    public static BatchResult<DynamicObject> doSetTaxDataBizStatus2Export(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, BatchResult<DynamicObject> result) {
        return TaxDataServiceHelper.saveTaxData(result, taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.EXPORT_REPORT, true, new CustomFunction[0]);
    }

    public static BatchResult<DynamicObject> doSetTaxDataEndStatus2End(BatchResult<DynamicObject> result, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, boolean taxTaskFlag) {
        result = TaxDataServiceHelper.saveTaxData(result, taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.END, true, () -> {
            if (taxTaskFlag) {
                TaxTaskGuideServiceHelper.operateTaxTask(taxTaskEntity, YesOrNoEnum.YES.getCode());
            }
        });
        Set unlockedTaxFileIds = result.getSuccessResult().stream().map(dy -> dy.getLong("taxfile.id")).collect(Collectors.toSet());
        ThreadPools.executeOnce((String)"unlockTaxFiles", () -> {
            DynamicObject[] taxFileDys;
            QFilter qFilter = new QFilter("taxfile.id", "in", (Object)unlockedTaxFileIds);
            qFilter.and("endoprecord.result", "=", (Object)YesOrNoEnum.NO.getCode());
            qFilter.and(new QFilter("status", "not in", Arrays.asList("D", "E")));
            HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdata");
            DynamicObject[] lockedTaxFileTaxDataDys = helper.query("id,taxfile", new QFilter[]{qFilter});
            Set excludeTaxFileIds = Arrays.stream(lockedTaxFileTaxDataDys).map(dy -> dy.getLong("taxfile.id")).collect(Collectors.toSet());
            unlockedTaxFileIds.removeAll(excludeTaxFileIds);
            HRBaseServiceHelper taxFileHelper = new HRBaseServiceHelper("itc_taxfile");
            QFilter idQFilter = new QFilter("id", "in", (Object)unlockedTaxFileIds);
            for (DynamicObject taxFileDy : taxFileDys = taxFileHelper.query("id,lockstatus", new QFilter[]{idQFilter})) {
                taxFileDy.set("lockstatus", (Object)YesOrNoEnum.NO.getCode());
            }
            LOGGER.info("Trace by wenbin: {}", (Object)"unlock taxfile begin");
            taxFileHelper.update(taxFileDys);
            LOGGER.info("Trace by wenbin: {}", (Object)"unlock taxfile finish");
        });
        LOGGER.info("Trace By Quinn: {} - {}", (Object)"after modifyTaxFiles");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> validateCategoryComplete(TaxTaskEntity taxTaskEntity, List<QFilter> filters) {
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(filters, taxTaskEntity, new Object[0]);
        DataSet dataSet = null;
        DataSet distinct = null;
        try {
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxrawdata", (String)"employment.taxpayertype.id,taxcategory.id,taxcategory.taxpayertype.id", (QFilter[])filters.toArray(new QFilter[0]), (String)"");
            distinct = dataSet.distinct();
            HashSet<Long> taxCategories = new HashSet<Long>(16);
            distinct.forEach(e1 -> {
                if (e1.getLong("employment.taxpayertype.id").equals(e1.getLong("taxcategory.taxpayertype.id"))) {
                    taxCategories.add(e1.getLong("taxcategory.id"));
                }
            });
            List taxCategoryEntityList = taxTaskEntity.getTaxCategoryEntityList();
            List collect = taxCategoryEntityList.stream().map(TaxCategoryEntity::getId).collect(Collectors.toList());
            taxCategories.removeAll(collect);
            HashSet<Long> hashSet = taxCategories;
            return hashSet;
        }
        finally {
            if (dataSet != null) {
                dataSet.close();
            }
            if (distinct != null) {
                distinct.close();
            }
        }
    }

    public static BaseResult<DynamicObject> createTaxTaskRecord(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, Map<String, Object> param) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtaskrecord");
        DynamicObject taxTaskOpRecord = serviceHelper.generateEmptyDynamicObject();
        taxTaskOpRecord.set("id", (Object)ORM.create().genLongId("itc_taxtaskrecord"));
        taxTaskOpRecord.set("optype", (Object)opEnum.getCode());
        taxTaskOpRecord.set("result", (Object)(opEnum.name().startsWith("ROLLBACK") ? "0" : "1"));
        taxTaskOpRecord.set("taxtask", (Object)taxTaskEntity.getId());
        taxTaskOpRecord.set("step", (Object)stepCaseInfo.getStepCode());
        if (stepCaseInfo.tabByGroup()) {
            taxTaskOpRecord.set("taxgroup", (Object)stepCaseInfo.getTabValue());
        } else {
            taxTaskOpRecord.set("taxcategory", (Object)stepCaseInfo.getTabValue());
        }
        if (param != null) {
            taxTaskOpRecord.set("description", (Object)JSONObject.toJSONString(param));
        }
        SitBaseUtil.initSystemProp((DynamicObject)taxTaskOpRecord);
        if (TaxTaskGuideOpEnum.isYes((String)opEnum.getCode())) {
            taxTaskOpRecord.set("showtime", (Object)new Date());
        } else {
            taxTaskOpRecord.set("creator", (Object)0L);
        }
        serviceHelper.saveOne(taxTaskOpRecord);
        return BaseResult.success((Object)taxTaskOpRecord);
    }

    public static DynamicObject cloneTaxTaskRecord(DynamicObject taxTaskRecord, TaxTaskGuideOpEnum opEnum) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtaskrecord");
        DynamicObject taxTaskRecordNew = serviceHelper.generateEmptyDynamicObject();
        taxTaskRecordNew.set("id", (Object)ORM.create().genLongId("itc_taxtaskrecord"));
        taxTaskRecordNew.set("optype", (Object)opEnum.getCode());
        taxTaskRecordNew.set("result", (Object)(opEnum.name().startsWith("ROLLBACK") ? "0" : "1"));
        taxTaskRecordNew.set("taxtask", taxTaskRecord.get("taxtask"));
        taxTaskRecordNew.set("step", taxTaskRecord.get("step"));
        taxTaskRecordNew.set("taxgroup", taxTaskRecord.get("taxgroup"));
        taxTaskRecordNew.set("taxcategory", taxTaskRecord.get("taxcategory"));
        String description = taxTaskRecord.getString("description");
        Object param = !StringUtils.isEmpty((CharSequence)description) ? JSONObject.parseObject((String)description) : new HashMap(2);
        param.put("from", taxTaskRecord.getLong("id"));
        taxTaskRecordNew.set("description", (Object)JSONObject.toJSONString((Object)param));
        SitBaseUtil.initSystemProp((DynamicObject)taxTaskRecordNew);
        if (TaxTaskGuideOpEnum.isYes((String)opEnum.getCode())) {
            taxTaskRecordNew.set("showtime", (Object)new Date());
        } else {
            taxTaskRecordNew.set("creator", (Object)0L);
        }
        serviceHelper.saveOne(taxTaskRecordNew);
        return taxTaskRecordNew;
    }

    public static BatchResult<Long> validateRollbackLockByPerson(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Object[] taxDataIds) {
        return TaxTaskGuideServiceHelper.basicValidateForRollbackOpByPerson(taxTaskEntity, stepCaseInfo, taxDataIds, TaxTaskGuideOpEnum.ROLLBACK_LOCK_BY_PERSON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> basicValidateForRollbackOpByPerson(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Object[] taxDataIds, TaxTaskGuideOpEnum opEnum) {
        int expectSize;
        if (taxDataIds != null && taxDataIds.length == 0) {
            return new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8bb0\u5f55\u3002", (String)"TaxTaskGuideStep1Plugin_1", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        if (taxDataIds != null) {
            qFilters.add(new QFilter("yearmonth", "=", (Object)taxTaskEntity.yearMonth()));
            qFilters.add(new QFilter("id", "in", (Object)taxDataIds));
            expectSize = taxDataIds.length;
        } else {
            TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, null);
            if (opEnum == TaxTaskGuideOpEnum.FEEDBACK) {
                TaxTaskGuideServiceHelper.packageStatueFilter4Data(taxTaskEntity, stepCaseInfo, qFilters);
            }
            expectSize = 2048;
        }
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxdata", (String)"id,taxfile.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u7b26\u5408\u5bfc\u5165\u6761\u4ef6\u3002", (String)"TaxTaskGuideServiceHelper_2", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            switch (opEnum) {
                case ROLLBACK_REFER_SRC_DATA_BY_PERSON: 
                case FEEDBACK: {
                    HashSet taxFileSet = new HashSet(expectSize);
                    dataSet.distinct().forEach(e1 -> taxFileSet.add(e1.getLong("taxfile.id")));
                    ArrayList taxFileList = new ArrayList(taxFileSet);
                    BatchResult batchResult = new BatchResult(true, taxFileList);
                    return batchResult;
                }
                case ROLLBACK_LOCK_BY_PERSON: {
                    BatchResult<Long> batchResult = TaxTaskGuideServiceHelper.getBatchResultForRollbackLockByPerson(dataSet, expectSize, taxTaskEntity, stepCaseInfo);
                    return batchResult;
                }
            }
            BatchResult<Long> batchResult = null;
            return batchResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BatchResult<Long> getBatchResultForRollbackLockByPerson(DataSet dataSet, int expectSize, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        HashSet taxFileIds = new HashSet(expectSize);
        dataSet.forEach(e1 -> taxFileIds.add(e1.getLong("taxfile.id")));
        ArrayList<QFilter> finalQFilters = new ArrayList<QFilter>(10);
        finalQFilters.add(new QFilter("yearmonth", "=", (Object)taxTaskEntity.yearMonth()));
        finalQFilters.add(new QFilter("taxfile.id", "in", taxFileIds));
        finalQFilters.add(new QFilter("status", "not in", Arrays.asList("D", "E")));
        finalQFilters.add(new QFilter("taxcategory.group.id", "=", (Object)stepCaseInfo.getTabValue()));
        finalQFilters.add(new QFilter("bizstatus", "in", Arrays.asList(TaxDataBizStatusEnum.EXPORT_LOCK.getCode(), TaxDataBizStatusEnum.IMPORT.getCode(), TaxDataBizStatusEnum.FEEDBACK.getCode())));
        ArrayList taxDataList = new ArrayList(expectSize);
        try (DataSet finalDataSet = null;){
            finalDataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxdata", (String)"id,taxfile.id", (QFilter[])finalQFilters.toArray(new QFilter[0]), (String)"");
            if (finalDataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u7b26\u5408\u5bfc\u5165\u6761\u4ef6\u3002", (String)"TaxTaskGuideServiceHelper_2", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            finalDataSet.distinct().forEach(e1 -> taxDataList.add(e1.getLong("id")));
            BatchResult batchResult = new BatchResult(true, taxDataList);
            return batchResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateRollbackLockByTask(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long rawCalTaskId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxdatabasic.rawcaltask.id", "=", (Object)rawCalTaskId));
        qFilters.add(new QFilter("yearmonth", "=", (Object)taxTaskEntity.yearMonth()));
        qFilters.add(new QFilter("taxdata", "!=", (Object)0L));
        qFilters.add(new QFilter("status", "not in", Arrays.asList("D", "E")));
        TaxTaskGuideServiceHelper.packageTaxCatGroupFilter4SrcData(taxTaskEntity, stepCaseInfo, qFilters);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxrawdata", (String)"taxdata,taxfile.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u7b26\u5408\u5bfc\u5165\u6761\u4ef6\u3002", (String)"TaxTaskGuideServiceHelper_2", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            ArrayList taxDataList = new ArrayList(2048);
            dataSet.distinct().forEach(e1 -> taxDataList.add(e1.getLong("taxdata")));
            BatchResult batchResult = new BatchResult(true, taxDataList);
            return batchResult;
        }
    }

    public static BatchResult<DynamicObject> validateIsExistUnRefSrcDataOrUnDeclareTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, String pageNum) {
        List<DynamicObject> dataList = TaxTaskGuideServiceHelper.queryData(taxTaskEntity, stepCaseInfo, true, pageNum);
        BatchResult result = null;
        if (!CollectionUtils.isEmpty(dataList)) {
            result = HRStringUtils.equals((String)"itc_taxrawdata", (String)pageNum) ? new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5bfc\u5165\u7684\u85aa\u8d44\u6838\u7b97\u8bb0\u5f55\uff0c\u7ed3\u675f\u4e2a\u7a0e\u4efb\u52a1\u5931\u8d25\u3002", (String)"TaxTaskGuideServiceHelper_18", (String)"sit-itc-business", (Object[])new Object[0])) : (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(taxTaskEntity.getTaxTaskType()) ? new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u7533\u62a5\u548c\u672a\u786e\u8ba4\u7684\u4e2a\u7a0e\u6570\u636e\uff0c\u7ed3\u675f\u4e2a\u7a0e\u4efb\u52a1\u5931\u8d25\u3002", (String)"TaxTaskGuideServiceHelper_24", (String)"sit-itc-business", (Object[])new Object[0])) : new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u7533\u62a5\u7684\u4e2a\u7a0e\u6570\u636e\uff0c\u7ed3\u675f\u4e2a\u7a0e\u4efb\u52a1\u5931\u8d25\u3002", (String)"TaxTaskGuideServiceHelper_19", (String)"sit-itc-business", (Object[])new Object[0])));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DynamicObject> queryData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, boolean isQueryOne, String pageNum) {
        GlobalParam.set((String)"_forRefData", (Object)Boolean.TRUE);
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            if (HRStringUtils.equals((String)"itc_taxrawdata", (String)pageNum)) {
                qFilters.add(new QFilter("reportoprecord.optype", "in", (Object)new String[]{TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_PERSON.getCode(), TaxTaskGuideOpEnum.ROLLBACK_REFER_SRC_DATA_BY_TASK.getCode()}));
                TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, stepCaseInfo);
            } else {
                if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(taxTaskEntity.getTaxTaskType())) {
                    qFilters.add(new QFilter("reportoprecord.optype", "in", (Object)new String[]{TaxTaskGuideOpEnum.ROLLBACK_DECLARE.getCode(), TaxTaskGuideOpEnum.ROLLBACK_CONFIRM.getCode()}));
                } else {
                    qFilters.add(new QFilter("confirmoprecord.optype", "in", (Object)new String[]{TaxTaskGuideOpEnum.ROLLBACK_DECLARE.getCode(), TaxTaskGuideOpEnum.ROLLBACK_CONFIRM.getCode()}));
                }
                TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, new Object[0]);
            }
            HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper(pageNum);
            List<Object> list = new ArrayList<DynamicObject>(16);
            if (isQueryOne) {
                DynamicObject dynamicObject = dataServiceHelper.queryOne(qFilters.toArray(new QFilter[0]));
                if (null != dynamicObject) {
                    list.add(dynamicObject);
                }
            } else {
                DynamicObject[] dynamicObjects = dataServiceHelper.query("taxfile.number,taxfile.taxperson.name", qFilters.toArray(new QFilter[0]));
                if (null != dynamicObjects && 0 != dynamicObjects.length) {
                    list = Arrays.stream(dynamicObjects).collect(Collectors.toList());
                }
            }
            ArrayList<DynamicObject> arrayList = list;
            return arrayList;
        }
        finally {
            GlobalParam.remove((String)"_forRefData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<DynamicObject> queryStep4AllTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, String code, QFilter filter) {
        GlobalParam.set((String)"_forRefData", (Object)Boolean.TRUE);
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter("endoprecord.optype", "=", (Object)code));
            if (null != filter) {
                qFilters.add(filter);
            }
            TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, new Object[0]);
            HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
            DynamicObject[] dynamicObjects = dataServiceHelper.query("id,endoprecord.optype,reportoprecord.optype,exportoprecord,lockoprecord,importoprecord,feedbackoprecord,endoprecord,taxfile,bizstatus,confirmoprecord,refoprecord", qFilters.toArray(new QFilter[0]));
            BatchResult batchResult = new BatchResult(true, Arrays.asList(dynamicObjects));
            return batchResult;
        }
        finally {
            GlobalParam.remove((String)"_forRefData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateForDeclareByTaskUnit(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long taxUnitId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxfile.taxunit.id", "=", (Object)taxUnitId));
        qFilters.add(new QFilter("refoprecord.result", "=", (Object)YesOrNoEnum.NO.getCode()));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, new Arrays[0]);
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxrawdata");
        DynamicObject dynamicObject = dataServiceHelper.queryOne(qFilters.toArray(new QFilter[0]));
        if (null != dynamicObject) {
            return new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"%s\u8fd8\u6709\u672a\u5bfc\u5165\u7684\u7b97\u85aa\u6570\u636e\uff0c\u65e0\u6cd5\u6807\u8bb0\u7533\u62a5\u3002", (String)"TaxTaskGuideServiceHelper_20", (String)"sit-itc-business", (Object[])new Object[]{((TaxUnitEntity)taxTaskEntity.getTaxUnitMap().get(taxUnitId)).localName()}));
        }
        qFilters.clear();
        qFilters.add(new QFilter("taxfile.taxunit.id", "=", (Object)taxUnitId));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, taxTaskEntity, new Arrays[0]);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxrawdata", (String)"taxdata", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u7eb3\u7a0e\u5355\u4f4d%s\u6ca1\u6709\u7b26\u5408\u6807\u8bb0\u7533\u62a5\u6761\u4ef6\u7684\u8bb0\u5f55\u3002", (String)"TaxTaskGuideServiceHelper_22", (String)"sit-itc-business", (Object[])new Object[]{((TaxUnitEntity)taxTaskEntity.getTaxUnitMap().get(taxUnitId)).localName()}));
                return batchResult;
            }
            ArrayList taxDataList = new ArrayList(16);
            dataSet.distinct().forEach(e1 -> taxDataList.add(e1.getLong("taxdata")));
            BatchResult batchResult = new BatchResult(true, taxDataList);
            return batchResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateRollbackImport(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long taxUnitId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("taxfile.taxunit.id", "=", (Object)taxUnitId));
        if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(taxTaskEntity.getTaxTaskType())) {
            qFilters.add(new QFilter("bizstatus", "=", (Object)TaxDataBizStatusEnum.IMPORT.getCode()));
        }
        TaxTaskGuideServiceHelper.packageTaxCatGroupFilter4Data(taxTaskEntity, stepCaseInfo, qFilters, null);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxdata", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u7eb3\u7a0e\u5355\u4f4d\u4e0b\u6ca1\u6709\u7b26\u5408\u5220\u9664\u6761\u4ef6\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u8bd5\u3002", (String)"TaxTaskGuideServiceHelper_21", (String)"sit-itc-business", (Object[])new Object[]{((TaxUnitEntity)taxTaskEntity.getTaxUnitMap().get(taxUnitId)).localName()}));
                return batchResult;
            }
            ArrayList taxFileList = new ArrayList(16);
            dataSet.distinct().forEach(e1 -> taxFileList.add(e1.getLong("id")));
            BatchResult batchResult = new BatchResult(true, taxFileList);
            return batchResult;
        }
    }

    public static void repackageResult(BatchResult<TaxDataSrcGroup<Long, DynamicObject>> result, BatchResult<DynamicObject> resultAfterOp) {
        if (!CollectionUtils.isEmpty((Collection)resultAfterOp.getFailResult())) {
            Map<Long, TaxDataSrcGroup> groupMap = result.getSuccessResult().stream().collect(Collectors.toMap(group -> ((DynamicObject)group.getTaxData()).getLong("id"), group -> group));
            List failResultOriginal = resultAfterOp.getFailResultOriginal();
            for (ResultItem failItem : failResultOriginal) {
                DynamicObject taxData = (DynamicObject)failItem.getData();
                long failTaxDataId = taxData.getLong("id");
                String message = failItem.getMessage();
                result.successItemToFail((Object)groupMap.get(failTaxDataId), message);
            }
        }
    }

    public static boolean checkTaskSnapShotWithTaxtemplate(String templateId, TaxTaskEntity taxTaskEntity) {
        String selectProperties = "id, isonly, importfield, taxitem, fieldkey, ismustinput";
        HRBaseServiceHelper helper = new HRBaseServiceHelper("sitbs_taxtemplate");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(templateId));
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject dynamicObject = helper.queryOne(selectProperties, qFilters);
        DynamicObjectCollection dys = dynamicObject.getDynamicObjectCollection("entryentity");
        HashSet<Long> set = new HashSet<Long>(dys.size());
        for (DynamicObject dy : dys) {
            long id = dy.getLong("taxitem.id");
            if (0L == id) continue;
            set.add(id);
        }
        Map taxItemMap = taxTaskEntity.getTaxItemMap();
        for (Long id : set) {
            TaxItemEntity taxItemEntity = (TaxItemEntity)taxItemMap.get(id);
            if (null != taxItemEntity) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject queryStep4OneTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, QFilter filter) {
        GlobalParam.set((String)"_forRefData", (Object)Boolean.TRUE);
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter("reportoprecord.optype", "=", (Object)TaxTaskGuideOpEnum.DECLARE.getCode()));
            if (null != filter) {
                qFilters.add(filter);
            }
            TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, new Object[0]);
            HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
            DynamicObject dynamicObject = dataServiceHelper.queryOne(qFilters.toArray(new QFilter[0]));
            return dynamicObject;
        }
        finally {
            GlobalParam.remove((String)"_forRefData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObject queryStep3OneTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, String code, QFilter filter) {
        GlobalParam.set((String)"_forRefData", (Object)Boolean.TRUE);
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter("reportoprecord.result", "=", (Object)YesOrNoEnum.NO.getCode()));
            qFilters.add(new QFilter("lockoprecord.result", "=", (Object)YesOrNoEnum.YES.getCode()));
            TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, new Object[0]);
            HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
            DynamicObject dynamicObject = dataServiceHelper.queryOne(qFilters.toArray(new QFilter[0]));
            return dynamicObject;
        }
        finally {
            GlobalParam.remove((String)"_forRefData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateConfirm(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("reportoprecord.result", "=", (Object)YesOrNoEnum.YES.getCode()));
        TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, new Object[0]);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxdata", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\u53ef\u4ee5\u786e\u8ba4\u7ed3\u679c\u3002", (String)"TaxTaskGuideServiceHelper_23", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            ArrayList taxDataList = new ArrayList(16);
            dataSet.distinct().forEach(taxData -> taxDataList.add(taxData.getLong("id")));
            BatchResult batchResult = new BatchResult(true, taxDataList);
            return batchResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateRollbackConfirm(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("confirmoprecord.result", "=", (Object)YesOrNoEnum.YES.getCode()));
        TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, new Object[0]);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxdata", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u6570\u636e\u53ef\u4ee5\u786e\u8ba4\u7ed3\u679c\u3002", (String)"TaxTaskGuideServiceHelper_23", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            ArrayList taxDataList = new ArrayList(16);
            dataSet.distinct().forEach(taxData -> taxDataList.add(taxData.getLong("id")));
            BatchResult batchResult = new BatchResult(true, taxDataList);
            return batchResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> getTaxUnitMapForRollImport(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("importoprecord.optype", "=", (Object)TaxTaskGuideOpEnum.IMPORT.getCode()));
        TaxTaskGuideServiceHelper.packageStatueFilter4Data(taxTaskEntity, stepCaseInfo, qFilters);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxdata", (String)"id,taxfile.id,taxfile.taxunit.id", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                Set<Long> set = null;
                return set;
            }
            HashSet<Long> taxFileSet = new HashSet<Long>(16);
            dataSet.distinct().forEach(e1 -> taxFileSet.add(e1.getLong("taxfile.taxunit.id")));
            HashSet<Long> hashSet = taxFileSet;
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getIntroducedNum(Object[] taxDataBasicIds) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("id", "in", (Object)taxDataBasicIds));
        filters.add(new QFilter("bizstatus", "=", (Object)YesOrNoEnum.YES.getCode()));
        try (DataSet introducedDataSet = null;){
            introducedDataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxpreparedata", (String)"id", (QFilter[])filters.toArray(new QFilter[0]), (String)"");
            int introducedNum = introducedDataSet.count("id", false);
            LOGGER.info("filters is {} and introducedNum is {}", (Object)((Object)filters).toString(), (Object)introducedNum);
            int n = introducedNum;
            return n;
        }
    }

    public static void markPreparedStatus(TaxTaskEntity taxTask, Object[] taxDataBasicIds, TaxTaskGuideOpEnum opEnum) {
        if (ArrayUtils.isEmpty((Object[])taxDataBasicIds)) {
            return;
        }
        HRBaseServiceHelper taxTaskHelper = new HRBaseServiceHelper("itc_taxtask");
        HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        DynamicObject taxTaskDy = taxTaskHelper.queryOne("id,taskstatus", (Object)taxTask.getId());
        DynamicObject[] taxDataBasicDys = taxDataBasicHelper.query("id,taxfile,preparestatus,srcrefnum,taxperson", new QFilter[]{new QFilter("id", "in", (Object)taxDataBasicIds)});
        if (TaxTaskGuideOpEnum.SAD_PREPARED == opEnum) {
            Arrays.stream(taxDataBasicDys).forEach(dy -> dy.set("preparestatus", (Object)YesOrNoEnum.YES.getCode()));
            taxDataBasicHelper.save(taxDataBasicDys);
        } else {
            ArrayList unPassSrcRefTaxDataBasicDys = Lists.newArrayListWithExpectedSize((int)taxDataBasicDys.length);
            ArrayList unPassPreStatusTaxDataBasicDys = Lists.newArrayListWithExpectedSize((int)taxDataBasicDys.length);
            ArrayList passTaxDataBasicDys = Lists.newArrayListWithExpectedSize((int)taxDataBasicDys.length);
            for (DynamicObject taxDataBasicDy : taxDataBasicDys) {
                String srcRefNum = taxDataBasicDy.getString("srcrefnum");
                String prepareStatus = taxDataBasicDy.getString("preparestatus");
                if (!SrcRefNumEnums.NO_REF.getCode().equals(srcRefNum)) {
                    unPassSrcRefTaxDataBasicDys.add(taxDataBasicDy);
                    continue;
                }
                if (YesOrNoEnum.NO.getCode().equals(prepareStatus)) {
                    unPassPreStatusTaxDataBasicDys.add(taxDataBasicDy);
                    continue;
                }
                passTaxDataBasicDys.add(taxDataBasicDy);
            }
            if (!CollectionUtils.isEmpty((Collection)unPassSrcRefTaxDataBasicDys) || !CollectionUtils.isEmpty((Collection)unPassPreStatusTaxDataBasicDys)) {
                GlobalParam.remove((String)"unPassSrcRefTaxDataBasicDys");
                GlobalParam.remove((String)"unPassPreStatusTaxDataBasicDys");
                GlobalParam.set((String)"unPassSrcRefTaxDataBasicDys", (Object)unPassSrcRefTaxDataBasicDys);
                GlobalParam.set((String)"unPassPreStatusTaxDataBasicDys", (Object)unPassPreStatusTaxDataBasicDys);
            }
            passTaxDataBasicDys.forEach(dy -> dy.set("preparestatus", (Object)YesOrNoEnum.NO.getCode()));
            taxDataBasicHelper.save(passTaxDataBasicDys.toArray(new DynamicObject[0]));
        }
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taxTask.getId());
        QFilter statusFilter = new QFilter("status", "not in", Arrays.asList("D", "E"));
        QFilter prepareStatusFilter = new QFilter("preparestatus", "=", (Object)YesOrNoEnum.NO.getCode());
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{taxTaskFilter, statusFilter, prepareStatusFilter});
        boolean isExistsUnPreparedData = taxDataBasicHelper.isExists(filters.toArray(new QFilter[0]));
        if (TaxTaskGuideOpEnum.SAD_PREPARED == opEnum) {
            if (!isExistsUnPreparedData) {
                taxTaskDy.set("taskstatus", (Object)TaxTaskStatusEnum.SAD_PREPARED.getCode());
                taxTaskHelper.saveOne(taxTaskDy);
            }
        } else if (isExistsUnPreparedData) {
            taxTaskDy.set("taskstatus", (Object)TaxTaskStatusEnum.INIT_FINISH.getCode());
            taxTaskHelper.saveOne(taxTaskDy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DynamicObject> queryStep3OPrepareTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long taxUnitId) {
        GlobalParam.set((String)"_forRefData", (Object)Boolean.TRUE);
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter("taxfile.taxunit.id", "=", (Object)taxUnitId));
            qFilters.add(new QFilter("taxdatabasic.preparestatus", "=", (Object)YesOrNoEnum.NO.getCode()));
            qFilters.add(new QFilter("reportoprecord.result", "=", (Object)YesOrNoEnum.NO.getCode()));
            qFilters.add(new QFilter("lockoprecord.result", "=", (Object)YesOrNoEnum.YES.getCode()));
            TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, new Object[0]);
            List<DynamicObject> list = TaxTaskGuideServiceHelper.loadTaxData(qFilters);
            return list;
        }
        finally {
            GlobalParam.remove((String)"_forRefData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<DynamicObject> queryStep30NoPersonDeclareTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, Long taxUnitId) {
        GlobalParam.set((String)"_forRefData", (Object)Boolean.TRUE);
        try {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter("taxfile.taxunit.id", "=", (Object)taxUnitId));
            qFilters.add(new QFilter("taxdatabasic.declarestatus", "=", (Object)YesOrNoEnum.NO.getCode()));
            qFilters.add(new QFilter("reportoprecord.result", "=", (Object)YesOrNoEnum.NO.getCode()));
            qFilters.add(new QFilter("lockoprecord.result", "=", (Object)YesOrNoEnum.YES.getCode()));
            TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, new Object[0]);
            List<DynamicObject> list = TaxTaskGuideServiceHelper.loadTaxData(qFilters);
            return list;
        }
        finally {
            GlobalParam.remove((String)"_forRefData");
        }
    }

    public static List<DynamicObject> loadTaxDataInExportReport(List<QFilter> qFilters) {
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
        Object[] taxDataArr = dataServiceHelper.query("id,taxfile.id,taxfile.status,taxperson.personindexid,taxunit.name,taxunit.id", qFilters.toArray(new QFilter[0]));
        return Lists.newArrayList((Object[])taxDataArr);
    }

    public static List<DynamicObject> loadTaxDataInExportReport(List<QFilter> qFilters, String orderBy) {
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
        if (StringUtils.isEmpty((CharSequence)orderBy)) {
            orderBy = "taxunit.id asc, id desc";
        }
        Object[] taxDataArr = dataServiceHelper.query("id,taxfile.id,taxfile.status,taxperson.personindexid,taxunit.name,taxunit.id", qFilters.toArray(new QFilter[0]), orderBy);
        return Lists.newArrayList((Object[])taxDataArr);
    }
}

