/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxTaskGuideViewFilter {
    public static void setPersonFilter(List<QFilter> qFilters, Long taxTaskId) {
        QFilter filter;
        ArrayList<Object> equalsPersonIds = new ArrayList<Object>(1);
        ArrayList<Object> notEqualsInPersonIds = new ArrayList<Object>(1);
        HashSet personId = Sets.newHashSetWithExpectedSize((int)1);
        for (QFilter qFilter : qFilters) {
            if (null == qFilter || !qFilter.getProperty().equals("taxfile.person.id")) continue;
            String cp = qFilter.getCP();
            if ("=".equals(cp) && qFilter.getValue() instanceof Long) {
                equalsPersonIds.add(BaseDataConverter.convert((Object)qFilter.getValue(), Long.class));
                personId.add(BaseDataConverter.convert((Object)qFilter.getValue(), Long.class));
            }
            if (!"!=".equals(cp) && !"<>".equals(cp) || !(qFilter.getValue() instanceof Long)) continue;
            notEqualsInPersonIds.add(BaseDataConverter.convert((Object)qFilter.getValue(), Long.class));
            personId.add(BaseDataConverter.convert((Object)qFilter.getValue(), Long.class));
        }
        if (CollectionUtils.isEmpty((Collection)personId)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        QFilter personIdFilter = new QFilter("taxfile.person.id", "in", (Object)personId);
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taxTaskId);
        Object[] basicDatas = serviceHelper.query("taxfile.person.id,taxfile.person.name,taxfile.person.number", new QFilter[]{personIdFilter, taxTaskFilter});
        if (ArrayUtils.isEmpty((Object[])basicDatas)) {
            return;
        }
        Set names = Arrays.stream(basicDatas).map(obj -> (String)BaseDataConverter.convert((Object)obj.getString("taxfile.person.name"), String.class)).collect(Collectors.toSet());
        Set numbers = Arrays.stream(basicDatas).map(obj -> (String)BaseDataConverter.convert((Object)obj.getString("taxfile.person.number"), String.class)).collect(Collectors.toSet());
        QFilter namesFilter = new QFilter("taxfile.person.name", "in", names);
        namesFilter.or("taxfile.person.name", "in", numbers);
        basicDatas = serviceHelper.query("taxfile.person.id,taxfile.person.name,taxfile.person.number", new QFilter[]{namesFilter});
        if (ArrayUtils.isEmpty((Object[])basicDatas)) {
            return;
        }
        Map<Long, List<DynamicObject>> map = Arrays.stream(basicDatas).collect(Collectors.groupingBy(dy -> dy.getLong("taxfile.person.id")));
        HashSet equalsPersonName = Sets.newHashSetWithExpectedSize((int)basicDatas.length);
        HashSet equalsPersonNumber = Sets.newHashSetWithExpectedSize((int)basicDatas.length);
        HashSet notEqualsPersonName = Sets.newHashSetWithExpectedSize((int)basicDatas.length);
        HashSet notEqualsPersonNumber = Sets.newHashSetWithExpectedSize((int)basicDatas.length);
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            Long key = entry.getKey();
            List<DynamicObject> value = entry.getValue();
            for (DynamicObject dy2 : value) {
                if (equalsPersonIds.contains(key)) {
                    equalsPersonName.add(dy2.getString("taxfile.person.name"));
                    equalsPersonNumber.add(dy2.getString("taxfile.person.number"));
                }
                if (!notEqualsInPersonIds.contains(key)) continue;
                notEqualsPersonName.add(dy2.getString("taxfile.person.name"));
                notEqualsPersonNumber.add(dy2.getString("taxfile.person.number"));
            }
        }
        Iterator<QFilter> iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            filter = iterator.next();
            if (null == filter || !filter.getProperty().equals("taxfile.person.id") || !"=".equals(filter.getCP()) && !"!=".equals(filter.getCP()) && !"<>".equals(filter.getCP())) continue;
            iterator.remove();
        }
        if (!CollectionUtils.isEmpty((Collection)equalsPersonName)) {
            filter = new QFilter("taxfile.person.name", "in", (Object)equalsPersonName);
            filter.or("taxfile.person.number", "in", (Object)equalsPersonNumber);
            qFilters.add(filter);
        }
        if (!CollectionUtils.isEmpty((Collection)notEqualsPersonName)) {
            filter = new QFilter("taxfile.person.name", "not in", (Object)notEqualsPersonName);
            filter.and("taxfile.person.number", "not in", (Object)notEqualsPersonNumber);
            qFilters.add(filter);
        }
    }

    public static void setSchemeFilter(FilterContainerSearchClickArgs args, Long taxTaskId) {
        Map filterValues = args.getFilterValues();
        List schemeFilters = (List)filterValues.get("schemefilter");
        if (schemeFilters == null) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)schemeFilters)) {
            for (int i = schemeFilters.size() - 1; i >= 0; --i) {
                Set<Object> ids;
                Map schemeFilter = (Map)schemeFilters.get(i);
                if (!schemeFilter.containsKey("Id") || !"taxfile.person.name".equals(((List)schemeFilter.get("FieldName")).get(0)) && !"taxfile.person.number".equals(((List)schemeFilter.get("FieldName")).get(0)) || CollectionUtils.isEmpty(ids = TaxTaskGuideViewFilter.addPersonFilter(schemeFilter, taxTaskId))) continue;
                schemeFilter.put("Id", Lists.newArrayList(ids));
            }
        }
    }

    private static Set<Object> addPersonFilter(Map<String, List<Object>> schemeFilter, Long taxTaskId) {
        List<Object> fieldNames = schemeFilter.get("FieldName");
        List<Object> values = schemeFilter.get("Value");
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        String fieldName = (String)fieldNames.get(0);
        QFilter filter = new QFilter(fieldName, "in", (Object)values.toArray());
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taxTaskId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        Object[] basicDatas = serviceHelper.query("taxfile.person.id", new QFilter[]{filter, taxTaskFilter});
        if (ArrayUtils.isEmpty((Object[])basicDatas)) {
            return null;
        }
        return Arrays.stream(basicDatas).map(obj -> (String)BaseDataConverter.convert((Object)obj.getLong("taxfile.person.id"), String.class)).collect(Collectors.toSet());
    }

    public static void setTaxFileFilter(List<QFilter> qFilters, String entityName, long taxTaskId) {
        QFilter statusFilter;
        HashSet taxFileIds = Sets.newHashSetWithExpectedSize((int)4);
        for (QFilter filter : qFilters) {
            if (null == filter || !filter.getProperty().equals("taxfile.id")) continue;
            String cp = filter.getCP();
            if (("=".equals(cp) || "!=".equals(cp) || "<>".equals(cp)) && filter.getValue() instanceof Long) {
                taxFileIds.add(BaseDataConverter.convert((Object)filter.getValue(), Long.class));
            }
            if (!"IN".equals(cp) && !"in".equals(cp) && !"not in".equals(cp) || !(filter.getValue() instanceof List)) continue;
            taxFileIds.addAll((Collection)BaseDataConverter.convert((Object)filter.getValue(), List.class));
        }
        if (CollectionUtils.isEmpty((Collection)taxFileIds)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter personIdFilter = new QFilter("taxfile.boid", "in", (Object)taxFileIds);
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taxTaskId);
        Object[] taxDataBasicDys = serviceHelper.query("id,taxfile.id,taxfile.boid", new QFilter[]{personIdFilter, taxTaskFilter, statusFilter = new QFilter("status", "=", (Object)"C")});
        if (ArrayUtils.isEmpty((Object[])taxDataBasicDys)) {
            return;
        }
        Map<Long, List<DynamicObject>> taxDataBasicMap = Arrays.stream(taxDataBasicDys).collect(Collectors.groupingBy(taxDataBasicDy -> taxDataBasicDy.getLong("taxfile.boid")));
        for (QFilter filter : qFilters) {
            if (null == filter || !filter.getProperty().equals("taxfile.id")) continue;
            String cp = filter.getCP();
            if ("=".equals(cp) || "!=".equals(cp) || "<>".equals(cp)) {
                Long taxFileBoId = (Long)BaseDataConverter.convert((Object)filter.getValue(), Long.class);
                List<DynamicObject> list = taxDataBasicMap.get(taxFileBoId);
                if (CollectionUtils.isEmpty(list)) continue;
                List tempVIds = list.stream().map(dy -> dy.getLong("taxfile.id")).collect(Collectors.toList());
                if (tempVIds.size() == 1) {
                    filter.__setValue(tempVIds.get(0));
                }
            }
            if (!"IN".equals(cp) && !"in".equals(cp) && !"not in".equals(cp) || !(filter.getValue() instanceof List)) continue;
            List taxFileBoIds = (List)BaseDataConverter.convert((Object)filter.getValue(), List.class);
            ArrayList taxFileVIds = Lists.newArrayListWithExpectedSize((int)4);
            for (Object taxFileBoId : taxFileBoIds) {
                List<DynamicObject> list = taxDataBasicMap.get(taxFileBoId);
                if (CollectionUtils.isEmpty(list)) continue;
                List tempVIds = list.stream().map(dy -> dy.getLong("taxfile.id")).collect(Collectors.toList());
                taxFileVIds.addAll(tempVIds);
            }
            filter.__setValue((Object)taxFileVIds);
        }
    }

    public static void addOrgFilterForTaxFile(List<QFilter> originalFilters) {
        HasPermOrgResult permOrgResult = SITPermissionServiceHelper.getPermOrgs((String)"17/+CT1QBPNP", (String)"itc_taxfile");
        if (!permOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgResult.getHasPermOrgs();
            QFilter orgFilter = new QFilter("org", "in", (Object)hasPermOrgs);
            originalFilters.add(orgFilter);
        }
    }
}

