/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.container.Tab;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRawDataReferTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.api.MultiThreadTask;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.MultiThreadTaskExecutor;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;

public class TaxTaskGuideViewHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskGuideViewHelper.class);

    private TaxTaskGuideViewHelper() {
    }

    public static BatchResult refRawData(IFormView formView, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, List<Long> taxFileIds) {
        TaskGuideRawDataReferTask taskGuideRawDataReferRollbackTask = new TaskGuideRawDataReferTask(formView, taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.REFER_SPECIAL_SRC_DATA);
        taskGuideRawDataReferRollbackTask.addData(500, taxFileIds);
        return MultiThreadTaskExecutor.execute((MultiThreadTask)taskGuideRawDataReferRollbackTask, (boolean)false, (ThreadPool)SITThreadPoolFactory.getImportPrepareThreadPool(), (ThreadPool)SITThreadPoolFactory.getImportHanddataThreadPool());
    }

    public static BaseResult<TaxTaskEntity> getTaxTask(IFormView formView) {
        if (formView == null) {
            BaseResult result = BaseResult.fail((String)ResManager.loadKDString((String)"\u9875\u9762\u975e\u6b63\u5e38\u5173\u95ed\u3002", (String)"TaxTaskGuideViewHelper_4", (String)"sit-itc-business", (Object[])new Object[0]));
            TaxTaskEntity taskEntity = new TaxTaskEntity();
            DynamicObject obj = new HRBaseServiceHelper("itc_taxtask").generateEmptyDynamicObject();
            taskEntity.initBy(obj);
            return result.ofData((Object)taskEntity);
        }
        Long taxTaskId = (Long)formView.getFormShowParameter().getCustomParam("taxTaskId");
        return TaxTaskServiceHelper.loadTaxTaskEntity(taxTaskId);
    }

    public static TaxTaskGuideStepCaseInfo getStepCaseInfo(IFormView formView, TaxTaskEntity taxTask) {
        TaxTaskGuideStepCaseInfo stepCaseInfo = new TaxTaskGuideStepCaseInfo();
        if (null != formView) {
            FormShowParameter formShowParameter = formView.getFormShowParameter();
            stepCaseInfo.setStepCode((String)formShowParameter.getCustomParam("stepCode"));
            Tab tab = (Tab)formView.getControl("tabap");
            if (tab != null) {
                String currentTab = tab.getCurrentTab();
                if (StringUtils.isEmpty((String)currentTab)) {
                    currentTab = (String)formShowParameter.getCustomParam("defTab");
                }
                stepCaseInfo.setTabType(currentTab.substring(0, 2));
                stepCaseInfo.setTabValue((Long)BaseDataConverter.convert((Object)currentTab.substring(2), Long.class));
            }
        }
        return stepCaseInfo;
    }

    public static String tabPageName(String step, String key) {
        return step + key + "_tp";
    }

    public static boolean isTabPageName(String key) {
        return key != null && key.startsWith("step") && key.endsWith("_tp");
    }

    public static String itemFromTabPageName(String key) {
        return key.substring(5, key.length() - 3);
    }

    public static String getStepCode(String fullKey, String type) {
        if (fullKey.endsWith(type)) {
            return fullKey.substring(0, fullKey.length() - type.length());
        }
        if ("tabpageap".equals(type) && TaxTaskGuideViewHelper.isTabPageName(fullKey)) {
            return fullKey.substring(0, 5);
        }
        return fullKey;
    }

    public static void showConfirmBeforePrepared(IFormView view, AbstractFormPlugin plugin, TaxTaskEntity taxTask) {
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            String info = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TaxTaskGuideViewHelper_3", (String)"sit-itc-business", (Object[])new Object[0]);
            view.showTipNotification(info);
            return;
        }
        Object[] taxDataBasicIds = selectedRows.getPrimaryKeyValues();
        int total = taxDataBasicIds.length;
        int introducedNum = TaxTaskGuideServiceHelper.getIntroducedNum(taxDataBasicIds);
        int noIntroducedNum = total - introducedNum;
        String tip = null;
        tip = noIntroducedNum == 0 ? MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u8bb0\u5f55\u3002\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\u51c6\u5907\u5b8c\u6210\u540e\uff0c\u53ef\u8fdb\u884c\u85aa\u8d44\u8ba1\u7b97\uff0c\u5e76\u4e0d\u5141\u8bb8\u518d\u6b21\u5bfc\u5165\u6216\u6e05\u9664\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TaxTaskGuideViewHelper_0", (String)"sit-itc-business", (Object[])new Object[0]), total) : MessageFormat.format(ResManager.loadKDString((String)"\u5171\u9009\u62e9{0}\u6761\u8bb0\u5f55\uff0c\u5176\u4e2d{1}\u6761\u672a\u5bfc\u5165\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\u3002\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\u51c6\u5907\u5b8c\u6210\u540e\uff0c\u53ef\u8fdb\u884c\u85aa\u8d44\u8ba1\u7b97\uff0c\u5e76\u4e0d\u5141\u8bb8\u518d\u6b21\u5bfc\u5165\u6216\u6e05\u9664\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TaxTaskGuideViewHelper_1", (String)"sit-itc-business", (Object[])new Object[0]), total, noIntroducedNum);
        view.showConfirm(tip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(TaxTaskGuideOpEnum.SAD_PREPARED.getCode(), (IFormPlugin)plugin));
    }

    public static void showConfirmBeforeRollbackPrepared(IFormView view, AbstractFormPlugin plugin) {
        String msg = ResManager.loadKDString((String)"\u64a4\u9500\u6570\u636e\u51c6\u5907\u5b8c\u6210\u540e\uff0c\u5c06\u4e0d\u80fd\u4f7f\u7528\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\u53c2\u4e0e\u85aa\u8d44\u8ba1\u7b97\uff0c\u786e\u8ba4\u7ee7\u7eed\uff1f", (String)"TaxTaskGuideViewHelper_2", (String)"sit-itc-business", (Object[])new Object[0]);
        view.showConfirm(msg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(TaxTaskGuideOpEnum.ROLLBACK_SAD_PREPARED.getCode(), (IFormPlugin)plugin));
    }

    public static List<DynamicObject> loadTaxData(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, BillList billList, boolean isSelected) {
        ListSelectedRowCollection selectedRows;
        FilterParameter filterParameter = billList.generalFilterParameter();
        List qFilters = filterParameter.getQFilters();
        Object[] ids = null;
        if (isSelected && !CollectionUtils.isEmpty((Collection)(selectedRows = billList.getSelectedRows()))) {
            ids = selectedRows.getPrimaryKeyValues();
        }
        TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, taxTaskEntity, stepCaseInfo, ids);
        qFilters.removeIf(qFilter -> "taxdatabasic.calstatus".equals(qFilter.getProperty()));
        String orderBy = TaxTaskGuideViewHelper.fetchListDataProviderOrderBy(billList.getView().getPageCache());
        return TaxTaskGuideServiceHelper.loadTaxDataInExportReport(qFilters, orderBy);
    }

    public static void cacheFilterAndOrderBy(ListDataProvider provider, IPageCache cache) {
        String orderBy = provider.getOrderByExpr();
        cache.put("ListDataProvider.orderBy", orderBy);
        List qFilters = provider.getQFilters();
        if (!CollectionUtils.isEmpty((Collection)qFilters)) {
            ArrayList<String> filterStrList = new ArrayList<String>(qFilters.size());
            for (QFilter filter : qFilters) {
                filterStrList.add(filter.toSerializedString());
            }
            cache.put("ListDataProvider.filters", SerializationUtils.serializeToBase64(filterStrList));
        }
    }

    public static String fetchListDataProviderOrderBy(IPageCache cache) {
        return cache.get("ListDataProvider.orderBy");
    }

    public static List<QFilter> fetchListDataProviderQFilters(IPageCache cache) {
        String filterStr = cache.get("ListDataProvider.filters");
        if (StringUtils.isEmpty((String)filterStr)) {
            return new ArrayList<QFilter>(0);
        }
        List filterStrList = (List)SerializationUtils.deSerializeFromBase64((String)filterStr);
        ArrayList<QFilter> result = new ArrayList<QFilter>(filterStrList.size());
        for (String str : filterStrList) {
            result.add(QFilter.fromSerializedString((String)str));
        }
        return result;
    }
}

