/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.imports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.sit.itc.business.common.model.TaxtemplateEntity;
import kd.sit.itc.business.taxfile.imports.plugin.ITaxImportPlugin;
import kd.sit.itc.business.taxfile.imports.plugin.ImportPluginGenerate;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;

public class TaxResultImportConfig {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(TaxResultImportConfig.class);
    public static final int BATCH_IMPORT_SIZE = 500;
    private static final int IMPORT_MULTIPLY_SIZE = 3;
    private IFormView formView;
    private Object logId;
    private boolean isComplete;
    private String url;
    private LinkedBlockingQueue<ImportBillData> dataQueue;
    private ImportLogger importLogger;
    private Long taxUnitId;
    private Map<Integer, TaxtemplateEntity> templateMap;
    private TaxTaskEntity taxTask;
    private TaxTaskGuideStepCaseInfo stepCaseInfo;
    private MainEntityType entityType;
    private int headerLineNumber;
    private TaxTaskGuideOpEnum opEnum;
    Map<Long, TaxItemEntity> itemMap;
    Map<String, DynamicObject> credentialstype;
    private Map<String, Object> cacheInfoMap = new HashMap<String, Object>(16);
    private List<ITaxImportPlugin> importPlugins;
    private Set<Integer> onlyFields;

    public Long getTaxUnitId() {
        return this.taxUnitId;
    }

    public void setTaxUnitId(Long taxUnitId) {
        this.taxUnitId = taxUnitId;
    }

    public TaxResultImportConfig(IFormView view, Object logId, String url, String mainEntityId, Map<Integer, TaxtemplateEntity> templateMap, Map<Long, TaxItemEntity> itemMap, TaxTaskEntity taxTask, Map<String, DynamicObject> credentialstype, Set<Integer> onlyFields, TaxTaskGuideStepCaseInfo stepCaseInfo, int headerLineNumber, TaxTaskGuideOpEnum opEnum, Long taxUnitId) {
        this.formView = view;
        this.logId = logId;
        this.url = url;
        this.importLogger = new ImportLogger(url);
        this.dataQueue = new LinkedBlockingQueue(1500);
        this.templateMap = templateMap;
        this.itemMap = itemMap;
        this.credentialstype = credentialstype;
        this.onlyFields = onlyFields;
        this.taxTask = taxTask;
        this.stepCaseInfo = stepCaseInfo;
        this.headerLineNumber = headerLineNumber;
        this.opEnum = opEnum;
        this.importPlugins = ImportPluginGenerate.generate(mainEntityId);
        if (this.entityType == null) {
            this.entityType = MetadataServiceHelper.getDataEntityType((String)mainEntityId);
        }
        this.taxUnitId = taxUnitId;
    }

    public TaxTaskGuideOpEnum getOpEnum() {
        return this.opEnum;
    }

    public void setOpEnum(TaxTaskGuideOpEnum opEnum) {
        this.opEnum = opEnum;
    }

    public TaxTaskGuideStepCaseInfo getStepCaseInfo() {
        return this.stepCaseInfo;
    }

    public void setStepCaseInfo(TaxTaskGuideStepCaseInfo stepCaseInfo) {
        this.stepCaseInfo = stepCaseInfo;
    }

    public Set<Integer> getOnlyFields() {
        return this.onlyFields;
    }

    public void setOnlyFields(Set<Integer> onlyFields) {
        this.onlyFields = onlyFields;
    }

    public Map<String, DynamicObject> getCredentialstype() {
        return this.credentialstype;
    }

    public void setCredentialstype(Map<String, DynamicObject> credentialstype) {
        this.credentialstype = credentialstype;
    }

    public TaxTaskEntity getTaxTask() {
        return this.taxTask;
    }

    public void setTaxTask(TaxTaskEntity taxTask) {
        this.taxTask = taxTask;
    }

    public Map<Long, TaxItemEntity> getItemMap() {
        return this.itemMap;
    }

    public void setItemMap(Map<Long, TaxItemEntity> itemMap) {
        this.itemMap = itemMap;
    }

    public Map<Integer, TaxtemplateEntity> getTemplateMap() {
        return this.templateMap;
    }

    public void setTemplateMap(Map<Integer, TaxtemplateEntity> templateMap) {
        this.templateMap = templateMap;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public Object getLogId() {
        return this.logId;
    }

    public void setLogId(Object logId) {
        this.logId = logId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setComplete(boolean complete) {
        this.isComplete = complete;
    }

    public LinkedBlockingQueue<ImportBillData> getDataQueue() {
        return this.dataQueue;
    }

    public void setDataQueue(LinkedBlockingQueue<ImportBillData> dataQueue) {
        this.dataQueue = dataQueue;
    }

    public ImportLogger getImportLogger() {
        return this.importLogger;
    }

    public void setImportLogger(ImportLogger importLogger) {
        this.importLogger = importLogger;
    }

    public List<ITaxImportPlugin> getImportPlugins() {
        return this.importPlugins;
    }

    public void setImportPlugins(List<ITaxImportPlugin> importPlugins) {
        this.importPlugins = importPlugins;
    }

    public Map<String, Object> getCacheInfoMap() {
        return this.cacheInfoMap;
    }

    public void setCacheInfoMap(Map<String, Object> cacheInfoMap) {
        this.cacheInfoMap = cacheInfoMap;
    }

    public MainEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(MainEntityType entityType) {
        this.entityType = entityType;
    }

    public int getHeaderLineNumber() {
        return this.headerLineNumber;
    }

    public void setHeaderLineNumber(int headerLineNumber) {
        this.headerLineNumber = headerLineNumber;
    }

    public synchronized void feedbackProgress(int progress, ImportLogger importLogger, String errMsg, int failed, int succeed, boolean doImport) {
        JSONObject map;
        IPageCache cache = (IPageCache)this.formView.getService(IPageCache.class);
        String cachedLogStr = cache.get("Cached_Import_Logger");
        JSONObject jSONObject = map = StringUtils.isEmpty((String)cachedLogStr) ? new JSONObject() : JSON.parseObject((String)cachedLogStr);
        if (progress > map.getIntValue("progress")) {
            map.put("progress", (Object)progress);
        }
        if (importLogger != null) {
            map.put("rowindex", (Object)importLogger.getRowIndex());
            map.put("lastrowindex", (Object)importLogger.getLastRowIndex());
            map.put("total", (Object)importLogger.getTotal());
            map.put("succeed", (Object)succeed);
            map.put("failed", (Object)failed);
        }
        if (!StringUtils.isEmpty((String)errMsg)) {
            map.put("err", (Object)errMsg);
            map.put("progress", (Object)progress);
        }
        cachedLogStr = JSON.toJSONString((Object)map);
        log.info("Cached_Import_Logger ----> {}", (Object)cachedLogStr);
        cache.put("Cached_Import_Logger", cachedLogStr);
        try {
            Method method = cache.getClass().getMethod("saveChanges", new Class[0]);
            method.invoke((Object)cache, new Object[0]);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }
}

