/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.imports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sit.itc.business.common.model.TaxtemplateEntity;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxfile.imports.entity.ImportRowInfo;
import kd.sit.itc.business.taxfile.imports.sheethandler.TaxResultImportFailedSheetHandler;
import kd.sit.itc.business.taxfile.imports.sheethandler.TaxResultImportSheetHandler;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.imports.TaxResultImportConfig;
import kd.sit.itc.business.taxtaskguide.imports.TaxTaskGuideImportDBServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.SrcStatus;
import kd.sit.itc.common.constants.TaxGuideImportConstants;
import kd.sit.itc.common.enums.SrcRefNumEnums;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.algo.TaxDataAlgoServiceHelper;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.api.DataFilter;
import kd.sit.sitbp.common.api.KeyGenerator;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxPeriodEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.AlgoHandlerEnum;
import kd.sit.sitbp.common.enums.CalTaxTypeEnum;
import kd.sit.sitbp.common.enums.DataRoundEnum;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxDataSrcGroup;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.SITDateTimeUtils;
import kd.sit.sitbp.common.util.SitDateUtil;
import kd.sit.sitbp.common.util.dataround.BaseDataRoundHandler;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.commons.lang3.StringUtils;

public class TaxResultImportDataTask
implements Runnable {
    private static final Log LOGGER = LogFactory.getLog(TaxResultImportDataTask.class);
    private final RequestContext ctx;
    private final TaxResultImportConfig conf;
    private final String action;
    public static final int BATCH_IMPORT_SIZE = 500;
    private static final char SPLIT_CHAR = '\u3001';
    private Map<String, Integer> cacheMap = new ConcurrentHashMap<String, Integer>(16);

    public TaxResultImportDataTask(RequestContext ctx, TaxResultImportConfig conf, String action) {
        this.ctx = ctx;
        this.conf = conf;
        this.action = action;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            RequestContext.copyAndSet((RequestContext)this.ctx);
            switch (this.action) {
                case "resolveExcel": {
                    long startTime = System.currentTimeMillis();
                    LOGGER.info("Resolve startTime\uff1a{}", (Object)HRDateTimeUtils.format((Date)new Date(startTime), (String)"yyyy-MM-dd HH:mm:ss"));
                    this.resolve();
                    LOGGER.info("Resolve endTime\uff1a{} cost\uff1a{}", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), (Object)(System.currentTimeMillis() - startTime));
                    return;
                }
                case "importData": {
                    long importStartTime = System.currentTimeMillis();
                    LOGGER.info("Import startTime\uff1a{}", (Object)HRDateTimeUtils.format((Date)new Date(importStartTime), (String)"yyyy-MM-dd HH:mm:ss"));
                    this.importData();
                    LOGGER.info("Import endTime\uff1a{} cost\uff1a{}", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), (Object)(System.currentTimeMillis() - importStartTime));
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            RequestContext.set(null);
        }
    }

    private void resolve() {
        ImportLogger importLogger = this.conf.getImportLogger();
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader excelReader = new ExcelReader();
        String path = this.conf.getUrl();
        try (InputStream in = service.getInputStream(path);){
            excelReader.read(in, (SheetHandler)new TaxResultImportSheetHandler(this.conf));
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof KDBizException) {
                importLogger.log(Integer.valueOf(0), cause.getMessage());
            } else {
                importLogger.log(Integer.valueOf(0), ImportLogger.formatException((Throwable)e));
            }
            LOGGER.error((Throwable)e);
            LOGGER.error("path: {}", (Object)path);
            this.conf.getDataQueue().add(new ImportBillData(new JSONObject(), 0, 0, null));
            this.conf.setComplete(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importData() {
        LinkedBlockingQueue<ImportBillData> dataQueue = this.conf.getDataQueue();
        ImportLogger importLogger = this.conf.getImportLogger();
        String errMsg = "";
        try {
            this.doImport(importLogger, dataQueue);
        }
        catch (Exception e) {
            block13: {
                try {
                    String message;
                    LOGGER.error("TaxResultImportDataTask----importData error...", (Throwable)e);
                    errMsg = message = e.getMessage();
                    if (null != message) break block13;
                    errMsg = "error";
                }
                catch (Throwable throwable) {
                    if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                        this.conf.feedbackProgress(-1, importLogger, errMsg, 0, 0, false);
                    } else {
                        HashMap<String, Serializable> retData = new HashMap<String, Serializable>(16);
                        HashMap<String, ImportLogger> dataMap = new HashMap<String, ImportLogger>(16);
                        dataMap.put(this.conf.getUrl(), importLogger);
                        retData.put("complete", Boolean.TRUE);
                        retData.put("info", dataMap);
                        int total = 0;
                        int failQty = 0;
                        ImportLogger logger = importLogger;
                        total += logger.getTotal();
                        total += logger.getTotal();
                        int n = logger.getRowIndex() <= logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
                        this.resetErrorMsgIndex(importLogger);
                        if ((failQty += n) > 0 || importLogger.getRowIndex() < importLogger.getLastRowIndex() - 1) {
                            this.outputFailedData();
                        }
                        ImportLogHelper.logAll((Object)this.conf.getLogId(), (String)JSON.toJSONString(retData), (int)importLogger.getTotal(), (int)importLogger.getFailed());
                        this.conf.feedbackProgress(100, importLogger, errMsg, failQty, logger.getDelRows().size(), false);
                    }
                    throw throwable;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                this.conf.feedbackProgress(-1, importLogger, errMsg, 0, 0, false);
            } else {
                HashMap<String, Serializable> retData = new HashMap<String, Serializable>(16);
                HashMap<String, ImportLogger> dataMap = new HashMap<String, ImportLogger>(16);
                dataMap.put(this.conf.getUrl(), importLogger);
                retData.put("complete", Boolean.TRUE);
                retData.put("info", dataMap);
                int total = 0;
                int failQty = 0;
                ImportLogger logger = importLogger;
                total += logger.getTotal();
                total += logger.getTotal();
                int n = logger.getRowIndex() <= logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
                this.resetErrorMsgIndex(importLogger);
                if ((failQty += n) > 0 || importLogger.getRowIndex() < importLogger.getLastRowIndex() - 1) {
                    this.outputFailedData();
                }
                ImportLogHelper.logAll((Object)this.conf.getLogId(), (String)JSON.toJSONString(retData), (int)importLogger.getTotal(), (int)importLogger.getFailed());
                this.conf.feedbackProgress(100, importLogger, errMsg, failQty, logger.getDelRows().size(), false);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)errMsg)) {
            this.conf.feedbackProgress(-1, importLogger, errMsg, 0, 0, false);
        } else {
            HashMap<String, Serializable> retData = new HashMap<String, Serializable>(16);
            HashMap<String, ImportLogger> dataMap = new HashMap<String, ImportLogger>(16);
            dataMap.put(this.conf.getUrl(), importLogger);
            retData.put("complete", Boolean.TRUE);
            retData.put("info", dataMap);
            int total = 0;
            int failQty = 0;
            ImportLogger logger = importLogger;
            total += logger.getTotal();
            total += logger.getTotal();
            int n = logger.getRowIndex() <= logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed();
            this.resetErrorMsgIndex(importLogger);
            if ((failQty += n) > 0 || importLogger.getRowIndex() < importLogger.getLastRowIndex() - 1) {
                this.outputFailedData();
            }
            ImportLogHelper.logAll((Object)this.conf.getLogId(), (String)JSON.toJSONString(retData), (int)importLogger.getTotal(), (int)importLogger.getFailed());
            this.conf.feedbackProgress(100, importLogger, errMsg, failQty, logger.getDelRows().size(), false);
        }
    }

    private boolean doImport(ImportLogger importLogger, LinkedBlockingQueue<ImportBillData> dataQueue) throws InterruptedException {
        LOGGER.info("TaxResultImportDataTask----importTaxData...");
        boolean isTimeOut = false;
        int timeout = 0;
        while (!this.conf.isComplete() || !dataQueue.isEmpty()) {
            if (timeout > 5) {
                isTimeOut = true;
                break;
            }
            String appId = EntityMetadataCache.getDataEntityType((String)"itc_taxdata").getAppId();
            String suspendCache = (String)AppCache.get((String)appId).get("IMPT_SUSPEND_itc_taxdata", String.class);
            if (StringUtils.isNotBlank((CharSequence)suspendCache) && "IMPT_SUSPEND_itc_taxdata".equals(suspendCache)) break;
            ArrayList<ImportBillData> rowdatas = new ArrayList<ImportBillData>(10);
            ImportBillData rowData = dataQueue.poll(1L, TimeUnit.MINUTES);
            if (null == rowData || rowData.isEmpty()) {
                ++timeout;
                continue;
            }
            rowdatas.add(rowData);
            dataQueue.drainTo(rowdatas, 500);
            rowdatas = rowdatas.stream().filter(data -> !data.isEmpty()).collect(Collectors.toList());
            timeout = 0;
            List<ImportRowInfo> rowInfos = this.getImportRowInfo(rowdatas, importLogger);
            rowInfos = this.checkRowData(rowInfos, importLogger);
            if (TaxTaskGuideOpEnum.IMPORT == this.conf.getOpEnum()) {
                this.importTaxData(rowInfos, importLogger);
            } else {
                this.importTaxDeduct(rowInfos, importLogger);
            }
            this.syncFeedbackProgress(rowdatas, importLogger);
        }
        return isTimeOut;
    }

    private void importTaxDeduct(List<ImportRowInfo> rowInfos, ImportLogger importLogger) {
        Map<Integer, TaxtemplateEntity> templateMap = this.conf.getTemplateMap();
        Map<Long, TaxItemEntity> itemMap = this.conf.getItemMap();
        HashSet<String> idNumbers = new HashSet<String>(16);
        HashSet<String> names = new HashSet<String>(16);
        HashSet<Long> categoryIds = new HashSet<Long>(16);
        for (ImportRowInfo importRowInfo : rowInfos) {
            JSONObject data = importRowInfo.getData();
            Map map = (Map)data.get((Object)(importRowInfo.getRowIndex() - 1));
            this.getCondition(map, templateMap, itemMap, idNumbers, names, categoryIds);
        }
        Object[] taxDataBasicDys = TaxTaskGuideImportDBServiceHelper.queryTaxFileByCondition(idNumbers, names, this.conf.getTaxTask(), this.conf.getTaxUnitId());
        if (taxDataBasicDys.length == 0) {
            for (ImportRowInfo rowInfo : rowInfos) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7eb3\u7a0e\u5355\u4f4d\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u4e2a\u7a0e\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u7684\u6570\u636e\u662f\u5426\u6709\u8bef\uff0c\u6216\u8005\u662f\u5426\u6709\u5f15\u5165\u6570\u636e\u7684\u6743\u9650\u3002", (String)"TaxResultImportDataTask_24", (String)"sit-itc-business", (Object[])new Object[0]);
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
            }
            return;
        }
        ArrayList arrayList = Lists.newArrayList((Object[])taxDataBasicDys);
        HashMap<Long, ImportRowInfo> map = new HashMap<Long, ImportRowInfo>();
        HashMap<String, Map<Long, List<DynamicObject>>> groupDataMap = this.getGroupDataByPersonNameAndPercreNumber(arrayList);
        for (ImportRowInfo rowInfo : rowInfos) {
            this.matchData(rowInfo, groupDataMap, importLogger, map);
        }
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        List<DynamicObject> list = this.removeNotMatchedDData(map, arrayList);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<DynamicObject> list2 = this.checkTaxFileTaxStatus(list, map, importLogger);
        if (CollectionUtils.isEmpty(list2)) {
            return;
        }
        List<DynamicObject> list3 = this.checkPersonDeclare(list2, map, importLogger);
        if (CollectionUtils.isEmpty(list3)) {
            return;
        }
        List<DynamicObject> list5 = this.checkTaxPayerType(list3, map, importLogger);
        list5 = this.checkPrepareStatus(list5, map, importLogger);
        if (CollectionUtils.isEmpty(list5)) {
            return;
        }
        List<DynamicObject> list6 = this.checkCalStatus(list5, map, importLogger);
        if (CollectionUtils.isEmpty(list6)) {
            return;
        }
        Set<Long> taxDataBasicIds = list6.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        Map<Long, Long> taxFileMap = list6.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("taxfile.id")));
        DynamicObject[] taxDeductDys = TaxTaskGuideImportDBServiceHelper.getTaxDeductByTaxDataBasic(taxDataBasicIds, this.conf.getTaxTask());
        if (taxDeductDys.length != taxDataBasicIds.size()) {
            List<DynamicObject> list7 = this.createTaxDeductDysByTaxDataBasic(taxDeductDys, taxDataBasicIds, taxFileMap, list6);
            this.fillDeductEntity(list7, map);
            this.doSaveDeductData(list7, list6);
            this.setDel(list6, map, importLogger);
            return;
        }
        this.fillDeductEntity(Arrays.asList(taxDeductDys), map);
        this.doSaveDeductData(Arrays.asList(taxDeductDys), list6);
        this.setDel(list6, map, importLogger);
    }

    private List<DynamicObject> checkTaxFileTaxStatus(List<DynamicObject> taxDataBasicList, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(taxDataBasicList.size());
        String msg = ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\u5728\u4e2a\u7a0e\u4efb\u52a1\u671f\u95f4\u7b97\u7a0e\u72b6\u6001=\u505c\u6b62\u7b97\u7a0e\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"TaxResultImportDataTask_23", (String)"sit-itc-business", (Object[])new Object[0]);
        for (DynamicObject dynamicObject : taxDataBasicList) {
            if (!YesOrNoEnum.YES.getCode().equals(dynamicObject.getString("taxfile.taxstatus"))) {
                ImportRowInfo rowInfo = map.get(dynamicObject.getLong("id"));
                if (null == rowInfo) continue;
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                continue;
            }
            list.add(dynamicObject);
        }
        return list;
    }

    private List<DynamicObject> getTaxDataBasicDyList(TaxTaskEntity taxTaskEntity) {
        HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId());
        QFilter statusFilter = new QFilter("status", "not in", Arrays.asList("D", "E"));
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{taxTaskFilter, statusFilter});
        String fieldsOfTaxDataBasic = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)new PropertiesQueryInfo("itc_taxdatabasic"), (DataFilter)SitDataServiceHelper.DEFAULT_FILTER);
        Object[] taxDataBasicDys = taxDataBasicHelper.query(fieldsOfTaxDataBasic, filters.toArray(new QFilter[0]));
        return Lists.newArrayList((Object[])taxDataBasicDys);
    }

    private void fillDeductEntity(List<DynamicObject> taxDeductDys, HashMap<Long, ImportRowInfo> map) {
        Map<Integer, TaxtemplateEntity> templateMap = this.conf.getTemplateMap();
        Map<Long, TaxItemEntity> itemMap = this.conf.getItemMap();
        for (DynamicObject dy : taxDeductDys) {
            ImportRowInfo info = map.get(dy.getLong("taxdatabasic.id"));
            if (null == info) continue;
            this.doFillDeduct(dy, templateMap, info, itemMap);
        }
    }

    private List<DynamicObject> createTaxDeductDysByTaxDataBasic(DynamicObject[] dys, Set<Long> taxDataBasicIds, Map<Long, Long> taxFileMap, List<DynamicObject> taxDataBasicList) {
        Map<Long, DynamicObject> map = taxDataBasicList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        Set set = Arrays.stream(dys).map(dy -> dy.getLong("taxdatabasic.id")).collect(Collectors.toSet());
        for (Long id : taxDataBasicIds) {
            if (set.contains(id)) continue;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdeduct");
            DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
            dynamicObject.set("taxdatabasic", (Object)map.get(id));
            dynamicObject.set("taxtask", (Object)this.conf.getTaxTask().getId());
            dynamicObject.set("taxfile", (Object)taxFileMap.get(id));
            dynamicObject.set("yearmonth", (Object)this.conf.getTaxTask().yearMonth());
            dynamicObject.set("taxcategory", (Object)TaxGuideImportConstants.NORMAL_SALARY_INCOME_ID);
            list.add(dynamicObject);
        }
        return list;
    }

    private void doFillDeduct(DynamicObject dy, Map<Integer, TaxtemplateEntity> templateMap, ImportRowInfo rowInfo, Map<Long, TaxItemEntity> itemMap) {
        JSONObject data = rowInfo.getData();
        Map map = (Map)data.get((Object)(rowInfo.getRowIndex() - 1));
        HashMap taxItemMap = new HashMap(16);
        HashSet<Long> entryId = new HashSet<Long>(16);
        String globalId = "1000001_0_0_dy";
        Map result = (Map)GlobalParam.get((String)globalId);
        for (Map.Entry<Integer, TaxtemplateEntity> entry : templateMap.entrySet()) {
            TaxtemplateEntity template = entry.getValue();
            String fieldKey = template.getFieldkey();
            if (StringUtils.isNotBlank((CharSequence)fieldKey)) continue;
            taxItemMap.put(template.getTaxitemid(), map.get(entry.getKey()));
        }
        DynamicObjectCollection entryEntities = dy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryEntity : entryEntities) {
            Long taxItemId = entryEntity.getLong("taxitem.id");
            Object value = taxItemMap.get(taxItemId);
            TaxItemEntity taxItemEntity = itemMap.get(taxItemId);
            if (null == taxItemEntity) {
                entryEntity.set("itemvalue", null);
                continue;
            }
            entryEntity.set("itemvalue", value);
            entryId.add(taxItemId);
        }
        if (taxItemMap.size() > 0) {
            for (Map.Entry entry : taxItemMap.entrySet()) {
                Object taxItemValue = entry.getValue();
                Long taxItemId = (Long)entry.getKey();
                if (entryId.contains(taxItemId) || !itemMap.containsKey(taxItemId)) continue;
                DynamicObject newEntryEntity = entryEntities.addNew();
                DynamicObject taxItemDy = (DynamicObject)result.get(taxItemId);
                if (null == taxItemDy) continue;
                newEntryEntity.set("taxitem", (Object)taxItemDy);
                newEntryEntity.set("itemvalue", taxItemValue);
            }
        }
    }

    private Map<Long, TaxDataSrcGroup<Long, DynamicObject>> getSrcTaxData(DynamicObject[] dys) {
        if (null == dys || dys.length == 0) {
            return null;
        }
        Set ids = Arrays.asList(dys).stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("taxdata", "in", ids));
        qFilters.add(new QFilter("status", "!=", (Object)"E"));
        DynamicObject[] taxSrcDataArr = TaxTaskGuideServiceHelper.loadTaxSrcData(qFilters);
        HashMap<Long, TaxDataSrcGroup<Long, DynamicObject>> dataSrcGroupMap = new HashMap<Long, TaxDataSrcGroup<Long, DynamicObject>>(dys.length);
        Arrays.asList(dys).forEach(e1 -> dataSrcGroupMap.put(e1.getLong("id"), new TaxDataSrcGroup(e1, KeyGenerator.DYNAMIC_OBJ_GENERATOR)));
        for (DynamicObject srcData : taxSrcDataArr) {
            TaxDataSrcGroup taxDataSrcGroup = (TaxDataSrcGroup)dataSrcGroupMap.get(srcData.getLong("taxdata"));
            if (taxDataSrcGroup == null) continue;
            taxDataSrcGroup.addTaxSrcData((Object)srcData);
        }
        return dataSrcGroupMap;
    }

    private void doImportData(List<DynamicObject> dys, Map<Long, List<DynamicObject>> srcMap) {
        if (CollectionUtils.isEmpty(dys)) {
            return;
        }
        TaxTaskEntity taxTaskEntity = this.conf.getTaxTask();
        TaxTaskGuideStepCaseInfo stepCaseInfo = this.conf.getStepCaseInfo();
        BatchResult result = new BatchResult(true, dys);
        TaxDataServiceHelper.saveTaxData((BatchResult<DynamicObject>)result, taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.IMPORT, srcMap, true, new CustomFunction[0]);
    }

    private void doSaveDeductData(List<DynamicObject> deductDys, List<DynamicObject> taxDataBasicList) {
        if (CollectionUtils.isEmpty(deductDys)) {
            return;
        }
        TaxTaskEntity taxTaskEntity = this.conf.getTaxTask();
        TaxTaskGuideStepCaseInfo stepCaseInfo = this.conf.getStepCaseInfo();
        BatchResult result = new BatchResult(true, deductDys);
        TaxTaskGuideImportDBServiceHelper.saveTaxDeduct((BatchResult<DynamicObject>)result, taxDataBasicList, taxTaskEntity, stepCaseInfo, TaxTaskGuideOpEnum.IMPORT_SAD, true, new CustomFunction[0]);
    }

    private void importTaxData(List<ImportRowInfo> rowInfos, ImportLogger importLogger) {
        if (CollectionUtils.isEmpty(rowInfos)) {
            return;
        }
        Object[] dys = this.getTaxData(rowInfos);
        if (HRArrayUtils.isEmpty((Object[])dys)) {
            for (ImportRowInfo rowInfo : rowInfos) {
                String msg = ResManager.loadKDString((String)"\u5f53\u524d\u7eb3\u7a0e\u5355\u4f4d\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u4e2a\u7a0e\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u7684\u6570\u636e\u662f\u5426\u6709\u8bef\uff0c\u6216\u8005\u662f\u5426\u6709\u5f15\u5165\u6570\u636e\u7684\u6743\u9650\u3002", (String)"TaxResultImportDataTask_24", (String)"sit-itc-business", (Object[])new Object[0]);
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                LOGGER.info("TaxResultImportDataTask----importTaxData...{}", (Object)msg);
            }
            return;
        }
        HashMap<Long, ImportRowInfo> map = new HashMap<Long, ImportRowInfo>();
        HashMap<String, Map<Long, List<DynamicObject>>> groupDataMap = this.getGroupDataByPersonNameAndPercreNumber(Arrays.asList(dys));
        for (ImportRowInfo rowInfo : rowInfos) {
            this.matchData(rowInfo, groupDataMap, importLogger, map);
        }
        if (CollectionUtils.isEmpty(map)) {
            return;
        }
        List<DynamicObject> list = this.removeNotMatchedDData(map, Arrays.asList(dys));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        dys = list.toArray(new DynamicObject[0]);
        Map<Long, TaxDataSrcGroup<Long, DynamicObject>> srcTaxData = this.getSrcTaxData((DynamicObject[])(dys = this.checkLockStatus((DynamicObject[])dys, map, importLogger)));
        if (srcTaxData == null) {
            return;
        }
        dys = TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(this.conf.getTaxTask().getTaxTaskType()) ? this.checkDeclareStatus((DynamicObject[])dys, map, importLogger) : this.checkSrcStatus((DynamicObject[])dys, srcTaxData, map, importLogger);
        this.fillEntityDynamicObject((DynamicObject[])dys, map);
        BatchResult taxDataResult = new BatchResult(true, new ArrayList<Object>(Arrays.asList(dys)));
        HashMap<Long, List<DynamicObject>> srcMap = new HashMap<Long, List<DynamicObject>>(16);
        for (Map.Entry<Long, TaxDataSrcGroup<Long, DynamicObject>> entry : srcTaxData.entrySet()) {
            TaxDataSrcGroup<Long, DynamicObject> value = entry.getValue();
            Map srcDataMap = value.getSrcDataMap();
            ArrayList values = new ArrayList(srcDataMap.values());
            srcMap.put(entry.getKey(), values);
        }
        AlgoHandlerEnum splitEnum = AlgoHandlerEnum.IMPORT_TAX_SPLIT;
        if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(this.conf.getTaxTask().getTaxTaskType())) {
            splitEnum = AlgoHandlerEnum.LOCAL_CAL_IMPORT_TAX_SPLIT;
        }
        BatchResult result = TaxDataAlgoServiceHelper.batchDealTaxDataAndSrc((TaxTaskEntity)this.conf.getTaxTask(), (List)taxDataResult.getSuccessResult(), srcMap, (AlgoHandlerEnum)splitEnum);
        result.getFailResultOriginal().forEach(obj -> taxDataResult.successItemToFail(obj.getData(), obj.getMessage()));
        this.getSuccessResult((BatchResult<DynamicObject>)taxDataResult, srcMap, map, importLogger);
        this.doImportData(taxDataResult.getSuccessResult(), srcMap);
        this.setDel(taxDataResult.getSuccessResult(), map, importLogger);
    }

    private void setThisTimeTax(DynamicObject[] dys) {
        for (DynamicObject dy : dys) {
            DynamicObjectCollection entities = dy.getDynamicObjectCollection("entryentity");
            DynamicObject thisTimeTaxDy = null;
            DynamicObject allTaxDy = null;
            for (DynamicObject entity : entities) {
                long taxItemId = entity.getLong("taxitem.id");
                if (1231713881429134336L == taxItemId) {
                    thisTimeTaxDy = entity;
                }
                if (1123912108812036096L != taxItemId) continue;
                allTaxDy = entity;
            }
            if (null == allTaxDy) continue;
            String globalId = "1000001_0_0_dy";
            Map itemDys = (Map)GlobalParam.get((String)globalId);
            String itemValue = allTaxDy.getString("itemvalue");
            if (thisTimeTaxDy == null) {
                DynamicObject dynamicObject = entities.addNew();
                dynamicObject.set("taxitem", itemDys.get(1231713881429134336L));
                dynamicObject.set("itemvalue", (Object)itemValue);
                dynamicObject.set("entryyearmonth", (Object)this.conf.getTaxTask().yearMonth());
                if (!TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(this.conf.getTaxTask().getTaxTaskType())) continue;
                dynamicObject.set("calvalue", (Object)itemValue);
                continue;
            }
            thisTimeTaxDy.set("itemvalue", (Object)itemValue);
            if (!TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(this.conf.getTaxTask().getTaxTaskType())) continue;
            thisTimeTaxDy.set("calvalue", (Object)itemValue);
        }
    }

    private void getSuccessResult(BatchResult<DynamicObject> result, Map<Long, List<DynamicObject>> srcMap, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        List failResultOriginal = result.getFailResultOriginal();
        if (CollectionUtils.isEmpty((Collection)failResultOriginal)) {
            return;
        }
        for (ResultItem failResult : failResultOriginal) {
            DynamicObject data = (DynamicObject)failResult.getData();
            String message = failResult.getMessage();
            long id = data.getLong("id");
            ImportRowInfo rowInfo = map.get(id);
            if (null != rowInfo) {
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{message});
            }
            srcMap.remove(id);
        }
    }

    private DynamicObject[] checkSrcStatus(DynamicObject[] dys, Map<Long, TaxDataSrcGroup<Long, DynamicObject>> srcTaxData, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        if (null == dys || dys.length == 0) {
            return new DynamicObject[0];
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (DynamicObject dy : dys) {
            String taxDataBizStatus = dy.getString("bizstatus");
            if (TaxDataBizStatusEnum.IMPORT.isGreaterEqThan(taxDataBizStatus)) {
                list.add(dy);
                continue;
            }
            long id = dy.getLong("id");
            TaxDataSrcGroup<Long, DynamicObject> srcMap = srcTaxData.get(id);
            Map srcDataMap = srcMap.getSrcDataMap();
            boolean hasNotReceived = false;
            for (Map.Entry entry : srcDataMap.entrySet()) {
                DynamicObject srcData = (DynamicObject)entry.getValue();
                if (!SrcStatus.RECEIVED.isGreaterThan(srcData.getString("taxdatabasic.srcstatus"))) continue;
                hasNotReceived = true;
                break;
            }
            if (!hasNotReceived) {
                ImportRowInfo rowInfo = map.get(dy.getLong("id"));
                if (null != rowInfo) {
                    String msg = MessageFormat.format(ResManager.loadKDString((String)"{0}{1}\u4e2a\u7a0e\u8bb0\u5f55\u5bf9\u5e94\u7684\u85aa\u8d44\u6838\u7b97\u8bb0\u5f55\u5df2\u83b7\u53d6\u4e2a\u7a0e\u6570\u636e\uff0c\u65e0\u6cd5\u91cd\u65b0\u5bfc\u5165", (String)"TaxResultImportDataTask_7", (String)"sit-itc-business", (Object[])new Object[0]), dy.getString("taxfile.number"), dy.getString("taxperson.name"));
                    importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                }
                srcTaxData.remove(id);
                continue;
            }
            list.add(dy);
        }
        return list.toArray(new DynamicObject[0]);
    }

    private DynamicObject[] getTaxData(List<ImportRowInfo> rowInfos) {
        Map<Integer, TaxtemplateEntity> templateMap = this.conf.getTemplateMap();
        Map<Long, TaxItemEntity> itemMap = this.conf.getItemMap();
        HashSet<String> ids = new HashSet<String>(16);
        HashSet<String> names = new HashSet<String>(16);
        HashSet<Long> categoryIds = new HashSet<Long>(16);
        for (ImportRowInfo rowInfo : rowInfos) {
            JSONObject data = rowInfo.getData();
            Map map = (Map)data.get((Object)(rowInfo.getRowIndex() - 1));
            this.getCondition(map, templateMap, itemMap, ids, names, categoryIds);
        }
        return TaxTaskGuideImportDBServiceHelper.queryTaxDataByCondition(ids, names, categoryIds, this.conf.getTaxTask(), this.conf.getTaxUnitId());
    }

    private DynamicObject[] checkLockStatus(DynamicObject[] dys, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (DynamicObject dy : dys) {
            String taxDataBizStatus = dy.getString("bizstatus");
            if (TaxDataBizStatusEnum.LOCK.isGreaterThan(taxDataBizStatus)) {
                ImportRowInfo rowInfo = map.get(dy.getLong("id"));
                if (null == rowInfo) continue;
                String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u6570\u636e\u5bfc\u5165\u9519\u8bef\uff0c\u8bf7\u9501\u5b9a\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"TaxResultImportDataTask_3", (String)"sit-itc-business", (Object[])new Object[0]);
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                continue;
            }
            list.add(dy);
        }
        return list.toArray(new DynamicObject[0]);
    }

    private void fillEntityDynamicObject(DynamicObject[] dys, HashMap<Long, ImportRowInfo> map) {
        Map<Integer, TaxtemplateEntity> templateMap = this.conf.getTemplateMap();
        Map<Long, TaxItemEntity> itemMap = this.conf.getItemMap();
        for (DynamicObject dy : dys) {
            ImportRowInfo info = map.get(dy.getLong("id"));
            if (null == info) continue;
            this.doFill(dy, templateMap, info, itemMap);
        }
        this.setThisTimeTax(dys);
    }

    private void doFill(DynamicObject dy, Map<Integer, TaxtemplateEntity> templateMap, ImportRowInfo rowInfo, Map<Long, TaxItemEntity> itemMap) {
        TaxItemEntity taxItemEntity;
        Long taxItemId;
        JSONObject data = rowInfo.getData();
        Map map = (Map)data.get((Object)(rowInfo.getRowIndex() - 1));
        HashMap taxItemMap = new HashMap(16);
        HashSet<Long> entryId = new HashSet<Long>(16);
        HashSet<Long> mustInputId = new HashSet<Long>(16);
        TaxTaskEntity taxTask = this.conf.getTaxTask();
        int yearMonth = taxTask.yearMonth();
        String globalId = "1000001_0_0_dy";
        Map result = (Map)GlobalParam.get((String)globalId);
        for (Map.Entry<Integer, TaxtemplateEntity> entry : templateMap.entrySet()) {
            TaxtemplateEntity template = entry.getValue();
            String fieldKey = template.getFieldkey();
            if (StringUtils.isNotBlank((CharSequence)fieldKey)) continue;
            taxItemId = template.getTaxitemid();
            if (template.isMustInput()) {
                mustInputId.add(taxItemId);
            }
            Object value = map.get(entry.getKey());
            taxItemMap.put(taxItemId, value);
        }
        DynamicObjectCollection entities = dy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entities) {
            Long taxItemId2 = entity.getLong("taxitem.id");
            Object value = taxItemMap.get(taxItemId2);
            taxItemEntity = itemMap.get(taxItemId2);
            if (null == taxItemEntity) {
                entity.set("itemvalue", null);
                continue;
            }
            long caltaxtypeId = taxItemEntity.getCaltaxtypeId();
            if (CalTaxTypeEnum.RETURN.getId() != caltaxtypeId && !mustInputId.contains(taxItemId2)) continue;
            entity.set("itemvalue", value);
            if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(this.conf.getTaxTask().getTaxTaskType())) {
                entity.set("calvalue", value);
            }
            entity.set("entryyearmonth", (Object)yearMonth);
            entryId.add(taxItemId2);
        }
        if (taxItemMap.size() > 0) {
            for (Map.Entry entry : taxItemMap.entrySet()) {
                Object taxItemValue = entry.getValue();
                taxItemId = (Long)entry.getKey();
                if (entryId.contains(taxItemId) || null == (taxItemEntity = itemMap.get(taxItemId)) || CalTaxTypeEnum.RETURN.getId() != taxItemEntity.getCaltaxtypeId()) continue;
                DynamicObject newEntryEntity = entities.addNew();
                DynamicObject taxItemDy = (DynamicObject)result.get(taxItemId);
                newEntryEntity.set("taxitem", (Object)taxItemDy);
                newEntryEntity.set("itemvalue", taxItemValue);
                if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(this.conf.getTaxTask().getTaxTaskType())) {
                    newEntryEntity.set("calvalue", taxItemValue);
                }
                newEntryEntity.set("entryyearmonth", (Object)yearMonth);
            }
        }
    }

    private void matchData(ImportRowInfo rowInfo, HashMap<String, Map<Long, List<DynamicObject>>> groupMap, ImportLogger importLogger, HashMap<Long, ImportRowInfo> map) {
        Object msg;
        if (CollectionUtils.isEmpty(groupMap)) {
            String msg2 = ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u4e2a\u7a0e\u6570\u636e\u8bf7\u68c0\u67e5\u4e0a\u4f20\u7684\u6570\u636e\u662f\u5426\u6709\u8bef\u3002", (String)"TaxResultImportDataTask_14", (String)"sit-itc-business", (Object[])new Object[0]);
            importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg2});
            LOGGER.info("TaxResultImportDataTask --- not match any group data");
            return;
        }
        JSONObject data = rowInfo.getData();
        Map<Integer, TaxtemplateEntity> templateMap = this.conf.getTemplateMap();
        Map<Long, TaxItemEntity> itemMap = this.conf.getItemMap();
        Map rowData = (Map)data.get((Object)(rowInfo.getRowIndex() - 1));
        String rowIdNumber = null;
        String rowName = null;
        String cateGoryName = null;
        HashSet<Long> categoryIdSet = new HashSet<Long>(16);
        Set<Integer> onlyFields = this.conf.getOnlyFields();
        block8: for (Integer integer : onlyFields) {
            String fieldKey;
            String value = (String)rowData.get(integer);
            TaxtemplateEntity template = templateMap.get(integer);
            switch (fieldKey = template.getFieldkey()) {
                case "percre.number": {
                    rowIdNumber = value;
                    continue block8;
                }
                case "taxperson.name": {
                    rowName = value;
                    continue block8;
                }
            }
            cateGoryName = value;
            this.getCategoriesId(value, itemMap, categoryIdSet);
        }
        boolean isMatch = false;
        boolean categoryMatch = false;
        if (null == rowName || null == rowIdNumber) {
            String nameAndIdNumberError = ResManager.loadKDString((String)"\u59d3\u540d\u3001\u5de5\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxResultImportDataTask_22", (String)"sit-itc-business", (Object[])new Object[0]);
            importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{nameAndIdNumberError});
            return;
        }
        String key = rowName.concat("_").concat(rowIdNumber);
        Map<Long, List<DynamicObject>> groupData = groupMap.get(key);
        if (CollectionUtils.isEmpty(groupData)) {
            String msg3 = ResManager.loadKDString((String)"\u5f53\u524d\u7eb3\u7a0e\u5355\u4f4d\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u4e2a\u7a0e\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u7684\u6570\u636e\u662f\u5426\u6709\u8bef\uff0c\u6216\u8005\u662f\u5426\u6709\u5f15\u5165\u6570\u636e\u7684\u6743\u9650\u3002", (String)"TaxResultImportDataTask_24", (String)"sit-itc-business", (Object[])new Object[0]);
            importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg3});
            LOGGER.info("TaxResultImportDataTask --- groupData is empty");
            return;
        }
        if (0L == this.conf.getTaxUnitId() && groupData.size() > 1) {
            ArrayList<List<DynamicObject>> values = new ArrayList<List<DynamicObject>>(groupData.values());
            String personNumber = ((DynamicObject)((List)values.get(0)).get(0)).getString("taxperson.number");
            String selectErrMsg = this.gerTaxUnitSelectErrMSg(groupData);
            String msg4 = ResManager.loadKDString((String)"{0}{1}\u5728{2}\u4e2d\u5b58\u5728\u591a\u4e2a\u4eba\u5458\u4e2a\u7a0e\u6863\u6848\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"TaxResultImportDataTask_21", (String)"sit-itc-business", (Object[])new Object[]{rowName, personNumber, selectErrMsg});
            importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg4});
            return;
        }
        List<DynamicObject> list = this.getGroupDataByTaxUnit(groupData);
        if (CollectionUtils.isEmpty(list)) {
            msg = ResManager.loadKDString((String)"\u5f53\u524d\u7eb3\u7a0e\u5355\u4f4d\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u4e2a\u7a0e\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u4e0a\u4f20\u7684\u6570\u636e\u662f\u5426\u6709\u8bef\uff0c\u6216\u8005\u662f\u5426\u6709\u5f15\u5165\u6570\u636e\u7684\u6743\u9650\u3002", (String)"TaxResultImportDataTask_24", (String)"sit-itc-business", (Object[])new Object[0]);
            importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
            LOGGER.info("TaxResultImportDataTask --- taxunit not match any data in groupdata");
            return;
        }
        for (DynamicObject dy : list) {
            String idNumber = dy.getString("percre.number");
            String name = dy.getString("taxperson.name");
            if (!idNumber.equals(rowIdNumber) || !StringUtils.equalsIgnoreCase((CharSequence)rowName, (CharSequence)name)) continue;
            isMatch = true;
            if (TaxTaskGuideOpEnum.IMPORT != this.conf.getOpEnum()) {
                map.put(dy.getLong("id"), rowInfo);
                break;
            }
            if (TaxTaskGuideOpEnum.IMPORT != this.conf.getOpEnum() || !categoryIdSet.contains(dy.getLong("taxcategory.id"))) continue;
            map.put(dy.getLong("id"), rowInfo);
            categoryMatch = true;
            break;
        }
        if (!isMatch) {
            msg = ResManager.loadKDString((String)"\u8bc1\u4ef6\u53f7\u7801\u4e0e\u59d3\u540d\u4e0d\u5339\u914d\uff0c\u6216\u5f53\u524d\u59d3\u540d\u3001\u8bc1\u4ef6\u53f7\u7801\u6ca1\u6709\u5339\u914d\u5230\u76f8\u5e94\u7684\u4e2a\u7a0e\u6570\u636e\u3002", (String)"TaxResultImportDataTask_27", (String)"sit-itc-business", (Object[])new Object[0]);
            importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
            return;
        }
        if (TaxTaskGuideOpEnum.IMPORT == this.conf.getOpEnum() && !categoryMatch) {
            msg = ResManager.loadKDString((String)"\u5f85\u5bfc\u5165\u7684\u6240\u5f97\u9879\u76ee\u201c{0}\u201d\u5728\u7a0e\u5c40\u6570\u636e\u5bfc\u5165\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TaxResultImportDataTask_10", (String)"sit-itc-business", (Object[])new Object[]{cateGoryName});
            importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
        }
    }

    private void getCondition(Map<Integer, String> map, Map<Integer, TaxtemplateEntity> templateMap, Map<Long, TaxItemEntity> itemMap, Set<String> idNumbers, Set<String> names, Set<Long> categoryIds) {
        Set<Integer> onlyFields = this.conf.getOnlyFields();
        block8: for (Integer integer : onlyFields) {
            String fieldKey;
            String value = map.get(integer);
            TaxtemplateEntity template = templateMap.get(integer);
            switch (fieldKey = template.getFieldkey()) {
                case "percre.number": {
                    idNumbers.add(value);
                    continue block8;
                }
                case "taxperson.name": {
                    names.add(value);
                    continue block8;
                }
            }
            this.getCategoriesId(value, itemMap, categoryIds);
        }
    }

    private void getCategoriesId(Object value, Map<Long, TaxItemEntity> itemMap, Set<Long> categoryId) {
        for (Map.Entry<Long, TaxItemEntity> entry : itemMap.entrySet()) {
            TaxItemEntity taxItem = entry.getValue();
            String fromMap = LocaleString.fromMap((Map)taxItem.getName()).getLocaleValue();
            if (!fromMap.equals(value)) continue;
            List categories = taxItem.getCategories();
            categoryId.addAll(categories);
        }
    }

    private List<ImportRowInfo> checkRowData(List<ImportRowInfo> rowInfos, ImportLogger importLogger) {
        Map<Integer, TaxtemplateEntity> templateMap = this.conf.getTemplateMap();
        Map<Long, TaxItemEntity> itemMap = this.conf.getItemMap();
        TaxPeriodEntity taxPeriodEntity = this.conf.getTaxTask().getTaxPeriodEntity();
        ArrayList<ImportRowInfo> result = new ArrayList<ImportRowInfo>(16);
        for (ImportRowInfo rowInfo : rowInfos) {
            HashSet<String> logs = new HashSet<String>();
            JSONObject data = rowInfo.getData();
            Map map = (Map)data.get((Object)(rowInfo.getRowIndex() - 1));
            this.doCheck(map, templateMap, itemMap, logs, rowInfo);
            this.doCheckPeriod(map, taxPeriodEntity, templateMap, logs);
            if (!logs.isEmpty()) {
                ArrayList msg = new ArrayList(logs.size());
                logs.forEach(obj -> msg.add(new ImportLogger.ImportLog("", obj)));
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), msg);
                continue;
            }
            rowInfo.setData(data);
            result.add(rowInfo);
        }
        return result;
    }

    private void doCheck(Map<Integer, String> map, Map<Integer, TaxtemplateEntity> templateMap, Map<Long, TaxItemEntity> itemMap, Set<String> logs, ImportRowInfo rowInfo) {
        StringBuilder bu = new StringBuilder();
        for (Map.Entry<Integer, String> entry : map.entrySet()) {
            TaxtemplateEntity template = templateMap.get(entry.getKey());
            if (null == template) continue;
            Object value = entry.getValue();
            String fieldKey = template.getFieldkey();
            Long taxItemId = template.getTaxitemid();
            if ("itc_taxtask.taxstartdate".equals(fieldKey)) {
                bu.append(value).append('&');
                continue;
            }
            if ("itc_taxtask.taxenddate".equals(fieldKey)) {
                bu.append(value).append('&');
                continue;
            }
            String isOnly = template.getIsonly();
            if (StringUtils.isNotBlank((CharSequence)fieldKey) && StringUtils.equals((CharSequence)"0", (CharSequence)isOnly)) continue;
            if (StringUtils.equals((CharSequence)"1", (CharSequence)isOnly)) {
                this.checkOnlyField(fieldKey, template.getImportfield(), value, itemMap, logs);
                bu.append(value).append('&');
                continue;
            }
            TaxItemEntity taxItemEntity = itemMap.get(taxItemId);
            if (null == taxItemEntity) continue;
            try {
                value = this.checkTaxItemDataType(taxItemEntity, value, logs, template.getImportfield());
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
            }
            entry.setValue(String.valueOf(value));
        }
        if (bu.length() > 0 && null != this.cacheMap.putIfAbsent(bu.toString(), rowInfo.getRowIndex())) {
            logs.add(MessageFormat.format(ResManager.loadKDString((String)"\u4e0e\u7b2c{0}\u884c\u7533\u62a5\u6570\u636e\u91cd\u590d\u3002", (String)"TaxResultImportDataTask_4", (String)"sit-itc-business", (Object[])new Object[0]), this.cacheMap.get(bu.toString())));
        }
    }

    private void doCheckPeriod(Map<Integer, String> map, TaxPeriodEntity taxPeriodEntity, Map<Integer, TaxtemplateEntity> templateMap, Set<String> logs) {
        String startDateStr = null;
        String endDateStr = null;
        String startImportField = null;
        String endImportField = null;
        for (Map.Entry<Integer, TaxtemplateEntity> entry : templateMap.entrySet()) {
            TaxtemplateEntity template = entry.getValue();
            String fieldKey = template.getFieldkey();
            if ("itc_taxtask.taxstartdate".equals(fieldKey)) {
                startDateStr = map.get(entry.getKey());
                startImportField = template.getImportfield();
            }
            if (!"itc_taxtask.taxenddate".equals(fieldKey)) continue;
            endDateStr = map.get(entry.getKey());
            endImportField = template.getImportfield();
        }
        if (StringUtils.isBlank(startDateStr) || StringUtils.isBlank(endDateStr)) {
            String msg = ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u65f6\u95f4\u4e0e\u4e2a\u7a0e\u4efb\u52a1\u671f\u95f4\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u662f\u5426\u6b63\u786e\u540e\u518d\u8bd5\u3002", (String)"TaxResultImportDataTask_2", (String)"sit-itc-business", (Object[])new Object[0]);
            logs.add(msg);
            return;
        }
        Date endDate = null;
        Date startDate = null;
        try {
            startDate = SitDateUtil.parseDate(startDateStr, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            logs.add(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5{0}\uff0c\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u65e5\u671f\u3002", (String)"TaxResultImportDataTask_9", (String)"sit-itc-business", (Object[])new Object[0]), startImportField));
            LOGGER.error((Throwable)e);
        }
        try {
            endDate = SitDateUtil.parseDate(endDateStr, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            logs.add(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5{0}\uff0c\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u65e5\u671f\u3002", (String)"TaxResultImportDataTask_9", (String)"sit-itc-business", (Object[])new Object[0]), endImportField));
            LOGGER.error((Throwable)e);
        }
        boolean startDateEq = SITDateTimeUtils.dayEquals((Date)SitDateUtil.ceil((Object)taxPeriodEntity.getStartDate()), (Date)SitDateUtil.ceil((Object)startDate));
        boolean endDateEq = SITDateTimeUtils.dayEquals((Date)SitDateUtil.ceil((Object)taxPeriodEntity.getEndDate()), (Date)SitDateUtil.ceil((Object)endDate));
        if (!startDateEq || !endDateEq) {
            String msg = ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u65f6\u95f4\u4e0e\u4e2a\u7a0e\u4efb\u52a1\u671f\u95f4\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6587\u4ef6\u662f\u5426\u6b63\u786e\u540e\u518d\u8bd5\u3002", (String)"TaxResultImportDataTask_2", (String)"sit-itc-business", (Object[])new Object[0]);
            logs.add(msg);
        }
    }

    private void checkOnlyField(String fieldKey, String importField, Object value, Map<Long, TaxItemEntity> itemMap, Set<String> logs) {
        switch (fieldKey) {
            case "percre.number": 
            case "taxperson.name": {
                if (null != value) break;
                logs.add(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxResultImportDataTask_12", (String)"sit-itc-business", (Object[])new Object[0]), importField));
                break;
            }
            default: {
                this.checkCategoryByTaxItem(value, itemMap, importField, logs);
            }
        }
    }

    private void checkCategoryByTaxItem(Object value, Map<Long, TaxItemEntity> itemMap, String importField, Set<String> logs) {
        List categories = new ArrayList(16);
        for (Map.Entry<Long, TaxItemEntity> entry : itemMap.entrySet()) {
            TaxItemEntity taxItem = entry.getValue();
            String fromMap = LocaleString.fromMap((Map)taxItem.getName()).getLocaleValue();
            if (!fromMap.equals(value)) continue;
            categories = taxItem.getCategories();
        }
        if (!CollectionUtils.isEmpty(categories)) {
            return;
        }
        logs.add(MessageFormat.format(ResManager.loadKDString((String)"{0}_{1}:\u6709\u8bef\u3002", (String)"TaxResultImportDataTask_13", (String)"sit-itc-business", (Object[])new Object[0]), importField, value));
    }

    private DynamicObject[] checkDeclareStatus(DynamicObject[] dys, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
        for (DynamicObject dy : dys) {
            String taxDataBizStatus = dy.getString("bizstatus");
            if (TaxDataBizStatusEnum.DECLARE.isLessEqThan(taxDataBizStatus)) {
                ImportRowInfo rowInfo = map.get(dy.getLong("id"));
                if (null == rowInfo) continue;
                String msg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u6570\u636e\u5bfc\u5165\u9519\u8bef\uff0c\u5df2\u7ecf\u6807\u8bb0\u7533\u62a5\u7684\u6570\u636e\u65e0\u6cd5\u518d\u6b21\u5bfc\u5165\u3002", (String)"TaxResultImportDataTask_11", (String)"sit-itc-business", (Object[])new Object[0]);
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                continue;
            }
            list.add(dy);
        }
        return list.toArray(new DynamicObject[0]);
    }

    private Object checkTaxItemDataType(TaxItemEntity taxItemEntity, Object value, Set<String> logs, String importField) {
        SitDataTypeEnum dataTypeEnum = SitDataTypeEnum.getEnumById((long)taxItemEntity.getDatatypeId());
        switch (dataTypeEnum) {
            case AMOUNT: {
                value = TaxResultImportDataTask.resolveAmount(taxItemEntity, value, importField, logs);
                break;
            }
            case NUMBER: {
                value = TaxResultImportDataTask.resolveBigDecimal(taxItemEntity, value, importField, logs);
                break;
            }
            case INTEGER: {
                value = TaxResultImportDataTask.resolveInteger(value, importField, logs);
                break;
            }
            case DATE: {
                value = TaxResultImportDataTask.resolveDate(value, importField, logs);
                break;
            }
            case BOOLEAN: {
                value = TaxResultImportDataTask.resolveBoolean(value, importField, logs);
                break;
            }
        }
        return value;
    }

    private static Object resolveBoolean(Object val, String field, Set<String> logs) {
        return val;
    }

    private static Object resolveBigDecimal(TaxItemEntity taxItem, Object val, String fieldName, Set<String> logs) {
        try {
            long dataRoundId = taxItem.getDataRoundId();
            if (dataRoundId != 0L) {
                BigDecimal itemAmount = (BigDecimal)BaseDataConverter.convert((Object)val, BigDecimal.class);
                int scale = taxItem.getDataPrecisionScale();
                String dataRound = DataRoundEnum.nameById((long)dataRoundId);
                val = BaseDataRoundHandler.handle((Number)itemAmount, (String)dataRound, (int)scale);
            }
        }
        catch (NumberFormatException e) {
            logs.add(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5{0}\uff0c\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6570\u5b57\u3002", (String)"TaxResultImportDataTask_5", (String)"sit-itc-business", (Object[])new Object[0]), fieldName));
        }
        return val;
    }

    private static Object resolveAmount(TaxItemEntity taxItem, Object value, String fieldName, Set<String> logs) {
        try {
            long dataRoundId = taxItem.getDataRoundId();
            if (dataRoundId != 0L) {
                BigDecimal itemAmount = (BigDecimal)BaseDataConverter.convert((Object)value, BigDecimal.class);
                int scale = taxItem.getDataPrecisionScale();
                String dataRound = DataRoundEnum.nameById((long)dataRoundId);
                value = BaseDataRoundHandler.handle((Number)itemAmount, (String)dataRound, (int)scale);
            }
        }
        catch (NumberFormatException e) {
            logs.add(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5{0}\uff0c\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6570\u5b57\u3002", (String)"TaxResultImportDataTask_5", (String)"sit-itc-business", (Object[])new Object[0]), fieldName));
        }
        return value;
    }

    private static Object resolveInteger(Object val, String fieldName, Set<String> logs) {
        try {
            val = Integer.valueOf(String.valueOf(val));
        }
        catch (NumberFormatException e) {
            logs.add(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5{0}\uff0c\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6574\u6570\u3002", (String)"TaxResultImportDataTask_6", (String)"sit-itc-business", (Object[])new Object[0]), fieldName));
        }
        return val;
    }

    private static Object resolveDate(Object val, String fieldName, Set<String> logs) {
        try {
            val = SitDateUtil.parseDate((String)((String)val), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            logs.add(MessageFormat.format(ResManager.loadKDString((String)"\u5b57\u6bb5{0}\uff0c\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6b63\u786e\u7684\u65e5\u671f\u3002", (String)"TaxResultImportDataTask_9", (String)"sit-itc-business", (Object[])new Object[0]), fieldName));
        }
        return val;
    }

    private void syncFeedbackProgress(List<ImportBillData> rowDatas, ImportLogger importLogger) {
        int lastEndIndex = rowDatas.get(rowDatas.size() - 1).getEndIndex();
        int lastRowIndex = importLogger.getLastRowIndex();
        int total = 0;
        int failQty = 0;
        ImportLogger logger = importLogger;
        total += logger.getTotal();
        this.conf.feedbackProgress(Math.min(99, lastEndIndex * 100 / lastRowIndex), importLogger, null, failQty += logger.getRowIndex() <= logger.getLastRowIndex() - 1 ? logger.getTotal() - logger.getDelRows().size() : logger.getFailed(), importLogger.getDelRows().size(), true);
    }

    private List<ImportRowInfo> getImportRowInfo(List<ImportBillData> rowDates, ImportLogger importLogger) {
        Set errorRowIndex = importLogger.getLogCache().keySet();
        ArrayList<ImportRowInfo> rowInfos = new ArrayList<ImportRowInfo>(16);
        for (ImportBillData rowData : rowDates) {
            ImportRowInfo rowInfo = new ImportRowInfo(rowData.getStartIndex() + 1, rowData.getData());
            importLogger.tick();
            if (errorRowIndex.contains(rowInfo.getRowIndex())) continue;
            rowInfos.add(rowInfo);
        }
        return rowInfos;
    }

    private void outputFailedData() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            String url = this.conf.getUrl();
            new ExcelReader().read(service.getInputStream(url), (SheetHandler)new TaxResultImportFailedSheetHandler(this.conf, service));
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
        }
    }

    private void resetErrorMsgIndex(ImportLogger importLogger) {
        Map importLogs = importLogger.getLogCache();
        if (CollectionUtils.isEmpty((Map)importLogs)) {
            return;
        }
        HashMap tempImportLogs = new HashMap(16);
        for (Map.Entry importLogEntry : importLogs.entrySet()) {
            tempImportLogs.put((Integer)importLogEntry.getKey() - 1, importLogEntry.getValue());
        }
        importLogger.setLogCache(tempImportLogs);
    }

    private List<DynamicObject> checkPersonDeclare(List<DynamicObject> taxDataBasicList, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(taxDataBasicList.size());
        String msg = ResManager.loadKDString((String)"\u4eba\u5458\u672a\u62a5\u9001\uff0c\u65e0\u6cd5\u5bfc\u5165\u4e13\u6263\u6570\u636e\u3002", (String)"TaxResultImportDataTask_15", (String)"sit-itc-business", (Object[])new Object[0]);
        for (DynamicObject dynamicObject : taxDataBasicList) {
            if (!YesOrNoEnum.YES.getCode().equals(dynamicObject.getString("declarestatus"))) {
                ImportRowInfo rowInfo = map.get(dynamicObject.getLong("id"));
                if (null == rowInfo) continue;
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                continue;
            }
            list.add(dynamicObject);
        }
        return list;
    }

    private List<DynamicObject> checkPrepareStatus(List<DynamicObject> taxDataBasicList, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(taxDataBasicList.size());
        for (DynamicObject dynamicObject : taxDataBasicList) {
            if (YesOrNoEnum.YES.getCode().equals(dynamicObject.getString("preparestatus"))) {
                ImportRowInfo rowInfo = map.get(dynamicObject.getLong("id"));
                if (null == rowInfo) continue;
                String msg = ResManager.loadKDString((String)"\u6570\u636e\u51c6\u5907\u5b8c\u6210\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"TaxResultImportDataTask_20", (String)"sit-itc-business", (Object[])new Object[0]);
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                continue;
            }
            list.add(dynamicObject);
        }
        return list;
    }

    private List<DynamicObject> checkCalStatus(List<DynamicObject> taxDataBasicList, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(taxDataBasicList.size());
        for (DynamicObject dynamicObject : taxDataBasicList) {
            if (!SrcRefNumEnums.NO_REF.getCode().equals(dynamicObject.getString("srcrefnum"))) {
                ImportRowInfo rowInfo = map.get(dynamicObject.getLong("id"));
                if (null == rowInfo) continue;
                String msg = ResManager.loadKDString((String)"\u5df2\u5bfc\u5165\u7b97\u85aa\u6570\u636e\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxResultImportDataTask_16", (String)"sit-itc-business", (Object[])new Object[0]);
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                continue;
            }
            list.add(dynamicObject);
        }
        return list;
    }

    private List<DynamicObject> checkTaxPayerType(List<DynamicObject> taxDataBasicList, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(taxDataBasicList.size());
        for (DynamicObject dynamicObject : taxDataBasicList) {
            DynamicObject employmentDy = dynamicObject.getDynamicObject("employment");
            if (null != employmentDy && 1038305410060130304L != employmentDy.getLong("taxpayertype.id")) {
                ImportRowInfo rowInfo = map.get(dynamicObject.getLong("id"));
                if (null == rowInfo) continue;
                String msg = ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e3a\u975e\u5c45\u6c11\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e\u3002", (String)"TaxResultImportDataTask_17", (String)"sit-itc-business", (Object[])new Object[0]);
                importLogger.logAll(Integer.valueOf(rowInfo.getRowIndex()), new String[]{msg});
                continue;
            }
            list.add(dynamicObject);
        }
        return list;
    }

    private void setDel(List<DynamicObject> successResult, HashMap<Long, ImportRowInfo> map, ImportLogger importLogger) {
        if (CollectionUtils.isEmpty(successResult)) {
            return;
        }
        List delRows = importLogger.getDelRows();
        if (CollectionUtils.isEmpty((Collection)delRows)) {
            ArrayList list = new ArrayList(importLogger.getLastRowIndex());
            importLogger.setDelRows(list);
        }
        for (DynamicObject dynamicObject : successResult) {
            ImportRowInfo rowInfo = map.get(dynamicObject.getLong("id"));
            if (null == rowInfo) continue;
            int[] del = new int[]{rowInfo.getRowIndex()};
            delRows.add(del);
            importLogger.setDelRows(delRows);
        }
    }

    private HashMap<String, Map<Long, List<DynamicObject>>> getGroupDataByPersonNameAndPercreNumber(List<DynamicObject> dys) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)dys.size());
        if (CollectionUtils.isEmpty(dys)) {
            return map;
        }
        for (DynamicObject dy : dys) {
            List list;
            Map taxUnitMap;
            String str = dy.getString("taxperson.name").concat("_").concat(dy.getString("percre.number"));
            if (0L == this.conf.getTaxUnitId() && "itc_taxdatabasic".equals(dy.getDataEntityType().getName())) {
                if (!YesOrNoEnum.YES.getCode().equals(dy.getString("taxfile.taxstatus"))) continue;
                taxUnitMap = map.computeIfAbsent(str, key -> Maps.newHashMapWithExpectedSize((int)2));
                list = taxUnitMap.computeIfAbsent(dy.getLong("taxunit.id"), key -> Lists.newArrayListWithExpectedSize((int)2));
                list.add(dy);
                continue;
            }
            taxUnitMap = map.computeIfAbsent(str, key -> Maps.newHashMapWithExpectedSize((int)2));
            list = taxUnitMap.computeIfAbsent(dy.getLong("taxunit.id"), key -> Lists.newArrayListWithExpectedSize((int)2));
            list.add(dy);
        }
        return map;
    }

    private List<DynamicObject> getGroupDataByTaxUnit(Map<Long, List<DynamicObject>> groupData) {
        if (0L != this.conf.getTaxUnitId()) {
            return groupData.get(this.conf.getTaxUnitId());
        }
        List<Object> result = Lists.newArrayListWithExpectedSize((int)1);
        if (1 == groupData.size()) {
            for (Map.Entry<Long, List<DynamicObject>> entry : groupData.entrySet()) {
                result = entry.getValue();
            }
        }
        return result;
    }

    private String gerTaxUnitSelectErrMSg(Map<Long, List<DynamicObject>> groupData) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Long, List<DynamicObject>> entry : groupData.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            if (CollectionUtils.isEmpty(value)) continue;
            if (builder.length() > 0) {
                builder.append('\u3001');
            }
            builder.append(value.get(0).getString("taxunit.name"));
        }
        return builder.toString();
    }

    private List<DynamicObject> removeNotMatchedDData(HashMap<Long, ImportRowInfo> map, List<DynamicObject> taxDataBasicList) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)taxDataBasicList.size());
        for (DynamicObject dynamicObject : taxDataBasicList) {
            if (!map.containsKey(dynamicObject.getLong("id"))) continue;
            result.add(dynamicObject);
        }
        return result;
    }
}

