/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.imports;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.BatchResult;

public class TaxTaskGuideImportDBServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskGuideImportDBServiceHelper.class);

    public static DynamicObject[] getTaxDeductByTaxDataBasic(Set<Long> taxDataBasicIds, TaxTaskEntity taxTask) {
        Long taxTaskId = taxTask.getId();
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdeduct").subProp("entryentity", new String[]{"taxitem", "itemvalue"});
        String prop = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, e1 -> !e1.contains("_"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdeduct");
        QFilter qFilter = new QFilter("taxtask", "=", (Object)taxTaskId);
        qFilter.and("taxdatabasic", "in", taxDataBasicIds);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return helper.query(prop, qFilters);
    }

    public static DynamicObject[] queryTaxDeductByCondition(Set<String> ids, Set<String> names, TaxTaskEntity taxTask) {
        Long taxTaskId = taxTask.getId();
        Long taxPeriodId = taxTask.getTaxPeriodEntity().getId();
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdatabasic").subProp("yearmonth", new String[]{"taxunit", "taxtask", "taxperson", "taxfile"});
        String prop = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, e1 -> !e1.contains("_"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdatabasic");
        QFilter qFilter = new QFilter("taxtask", "=", (Object)taxTaskId);
        qFilter.and("taxtask.taxperiod", "=", (Object)taxPeriodId);
        qFilter.and("taxperson.idnumber", "in", ids);
        qFilter.and("taxperson.name", "in", names);
        QFilter[] qFilters = new QFilter[]{qFilter};
        return helper.query(prop, qFilters);
    }

    public static DynamicObject[] queryTaxFileByCondition(Set<String> idNumbers, Set<String> names, TaxTaskEntity taskEntity, Long taxUnitId) {
        List authorizedDataRuleQFilter = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"17/+CT1QBPNP", (String)"itc_taxpreparedata", (String)"28IFB781YOFI");
        if (null == authorizedDataRuleQFilter) {
            return new DynamicObject[0];
        }
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdatabasic").subProp("id", new String[]{"taxperson.idnumber"});
        String prop = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, e1 -> !"multilanguagetext".equals(e1) && !e1.contains("_"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdatabasic");
        QFilter qFilter = new QFilter("percre.number", "in", idNumbers);
        qFilter.and("taxperson.name", "in", names);
        if (null != taxUnitId && 0L != taxUnitId) {
            qFilter.and("taxunit.id", "=", (Object)taxUnitId);
        }
        qFilter.and("yearmonth", "=", (Object)taskEntity.yearMonth());
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taskEntity.getId());
        QFilter statusFilter = new QFilter("status", "not in", Arrays.asList("D", "E"));
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{qFilter, taxTaskFilter, statusFilter});
        filters.addAll(authorizedDataRuleQFilter);
        return helper.query(prop, filters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] queryTaxDataByCondition(Set<String> ids, Set<String> names, Set<Long> taxcategoryId, TaxTaskEntity taxTask, long taxUnitId) {
        List authorizedDataRuleQFilter = SITPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"17/+CT1QBPNP", (String)"itc_taxdata", (String)"2/C55F31YORN");
        if (null == authorizedDataRuleQFilter) {
            return new DynamicObject[0];
        }
        Long taxTaskId = taxTask.getId();
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdata").subProp("entryentity", new String[]{"entryyearmonth", "taxitem", "taxcategory", "itemvalue", "calvalue", "entrystatus", "entrymodifytime", "calvalue", "diffvalue"});
        String prop = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, e1 -> !e1.contains("_"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxdata");
        QFilter qFilter = new QFilter("taxtask", "=", (Object)taxTaskId);
        qFilter.and("taxcategory", "in", taxcategoryId);
        qFilter.and("taxperson.name", "in", names);
        qFilter.and("percre.number", "in", ids);
        qFilter.and("status", "!=", (Object)"E");
        if (0L != taxUnitId) {
            qFilter.and("taxunit", "=", (Object)taxUnitId);
        }
        qFilter.and("yearmonth", "=", (Object)taxTask.yearMonth());
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{qFilter});
        filters.addAll(authorizedDataRuleQFilter);
        long startTime = System.currentTimeMillis();
        LOGGER.info("Query taxData startTime\uff1a{} param\uff1a{}", (Object)HRDateTimeUtils.format((Date)new Date(startTime), (String)"yyyy-MM-dd HH:mm:ss"), (Object)((Object)filters).toString());
        DynamicObject[] dys = helper.query(prop, filters.toArray(new QFilter[0]));
        LOGGER.info("Query taxData  endTime\uff1a{} cost\uff1a{}", (Object)HRDateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), (Object)(System.currentTimeMillis() - startTime));
        return dys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BatchResult<DynamicObject> saveTaxDeduct(BatchResult<DynamicObject> taxDataResult, List<DynamicObject> taxDataBasicList, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, boolean newTx, CustomFunction ... customs) {
        TaxTaskGuideServiceHelper.createTaxTaskRecord(taxTaskEntity, stepCaseInfo, opEnum, null);
        List successResult = taxDataResult.successResult();
        ArrayList basicList = Lists.newArrayListWithExpectedSize((int)taxDataBasicList.size());
        ArrayList updateList = Lists.newArrayListWithExpectedSize((int)successResult.size());
        switch (opEnum) {
            case IMPORT_SAD: {
                for (DynamicObject dy : successResult) {
                    dy.set("bizstatus", (Object)YesOrNoEnum.YES.getCode());
                    updateList.add(dy);
                }
                for (DynamicObject dy : taxDataBasicList) {
                    dy.set("bizstatus", (Object)YesOrNoEnum.YES.getCode());
                    basicList.add(dy);
                }
                break;
            }
            case ROLLBACK_IMPORT_SAD: 
            case ROLLBACK_IMPORT_SAD_BY_TAX_UNIT: {
                for (DynamicObject dy : successResult) {
                    updateList.add(dy);
                }
                for (DynamicObject dy : taxDataBasicList) {
                    dy.set("bizstatus", (Object)YesOrNoEnum.NO.getCode());
                    basicList.add(dy);
                }
                break;
            }
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdeduct");
        TXHandle required = null;
        if (newTx) {
            required = TX.required();
        }
        try {
            for (CustomFunction function : customs) {
                function.apply();
            }
            if (CollectionUtils.isEmpty((Collection)updateList)) return taxDataResult;
            switch (opEnum) {
                case IMPORT_SAD: {
                    serviceHelper.save(updateList.toArray(new DynamicObject[0]));
                    serviceHelper.save(basicList.toArray(new DynamicObject[0]));
                    return taxDataResult;
                }
                case ROLLBACK_IMPORT_SAD: 
                case ROLLBACK_IMPORT_SAD_BY_TAX_UNIT: {
                    Set ids = updateList.stream().map(e1 -> e1.getLong("id")).collect(Collectors.toSet());
                    QFilter filter = new QFilter("id", "in", ids);
                    serviceHelper.deleteByFilter(new QFilter[]{filter});
                    serviceHelper.save(basicList.toArray(new DynamicObject[0]));
                    return taxDataResult;
                }
            }
            return taxDataResult;
        }
        catch (Exception e) {
            LOGGER.warn("Error occurs when save tax data", (Throwable)e);
            taxDataResult.ofSuccess(false).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"{0}\u5931\u8d25\uff1a{1}\u3002", (String)"TaxTaskGuideServiceHelper_10", (String)"sit-itc-business", (Object[])new Object[]{opEnum.loadKDString(), e.getLocalizedMessage()}));
            taxDataResult.addFailResult(taxDataResult.getSuccessResult(), e.getMessage(), ResultStatusEnum.ERROR.getCode());
            taxDataResult.getSuccessResult().clear();
            if (required == null) return taxDataResult;
            required.markRollback();
            return taxDataResult;
        }
        finally {
            if (required != null) {
                required.close();
            }
        }
    }

    public static List<DynamicObject> loadTaxDeductData(QFilter[] qFilters) {
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdeduct").subProp("entryentity", new String[]{"taxitem", "taxitem.caltaxtype", "taxitem.name", "taxcategory", "itemvalue", "bizstatus"});
        String prop = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, e1 -> !e1.contains("_"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdeduct");
        DynamicObject[] taxDataArr = serviceHelper.query(prop, qFilters);
        return new ArrayList<DynamicObject>(Arrays.asList(taxDataArr));
    }

    public static List<DynamicObject> loadTaxBasicData(QFilter[] qFilters) {
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxpreparedata").subProp("yearmonth", new String[]{"taxunit", "taxtask", "taxperson", "taxfile", "bizstatus"});
        String prop = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, e1 -> !e1.contains("_"));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxpreparedata");
        DynamicObject[] taxDataArr = serviceHelper.query(prop, qFilters);
        return new ArrayList<DynamicObject>(Arrays.asList(taxDataArr));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> getTaxUnitIdByBizStatus(Long taxTaskId) {
        QFilter qFilter = new QFilter("taxtask", "=", (Object)taxTaskId);
        qFilter.and("bizstatus", "=", (Object)YesOrNoEnum.YES.getCode());
        ArrayList<Long> taxUnitIds = new ArrayList<Long>(16);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideImportDBServiceHelper.class.getName(), (String)"itc_taxpreparedata", (String)"taxfile.taxunit.id", (QFilter[])new QFilter[]{qFilter}, (String)"");
            if (dataSet.isEmpty()) {
                ArrayList<Long> arrayList = taxUnitIds;
                return arrayList;
            }
            dataSet = dataSet.distinct();
            for (Row row : dataSet) {
                taxUnitIds.add(row.getLong("taxfile.taxunit.id"));
            }
        }
        return taxUnitIds;
    }
}

