/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.imports;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.ksql.util.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.imports.TaxTaskGuideImportDBServiceHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BatchResult;
import org.apache.commons.lang3.StringUtils;

public class TaxTaskGuideImportServiceHelper {
    private static final Log LOG = LogFactory.getLog(TaxTaskGuideImportServiceHelper.class);

    private TaxTaskGuideImportServiceHelper() {
    }

    public static void showSelectForm(IFormView view, long taxGroupId, String scene, String className, String actionId, TaxTaskEntity taxTaskEntity) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("itc_selectimporttpl");
        parameter.setCustomParam("scene", (Object)scene);
        parameter.setCustomParam("taxgroup", (Object)taxGroupId);
        Object[] taxUnitIds = TaxTaskGuideImportServiceHelper.getTaxUnitIds(taxTaskEntity);
        if (!ArrayUtils.isEmpty((Object[])taxUnitIds) && taxUnitIds.length == 1) {
            parameter.setCustomParam("taxUnitId", taxUnitIds[0]);
        }
        parameter.setCustomParam("taxUnitIds", (Object)taxUnitIds);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack cb = new CloseCallBack(className, actionId);
        parameter.setCloseCallBack(cb);
        view.showForm(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long[] getTaxUnitIds(TaxTaskEntity taskEntity) {
        Set permItem;
        Map taxUnitMap = taskEntity.getTaxUnitMap();
        Set taxUnitIds = taxUnitMap.keySet();
        QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)taskEntity.getId());
        QFilter taxUnitFilter = new QFilter("taxunit.id", "in", taxUnitIds);
        QFilter statusFilter = new QFilter("status", "not in", Arrays.asList("D", "E"));
        ArrayList filters = Lists.newArrayList((Object[])new QFilter[]{taxTaskFilter, taxUnitFilter, statusFilter});
        HashSet set = new HashSet(16);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideServiceHelper.class.getName(), (String)"itc_taxdatabasic", (String)"taxunit.id", (QFilter[])filters.toArray(new QFilter[0]), (String)"");
            if (dataSet.isEmpty()) {
                Long[] longArray = new Long[]{};
                return longArray;
            }
            dataSet.distinct().forEach(e1 -> set.add(e1.getLong("taxunit.id")));
        }
        if (CollectionUtils.isEmpty(set)) {
            return new Long[0];
        }
        HashSet tmpSet = Sets.newHashSetWithExpectedSize((int)taxUnitIds.size());
        for (Long taxUnitId : taxUnitIds) {
            if (!set.contains(taxUnitId)) continue;
            tmpSet.add(taxUnitId);
        }
        if (CollectionUtils.isEmpty((Collection)tmpSet)) {
            return new Long[0];
        }
        if (!SITPermissionServiceHelper.isSuperUser() && (permItem = SITPermissionServiceHelper.getTaxUnitSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxdata", (String)"47150e89000000ac")) != null) {
            tmpSet.retainAll(permItem);
        }
        if (CollectionUtils.isEmpty((Collection)tmpSet)) {
            return new Long[0];
        }
        Long[] reArr = new Long[set.size()];
        int index = 0;
        Iterator iterator = tmpSet.iterator();
        while (iterator.hasNext()) {
            Long aLong;
            reArr[index] = aLong = (Long)iterator.next();
            ++index;
        }
        return reArr;
    }

    public static void openImportingPage(Map<Long, String> returnData, IFormView view, TaxTaskEntity taxTaskEntity, String className, String actionId, String entityId, TaxTaskGuideStepCaseInfo stepCaseInfo, String opName, AbstractFormPlugin plugin) {
        if (CollectionUtils.isEmpty(returnData)) {
            return;
        }
        Map.Entry<Long, String> next = returnData.entrySet().iterator().next();
        Long taxUnitId = next.getKey();
        String url = next.getValue();
        IPageCache pageCache = view.getPageCache();
        String templateId = pageCache.get("templateId");
        LOG.info("url:{}--------------TaxunitId:{}----------templateId:{}---", new Object[]{url, taxUnitId, templateId});
        if (!TaxTaskGuideServiceHelper.checkTaskSnapShotWithTaxtemplate(templateId, taxTaskEntity)) {
            pageCache.put("importUrl", url);
            pageCache.put("importTaxUnit", String.valueOf(taxUnitId));
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u5305\u542b\u7684\u4e2a\u7a0e\u9879\u76ee\u4e0e\u4e2a\u7a0e\u4efb\u52a1\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u7ee7\u7eed\u5bfc\u5165\uff1f", (String)"TaxTaskGuideImportServiceHelper_1", (String)"sit-itc-business", (Object[])new Object[0]);
            view.showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("TaxItemConfirm", (IFormPlugin)plugin));
            return;
        }
        if (StringUtil.isEmpty((String)url)) {
            String msg = ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u4e0a\u4f20\u60c5\u51b5", (String)"TaxTaskGuideImportServiceHelper_3", (String)"sit-itc-business", (Object[])new Object[0]);
            view.showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("TaxItemConfirm", (IFormPlugin)plugin));
            return;
        }
        TaxTaskGuideImportServiceHelper.openImportingPage(url, view, taxTaskEntity, className, actionId, entityId, stepCaseInfo, opName, taxUnitId);
    }

    public static void openImportingPage(String url, IFormView view, TaxTaskEntity taxTaskEntity, String className, String actionId, String entityId, TaxTaskGuideStepCaseInfo stepCaseInfo, String opName, Long taxUnitId) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return;
        }
        IPageCache pageCache = view.getPageCache();
        String head = pageCache.get("head");
        String headerLineNumber = pageCache.get("headerLineNumber");
        String templateId = pageCache.get("templateId");
        if (StringUtils.isBlank((CharSequence)head)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("itc_taxresultimporting");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("opName", (Object)opName);
        showParameter.setCustomParam("entityid", (Object)entityId);
        showParameter.setCustomParam("url", (Object)url);
        showParameter.setCustomParam("head", (Object)head);
        showParameter.setCustomParam("headerLineNumber", (Object)headerLineNumber);
        showParameter.setCustomParam("templateId", (Object)templateId);
        showParameter.setCustomParam("taxUnitId", (Object)taxUnitId);
        String taxTaskEntityJson = JSON.toJSONString((Object)taxTaskEntity);
        showParameter.setCustomParam("taxTaskEntity", (Object)taxTaskEntityJson);
        String stepCaseInfoJson = JSON.toJSONString((Object)stepCaseInfo);
        showParameter.setCustomParam("stepCaseInfo", (Object)stepCaseInfoJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack cb = new CloseCallBack(className, actionId);
        showParameter.setCloseCallBack(cb);
        view.showForm(showParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatchResult<Long> validateRollbackImportSADTask(TaxTaskEntity taxTask, TaxTaskGuideOpEnum opEnum, List<Object> ids) {
        QFilter taskFilter = new QFilter("taxtask.id", "=", (Object)taxTask.getId());
        QFilter bizStatusFilter = new QFilter("bizstatus", "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter basicFilter = new QFilter("id", "in", ids);
        QFilter[] qFilters = new QFilter[]{taskFilter, bizStatusFilter, basicFilter};
        ArrayList taxDataBasicList = new ArrayList(16);
        try (DataSet dataSet = null;){
            dataSet = QueryServiceHelper.queryDataSet((String)TaxTaskGuideImportServiceHelper.class.getName(), (String)"itc_taxpreparedata", (String)"id", (QFilter[])qFilters, (String)"");
            if (dataSet.isEmpty()) {
                BatchResult batchResult = new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6e05\u9664\u6761\u4ef6\u7684\u8bb0\u5f55\u3002", (String)"TaxTaskGuideImportServiceHelper_0", (String)"sit-itc-business", (Object[])new Object[0]));
                return batchResult;
            }
            dataSet.distinct().forEach(e1 -> taxDataBasicList.add(e1.getLong("id")));
            BatchResult batchResult = new BatchResult(true, taxDataBasicList);
            return batchResult;
        }
    }

    public static BatchResult<Long> getOneImportSADTask(TaxTaskEntity taxTask) {
        QFilter taskFilter = new QFilter("taxtask.id", "=", (Object)taxTask.getId());
        QFilter bizStatusFilter = new QFilter("bizstatus", "=", (Object)YesOrNoEnum.YES.getCode());
        QFilter[] qFilters = new QFilter[]{taskFilter, bizStatusFilter};
        HRBaseServiceHelper helper = new HRBaseServiceHelper("ITC_TAXPREPAREDATA");
        DynamicObject dynamicObject = helper.queryOne(qFilters);
        ArrayList taxDataBasicList = new ArrayList(16);
        if (null == dynamicObject) {
            return new BatchResult(false, null).ofStatus(ResultStatusEnum.ERROR.getCode()).ofMessage(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6e05\u9664\u6761\u4ef6\u7684\u8bb0\u5f55\u3002", (String)"TaxTaskGuideImportServiceHelper_0", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        return new BatchResult(true, taxDataBasicList);
    }

    public static void rollbackImportSDAForTaxFileUnmark(TaxTaskEntity task, List<Long> idList, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        QFilter idFilter = new QFilter("taxfile.id", "in", idList);
        QFilter taxTaskFilter = new QFilter("taxtask.id", "in", (Object)task.getId());
        QFilter[] filters = new QFilter[]{idFilter, taxTaskFilter};
        List<DynamicObject> taxDataBasicList = TaxTaskGuideImportDBServiceHelper.loadTaxBasicData(filters);
        if (CollectionUtils.isEmpty(taxDataBasicList)) {
            return;
        }
        Set taxDataBasicId = taxDataBasicList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        QFilter taxBasicFilter = new QFilter("taxdatabasic", "in", taxDataBasicId);
        QFilter[] taxBasicFilters = new QFilter[]{taxBasicFilter};
        List<DynamicObject> deductList = TaxTaskGuideImportDBServiceHelper.loadTaxDeductData(taxBasicFilters);
        if (CollectionUtils.isEmpty(deductList)) {
            return;
        }
        BatchResult deductResult = new BatchResult(true, deductList);
        TaxTaskGuideImportDBServiceHelper.saveTaxDeduct((BatchResult<DynamicObject>)deductResult, taxDataBasicList, task, stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_IMPORT_SAD, false, new CustomFunction[0]);
    }
}

