/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.imports;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TimeProp;
import kd.sit.itc.common.model.ImportField;
import kd.sit.sitbp.business.helper.excel.model.HeadCellBar;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.SheetInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.common.util.datatype.DataTypeEnum;

public class WorkbookImportTemplateExport
implements WorkbookInfoGenerator {
    public WorkbookInfo generate(Map<String, Object> param) {
        ArrayList list = (ArrayList)param.get("template");
        String name = (String)param.get("name");
        int headerLineNumber = (Integer)param.get("headerlinenumber");
        String fileName = this.getFullFileName(name);
        WorkbookInfo workbookInfo = new WorkbookInfo();
        workbookInfo.setNeedTemplate(false);
        workbookInfo.setFileName(fileName);
        SheetInfo sheetInfo = new SheetInfo();
        sheetInfo.setName(name);
        sheetInfo.setNeedFillHead(true);
        sheetInfo.setBodyRow(4);
        HeadCellBar headCellBar = new HeadCellBar();
        for (ImportField field : list) {
            this.setFieldNameCell(headCellBar, field, field.getColNum(), headerLineNumber);
        }
        headCellBar.setHeadCellStyleName("importHead");
        headCellBar.setBodyCellStyleName("importBody");
        sheetInfo.setHeadCellBar(headCellBar);
        workbookInfo.setSheetInfoList(Collections.singletonList(sheetInfo));
        workbookInfo.ready();
        return workbookInfo;
    }

    private void setFieldNameCell(HeadCellBar headCellBar, ImportField field, int colNum, int rowNum) {
        String fieldName = field.getFieldName();
        HeadCellInfo cellInfo = new HeadCellInfo();
        cellInfo.setRowNum(rowNum);
        cellInfo.setColNum(colNum);
        boolean isMustInput = field.isMustInput();
        if (isMustInput) {
            cellInfo.setRequired(isMustInput);
            fieldName = "*" + fieldName;
        }
        cellInfo.setValueProp(field.getFieldName());
        cellInfo.setDefaultDesc(fieldName);
        cellInfo.setRequired(isMustInput);
        cellInfo.setWidth(256 * (8 + cellInfo.getDefaultDesc().getBytes(StandardCharsets.UTF_8).length));
        DynamicProperty property = field.getProperty();
        if (null != property) {
            this.setStyleInfo(cellInfo, property);
        }
        headCellBar.addHeadCellInfos(new HeadCellInfo[]{cellInfo});
    }

    private void setStyleInfo(HeadCellInfo cellInfo, DynamicProperty dynProperty) {
        if (dynProperty == null) {
            return;
        }
        if (dynProperty instanceof DateTimeProp || dynProperty instanceof TimeProp) {
            cellInfo.setBaseFormat("yyyy-MM-dd");
        } else if (dynProperty instanceof DecimalProp) {
            int scale = ((DecimalProp)dynProperty).getScale();
            String styleStr = "0";
            StringBuilder sb = new StringBuilder(styleStr);
            if (scale > 0) {
                sb.append('.');
                for (int i = 0; i < scale; ++i) {
                    sb.append('0');
                }
            }
            cellInfo.setBaseFormat(sb.toString());
            cellInfo.setDataType("DOUBLE");
        }
    }

    private void dealProperty(HeadCellInfo cellInfo, DataTypeEnum dataType) {
        switch (dataType) {
            case STRING: {
                cellInfo.setComment(ResManager.loadKDString((String)"\u6587\u672c", (String)"WorkbookImportTemplateExport_0", (String)"sit-sitbs-business", (Object[])new Object[0]));
                break;
            }
            case DATE: {
                cellInfo.setComment(ResManager.loadKDString((String)"\u65e5\u671f\uff0c\u793a\u4f8b\uff1a2018-05-01", (String)"WorkbookTaxFileExport_6", (String)"sit-itc-business", (Object[])new Object[0]));
                break;
            }
            case BIG_DECIMAL: {
                cellInfo.setComment(ResManager.loadKDString((String)"\u6570\u5b57", (String)"WorkbookTaxFileExport_8", (String)"sit-itc-business", (Object[])new Object[0]));
                cellInfo.setDataType("DOUBLE");
                break;
            }
        }
    }

    private String getFullFileName(String templateName) {
        LocalDate now = LocalDate.now();
        String date = String.format(Locale.ROOT, "%04d", now.getYear()) + String.format(Locale.ROOT, "%02d", now.getMonthValue()) + String.format(Locale.ROOT, "%02d", now.getDayOfMonth());
        return String.format("%s_%s%s", templateName, date, ".xlsx");
    }
}

