/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.listener;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.sit.itc.common.api.TaxTaskGuideOpBatchListener;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.api.SitAppReportService;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import org.springframework.util.CollectionUtils;

public class LockStatusListener
implements TaxTaskGuideOpBatchListener {
    public boolean match(DynamicObject taxTaskOpRecord) {
        String opType = taxTaskOpRecord.getString("optype");
        return TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK.getCode().equals(opType);
    }

    public BaseResult<?> afterBatchOperation(BatchResult<DynamicObject> res, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskOpRecord, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo caseInfo) {
        List taxDataList = res.successResult();
        if (CollectionUtils.isEmpty((Collection)taxDataList)) {
            return BaseResult.success(null);
        }
        SitAppReportService reportService = SitAppReportService.lookUpSitAppReportService((String)"itc");
        DynamicObject importRecord = reportService.cloneTaxTaskRecord(taxTaskOpRecord, TaxTaskGuideOpEnum.IMPORT);
        DynamicObject reportRecord = reportService.cloneTaxTaskRecord(taxTaskOpRecord, TaxTaskGuideOpEnum.DECLARE);
        DynamicObject confirmRecord = reportService.cloneTaxTaskRecord(taxTaskOpRecord, TaxTaskGuideOpEnum.CONFIRM);
        for (DynamicObject taxData : taxDataList) {
            long taxDataId;
            List<DynamicObject> rawDataList;
            taxData.set("importoprecord", (Object)importRecord);
            taxData.set("reportoprecord", (Object)reportRecord);
            taxData.set("confirmoprecord", (Object)confirmRecord);
            DynamicObjectCollection itemDataList = taxData.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)itemDataList)) {
                for (DynamicObject itemData : itemDataList) {
                    itemData.set("itemvalue", itemData.get("calvalue"));
                }
            }
            if (CollectionUtils.isEmpty(rawDataList = srcDataMap.get(taxDataId = taxData.getLong("id")))) continue;
            for (DynamicObject rawData : rawDataList) {
                rawData.set("importoprecord", (Object)importRecord);
                rawData.set("reportoprecord", (Object)reportRecord);
                rawData.set("confirmoprecord", (Object)confirmRecord);
                DynamicObjectCollection rawItemDataList = rawData.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isEmpty((Collection)rawItemDataList)) continue;
                for (DynamicObject itemData : rawItemDataList) {
                    itemData.set("itemvalue", itemData.get("calvalue"));
                }
            }
        }
        return BaseResult.success(null);
    }
}

