/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.listener;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.common.api.TaxTaskGuideOpBatchListener;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;

public class OperationLogBatchListener
implements TaxTaskGuideOpBatchListener {
    public int priority() {
        return 10000;
    }

    public BaseResult<?> afterBatchOperation(BatchResult<DynamicObject> data, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskOpRecord, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo caseInfo) {
        SITThreadPoolFactory.getCommonAsyncThreadpool().execute(() -> {
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdatarecord");
            int yearMonth = taxTaskEntity.yearMonth();
            List successItems = data.getSuccessResult();
            List failItems = data.getFailResultOriginal();
            DynamicObject[] records = new DynamicObject[successItems.size() + failItems.size()];
            for (int i = 0; i < successItems.size(); ++i) {
                DynamicObject record;
                records[i] = record = serviceHelper.generateEmptyDynamicObject();
                long taxDataId = ((DynamicObject)successItems.get(i)).getLong("id");
                record.set("taxdata", (Object)taxDataId);
                record.set("resultstatus", (Object)ResultStatusEnum.INFO.getCode());
                record.set("yearmonth", (Object)yearMonth);
                record.set("taxtaskrecord", (Object)taxTaskOpRecord);
                List srcData = (List)srcDataMap.get(taxDataId);
                if (!CollectionUtils.isEmpty((Collection)srcData)) continue;
                DynamicObjectCollection entryEntity = record.getDynamicObjectCollection("entryentity");
                for (DynamicObject src : srcData) {
                    DynamicObject dynamicObject = entryEntity.addNew();
                    dynamicObject.set("entryyearmonth", (Object)yearMonth);
                    dynamicObject.set("taxrawdata", src.get("id"));
                }
            }
            serviceHelper.save(records);
        });
        return BaseResult.success(null);
    }
}

