/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.listener;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.sit.itc.business.taxtaskguide.model.SrcStatus;
import kd.sit.itc.common.api.TaxTaskGuideOpBatchListener;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.threadpool.SITThreadPoolFactory;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;

public class SalaryDataStatusBatchListener
implements TaxTaskGuideOpBatchListener {
    private static final String OPERATE_KEY_MQ = "__operateKey__";
    private static final Log LOGGER = LogFactory.getLog(SalaryDataStatusBatchListener.class);

    public int priority() {
        return 10000;
    }

    public boolean match(DynamicObject taxTaskOpRecord) {
        return true;
    }

    public BaseResult<?> afterBatchOperation(BatchResult<DynamicObject> data, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskOpRecord, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo caseInfo) {
        if (taxTaskEntity.isLocalCal()) {
            return BaseResult.success(null);
        }
        String operateKey = taxTaskOpRecord.getString("id");
        String opType = taxTaskOpRecord.getString("optype");
        SITThreadPoolFactory.getCommonAsyncThreadpool().execute(() -> {
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
            }
            HashMap<String, Map> srcTypeStatusKeyMap = new HashMap<String, Map>(16);
            for (List list : srcDataMap.values()) {
                for (DynamicObject obj : list) {
                    String bizStatus = obj.getString("bizstatus");
                    String srcStatus = obj.getString("taxdatabasic.srcstatus");
                    if (StringUtils.isNotEmpty((CharSequence)srcStatus) && SalaryDataStatusBatchListener.shouldSkip(opType, obj, srcStatus)) continue;
                    String srcType = obj.getString("taxdatabasic.rawtype");
                    String srcDataKey = obj.getString("taxdatabasic.rawdatakey");
                    String rawTaskNumber = obj.getString("taxdatabasic.rawcaltask.number");
                    Map taskStatusKeyMap = srcTypeStatusKeyMap.computeIfAbsent(srcType, key -> new HashMap(16));
                    Map statusKeyMap = taskStatusKeyMap.computeIfAbsent(rawTaskNumber, key -> new HashMap(16));
                    Set keys = statusKeyMap.computeIfAbsent(bizStatus, key -> new HashSet(16));
                    keys.add(srcDataKey);
                }
            }
            for (Map.Entry entry : srcTypeStatusKeyMap.entrySet()) {
                String srcType = (String)entry.getKey();
                HashMap statusKeyMap = Maps.newHashMap((Map)((Map)entry.getValue()));
                MessagePublisher publisher = null;
                try {
                    publisher = MQFactory.get().createSimplePublisher("swc", "itc_tax_task_srcdata_chang_" + srcType);
                    statusKeyMap.put(OPERATE_KEY_MQ, operateKey);
                    publisher.publish((Object)statusKeyMap);
                }
                catch (Exception e) {
                    LOGGER.warn("Error when SalaryDataStatusListener.afterDoOperation", (Throwable)e);
                }
                finally {
                    if (publisher == null) continue;
                    publisher.close();
                }
            }
        });
        return BaseResult.success(null);
    }

    private static boolean shouldSkip(String opType, DynamicObject srcData, String srcStatus) {
        if (srcStatus.compareTo(SrcStatus.AUDITED.getCode()) >= 0) {
            return true;
        }
        String feedBackResult = srcData.getString("feedbackoprecord.result");
        String reportResult = srcData.getString("reportoprecord.result");
        return SrcStatus.RECEIVED.getCode().equals(srcStatus) && YesOrNoEnum.isYes((String)feedBackResult) && !YesOrNoEnum.isYes((String)reportResult);
    }
}

