/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.listener;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.common.api.TaxTaskGuideOpBatchListener;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;

public class TaxDataBasicBatchListener
implements TaxTaskGuideOpBatchListener {
    private static final Log LOGGER = LogFactory.getLog(TaxDataBasicBatchListener.class);

    public int priority() {
        return 10;
    }

    public boolean match(DynamicObject taxTaskOpRecord) {
        String opType = taxTaskOpRecord.getString("optype");
        return TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK.getCode().equals(opType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseResult<?> afterBatchOperation(BatchResult<DynamicObject> res, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskOpRecord, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo caseInfo) {
        DynamicObject[] rawDataArr;
        List taxDataSuccess = res.getSuccessResult();
        if (CollectionUtils.isEmpty((Collection)taxDataSuccess)) {
            return BaseResult.success(null);
        }
        HashSet dataBasicIds = Sets.newHashSetWithExpectedSize((int)taxDataSuccess.size());
        HashSet fileIds = Sets.newHashSetWithExpectedSize((int)taxDataSuccess.size());
        for (DynamicObject dataSuccess : taxDataSuccess) {
            dataBasicIds.add(dataSuccess.getLong("taxdatabasic.id"));
            fileIds.add(dataSuccess.getLong("taxfile.boid"));
        }
        int yearMonth = taxTaskEntity.yearMonth();
        Long taskId = taxTaskEntity.getId();
        HRBaseServiceHelper basicServiceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        DynamicObject[] dataBasics = basicServiceHelper.query("id,taxfile.boid,srcrefnum", new QFilter[]{new QFilter("id", "in", (Object)dataBasicIds)});
        HRBaseServiceHelper rawDataServiceHelper = new HRBaseServiceHelper("itc_taxrawdata");
        QFilter fileIdFilter = new QFilter("taxfile.boid", "in", (Object)fileIds);
        QFilter yearMonthFilter = new QFilter("yearmonth", "=", (Object)yearMonth);
        QFilter taskIdFilter = new QFilter("taxtask.id", "=", (Object)taskId);
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        HashMap rawBasicOfFile = Maps.newHashMapWithExpectedSize((int)dataBasics.length);
        for (DynamicObject object : rawDataArr = rawDataServiceHelper.query("id,taxdatabasic.id,taxfile.boid", new QFilter[]{fileIdFilter, yearMonthFilter, taskIdFilter, statusFilter})) {
            Set rawBasicIds = rawBasicOfFile.computeIfAbsent(object.getLong("taxfile.boid"), ky -> Sets.newHashSetWithExpectedSize((int)8));
            rawBasicIds.add(object.getLong("taxdatabasic.id"));
        }
        HashSet abandonTaxFileIds = Sets.newHashSetWithExpectedSize((int)dataBasics.length);
        for (DynamicObject dataBasic : dataBasics) {
            long fileBoId = dataBasic.getLong("taxfile.boid");
            Set rawBasicIds = (Set)rawBasicOfFile.get(fileBoId);
            if (CollectionUtils.isEmpty((Collection)rawBasicIds)) {
                abandonTaxFileIds.add(fileBoId);
                dataBasic.set("srcrefnum", (Object)"0");
                continue;
            }
            if (rawBasicIds.size() == 1) {
                dataBasic.set("srcrefnum", (Object)"1");
                continue;
            }
            dataBasic.set("srcrefnum", (Object)"2");
        }
        try (TXHandle required = TX.required();){
            basicServiceHelper.save(dataBasics);
            if (!CollectionUtils.isEmpty((Collection)abandonTaxFileIds)) {
                HRBaseServiceHelper rawDataBasicServiceHelper = new HRBaseServiceHelper("itc_taxrawdatabasic");
                QFilter taxFileFilter = new QFilter("taxfile.boid", "in", (Object)abandonTaxFileIds);
                Object[] query = rawDataBasicServiceHelper.query("id,status", new QFilter[]{taxFileFilter, yearMonthFilter, taskIdFilter, statusFilter});
                if (!ArrayUtils.isEmpty((Object[])query)) {
                    for (Object object : query) {
                        object.set("status", (Object)"E");
                    }
                }
                rawDataBasicServiceHelper.update((DynamicObject[])query);
            }
        }
        return BaseResult.success(null);
    }
}

