/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.listener;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.common.api.TaxTaskGuideOpBatchListener;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;

public class TaxFileStatusBatchListener
implements TaxTaskGuideOpBatchListener {
    public boolean match(DynamicObject taxTaskOpRecord) {
        String opType = taxTaskOpRecord.getString("optype");
        return TaxTaskGuideOpEnum.DECLARE.getCode().equals(opType);
    }

    public BaseResult<?> afterBatchOperation(BatchResult<DynamicObject> res, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskOpRecord, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo caseInfo) {
        TaxTaskGuideOpEnum opType = TaxTaskGuideOpEnum.of((String)taxTaskOpRecord.getString("optype"));
        if (opType == null) {
            return BaseResult.success(null);
        }
        switch (opType) {
            case DECLARE: {
                List data = res.successResult();
                List<Long> taxFileIds = data.stream().map(e1 -> e1.getLong("taxfile.id")).collect(Collectors.toList());
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxfile");
                QFilter idFilter = new QFilter("id", "in", (Object)taxFileIds.toArray(new Long[0]));
                DynamicObject[] query = serviceHelper.query("id,reportstatus", new QFilter[]{idFilter});
                Stream.of(query).forEach(e1 -> e1.set("reportstatus", (Object)"1"));
                serviceHelper.save(query);
                break;
            }
        }
        return BaseResult.success(null);
    }
}

