/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.listener;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sit.itc.common.api.TaxTaskGuideOpBatchListener;
import kd.sit.itc.common.api.TaxTaskGuideOpListener;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;

public class TaxTaskGuideOpListenerFactory {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskGuideOpListenerFactory.class);
    private static final List<TaxTaskGuideOpBatchListener> BATCH_LISTENERS = new ArrayList<TaxTaskGuideOpBatchListener>(10);
    private static final List<TaxTaskGuideOpListener> OP_LISTENERS = new ArrayList<TaxTaskGuideOpListener>(10);

    private TaxTaskGuideOpListenerFactory() {
    }

    public static BatchResult<?> afterBatchOperation(BatchResult<DynamicObject> data, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskOpRecord, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo caseInfo) {
        BatchResult result = new BatchResult(true, null);
        for (TaxTaskGuideOpBatchListener listener : BATCH_LISTENERS) {
            if (!listener.match(taxTaskOpRecord)) continue;
            try {
                BaseResult baseResult = listener.afterBatchOperation(data, srcDataMap, taxTaskOpRecord, taxTaskEntity, caseInfo);
                result.addBaseResult(baseResult);
            }
            catch (Exception e) {
                LOGGER.warn("Error occurs when TaxTaskGuideOpListenerFactory.afterDoOperation", (Throwable)e);
                result.addBaseResult(BaseResult.fail((String)e.getMessage()));
            }
        }
        return result;
    }

    public static BatchResult<?> afterOperation(BatchResult<?> data, DynamicObject taxTaskOpRecord, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo caseInfo) {
        BatchResult result = new BatchResult(true, null);
        for (TaxTaskGuideOpListener listener : OP_LISTENERS) {
            if (!listener.match(taxTaskOpRecord)) continue;
            try {
                BaseResult baseResult = listener.afterOperation(data, taxTaskOpRecord, taxTaskEntity, caseInfo);
                result.addBaseResult(baseResult);
            }
            catch (Exception e) {
                LOGGER.warn("Error occurs when TaxTaskGuideOpListenerFactory.afterDoOperation", (Throwable)e);
                result.addBaseResult(BaseResult.fail((String)e.getMessage()));
            }
        }
        return result;
    }

    static {
        ServiceLoader<TaxTaskGuideOpBatchListener> loadBatch = ServiceLoader.load(TaxTaskGuideOpBatchListener.class);
        Iterator<TaxTaskGuideOpBatchListener> iteratorBatch = loadBatch.iterator();
        while (iteratorBatch.hasNext()) {
            BATCH_LISTENERS.add(iteratorBatch.next());
        }
        ServiceLoader<TaxTaskGuideOpListener> loadOp = ServiceLoader.load(TaxTaskGuideOpListener.class);
        Iterator<TaxTaskGuideOpListener> iteratorOp = loadOp.iterator();
        while (iteratorOp.hasNext()) {
            OP_LISTENERS.add(iteratorOp.next());
        }
        BATCH_LISTENERS.sort(Comparator.comparingInt(TaxTaskGuideOpBatchListener::priority));
        OP_LISTENERS.sort(Comparator.comparingInt(TaxTaskGuideOpListener::priority));
    }
}

