/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.listener;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.common.api.TaxTaskGuideOpBatchListener;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;

public class TaxTaskStatusBatchListener
implements TaxTaskGuideOpBatchListener {
    public boolean match(DynamicObject taxTaskOpRecord) {
        String opType = taxTaskOpRecord.getString("optype");
        return TaxTaskGuideOpEnum.DECLARE.getCode().equals(opType) || TaxTaskGuideOpEnum.ROLLBACK_DECLARE.getCode().equals(opType);
    }

    public BaseResult<?> afterBatchOperation(BatchResult<DynamicObject> data, Map<Long, List<DynamicObject>> srcDataMap, DynamicObject taxTaskOpRecord, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo caseInfo) {
        TaxTaskGuideOpEnum opType = TaxTaskGuideOpEnum.of((String)taxTaskOpRecord.getString("optype"));
        List successResult = data.getSuccessResult();
        if (opType == null || CollectionUtils.isEmpty((Collection)successResult)) {
            return BaseResult.success(null);
        }
        DynamicObject dynamicObject = (DynamicObject)successResult.get(0);
        if (null == dynamicObject) {
            return BaseResult.success(null);
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxtask");
        QFilter idFilter = new QFilter("id", "in", (Object)taxTaskEntity.getId());
        DynamicObject[] query = serviceHelper.query("id, taxtaskunitentry.taxunit, taxtaskunitentry.declarestatus", new QFilter[]{idFilter});
        long taxUnitId = dynamicObject.getLong("taxfile.taxunit.id");
        switch (opType) {
            case DECLARE: {
                for (DynamicObject dy : query) {
                    DynamicObjectCollection taxtaskunitentry = dy.getDynamicObjectCollection("taxtaskunitentry");
                    for (DynamicObject entry : taxtaskunitentry) {
                        if (entry.getLong("taxunit.id") != taxUnitId) continue;
                        entry.set("declarestatus", (Object)"1");
                    }
                }
                serviceHelper.save(query);
                break;
            }
            case ROLLBACK_DECLARE: {
                for (DynamicObject dy : query) {
                    DynamicObjectCollection taxtaskunitentry = dy.getDynamicObjectCollection("taxtaskunitentry");
                    for (DynamicObject entry : taxtaskunitentry) {
                        if (entry.getLong("taxunit.id") != taxUnitId) continue;
                        entry.set("declarestatus", (Object)"0");
                    }
                }
                serviceHelper.save(query);
                break;
            }
        }
        return BaseResult.success(null);
    }
}

