/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.model;

import kd.bos.dataentity.utils.StringUtils;
import kd.sit.sitbp.common.model.SITI18NParam;

public enum SrcStatus {
    PUSHED("0", new SITI18NParam("\u5df2\u63a8\u9001", "SrcStatus_0", "sit-itc-common")),
    RECEIVED("10", new SITI18NParam("\u5df2\u83b7\u53d6", "SrcStatus_10", "sit-itc-common")),
    AUDITED("20", new SITI18NParam("\u5df2\u5ba1\u6838", "SrcStatus_20", "sit-itc-common")),
    PAYED("90", new SITI18NParam("\u5df2\u53d1\u653e", "SrcStatus_10", "sit-itc-common"));

    private String code;
    private SITI18NParam i18nParam;

    private SrcStatus(String code, SITI18NParam i18nParam) {
        this.code = code;
        this.i18nParam = i18nParam;
    }

    public String getCode() {
        return this.code;
    }

    public SITI18NParam getI18nParam() {
        return this.i18nParam;
    }

    public String getI18nParamString() {
        return this.i18nParam.loadKDString();
    }

    public static String getI18nNameByCode(String code) {
        for (SrcStatus statusEnum : SrcStatus.values()) {
            if (!statusEnum.code.equals(code)) continue;
            return statusEnum.i18nParam.loadKDString();
        }
        return code;
    }

    public boolean isLessThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        return this.getCode().compareTo(code) < 0;
    }

    public boolean isLessEqThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return false;
        }
        return this.getCode().compareTo(code) <= 0;
    }

    public boolean isGreaterThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return true;
        }
        return this.getCode().compareTo(code) > 0;
    }

    public boolean isGreaterEqThan(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return true;
        }
        return this.getCode().compareTo(code) >= 0;
    }
}

