/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;

public class TaxTaskGuideCacheData
implements Serializable {
    private static final long serialVersionUID = -7330500981420408012L;
    public static final String GLOBAL_KEY_SRC_DATA_TO_BE_REFER = "srcDataToBeRefer";
    public static final String GLOBAL_KEY_DATA_REFERRED = "dataReferred";
    public static final String GLOBAL_KEY_SRC_DATA_REFERRED = "srcDataReferred";
    public static final String GLOBAL_KEY_DATA_SRC = "taxDataSrc";
    public static final String GLOBAL_KEY_RESULT = "result";
    private TaxTaskEntity taxTaskEntity;
    private TaxTaskGuideStepCaseInfo stepCaseInfo;
    private String opName;
    private List<Long> srcDataIds;
    private List<Long> taxDataIds;
    private boolean toContinue;
    private String fatalMsg;
    private Map<Integer, List<Long>> statusIdMap;
    private Map<Long, String> idMsgMap;
    private List<DynamicObject> dataList;

    public TaxTaskGuideCacheData() {
    }

    public TaxTaskGuideCacheData(BatchResult result, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        this();
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.toContinue = result.isContinue();
        this.fatalMsg = result.getMessage();
        this.opName = opEnum.getCode();
    }

    public static TaxTaskGuideCacheData from(BatchResult<DynamicObject> result, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        List ids;
        TaxTaskGuideCacheData res = new TaxTaskGuideCacheData(result, taxTaskEntity, stepCaseInfo, opEnum);
        res.statusIdMap = new HashMap<Integer, List<Long>>(8);
        List successResult = result.getSuccessResult();
        List failResult = result.getFailResultOriginal();
        res.idMsgMap = new HashMap<Long, String>(failResult.size());
        ArrayList<Long> dataIds = new ArrayList<Long>(successResult.size());
        for (DynamicObject obj : successResult) {
            ids = res.statusIdMap.computeIfAbsent(ResultStatusEnum.INFO.getCode(), key -> new ArrayList(successResult.size()));
            long id = obj.getLong("id");
            ids.add(id);
            dataIds.add(id);
        }
        for (DynamicObject obj : failResult) {
            ids = res.statusIdMap.computeIfAbsent(obj.getStatus(), key -> new ArrayList(failResult.size()));
            DynamicObject data = (DynamicObject)obj.getData();
            long id = data.getLong("id");
            ids.add(id);
            if (opEnum == TaxTaskGuideOpEnum.FEEDBACK || opEnum == TaxTaskGuideOpEnum.ROLLBACK_FEEDBACK) {
                res.idMsgMap.put(id, obj.getMessage());
            } else {
                res.idMsgMap.put(id, opEnum.resultLoadKDString(obj.getMessage(), new Object[]{data.get("taxfile.number"), data.get("taxfile.person.name")}));
            }
            dataIds.add(id);
        }
        if (!dataIds.isEmpty()) {
            DynamicObject obj;
            DynamicObject dynamicObject = obj = CollectionUtils.isEmpty((Collection)successResult) ? (DynamicObject)((ResultItem)failResult.get(0)).getData() : (DynamicObject)successResult.get(0);
            if (obj.getDataEntityType().getName().equals("itc_taxrawdata")) {
                res.srcDataIds = dataIds;
            } else {
                res.taxDataIds = dataIds;
            }
        }
        return res;
    }

    public static TaxTaskGuideCacheData fromV1(BatchResult<Long> result, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        TaxTaskGuideCacheData res = new TaxTaskGuideCacheData(result, taxTaskEntity, stepCaseInfo, opEnum);
        res.statusIdMap = new HashMap<Integer, List<Long>>(8);
        if (opEnum == TaxTaskGuideOpEnum.REFER_SPECIAL_SRC_DATA || opEnum == TaxTaskGuideOpEnum.REFER_ALL_SRC_DATA) {
            res.srcDataIds = result.successResult();
        } else {
            res.taxDataIds = result.successResult();
        }
        List failResult = result.getFailResultOriginal();
        for (ResultItem obj : failResult) {
            List ids = res.statusIdMap.computeIfAbsent(obj.getStatus(), key -> new ArrayList(failResult.size()));
            ids.add(obj.getData());
            res.idMsgMap.put((Long)obj.getData(), obj.getMessage());
        }
        return res;
    }

    public TaxTaskGuideCacheData ofOpName(TaxTaskGuideOpEnum opName) {
        this.opName = opName.getCode();
        return this;
    }

    public boolean isToContinue() {
        return this.toContinue;
    }

    public void setToContinue(boolean toContinue) {
        this.toContinue = toContinue;
    }

    public String getFatalMsg() {
        return this.fatalMsg;
    }

    public void setFatalMsg(String fatalMsg) {
        this.fatalMsg = fatalMsg;
    }

    public String getOpName() {
        return this.opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public List<Long> getSrcDataIds() {
        return this.srcDataIds;
    }

    public void setSrcDataIds(List<Long> srcDataIds) {
        this.srcDataIds = srcDataIds;
    }

    public TaxTaskGuideStepCaseInfo getStepCaseInfo() {
        return this.stepCaseInfo;
    }

    public void setStepCaseInfo(TaxTaskGuideStepCaseInfo stepCaseInfo) {
        this.stepCaseInfo = stepCaseInfo;
    }

    public TaxTaskEntity getTaxTaskEntity() {
        return this.taxTaskEntity;
    }

    public void setTaxTaskEntity(TaxTaskEntity taxTaskEntity) {
        this.taxTaskEntity = taxTaskEntity;
    }

    public Map<Integer, List<Long>> getStatusIdMap() {
        return this.statusIdMap;
    }

    public void setStatusIdMap(Map<Integer, List<Long>> statusIdMap) {
        this.statusIdMap = statusIdMap;
    }

    public Map<Long, String> getIdMsgMap() {
        return this.idMsgMap;
    }

    public void setIdMsgMap(Map<Long, String> idMsgMap) {
        this.idMsgMap = idMsgMap;
    }

    public List<Long> getTaxDataIds() {
        return this.taxDataIds;
    }

    public void setTaxDataIds(List<Long> taxDataIds) {
        this.taxDataIds = taxDataIds;
    }

    public List<DynamicObject> getDataList() {
        return this.dataList;
    }

    public void setDataList(List<DynamicObject> dataList) {
        this.dataList = dataList;
    }
}

