/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.property.ComboProp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.sit.itc.business.taxfile.imports.TaxExportHelper;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.model.page.PageMultiThreadTask;

public abstract class AbstractTaxPersonDeclareAndReportExport
extends PageMultiThreadTask<Map<String, Object>> {
    protected static final Map<String, String> Entity_Id_Map = ImmutableMap.builder().put((Object)"empposorgrel", (Object)"empposorgrel").put((Object)"percre", (Object)"percre").put((Object)"pernontsprop", (Object)"pernontsprop").put((Object)"pertsprop", (Object)"pertsprop").put((Object)"pereduexp", (Object)"pereduexp").put((Object)"itc_bankcard", (Object)"bankcard").build();
    protected static final Map<String, String> Entity_Map = ImmutableMap.builder().put((Object)"empposorgrel", (Object)"hrpi_empposorgrel").put((Object)"percre", (Object)"hrpi_percre").put((Object)"pernontsprop", (Object)"hrpi_pernontsprop").put((Object)"pertsprop", (Object)"hrpi_pertsprop").put((Object)"pereduexp", (Object)"hrpi_pereduexp").put((Object)"bankcard", (Object)"itc_bankcard").build();
    protected static final ExecutorService Handle_Pool = ThreadPools.newExecutorService((String)"exportQueryThreadPool", (int)8);

    protected void initQueryStrMapAndNewFieldNameToOldNameMap(Map<String, List<String>> queryStrMap, Map<String, Map<String, String>> newFieldNameToOldNameMap, String[] oldFieldNames) {
        if (ArrayUtils.isEmpty((Object[])oldFieldNames)) {
            return;
        }
        for (String oldFieldName : oldFieldNames) {
            if (Strings.isNullOrEmpty((String)oldFieldName)) continue;
            boolean match = false;
            for (Map.Entry<String, String> entry : Entity_Id_Map.entrySet()) {
                String entityId = entry.getKey();
                if (!oldFieldName.startsWith(entityId)) continue;
                List newFieldNameList = queryStrMap.computeIfAbsent(Entity_Id_Map.get(entityId), k1 -> Lists.newArrayListWithExpectedSize((int)50));
                String newFieldName = oldFieldName.substring(entityId.length() + 1);
                newFieldNameList.add(newFieldName);
                String entryKey = entry.getValue();
                Map newFieldNameToOldNameMapMap = newFieldNameToOldNameMap.computeIfAbsent(entryKey, k1 -> Maps.newHashMapWithExpectedSize((int)50));
                newFieldNameToOldNameMapMap.put(newFieldName, oldFieldName);
                match = true;
                break;
            }
            if (match) continue;
            queryStrMap.get("taxdatabasic").add(oldFieldName);
        }
    }

    protected void initEntityQueryIdMapAndIdsRelateMap(Map<String, List<String>> queryStrMap, Map<String, List<Long>> entityQueryIdMap, Map<String, Map<Long, Long>> idsRelateMap, int totalNum) {
        for (String str : queryStrMap.keySet()) {
            entityQueryIdMap.put(str, Lists.newArrayListWithExpectedSize((int)totalNum));
        }
        for (String str : queryStrMap.keySet()) {
            idsRelateMap.put(str, Maps.newHashMapWithExpectedSize((int)totalNum));
        }
        entityQueryIdMap.remove("taxdatabasic");
        idsRelateMap.remove("taxdatabasic");
    }

    protected DataSet queryTaxDataBasicData(Map<String, List<String>> queryStrMap, QFilter[] qFilters, String orderBys) {
        List<String> taxDataBasicFieldList = queryStrMap.get("taxdatabasic");
        for (String entityKey : Entity_Map.keySet()) {
            taxDataBasicFieldList.add(entityKey + ".id");
        }
        ArrayList queryFieldList = Lists.newArrayList(taxDataBasicFieldList);
        this.resolveOrderBy(queryFieldList, orderBys);
        String queryFields = String.join((CharSequence)",", queryFieldList);
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"itc_taxdatabasic", (String)queryFields, (QFilter[])qFilters, (String)orderBys);
    }

    protected void resolveOrderBy(List<String> taxDataBasicFieldList, String orderBys) {
    }

    protected void initEntityQueryIdMapAndIdsRelateMapAndTaxFileIdToDataMap(DataSet dataSet, List<String> taxDataBasicFieldList, Map<String, List<Long>> entityQueryIdMap, Map<String, Map<Long, Long>> idsRelateMap, Map<String, DynamicProperty> dynamicPropertyMap, Map<Long, Object> taxFileIdToDataMap) {
        for (Row row : dataSet) {
            ConcurrentMap dataMap = Maps.newConcurrentMap();
            Long taxFileId = row.getLong("taxfile.id");
            for (String fieldName : taxDataBasicFieldList) {
                Object value;
                if (StringUtils.isEmpty((Object)fieldName)) continue;
                boolean match = false;
                for (String entityIdValue : Entity_Id_Map.values()) {
                    if (!fieldName.startsWith(entityIdValue)) continue;
                    List<Long> entityIds = entityQueryIdMap.get(entityIdValue);
                    Map<Long, Long> entityIdRelateMap = idsRelateMap.get(entityIdValue);
                    if (null == entityIds || null == entityIdRelateMap) break;
                    entityIds.add(row.getLong(fieldName));
                    entityIdRelateMap.put(row.getLong(fieldName), taxFileId);
                    match = true;
                    break;
                }
                if (match) continue;
                DynamicProperty dynProperty = dynamicPropertyMap.get(fieldName);
                if (dynProperty instanceof ComboProp && Objects.nonNull(row.get(fieldName))) {
                    dataMap.put(fieldName + "_v", row.get(fieldName));
                }
                if (!Objects.nonNull(value = TaxExportHelper.parseValue(row, fieldName, dynProperty))) continue;
                dataMap.put(fieldName, value);
            }
            taxFileIdToDataMap.put(taxFileId, dataMap);
        }
    }

    protected CompletableFuture<?>[] queryEntitiesData(Map<String, List<Long>> entityQueryIdMap, Map<String, List<String>> queryStrMap, Map<String, Map<Long, Long>> idsRelateMap, Map<String, Map<String, String>> newFieldNameToOldNameMap, Map<String, DynamicProperty> dynamicPropertyMap, Map<Long, Object> taxFileIdToDataMap) {
        return (CompletableFuture[])entityQueryIdMap.entrySet().stream().map(entry -> CompletableFuture.runAsync(() -> {
            String entityKey = (String)entry.getKey();
            String entityKeyWithAppId = Entity_Map.get(entityKey);
            List queryIds = (List)entry.getValue();
            List queryFieldList = (List)queryStrMap.get(entityKey);
            String allQueryFields = String.join((CharSequence)",", queryFieldList);
            QFilter qFilter = new QFilter("id", "in", (Object)queryIds);
            DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityKeyWithAppId, (String)(allQueryFields + ",id"), (QFilter[])new QFilter[]{qFilter}, null);
            for (Row row : resultDataSet) {
                Long id = row.getLong("id");
                Long taxFileId = (Long)((Map)idsRelateMap.get(entityKey)).get(id);
                for (String fieldName : queryFieldList) {
                    if (StringUtils.isEmpty((Object)fieldName) || "id".equals(fieldName)) continue;
                    Map newFieldNameToOldNameMapMap = (Map)newFieldNameToOldNameMap.get(entityKey);
                    String oldFieldName = (String)newFieldNameToOldNameMapMap.get(fieldName);
                    DynamicProperty dynProperty = (DynamicProperty)dynamicPropertyMap.get(oldFieldName);
                    Object value = TaxExportHelper.parseValue(row, fieldName, dynProperty);
                    Map dataMap = (Map)taxFileIdToDataMap.get(taxFileId);
                    if (!Objects.nonNull(value)) continue;
                    dataMap.put(oldFieldName, value);
                }
            }
            resultDataSet.close();
        }, Handle_Pool)).toArray(CompletableFuture[]::new);
    }

    protected BatchResult<Map<String, Object>> transferResult(BatchResult<Map<String, Object>> finalResult) {
        if (finalResult == null) {
            return null;
        }
        List successResult = finalResult.getSuccessResult();
        ArrayList newSuccessResult = null;
        if (!CollectionUtils.isEmpty((Collection)successResult)) {
            newSuccessResult = new ArrayList(successResult.size());
            for (Map successMap : successResult) {
                HashMap newSuccessMap = new HashMap(1);
                newSuccessMap.put("id", successMap.get("id"));
                newSuccessResult.add(newSuccessMap);
            }
        }
        BatchResult newFinalResult = new BatchResult(finalResult.isSuccess(), newSuccessResult);
        newFinalResult.setMessage(finalResult.getMessage());
        List failResultOriginal = finalResult.getFailResultOriginal();
        if (!CollectionUtils.isEmpty((Collection)failResultOriginal)) {
            for (ResultItem resultItem : failResultOriginal) {
                Map data = (Map)resultItem.getData();
                LinkedHashMap newData = Maps.newLinkedHashMapWithExpectedSize((int)1);
                newData.put("id", data.get("id"));
                newFinalResult.addFailItem((Object)newData, resultItem.getMessage(), resultItem.getStatus());
            }
        }
        return newFinalResult;
    }
}

