/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtask.InitTaxDataBasicHelper;
import kd.sit.itc.business.taxtask.PreTaxDataBasicUnit;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class InitTaxDataBasicTask
extends AssignMultiThreadTask<PreTaxDataBasicUnit> {
    private static final Log LOGGER = LogFactory.getLog(InitTaxDataBasicTask.class);
    private final TaxTaskEntity taxTaskEntity;
    private final IFormView view;

    public InitTaxDataBasicTask(TaxTaskEntity taxTaskEntity, IFormView view) {
        this.taxTaskEntity = taxTaskEntity;
        this.view = view;
    }

    protected List<PreTaxDataBasicUnit> queryData(String key, List<?> ids) {
        LOGGER.info("InitTaxDataBasicTask begin queryData in TaxTask={}", (Object)this.taxTaskEntity.getId());
        List<Long> taxFileFidList = ids;
        LOGGER.info("InitTaxDataBasicTask  queryData in taxFileFidList={}", (Object)taxFileFidList.toString());
        Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap = InitTaxDataBasicHelper.getPreTaxDataBasicUnitMap(taxFileFidList);
        return Lists.newArrayList(preTaxDataBasicUnitMap.values());
    }

    protected BatchResult<PreTaxDataBasicUnit> handleData(DataBatch<PreTaxDataBasicUnit> dataBatch) {
        LOGGER.info("InitTaxDataBasicTask begin handleData in TaxTask={}", (Object)this.taxTaskEntity.getId());
        HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        List preTaxDataBasicUnits = dataBatch.getDataList();
        List<DynamicObject> newTaxDataBasic = InitTaxDataBasicHelper.createNewTaxDataBasic(this.taxTaskEntity, preTaxDataBasicUnits, null);
        taxDataBasicHelper.save(newTaxDataBasic.toArray(new DynamicObject[0]));
        LOGGER.info("InitTaxDataBasicTask end handleData in result.size = {}", (Object)newTaxDataBasic.size());
        return new BatchResult(true, preTaxDataBasicUnits);
    }

    protected BaseResult<PreTaxDataBasicUnit> afterHandleDataBatch(int status) {
        LOGGER.info("InitTaxDataBasicTask begin afterHandleDataBatch in TaxTask={}", (Object)this.taxTaskEntity.getId());
        HRBaseServiceHelper taskHelper = new HRBaseServiceHelper("itc_taxtask");
        if (this.finalResult.isSuccess()) {
            DynamicObject taxTaskDy = taskHelper.queryOne("id,taskstatus", new QFilter("id", "=", (Object)this.taxTaskEntity.getId()));
            taxTaskDy.set("taskstatus", (Object)TaxTaskStatusEnum.INIT_FINISH.getCode());
            taskHelper.updateOne(taxTaskDy);
        }
        LOGGER.info("InitTaxDataBasicTask end afterHandleDataBatch in TaxTask={}", (Object)this.taxTaskEntity.getId());
        return super.afterHandleDataBatch(status);
    }

    protected ProcessHandler openProcessHandler() {
        if (Objects.isNull(this.view)) {
            return ProcessHandler.DEFAULT;
        }
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458", (String)"InitTaxDataBasicTask_0", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458\u8fdb\u5ea6\u6761", (String)"InitTaxDataBasicTask_1", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "refresh");
        return result;
    }
}

