/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxtaskguide.imports.TaxTaskGuideImportDBServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.common.enums.SrcRefNumEnums;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.Pair;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class RollbackImportSADTask
extends AssignMultiThreadTask<Pair<DynamicObject, DynamicObject>> {
    private final IFormView view;
    private final TaxTaskEntity taxTaskEntity;
    private final TaxTaskGuideOpEnum opEnum;
    private TaxTaskGuideStepCaseInfo stepCaseInfo;

    public RollbackImportSADTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.opEnum = opEnum;
    }

    protected List<Pair<DynamicObject, DynamicObject>> queryData(String key, List<?> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        QFilter idFilter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{idFilter};
        List<DynamicObject> taxDataBasicDatas = TaxTaskGuideImportDBServiceHelper.loadTaxBasicData(filters);
        QFilter taxBasicFilter = new QFilter("taxdatabasic", "in", ids);
        QFilter[] taxBasicFilters = new QFilter[]{taxBasicFilter};
        HashMap taxDeductMap = Maps.newHashMapWithExpectedSize((int)taxDataBasicDatas.size());
        List<DynamicObject> deductDates = TaxTaskGuideImportDBServiceHelper.loadTaxDeductData(taxBasicFilters);
        deductDates.forEach(e1 -> taxDeductMap.put(e1.getLong("taxdatabasic.id"), e1));
        ArrayList<Pair<DynamicObject, DynamicObject>> result = new ArrayList<Pair<DynamicObject, DynamicObject>>(taxDataBasicDatas.size());
        for (DynamicObject dy : taxDataBasicDatas) {
            DynamicObject dynamicObject = (DynamicObject)taxDeductMap.get(dy.getLong("id"));
            Pair pair = new Pair((Object)dy, (Object)dynamicObject);
            result.add((Pair<DynamicObject, DynamicObject>)pair);
        }
        return result;
    }

    protected BatchResult<Pair<DynamicObject, DynamicObject>> handleData(DataBatch<Pair<DynamicObject, DynamicObject>> dataBatch) {
        List dataList = dataBatch.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new BatchResult(true, dataList);
        }
        BatchResult result = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size()));
        ArrayList<DynamicObject> taxDataBasicList = new ArrayList<DynamicObject>(dataList.size());
        ArrayList<DynamicObject> deductList = new ArrayList<DynamicObject>(dataList.size());
        for (Object pair : dataList) {
            String msg;
            DynamicObject basic = (DynamicObject)pair.getKey();
            if (!YesOrNoEnum.YES.getCode().equals(basic.getString("bizstatus"))) {
                msg = ResManager.loadKDString((String)"{0}{1}\uff1a\u672a\u5bfc\u5165\u4e13\u6263\u6570\u636e\uff0c\u65e0\u9700\u6e05\u9664\u3002", (String)"RollbackImportSADTask_4", (String)"sit-itc-business", (Object[])new Object[]{basic.getString("taxfile.number"), basic.getString("taxfile.person.name")});
                result.addFailItem(pair, msg);
                continue;
            }
            msg = ResManager.loadKDString((String)"{0}{1}\uff1a\u6570\u636e\u51c6\u5907\u5b8c\u6210\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u6e05\u9664\u3002", (String)"RollbackImportSADTask_2", (String)"sit-itc-business", (Object[])new Object[]{basic.getString("taxfile.number"), basic.getString("taxfile.person.name")});
            if (YesOrNoEnum.YES.getCode().equals(basic.getString("preparestatus"))) {
                result.addFailItem(pair, msg);
                continue;
            }
            if (!SrcRefNumEnums.NO_REF.getCode().equals(basic.getString("srcrefnum"))) {
                String calStatusErrMsg = ResManager.loadKDString((String)"{0}{1}\uff1a\u5df2\u5bfc\u5165\u7b97\u85aa\u6570\u636e\uff0c\u65e0\u6cd5\u6e05\u9664\u6570\u636e\u3002", (String)"RollbackImportSADTask_3", (String)"sit-itc-business", (Object[])new Object[]{basic.getString("taxfile.number"), basic.getString("taxfile.person.name")});
                result.addFailItem(pair, calStatusErrMsg);
                continue;
            }
            result.addSuccessResult(pair);
        }
        List successResult = result.getSuccessResult();
        if (CollectionUtils.isEmpty((Collection)successResult)) {
            return result;
        }
        for (Pair pair : successResult) {
            DynamicObject deductDy = (DynamicObject)pair.getValue();
            if (null == deductDy) continue;
            deductList.add(deductDy);
            taxDataBasicList.add((DynamicObject)pair.getKey());
        }
        BatchResult deductResult = new BatchResult(true, deductList);
        TaxTaskGuideImportDBServiceHelper.saveTaxDeduct((BatchResult<DynamicObject>)deductResult, taxDataBasicList, this.taxTaskEntity, this.stepCaseInfo, this.opEnum, true, new CustomFunction[0]);
        if (deductResult.isSuccess()) {
            return result;
        }
        HashMap map = new HashMap(taxDataBasicList.size());
        taxDataBasicList.forEach(e1 -> map.put(e1.getLong("id"), e1));
        List failResult = deductResult.getFailResult();
        for (DynamicObject failDy : failResult) {
            DynamicObject dynamicObject = (DynamicObject)map.get(failDy.getLong("taxdatabasic.id"));
            Pair pair = new Pair((Object)failDy, (Object)dynamicObject);
            result.addFailItem((Object)pair, deductResult.getMessage());
        }
        return result;
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u6e05\u9664\u4e13\u9879\u9644\u52a0\u6263\u9664\u6570\u636e", (String)"RollbackImportSADTask_0", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u6e05\u9664\u8fdb\u5ea6", (String)"RollbackImportSADTask_1", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected BaseResult<Pair<DynamicObject, DynamicObject>> afterHandleDataBatch(int status) {
        TaxTaskGuideCacheData from = new TaxTaskGuideCacheData(this.finalResult, this.taxTaskEntity, this.stepCaseInfo, this.opEnum);
        List failItemList = this.finalResult.getFailResultOriginal();
        HashMap<Long, String> idMsgMap = new HashMap<Long, String>(failItemList.size());
        HashMap<Integer, List<Long>> statusIdMap = new HashMap<Integer, List<Long>>(8);
        for (ResultItem item : failItemList) {
            long id = ((DynamicObject)((Pair)item.getData()).getKey()).getLong("id");
            idMsgMap.put(id, item.getMessage());
            int errorCode = item.getStatus();
            List ids = statusIdMap.computeIfAbsent(errorCode, key -> new ArrayList());
            ids.add(id);
        }
        List successResult = this.finalResult.getSuccessResult();
        List ids = statusIdMap.computeIfAbsent(ResultStatusEnum.INFO.getCode(), key -> new ArrayList());
        successResult.forEach(e1 -> ids.add(((DynamicObject)e1.getKey()).getLong("id")));
        from.setIdMsgMap(idMsgMap);
        from.setStatusIdMap(statusIdMap);
        PageCache pageCache = new PageCache(this.view.getPageId());
        pageCache.put("dataOfPrevRequest", SerializationUtils.toJsonString((Object)from));
        return super.afterHandleDataBatch(status);
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "afterProcessClose");
        return result;
    }
}

