/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.SrcStatus;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRollbackLockTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.KeyGenerator;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.api.StatusInfo;
import kd.sit.sitbp.common.entity.TaxCategoryEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.DeclareResultEnum;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.model.TaxDataSrcGroup;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class TaskGuideDeclareTask
extends AssignMultiThreadTask<TaxDataSrcGroup<Long, DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(TaskGuideRollbackLockTask.class);
    private final IFormView view;
    private final TaxTaskEntity taxTaskEntity;
    private final TaxTaskGuideStepCaseInfo stepCaseInfo;
    private final TaxTaskGuideOpEnum opEnum;
    private final long taxUnitId;

    public TaskGuideDeclareTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, long taxUnitId) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.opEnum = opEnum;
        this.taxUnitId = taxUnitId;
        LOGGER.debug("handle {}", (Object)taxUnitId);
    }

    protected List<TaxDataSrcGroup<Long, DynamicObject>> queryData(String key, List<?> ids) {
        DynamicObject[] taxSrcDataArr;
        GlobalParam.remove();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("id", "in", ids));
        qFilters.add(new QFilter("yearmonth", "=", (Object)this.taxTaskEntity.yearMonth()));
        List<DynamicObject> taxDataList = this.loadTaxData(qFilters);
        HashMap dataSrcGroupMap = new HashMap(taxDataList.size());
        taxDataList.forEach(e1 -> dataSrcGroupMap.put(e1.getLong("id"), new TaxDataSrcGroup(e1, KeyGenerator.DYNAMIC_OBJ_GENERATOR)));
        qFilters.clear();
        qFilters.add(new QFilter("taxdata", "in", ids));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, this.taxTaskEntity, new Arrays[0]);
        for (DynamicObject srcData : taxSrcDataArr = this.loadSrcTaxData(qFilters)) {
            TaxDataSrcGroup taxDataSrcGroup = (TaxDataSrcGroup)dataSrcGroupMap.get(srcData.getLong("taxdata"));
            if (taxDataSrcGroup == null) continue;
            taxDataSrcGroup.addTaxSrcData((Object)srcData);
        }
        return Lists.newArrayList(dataSrcGroupMap.values());
    }

    protected BatchResult<TaxDataSrcGroup<Long, DynamicObject>> handleData(DataBatch<TaxDataSrcGroup<Long, DynamicObject>> dataBatch) {
        List dataList = dataBatch.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new BatchResult(true, dataList);
        }
        BatchResult result = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size()));
        for (TaxDataSrcGroup group : dataList) {
            DynamicObject taxData = (DynamicObject)group.getTaxData();
            String taxDataBizStatus = taxData.getString("bizstatus");
            long taxCategoryId = taxData.getLong("taxcategory.id");
            TaxCategoryEntity taxCategory = this.taxTaskEntity.getTaxCategory(Long.valueOf(taxCategoryId));
            if (!TaxDataBizStatusEnum.DECLARE.isGreaterThan(taxDataBizStatus)) {
                result.addFailItem((Object)group, (StatusInfo)DeclareResultEnum.END_FAIL, new Object[]{taxData.getString("taxfile.number"), taxData.getString("taxfile.person.name"), taxCategory.getIncomeItemLocaleString(), TaxDataBizStatusEnum.getI18nNameByCode((String)taxDataBizStatus)});
                continue;
            }
            if (TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(this.taxTaskEntity.getTaxTaskType()) && TaxDataBizStatusEnum.FEEDBACK.isGreaterThan(taxDataBizStatus)) {
                result.addFailItem((Object)group, (StatusInfo)DeclareResultEnum.NOT_IMPORT_FAIL, new Object[]{taxData.getString("taxfile.number"), taxData.getString("taxfile.person.name"), taxCategory.getIncomeItemLocaleString(), TaxDataBizStatusEnum.getI18nNameByCode((String)taxDataBizStatus)});
                continue;
            }
            if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(this.taxTaskEntity.getTaxTaskType()) && !TaxDataBizStatusEnum.FEEDBACK.getCode().equals(taxDataBizStatus)) {
                result.addFailItem((Object)group, (StatusInfo)DeclareResultEnum.NOT_PUSH_SALARY_FAIL, new Object[]{taxData.getString("taxfile.number"), taxData.getString("taxfile.person.name"), taxCategory.getIncomeItemLocaleString(), TaxDataBizStatusEnum.getI18nNameByCode((String)taxDataBizStatus)});
                continue;
            }
            result.addSuccessResult((Object)group);
        }
        List successResult = result.getSuccessResult();
        if (CollectionUtils.isEmpty((Collection)successResult) || successResult.size() != dataList.size()) {
            return result;
        }
        BatchResult result1 = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size()));
        for (TaxDataSrcGroup group : dataList) {
            Map srcDataMap = group.getSrcDataMap();
            DynamicObject taxData = (DynamicObject)group.getTaxData();
            String taxDataBizStatus = taxData.getString("bizstatus");
            boolean flag = false;
            for (Map.Entry entry : srcDataMap.entrySet()) {
                DynamicObject srcData = (DynamicObject)entry.getValue();
                String srcDataStatus = srcData.getString("taxdatabasic.srcstatus");
                long taxCategoryId = taxData.getLong("taxcategory.id");
                TaxCategoryEntity taxCategory = this.taxTaskEntity.getTaxCategory(Long.valueOf(taxCategoryId));
                if (!StringUtils.isEmpty((Object)srcDataStatus) && SrcStatus.RECEIVED.isLessEqThan(srcDataStatus)) continue;
                result1.addFailItem((Object)group, (StatusInfo)DeclareResultEnum.SALARY_OBTAIN_FAIL, new Object[]{taxData.getString("taxfile.number"), taxData.getString("taxfile.person.name"), taxCategory.getIncomeItemLocaleString(), TaxDataBizStatusEnum.getI18nNameByCode((String)taxDataBizStatus)});
                flag = true;
                break;
            }
            if (flag) continue;
            result1.addSuccessResult((Object)group);
        }
        List successResult1 = result1.getSuccessResult();
        if (CollectionUtils.isEmpty((Collection)successResult1) || successResult1.size() != dataList.size()) {
            return result1;
        }
        List taxDataDys = successResult.stream().map(e1 -> (DynamicObject)e1.getTaxData()).collect(Collectors.toList());
        BatchResult declareTaxDataDys = new BatchResult(true, taxDataDys);
        BatchResult<DynamicObject> resultAfterOp = TaxDataServiceHelper.saveTaxData((BatchResult<DynamicObject>)declareTaxDataDys, this.taxTaskEntity, this.stepCaseInfo, TaxTaskGuideOpEnum.DECLARE, true, new CustomFunction[0]);
        if (!resultAfterOp.isSuccess()) {
            result.addFailResult(result.getSuccessResult(), result.getMessage(), ResultStatusEnum.ERROR.getCode());
        }
        TaxTaskGuideServiceHelper.repackageResult((BatchResult<TaxDataSrcGroup<Long, DynamicObject>>)result, resultAfterOp);
        return result;
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u6807\u8bb0\u7533\u62a5", (String)"TaskGuideDeclareTask_0", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u6807\u8bb0\u7533\u62a5\u8fdb\u5ea6\u6761", (String)"TaskGuideDeclareTask_1", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected BaseResult<TaxDataSrcGroup<Long, DynamicObject>> afterHandleDataBatch(int status) {
        TaxTaskGuideCacheData from = new TaxTaskGuideCacheData(this.finalResult, this.taxTaskEntity, this.stepCaseInfo, this.opEnum);
        List failItemList = this.finalResult.getFailResultOriginal();
        HashMap<Long, String> idMsgMap = new HashMap<Long, String>(failItemList.size());
        HashMap<Integer, List<Long>> statusIdMap = new HashMap<Integer, List<Long>>(8);
        for (ResultItem item : failItemList) {
            long id = ((DynamicObject)((TaxDataSrcGroup)item.getData()).getTaxData()).getLong("id");
            idMsgMap.put(id, item.getMessage());
            int errorCode = item.getStatus();
            List ids = statusIdMap.computeIfAbsent(errorCode, key -> new ArrayList());
            ids.add(id);
        }
        List successResult = this.finalResult.getSuccessResult();
        List ids = statusIdMap.computeIfAbsent(ResultStatusEnum.INFO.getCode(), key -> new ArrayList());
        successResult.forEach(e1 -> ids.add(((DynamicObject)e1.getTaxData()).getLong("id")));
        from.setIdMsgMap(idMsgMap);
        from.setStatusIdMap(statusIdMap);
        PageCache pageCache = new PageCache(this.view.getPageId());
        pageCache.put("dataOfPrevRequest", SerializationUtils.toJsonString((Object)from));
        return super.afterHandleDataBatch(status);
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "afterProcessClose");
        return result;
    }

    private List<DynamicObject> loadTaxData(List<QFilter> qFilters) {
        String prop = "bizstatus,taxcategory,taxfile,yearmonth,taxunit,status,reportoprecord,feedbackoprecord,refoprecord,exportoprecord,lockoprecord,importoprecord,confirmoprecord,endoprecord";
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
        DynamicObject[] taxDataArr = dataServiceHelper.query(prop, qFilters.toArray(new QFilter[0]));
        return new ArrayList<DynamicObject>(Arrays.asList(taxDataArr));
    }

    private DynamicObject[] loadSrcTaxData(List<QFilter> qFilters) {
        String prop = "yearmonth,taxdata,taxdatabasic,yearmonth,bizstatus,taxfile,taxunit,reportoprecord,feedbackoprecord,refoprecord,exportoprecord,lockoprecord,importoprecord,confirmoprecord,endoprecord";
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxrawdata");
        return dataServiceHelper.query(prop, qFilters.toArray(new QFilter[0]));
    }
}

