/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.common.model.TaxDataItemWrapper;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.model.page.PageMultiThreadTask;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.poi.ss.usermodel.Workbook;

public class TaskGuideDifferenceReportDownLoadTask
extends PageMultiThreadTask<Map<String, Object>> {
    private final IFormView view;
    private final BillList billList;
    private final TaxTaskEntity taxTaskEntity;
    private final TaxTaskGuideStepCaseInfo stepCaseInfo;
    private WorkbookInfo workbookInfo;
    private ExportResult exportResult;
    private Map<String, Map<String, String>> combMapMap;
    private Object exportLogId;
    private List<Object> ids;
    private List<QFilter> filters;
    private List<String> props;
    private Map<String, IDataEntityProperty> desensitizeMap;
    private String queryProps;
    private String orderBy;
    private boolean containRawData = true;
    private final AtomicInteger startIndex = new AtomicInteger();

    public TaskGuideDifferenceReportDownLoadTask(TaxTaskEntity taxTaskEntity, BillList billList, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        this.view = billList.getView();
        this.billList = billList;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        this.exportResult = new ExportResult(Integer.valueOf(0));
        String type = this.stepCaseInfo.tabByGroup() ? this.taxTaskEntity.getTaxGroup(this.stepCaseInfo.getTabValue()).getNameLocaleString().getLocaleValue() : this.taxTaskEntity.getTaxCategory(this.stepCaseInfo.getTabValue()).getNameLocaleString().getLocaleValue();
        String suffix = BaseDataConverter.formats((Object)new Date(), (String)"MMdd");
        String prefix = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_", (String)"TaskGuideDifferenceReportDownLoadTask_0", (String)"sit-itc-business", (Object[])new Object[0]);
        String fileName = ResManager.loadKDString((String)(prefix + type + "_" + suffix), (String)"TaskGuideDifferenceReportDownLoadTask_1", (String)"sit-itc-business", (Object[])new Object[]{type, suffix});
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("fileName", fileName);
        ListSelectedRowCollection selectedRows = this.billList.getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.ids = Arrays.asList(selectedRows.getPrimaryKeyValues());
        } else {
            this.filters = TaxTaskGuideViewHelper.fetchListDataProviderQFilters(this.view.getPageCache());
        }
        this.orderBy = TaxTaskGuideViewHelper.fetchListDataProviderOrderBy(this.view.getPageCache());
        if (StringUtils.isEmpty((CharSequence)this.orderBy) || "id".equals(this.orderBy)) {
            this.orderBy = "taxfile.taxunit.id asc, id desc";
        } else if (!this.orderBy.contains(",id") && !this.orderBy.contains(", id")) {
            this.orderBy = this.orderBy + ", id desc";
        }
        HashMap<String, BillList> sheetInfos = new HashMap<String, BillList>(2);
        params.put("sheetInfos", sheetInfos);
        sheetInfos.put("defaultData", this.billList);
        HashMap<String, List<String>> ignoreFields = new HashMap<String, List<String>>(2);
        params.put("ignoreFields", ignoreFields);
        ignoreFields.put("defaultData", Arrays.asList("srcrefnum", "id"));
        this.workbookInfo = WorkbookInfoGenerator.generateWith((String)"differencereportbillListExport", params);
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdataguidequery").subProp("entryentity", new String[]{"taxitem", "taxcategory", "taxcategory.group", "itemvalue", "calvalue", "diffvalue"});
        this.queryProps = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, null);
        List headCellInfoList = this.workbookInfo.getSheetInfo("defaultData").getHeadCellBar().getContentHeadCellInfoList();
        this.props = CollectionUtils.isEmpty((Collection)headCellInfoList) ? new ArrayList<String>(10) : headCellInfoList.stream().map(HeadCellInfo::getValueProp).collect(Collectors.toList());
        this.desensitizeMap = SitDataServiceHelper.generateDesensitizeMap((EntityType)this.billList.getEntityType(), this.props);
        this.combMapMap = SitDataServiceHelper.resolveCombValues((String)"itc_taxdataguidequery", this.props);
        this.exportLogId = ExportLogHelper.create((Object)"", (String)("itc_taxdatadiffreport" + this.taxTaskEntity.getId()), (int)this.getTotalSize(), (String)"1");
        return BaseResult.success(null);
    }

    protected List<Map<String, Object>> queryData(String key, int pageIndex, int pageSize) {
        ArrayList result;
        DynamicObject[] objects;
        if (this.ids != null) {
            int fromIndex = pageIndex * pageSize;
            int toIndex = (pageIndex + 1) * pageSize;
            toIndex = Math.min(toIndex, this.ids.size());
            List<Object> keys = this.ids.subList(fromIndex, toIndex);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdata");
            QFilter idFilter = new QFilter("id", "in", keys);
            QFilter yearMonthFilter = new QFilter("yearmonth", "=", (Object)this.taxTaskEntity.yearMonth());
            objects = serviceHelper.query(this.queryProps, new QFilter[]{idFilter, yearMonthFilter}, this.orderBy);
        } else {
            objects = BusinessDataServiceHelper.load((String)"itc_taxdata", (String)this.queryProps, (QFilter[])this.filters.toArray(new QFilter[0]), (String)this.orderBy, (int)pageIndex, (int)pageSize);
        }
        Map<Long, List<DynamicObject>> srcDataMap = null;
        if (this.containRawData) {
            DynamicObject[] taxSrcData = TaxDataServiceHelper.queryTaxSrcData(this.taxTaskEntity, Arrays.stream(objects).map(e1 -> e1.getLong("id")).toArray(Long[]::new), this.queryProps);
            result = Lists.newArrayListWithCapacity((int)(objects.length + taxSrcData.length));
            srcDataMap = Arrays.stream(taxSrcData).collect(Collectors.groupingBy(e1 -> e1.getLong("taxdatabasic.id")));
        } else {
            result = Lists.newArrayListWithCapacity((int)objects.length);
        }
        for (int i = 0; i < objects.length; ++i) {
            List<DynamicObject> srcList;
            DynamicObject object = objects[i];
            long id = object.getLong("id");
            Map<String, Object> map = this.packageData(object);
            result.add(map);
            map.put("customseq", i + 1);
            String incomeItem = this.taxTaskEntity.getTaxCategory(Long.valueOf(object.getLong("taxcategory.id"))).getIncomeItemLocaleString();
            map.put("incomeitem", incomeItem);
            if (srcDataMap == null || (srcList = srcDataMap.get(id)) == null || srcList.size() < 2) continue;
            int j = 0;
            while (i < srcList.size()) {
                DynamicObject src = srcList.get(j);
                Map<String, Object> map1 = this.packageData(src);
                result.add(map1);
                map1.put("incomeitem", incomeItem);
                map1.put("customseq", i + 1 + "." + (j + 1));
                ++j;
            }
        }
        return result;
    }

    private Map<String, Object> packageData(DynamicObject object) {
        TaxTaskGuideOpEnum.convertStatus((DynamicObject)object);
        TaxDataItemWrapper wrapper = new TaxDataItemWrapper(object, "itemvalue");
        HashMap<String, Object> result = new HashMap<String, Object>(64);
        for (String prop : this.props) {
            if (prop.startsWith("rp_")) {
                String[] keys = prop.split("_");
                DynamicObject itemData = wrapper.getItemData((Long)BaseDataConverter.convert((Object)keys[1], Long.class));
                Object value = null;
                if (itemData == null) {
                    result.put(prop, value);
                    continue;
                }
                if (prop.endsWith("_t")) {
                    value = itemData.get("itemvalue");
                } else if (prop.endsWith("_c")) {
                    value = itemData.get("calvalue");
                } else if (prop.endsWith("_d")) {
                    String itemvalue = itemData.getString("itemvalue");
                    String calvalue = itemData.getString("calvalue");
                    String diffvalue = itemData.getString("diffvalue");
                    value = StringUtils.isBlank((CharSequence)itemvalue) && StringUtils.isBlank((CharSequence)calvalue) ? diffvalue : (StringUtils.isBlank((CharSequence)diffvalue) ? "0.00" : diffvalue);
                }
                result.put(prop, value);
                continue;
            }
            Object value = wrapper.getValue(prop);
            Map<String, String> combMap = this.combMapMap.get(prop);
            if (combMap != null) {
                value = combMap.get(value);
            } else if (value instanceof ILocaleString) {
                value = value.toString();
            }
            IDataEntityProperty property = this.desensitizeMap.get(prop);
            if (property != null) {
                Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)object, (Object)value);
                result.put(prop, desensitizeValue);
                continue;
            }
            result.put(prop, value);
        }
        return result;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        List dataList = dataBatch.getDataList();
        int startIndex = this.startIndex.getAndAdd(dataList.size());
        dataBatch.setStartIndex(startIndex);
        for (Map map : dataList) {
            Object customSeq = map.get("customseq");
            if (customSeq instanceof Integer) {
                map.put("customseq", (Integer)customSeq + startIndex);
                continue;
            }
            if (!(customSeq instanceof String)) continue;
            String seq = (String)customSeq;
            int index = seq.indexOf(46);
            map.put("customseq", Integer.parseInt(seq.substring(0, index)) + startIndex + seq.substring(index));
        }
        try {
            ExcelHelper.writeData((WorkbookInfo)this.workbookInfo, dataBatch, (ExportResult)this.exportResult);
        }
        catch (Exception e) {
            this.exportResult.addMessage(e.getMessage());
            return new BatchResult(false, dataBatch.getDataList());
        }
        return new BatchResult(true, dataBatch.getDataList());
    }

    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        HashMap<String, String> cond = new HashMap<String, String>(2);
        if (status == 0 && this.workbookInfo.getWorkbook() != null) {
            String url = ExcelHelper.storeFile((Workbook)this.workbookInfo.getWorkbook(), (String)this.workbookInfo.fullName());
            cond.put("url", url);
            this.exportLog(this.getTotalSize(), url, this.exportResult.generateMessage(255));
        } else {
            this.exportLog(0, "", this.exportResult.generateMessage(255));
        }
        this.processHandler.close(cond);
        GlobalParam.remove();
        return BaseResult.success(null);
    }

    private void exportLog(int complete, String url, String data) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)this.exportLogId, (DynamicObjectType)objType);
        List successResult = this.finalResult.getSuccessResult();
        dyn.set("total", (Object)(successResult.size() + this.finalResult.getFailResultOriginal().size()));
        dyn.set("complete", (Object)successResult.size());
        dyn.set("downloadurl", (Object)url);
        dyn.set("logs", (Object)data);
        dyn.set("exportstatus", (Object)"1");
        dyn.set("finishtime", (Object)new Date());
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "downloadClose");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u5dee\u503c\u62a5\u8868\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"TaskGuideDifferenceReportDownLoadTask_2", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"TaskGuideDifferenceReportDownLoadTask_3", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected long dealNum() {
        if (this.exportResult == null) {
            return 0L;
        }
        return this.exportResult.dealNum();
    }

    protected void appendLog(String msg) {
        this.exportResult.addMessage(msg);
    }
}

