/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.common.model.TaxDataItemWrapper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.model.page.PageMultiThreadTask;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.poi.ss.usermodel.Workbook;

public class TaskGuideRawDataDownLoadTask
extends PageMultiThreadTask<Map<String, Object>> {
    private final IFormView view;
    private final BillList billList;
    private final TaxTaskEntity taxTaskEntity;
    private WorkbookInfo workbookInfo;
    private ExportResult exportResult;
    private Map<String, Map<String, String>> combMapMap;
    private Object exportLogId;
    private List<QFilter> filters;
    private String orderBy;
    private String type;
    private Long categoryId;
    private List<String> props;
    private String queryProps;
    private List<Object> ids;
    private Map<String, IDataEntityProperty> desensitizeMap;
    private final AtomicInteger startIndex = new AtomicInteger();
    private TaxTaskGuideStepCaseInfo stepCaseInfo;

    public TaskGuideRawDataDownLoadTask(TaxTaskEntity taxTaskEntity, IFormView view, BillList billList) {
        this.view = view;
        this.billList = billList;
        this.taxTaskEntity = taxTaskEntity;
        this.categoryId = (Long)view.getFormShowParameter().getCustomParam("taxCategoryId");
        this.type = this.taxTaskEntity.getTaxCategory(this.categoryId).getNameLocaleString().getLocaleValue();
        this.stepCaseInfo = new TaxTaskGuideStepCaseInfo();
        this.stepCaseInfo.setStepCode("step40");
        this.stepCaseInfo.setTabType("ct");
        this.stepCaseInfo.setTabValue(this.categoryId);
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        this.exportResult = new ExportResult(Integer.valueOf(0));
        this.filters = new ArrayList<QFilter>(10);
        ListSelectedRowCollection selectedRows = this.billList.getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.ids = Arrays.asList(selectedRows.getPrimaryKeyValues());
        } else {
            this.filters = TaxTaskGuideViewHelper.fetchListDataProviderQFilters(this.view.getPageCache());
        }
        this.orderBy = TaxTaskGuideViewHelper.fetchListDataProviderOrderBy(this.view.getPageCache());
        if (StringUtils.isEmpty((String)this.orderBy) || "id".equals(this.orderBy)) {
            this.orderBy = "taxfile.taxunit.id asc, id desc";
        } else if (!this.orderBy.contains(",id") && !this.orderBy.contains(", id")) {
            this.orderBy = this.orderBy + ", id desc";
        }
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxrawdata").subProp("entryentity", new String[]{"taxitem", "taxcategory", "taxcategory.group", "itemvalue", "calvalue"});
        this.queryProps = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, null);
        String suffix = BaseDataConverter.formats((Object)new Date(), (String)"MMdd");
        String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u4e2a\u7a0e\u6e90\u6570\u636e_{0}_{1}", (String)"TaxTaskGuideDownLoadTask_4", (String)"sit-itc-formplugin", (Object[])new Object[]{this.type, suffix});
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("fileName", fileName);
        HashMap<String, BillList> sheetInfos = new HashMap<String, BillList>(2);
        params.put("sheetInfos", sheetInfos);
        String dataKey = (String)this.dataItemMap.entrySet().iterator().next().getKey();
        sheetInfos.put(dataKey, this.billList);
        this.workbookInfo = WorkbookInfoGenerator.generateWith((String)"billListExport", params);
        this.props = this.workbookInfo.getSheetInfo(dataKey).getHeadCellBar().getContentHeadCellInfoList().stream().map(HeadCellInfo::getValueProp).filter(e1 -> !"fseq".equals(e1)).collect(Collectors.toList());
        this.props.add("entryentity.taxitem");
        this.props.add("entryentity.itemvalue");
        this.props.add("entryentity.calvalue");
        this.desensitizeMap = SitDataServiceHelper.generateDesensitizeMap((EntityType)this.billList.getEntityType(), this.props);
        this.combMapMap = SitDataServiceHelper.resolveCombValues((String)"itc_taxrawdata", this.props);
        this.exportLogId = ExportLogHelper.create((Object)"", (String)("itc_taxrawdata" + this.taxTaskEntity.getId()), (int)this.getTotalSize(), (String)"1");
        return BaseResult.success(null);
    }

    protected List<Map<String, Object>> queryData(String key, int pageIndex, int pageSize) {
        DynamicObject[] objects;
        int fromIndex = pageIndex * pageSize;
        if (this.ids != null) {
            int toIndex = (pageIndex + 1) * pageSize;
            toIndex = Math.min(toIndex, this.ids.size());
            List<Object> keys = this.ids.subList(fromIndex, toIndex);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxrawdata");
            QFilter idFilter = new QFilter("id", "in", keys);
            QFilter yearMonthFilter = new QFilter("yearmonth", "=", (Object)this.taxTaskEntity.yearMonth());
            objects = serviceHelper.query(this.queryProps, new QFilter[]{idFilter, yearMonthFilter}, this.orderBy);
        } else {
            objects = BusinessDataServiceHelper.load((String)"itc_taxrawdata", (String)this.queryProps, (QFilter[])this.filters.toArray(new QFilter[0]), (String)this.orderBy, (int)pageIndex, (int)pageSize);
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)objects.length);
        int fromSeq = fromIndex + 1;
        for (int i = 0; i < objects.length; ++i) {
            DynamicObject object = objects[i];
            Map<String, Object> map = this.packageData(object);
            result.add(map);
            map.put("fseq", i + fromSeq);
            String incomeItem = this.taxTaskEntity.getTaxCategory(Long.valueOf(object.getLong("taxcategory.id"))).getIncomeItemLocaleString();
            map.put("incomeitem", incomeItem);
        }
        return result;
    }

    private Map<String, Object> packageData(DynamicObject object) {
        TaxTaskGuideOpEnum.convertStatus((DynamicObject)object);
        TaxDataItemWrapper wrapper = new TaxDataItemWrapper(object, "calvalue");
        HashMap<String, Object> result = new HashMap<String, Object>(64);
        TaxTaskGuideOpEnum.convertStatus((DynamicObject)object);
        for (String prop : this.props) {
            Object value = wrapper.getValue(prop);
            Map<String, String> combMap = this.combMapMap.get(prop);
            if (combMap != null) {
                value = combMap.get(value);
            } else if (value instanceof ILocaleString) {
                value = value.toString();
            }
            IDataEntityProperty property = this.desensitizeMap.get(prop);
            if (property != null) {
                Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)object, (Object)value);
                result.put(prop, desensitizeValue);
                continue;
            }
            result.put(prop, value);
        }
        String description = object.getString("taxdatabasic.description");
        JSONObject jsonObject = JSONObject.parseObject((String)description);
        if (!CollectionUtils.isEmpty((Map)jsonObject)) {
            for (Map.Entry entry : jsonObject.entrySet()) {
                result.put(((String)entry.getKey()).toLowerCase(), entry.getValue());
            }
        }
        return result;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        dataBatch.setStartIndex(this.startIndex.getAndAdd(dataBatch.getDataList().size()));
        try {
            ExcelHelper.writeData((WorkbookInfo)this.workbookInfo, dataBatch, (ExportResult)this.exportResult);
        }
        catch (Exception e) {
            this.exportResult.addMessage(e.getMessage());
            new BatchResult(false, dataBatch.getDataList());
        }
        return new BatchResult(true, null);
    }

    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        HashMap<String, String> cond = new HashMap<String, String>(2);
        if (status == 0 && this.workbookInfo.getWorkbook() != null) {
            String url = ExcelHelper.storeFile((Workbook)this.workbookInfo.getWorkbook(), (String)this.workbookInfo.fullName());
            cond.put("url", url);
            this.exportLog(this.getTotalSize(), url, this.exportResult.generateMessage(255));
        } else {
            this.exportLog(0, "", this.exportResult.generateMessage(255));
        }
        this.processHandler.close(cond);
        GlobalParam.remove();
        return BaseResult.success(null);
    }

    private void exportLog(int complete, String url, String data) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)this.exportLogId, (DynamicObjectType)objType);
        dyn.set("total", (Object)this.getTotalSize());
        dyn.set("complete", (Object)this.getTotalSize());
        dyn.set("downloadurl", (Object)url);
        dyn.set("logs", (Object)data);
        dyn.set("exportstatus", (Object)"1");
        dyn.set("finishtime", (Object)new Date());
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "downloadClose");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u4e2a\u7a0e\u6e90\u6570\u636e\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"TaxTaskGuideDownLoadTask_2", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"TaxTaskGuideDownLoadTask_1", (String)"sit-itc-formplugin", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected long dealNum() {
        if (this.exportResult == null) {
            return 0L;
        }
        return this.exportResult.dealNum();
    }

    protected void appendLog(String msg) {
        this.exportResult.addMessage(msg);
    }
}

