/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.listener.TaxTaskGuideOpListenerFactory;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.business.taxtaskguide.task.TaskGuideRawDataReferTask;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.api.StatusInfo;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.RollbackRefResultEnum;
import kd.sit.sitbp.common.model.TaxCalUnit;
import kd.sit.sitbp.common.model.TaxDataWrapper;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;

public class TaskGuideRawDataReferRollbackTask
extends TaskGuideRawDataReferTask {
    private static final Log LOGGER = LogFactory.getLog(TaskGuideRawDataReferRollbackTask.class);
    private final long rawCalTaskId;

    public TaskGuideRawDataReferRollbackTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, long rawCalTaskId) {
        super(view, taxTaskEntity, stepCaseInfo, opEnum);
        this.rawCalTaskId = rawCalTaskId;
    }

    @Override
    protected BaseResult<?> beforePrepareDataBatch() {
        HashMap<String, Object> param = null;
        if (this.rawCalTaskId != 0L) {
            param = new HashMap<String, Object>(2);
            param.put("rawCalTaskId", this.rawCalTaskId);
        }
        BaseResult<DynamicObject> taxTaskRecord = TaxTaskGuideServiceHelper.createTaxTaskRecord(this.taxTaskEntity, this.stepCaseInfo, this.opEnum, param);
        this.taxTaskOpRecord = (DynamicObject)taxTaskRecord.getData();
        return taxTaskRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BatchResult<TaxCalUnit> handleData(DataBatch<TaxCalUnit> dataBatch) {
        List dataList = dataBatch.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new BatchResult(true, dataList);
        }
        ArrayList<DynamicObject> updateBasicList = new ArrayList<DynamicObject>(dataList.size());
        ArrayList<DynamicObject> updateBasicRawList = new ArrayList<DynamicObject>(dataList.size());
        ArrayList updateList = new ArrayList(dataList.size());
        ArrayList srcDataList = new ArrayList(dataList.size());
        HashMap<Long, List<DynamicObject>> rawDataListMap = new HashMap<Long, List<DynamicObject>>(dataList.size());
        BatchResult result = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size()));
        BatchResult taxDataResult = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size() >> 1));
        for (TaxCalUnit taxCalUnit : dataList) {
            Map srcDataMap = taxCalUnit.getTaxRawDataMap();
            TaxDataWrapper taxData = taxCalUnit.getTaxData();
            Iterator iterator = srcDataMap.entrySet().iterator();
            BaseResult<TaxDataWrapper> res = null;
            ArrayList rollbackSrc = new ArrayList(srcDataMap.size());
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (this.rawCalTaskId != 0L && ((TaxDataWrapper)next.getValue()).getBasicData().getLong("rawcaltask.id") != this.rawCalTaskId) continue;
                BaseResult<TaxDataWrapper> resTmp = this.allowRollback((TaxDataWrapper)next.getValue());
                if (resTmp.isSuccess()) {
                    res = res == null ? resTmp : res;
                    rollbackSrc.add(next.getValue());
                    updateBasicRawList.add(((TaxDataWrapper)next.getValue()).getBasicData());
                    iterator.remove();
                    continue;
                }
                res = resTmp;
                break;
            }
            if (res == null) {
                if (this.rawCalTaskId != 0L) {
                    result.addFailItem((Object)taxCalUnit, (StatusInfo)RollbackRefResultEnum.SRC_STATUS_FILE, new Object[]{taxData.getBasicData().getString("taxfile.number"), taxData.getBasicData().getString("taxfile.person.number"), taxData.getBasicData().getString("taxfile.person.name")});
                    continue;
                }
            } else {
                if (!res.isSuccess() && rollbackSrc.isEmpty()) {
                    result.addFailItem((Object)taxCalUnit, res.getMessage(), res.getStatus());
                    continue;
                }
                if (CollectionUtils.isEmpty(rollbackSrc)) continue;
            }
            for (Map.Entry entry : taxData.getCategoryData().entrySet()) {
                ArrayList srcRollback = Lists.newArrayListWithCapacity((int)rollbackSrc.size());
                for (TaxDataWrapper wrapper : rollbackSrc) {
                    wrapper.getBasicData().set("status", (Object)"E");
                    DynamicObject category = wrapper.getCategory((Long)entry.getKey());
                    if (category == null) continue;
                    category.set("taxdata", null);
                    srcRollback.add(category);
                }
                this.opEnum.handle((DynamicObject)entry.getValue(), (Collection)srcRollback, this.taxTaskOpRecord, this.taxTaskEntity);
                srcDataList.addAll(srcRollback);
                rawDataListMap.put(((DynamicObject)entry.getValue()).getLong("id"), srcRollback);
                taxDataResult.addSuccessResult(entry.getValue());
                updateList.add(entry.getValue());
                if (srcDataMap.isEmpty()) {
                    ((DynamicObject)entry.getValue()).set("status", (Object)"E");
                    continue;
                }
                ArrayList srcEffect = Lists.newArrayListWithCapacity((int)rollbackSrc.size());
                for (Map.Entry wrapperEntry : srcDataMap.entrySet()) {
                    DynamicObject category = ((TaxDataWrapper)wrapperEntry.getValue()).getCategory((Long)entry.getKey());
                    if (category == null) continue;
                    srcEffect.add(category);
                }
                TaxDataServiceHelper.updateTaxDataFromRawDataV2(this.taxTaskEntity, (DynamicObject)entry.getValue(), srcEffect);
                if (CollectionUtils.isEmpty((Collection)srcEffect)) {
                    ((DynamicObject)entry.getValue()).set("status", (Object)"E");
                    continue;
                }
                TaxDataBizStatusEnum.rollbackStatusFromRawData((DynamicObject)((DynamicObject)entry.getValue()), (List)srcEffect);
            }
            updateBasicList.add(taxData.getBasicData());
            if (srcDataMap.isEmpty()) {
                taxData.getBasicData().set("srcrefnum", (Object)"0");
            } else if (srcDataMap.size() == 1) {
                taxData.getBasicData().set("srcrefnum", (Object)"1");
            } else {
                taxData.getBasicData().set("srcrefnum", (Object)"2");
            }
            result.addSuccessResult((Object)taxCalUnit);
        }
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
        HRBaseServiceHelper dataBasicServiceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        HRBaseServiceHelper rawDataBasicServiceHelper = new HRBaseServiceHelper("itc_taxrawdatabasic");
        try (TXHandle required = TX.required();){
            if (!CollectionUtils.isEmpty(updateList)) {
                dataServiceHelper.save(updateList.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty(srcDataList)) {
                dataServiceHelper.save(srcDataList.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty(updateBasicList)) {
                dataBasicServiceHelper.save(updateBasicList.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty(updateBasicRawList)) {
                rawDataBasicServiceHelper.save(updateBasicRawList.toArray(new DynamicObject[0]));
            }
        }
        TaxTaskGuideOpListenerFactory.afterBatchOperation((BatchResult<DynamicObject>)taxDataResult, rawDataListMap, this.taxTaskOpRecord, this.taxTaskEntity, this.stepCaseInfo);
        return result;
    }

    private BaseResult<TaxDataWrapper> allowRollback(TaxDataWrapper wrapper) {
        Map categoryData = wrapper.getCategoryData();
        for (Map.Entry entry : categoryData.entrySet()) {
            if (!TaxTaskGuideOpEnum.isYes((String)((DynamicObject)entry.getValue()).getString("lockoprecord.optype"))) continue;
            return BaseResult.fail((String)RollbackRefResultEnum.STATUS_FAIL.loadKDString(new Object[]{((DynamicObject)entry.getValue()).get("taxfile.number"), ((DynamicObject)entry.getValue()).get("taxfile.person.number"), ((DynamicObject)entry.getValue()).get("taxfile.person.name")}));
        }
        return BaseResult.success((Object)wrapper);
    }

    @Override
    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u9000\u56de\u7b97\u85aa\u6570\u636e", (String)"TaskGuideRawDataReferRollbackTask_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u9000\u56de\u8fdb\u5ea6\u6761", (String)"TaskGuideRawDataReferRollbackTask_2", (String)"sit-itc-formplugin", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    @Override
    protected BaseResult<TaxCalUnit> afterHandleDataBatch(int status) {
        TaxTaskGuideCacheData from = new TaxTaskGuideCacheData(this.finalResult, this.taxTaskEntity, this.stepCaseInfo, this.opEnum);
        TaxTaskGuideOpListenerFactory.afterOperation(this.finalResult, this.taxTaskOpRecord, this.taxTaskEntity, this.stepCaseInfo);
        List failItemList = this.finalResult.getFailResultOriginal();
        HashMap<Long, String> idMsgMap = new HashMap<Long, String>(failItemList.size());
        HashMap<Integer, List<Long>> statusIdMap = new HashMap<Integer, List<Long>>(8);
        for (ResultItem item : failItemList) {
            Map categoryData = ((TaxCalUnit)item.getData()).getTaxData().getCategoryData();
            for (Map.Entry entry : categoryData.entrySet()) {
                long id = ((DynamicObject)entry.getValue()).getLong("id");
                idMsgMap.put(id, item.getMessage());
                int errorCode = item.getStatus();
                List ids = statusIdMap.computeIfAbsent(errorCode, key -> new ArrayList());
                ids.add(id);
            }
        }
        List successResult = this.finalResult.getSuccessResult();
        List ids = statusIdMap.computeIfAbsent(ResultStatusEnum.INFO.getCode(), key -> new ArrayList());
        successResult.forEach(e1 -> {
            for (Map.Entry entry : e1.getTaxData().getCategoryData().entrySet()) {
                ids.add(((DynamicObject)entry.getValue()).getLong("id"));
            }
        });
        from.setIdMsgMap(idMsgMap);
        from.setStatusIdMap(statusIdMap);
        PageCache pageCache = new PageCache(this.view.getPageId());
        pageCache.put("dataOfPrevRequest", SerializationUtils.toJsonString((Object)from));
        return super.afterHandleDataBatch(status);
    }

    @Override
    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "afterProcessClose");
        return result;
    }
}

