/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxtask.TaxTaskServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.listener.TaxTaskGuideOpListenerFactory;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.servicehelper.SITPermissionServiceHelper;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.api.StatusInfo;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.RefResultEnum;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.model.TaxCalUnit;
import kd.sit.sitbp.common.model.TaxDataWrapper;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class TaskGuideRawDataReferTask
extends AssignMultiThreadTask<TaxCalUnit> {
    private static final Log LOGGER = LogFactory.getLog(TaskGuideRawDataReferTask.class);
    protected static final String TAX_FILE_ID = "taxfile.id";
    protected static final String TAX_FILE = "taxfile";
    protected final IFormView view;
    protected final TaxTaskEntity taxTaskEntity;
    protected final TaxTaskGuideStepCaseInfo stepCaseInfo;
    protected final TaxTaskGuideOpEnum opEnum;
    protected DynamicObject taxTaskOpRecord;
    protected Set<Long> taxUnitIds;

    public TaskGuideRawDataReferTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.opEnum = opEnum;
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        BaseResult<DynamicObject> taxTaskRecord = TaxTaskGuideServiceHelper.createTaxTaskRecord(this.taxTaskEntity, this.stepCaseInfo, this.opEnum, null);
        if (!SITPermissionServiceHelper.isSuperUser()) {
            this.taxUnitIds = SITPermissionServiceHelper.getTaxUnitSetByPermItem((Long)RequestContext.get().getCurrUserId(), (String)"17/+CT1QBPNP", (String)"itc_taxdata", (String)"47150e89000000ac");
        }
        this.taxTaskOpRecord = (DynamicObject)taxTaskRecord.getData();
        TaxTaskServiceHelper.loadTaxItemMap(this.taxTaskEntity);
        return taxTaskRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<TaxCalUnit> queryData(String str, List<?> list) {
        GlobalParam.set((String)"_forRefData", (Object)Boolean.TRUE);
        try {
            QFilter yearMonthFilter = new QFilter("yearmonth", "=", (Object)this.taxTaskEntity.yearMonth());
            QFilter taxTaskFilter = new QFilter("taxtask.id", "=", (Object)this.taxTaskEntity.getId());
            QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
            QFilter taxFileFilter = new QFilter(TAX_FILE_ID, "in", list);
            QFilter taxUnitFilter = this.taxUnitIds != null ? new QFilter("taxunit.id", "in", this.taxUnitIds) : new QFilter("taxunit.id", "!=", (Object)0L);
            PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdatabasic");
            DynamicObject[] taxDataBasics = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)info, (QFilter[])new QFilter[]{yearMonthFilter, taxFileFilter, taxTaskFilter, statusFilter, taxUnitFilter});
            HashMap taxCalUnitOfFile = Maps.newHashMapWithExpectedSize((int)list.size());
            ArrayList basicIds = Lists.newArrayListWithCapacity((int)list.size());
            for (DynamicObject arrayList : taxDataBasics) {
                long taxFileId = arrayList.getLong("taxfile.boid");
                TaxCalUnit calUnit = new TaxCalUnit();
                calUnit.setExtraParam("isLocalCal", (Object)this.taxTaskEntity.isLocalCal());
                taxCalUnitOfFile.put(taxFileId, calUnit);
                calUnit.setTaxDataBasic(arrayList);
                DynamicObject taxFile = arrayList.getDynamicObject(TAX_FILE);
                calUnit.setExtraParam(TAX_FILE, (Object)taxFile);
                basicIds.add(arrayList.getLong("id"));
            }
            if (!CollectionUtils.isEmpty((Collection)basicIds)) {
                DynamicObject[] taxData;
                PropertiesQueryInfo dataInfo = new PropertiesQueryInfo("itc_taxdata");
                dataInfo.subProp("entryentity", new String[]{"entryyearmonth", "taxitem", "datadirect", "itemvalue", "calvalue", "diffvalue"});
                QFilter basicFilter = new QFilter("taxdatabasic.id", "in", (Object)basicIds);
                DynamicObject[] dynamicObjectArray = taxData = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)dataInfo, (QFilter[])new QFilter[]{yearMonthFilter, basicFilter, statusFilter});
                int taxFileId = dynamicObjectArray.length;
                for (int i = 0; i < taxFileId; ++i) {
                    DynamicObject taxDatum = dynamicObjectArray[i];
                    long taxFileId2 = taxDatum.getLong("taxfile.boid");
                    long catId = taxDatum.getLong("taxcategory.id");
                    TaxCalUnit calUnit = (TaxCalUnit)taxCalUnitOfFile.get(taxFileId2);
                    calUnit.addTaxData(taxDatum);
                    calUnit.addCatIds(new Long[]{catId});
                    if (TaxTaskGuideOpEnum.isYes((String)taxDatum.getString("endoprecord.optype"))) {
                        calUnit.setExtraParam("hasEnd", (Object)"1");
                        continue;
                    }
                    if (!TaxTaskGuideOpEnum.isYes((String)taxDatum.getString("reportoprecord.optype"))) continue;
                    calUnit.setExtraParam("hasDeclare", (Object)"1");
                }
            }
            PropertiesQueryInfo rawDataBasicInfo = new PropertiesQueryInfo("itc_taxrawdatabasic");
            DynamicObject[] taxRawDataBasic = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)rawDataBasicInfo, (QFilter[])new QFilter[]{yearMonthFilter, taxFileFilter, taxTaskFilter, statusFilter}, (String)"createtime desc");
            ArrayList rawBasicIds = Lists.newArrayListWithCapacity((int)taxRawDataBasic.length);
            for (DynamicObject taxDatum : taxRawDataBasic) {
                long taxFileId = taxDatum.getLong("taxfile.boid");
                TaxCalUnit calUnit = (TaxCalUnit)taxCalUnitOfFile.get(taxFileId);
                calUnit.addTaxRawDataBasic(taxDatum);
                rawBasicIds.add(taxDatum.getLong("id"));
            }
            if (!CollectionUtils.isEmpty((Collection)rawBasicIds)) {
                DynamicObject[] taxRawData;
                QFilter qFilter = new QFilter("taxdatabasic.id", "in", (Object)rawBasicIds);
                PropertiesQueryInfo rawDataInfo = new PropertiesQueryInfo("itc_taxrawdata");
                rawDataInfo.subProp("entryentity", new String[]{"entryyearmonth", "originalValue", "taxitem", "datadirect", "itemvalue", "calvalue", "diffvalue"});
                for (DynamicObject taxRawDatum : taxRawData = SitDataServiceHelper.commonQuery((PropertiesQueryInfo)rawDataInfo, (QFilter[])new QFilter[]{yearMonthFilter, qFilter, statusFilter})) {
                    long taxFileId = taxRawDatum.getLong("taxfile.boid");
                    long rawCatId = taxRawDatum.getLong("taxcategory.id");
                    TaxCalUnit calUnit = (TaxCalUnit)taxCalUnitOfFile.get(taxFileId);
                    calUnit.addTaxRawData(taxRawDatum);
                    calUnit.addCatIds(new Long[]{rawCatId});
                    if (!TaxTaskGuideOpEnum.isYes((String)taxRawDatum.getString("lockoprecord.optype"))) {
                        calUnit.setExtraParam("hasUnLock", (Object)"1");
                        continue;
                    }
                    String bizStatus = taxRawDatum.getString("bizstatus");
                    String minStatus = (String)calUnit.getExtraParam("minStatus");
                    if (!StringUtils.isEmpty((Object)minStatus) && bizStatus.compareTo(minStatus) >= 0) continue;
                    calUnit.setExtraParam("minStatus", (Object)bizStatus);
                }
            }
            ArrayList<TaxCalUnit> arrayList = new ArrayList<TaxCalUnit>(taxCalUnitOfFile.values());
            return arrayList;
        }
        finally {
            GlobalParam.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchResult<TaxCalUnit> handleData(DataBatch<TaxCalUnit> dataBatch) {
        List dataList = dataBatch.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new BatchResult(true, dataList);
        }
        BatchResult result = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size()));
        for (TaxCalUnit taxCalUnit : dataList) {
            boolean needDeclare;
            boolean dataEmpty;
            TaxDataWrapper taxData = taxCalUnit.getTaxData();
            Map srcDataMap = taxCalUnit.getTaxRawDataMap();
            boolean bl = dataEmpty = taxData == null || CollectionUtils.isEmpty((Map)taxData.getCategoryData());
            if (dataEmpty && CollectionUtils.isEmpty((Map)srcDataMap)) continue;
            DynamicObject taxFile = (DynamicObject)taxCalUnit.getExtraParam(TAX_FILE);
            String taxFileNumber = taxFile.getString("number");
            String personNumber = taxFile.getString("person.number");
            String personName = taxFile.getString("person.name");
            if (taxData != null) {
                if (YesOrNoEnum.isYes((String)((String)taxCalUnit.getExtraParam("hasEnd")))) {
                    result.addFailItem((Object)taxCalUnit, (StatusInfo)RefResultEnum.TAX_DATA_STATUS_ERROR, new Object[]{taxFileNumber, personNumber, personName, TaxDataBizStatusEnum.END.getI18nParamString()});
                    continue;
                }
                if (YesOrNoEnum.isYes((String)((String)taxCalUnit.getExtraParam("hasDeclare")))) {
                    result.addFailItem((Object)taxCalUnit, (StatusInfo)RefResultEnum.TAX_DATA_STATUS_ERROR, new Object[]{taxFileNumber, personNumber, personName, TaxDataBizStatusEnum.DECLARE.getI18nParamString()});
                    continue;
                }
            }
            if (taxData != null && (needDeclare = this.taxTaskEntity.isNeedDeclare()) && !YesOrNoEnum.isYes((String)taxData.getBasicData().getString("declarestatus"))) {
                result.addFailItem((Object)taxCalUnit, (StatusInfo)RefResultEnum.PERSON_NOT_DECLARE, new Object[]{taxFileNumber, personNumber, personName});
                continue;
            }
            if (!YesOrNoEnum.isYes((String)((String)taxCalUnit.getExtraParam("hasUnLock")))) {
                if (srcDataMap.size() > 1) {
                    result.addFailItem((Object)taxCalUnit, (StatusInfo)RefResultEnum.TAX_RAW_DATA_STATUS_ERROR, new Object[]{taxFileNumber, personNumber, personName});
                    continue;
                }
                String minStatus = (String)taxCalUnit.getExtraParam("minStatus");
                TaxDataBizStatusEnum statusEnum = TaxDataBizStatusEnum.fromCode((String)minStatus);
                result.addFailItem((Object)taxCalUnit, (StatusInfo)RefResultEnum.TAX_DATA_STATUS_ERROR, new Object[]{taxFileNumber, personNumber, personName, statusEnum.getI18nParamString()});
                continue;
            }
            result.addSuccessResult((Object)taxCalUnit);
        }
        List successResult = result.getSuccessResult();
        if (CollectionUtils.isEmpty((Collection)successResult)) {
            return result;
        }
        ArrayList<DynamicObject> oldList = new ArrayList<DynamicObject>(dataList.size());
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(dataList.size());
        ArrayList<DynamicObject> newBasicList = new ArrayList<DynamicObject>(dataList.size());
        ArrayList<DynamicObject> oldBasicList = new ArrayList<DynamicObject>(dataList.size());
        HRBaseServiceHelper dataBasicServiceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        BatchResult taxDataResult = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size() >> 1));
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxdata");
        ArrayList<DynamicObject> srcDataListAll = new ArrayList<DynamicObject>(dataList.size() * 4);
        ORM ormBasic = ORM.create();
        long[] ids = ormBasic.genLongIds("itc_taxdatabasic", dataList.size());
        int index = 0;
        HashMap<Long, List<DynamicObject>> rawDataListMap = new HashMap<Long, List<DynamicObject>>(dataList.size());
        for (TaxCalUnit taxCalUnit : successResult) {
            Map categoryData;
            TaxDataWrapper taxDataWrapper = taxCalUnit.getTaxData();
            Map srcDataMap = taxCalUnit.getTaxRawDataMap();
            Collection<TaxDataWrapper> srcValues = srcDataMap.values();
            if (taxDataWrapper == null) {
                DynamicObject basicData = dataBasicServiceHelper.generateEmptyDynamicObject();
                basicData.set("id", (Object)ids[index++]);
                TaxDataServiceHelper.updateTaxDataBasicFromRawDataBasic(basicData, (TaxDataWrapper)srcValues.iterator().next(), this.taxTaskEntity);
                taxDataWrapper = new TaxDataWrapper(basicData);
                categoryData = taxDataWrapper.getCategoryData();
                taxCalUnit.setTaxData(taxDataWrapper);
                newBasicList.add(basicData);
            } else {
                oldBasicList.add(taxDataWrapper.getBasicData());
                categoryData = taxDataWrapper.getCategoryData();
                if (CollectionUtils.isEmpty((Map)srcDataMap)) {
                    if (CollectionUtils.isEmpty((Map)categoryData)) continue;
                    categoryData.forEach((k1, v1) -> v1.set("status", (Object)"E"));
                    continue;
                }
            }
            TaxDataServiceHelper.updateTaxDataFromRawData(this.taxTaskEntity, taxDataWrapper, srcValues, oldList, newList, srcDataListAll, dataServiceHelper);
            boolean calStatus = false;
            boolean multiStatus = false;
            for (Map.Entry entry : categoryData.entrySet()) {
                ArrayList<DynamicObject> srcEffect = new ArrayList<DynamicObject>(srcValues.size());
                rawDataListMap.put(((DynamicObject)entry.getValue()).getLong("id"), srcEffect);
                for (TaxDataWrapper srcData : srcValues) {
                    DynamicObject category = srcData.getCategory((Long)entry.getKey());
                    if (category == null || "E".equals(category.get("status"))) continue;
                    srcEffect.add(category);
                }
                if (CollectionUtils.isEmpty(srcEffect)) {
                    ((DynamicObject)entry.getValue()).set("status", (Object)"E");
                    continue;
                }
                this.opEnum.handle((DynamicObject)entry.getValue(), srcEffect, this.taxTaskOpRecord, this.taxTaskEntity);
                TaxDataBizStatusEnum.rollbackStatusFromRawData((DynamicObject)((DynamicObject)entry.getValue()), srcEffect);
                calStatus = true;
                multiStatus = srcEffect.size() > 1;
            }
            if (!calStatus) {
                taxDataWrapper.setBasicProp("srcrefnum", (Object)"0");
                taxDataWrapper.setBasicProp("calstatus", (Object)"0");
                continue;
            }
            taxDataWrapper.setBasicProp("srcrefnum", (Object)(multiStatus ? "2" : "1"));
        }
        try (TXHandle required = TX.required();){
            if (!CollectionUtils.isEmpty(newBasicList)) {
                dataServiceHelper.save(newBasicList.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty(oldBasicList)) {
                dataServiceHelper.save(oldBasicList.toArray(new DynamicObject[0]));
            }
            if (!CollectionUtils.isEmpty(newList)) {
                dataServiceHelper.save(newList.toArray(new DynamicObject[0]));
                taxDataResult.getSuccessResult().addAll(newList);
            }
            if (!CollectionUtils.isEmpty(oldList)) {
                dataServiceHelper.save(oldList.toArray(new DynamicObject[0]));
                taxDataResult.getSuccessResult().addAll(oldList);
            }
            if (!CollectionUtils.isEmpty(srcDataListAll)) {
                dataServiceHelper.save(srcDataListAll.toArray(new DynamicObject[0]));
            }
        }
        TaxTaskGuideOpListenerFactory.afterBatchOperation((BatchResult<DynamicObject>)taxDataResult, rawDataListMap, this.taxTaskOpRecord, this.taxTaskEntity, this.stepCaseInfo);
        return result;
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165\u7b97\u85aa\u6570\u636e", (String)"TaskGuideSrcDataReferTask_1", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u5bfc\u5165\u8fdb\u5ea6\u6761", (String)"TaskGuideSrcDataReferTask_2", (String)"sit-itc-formplugin", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected BaseResult<TaxCalUnit> afterHandleDataBatch(int status) {
        TaxTaskGuideCacheData from = new TaxTaskGuideCacheData(this.finalResult, this.taxTaskEntity, this.stepCaseInfo, this.opEnum);
        TaxTaskGuideOpListenerFactory.afterOperation(this.finalResult, this.taxTaskOpRecord, this.taxTaskEntity, this.stepCaseInfo);
        List failItemList = this.finalResult.getFailResultOriginal();
        HashMap<Long, String> idMsgMap = new HashMap<Long, String>(failItemList.size());
        HashMap<Integer, List<Long>> statusIdMap = new HashMap<Integer, List<Long>>(8);
        for (ResultItem item : failItemList) {
            TaxCalUnit dataSrcGroup = (TaxCalUnit)item.getData();
            DynamicObject taxFile = (DynamicObject)dataSrcGroup.getExtraParam(TAX_FILE);
            long id = taxFile.getLong("id");
            idMsgMap.put(id, item.getMessage());
            int errorCode = item.getStatus();
            List ids = statusIdMap.computeIfAbsent(errorCode, key -> new ArrayList());
            ids.add(id);
        }
        List successResult = this.finalResult.getSuccessResult();
        List ids = statusIdMap.computeIfAbsent(ResultStatusEnum.INFO.getCode(), key -> new ArrayList());
        successResult.forEach(e1 -> ids.add(e1.getTaxData().getBasicData().getLong(TAX_FILE_ID)));
        from.setIdMsgMap(idMsgMap);
        from.setStatusIdMap(statusIdMap);
        PageCache pageCache = new PageCache(this.view.getPageId());
        pageCache.put("dataOfPrevRequest", SerializationUtils.toJsonString((Object)from));
        return super.afterHandleDataBatch(status);
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "afterProcessClose");
        return result;
    }
}

