/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxfile.export.AbstractExportTask;
import kd.sit.itc.business.taxfile.exportDTO.TaxReportExportDTO;
import kd.sit.itc.business.taxfile.imports.TaxExportHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.task.AbstractTaxPersonDeclareAndReportExport;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.DataItem;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.SitDataTypeEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.poi.ss.usermodel.Workbook;
import org.elasticsearch.common.Strings;

public class TaskGuideReportExportTask
extends AbstractTaxPersonDeclareAndReportExport {
    private static final Log LOGGER = LogFactory.getLog(TaskGuideReportExportTask.class);
    private IFormView view;
    private AbstractFormPlugin plugin;
    private IPageCache pageCache;
    private TaxTaskEntity taxTaskEntity;
    private TaxTaskGuideStepCaseInfo stepCaseInfo;
    private Map<String, Object> nameMap;
    private int pageSize = 500;
    private DynamicObject exportTemplate;
    private QueryEntityType queryEntityType;
    private Map<String, Object> exportFieldsMap;
    private TaxReportExportDTO taxReportExportDTO;
    private String orderBy;
    private Map<String, List<Long>> declaredTaxUnitDataMap = new HashMap<String, List<Long>>(16);
    private Object exportLogId;
    private int total;
    private Map<String, WorkbookInfo> workbookInfoMap = new ConcurrentHashMap<String, WorkbookInfo>(16);

    public TaskGuideReportExportTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, AbstractFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.pageCache = view.getPageCache();
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            LOGGER.info("1---thread is [{}], task number is [{}], begin beforePrepareDataBatch", (Object)Thread.currentThread().getName(), (Object)this.taxTaskEntity.getNumber());
            this.initCustomParams();
            LOGGER.info("2---thread is [{}], task number is [{}], after initCustomParams, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            this.initExportInfo();
            LOGGER.info("3---thread is [{}], task number is [{}], after initExportInfo, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            stopwatch.stop();
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when beforePrepareDataBatch data", (Throwable)e);
            this.setErrorMsg(e.getMessage());
            this.afterHandleDataBatch(-2);
        }
        return BaseResult.success(null);
    }

    private void setErrorMsg(String message) {
        this.finalResult.setSuccess(false);
        String oldMessage = this.finalResult.getMessage();
        if (StringUtils.isEmpty((Object)oldMessage)) {
            this.finalResult.setMessage(message);
        } else {
            this.finalResult.setMessage(oldMessage + " ; " + message);
        }
    }

    private void initExportInfo() {
        this.exportTemplate = this.getExportTemplate();
        this.exportFieldsMap = this.parseExportFields(this.exportTemplate);
        this.queryEntityType = this.getQueryEntityType();
        this.taxReportExportDTO = this.getTaxReportExportDTO(this.queryEntityType, this.exportFieldsMap);
        this.nameMap = this.getFileNameParaMap(this.taxTaskEntity, this.stepCaseInfo);
        this.orderBy = TaxTaskGuideViewHelper.fetchListDataProviderOrderBy(this.view.getPageCache());
        if (StringUtils.isEmpty((Object)this.orderBy) || "id".equals(this.orderBy)) {
            this.orderBy = "taxfile.taxunit.id asc, id desc";
        } else if (!this.orderBy.contains(",id") && !this.orderBy.contains(", id")) {
            this.orderBy = this.orderBy + ", id desc";
        }
    }

    private Map<String, Object> getFileNameParaMap(TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("itc_taxtask");
        QFilter qFilter = new QFilter("id", "=", (Object)taxTaskEntity.getId());
        DynamicObject dy = helper.queryOne("id,taxstartdate,taxenddate,taxtaskcatgentry.taxcategory", new QFilter[]{qFilter});
        HashMap<String, Object> map = new HashMap<String, Object>();
        Date taxStartDate = dy.getDate("taxstartdate");
        map.put("taxstartdate", taxStartDate);
        Date taxEndDate = dy.getDate("taxenddate");
        map.put("taxenddate", taxEndDate);
        Long taxCategoryId = stepCaseInfo.getTabValue();
        DynamicObjectCollection taxtaskCatgEntry = dy.getDynamicObjectCollection("taxtaskcatgentry");
        for (DynamicObject dynamicObject : taxtaskCatgEntry) {
            if (taxCategoryId.longValue() != dynamicObject.getLong("taxcategory.id")) continue;
            map.put("taxcategoryname", dynamicObject.getString("taxcategory.name"));
        }
        return map;
    }

    private TaxReportExportDTO getTaxReportExportDTO(QueryEntityType queryEntityType, Map<String, Object> exportFields) {
        Map allFiledProperty = queryEntityType.getAllFields();
        TaxReportExportDTO taxReportExportDTO = new TaxReportExportDTO();
        ArrayList<DynamicObject> taxItemDys = new ArrayList<DynamicObject>();
        String baseExportFileds = (String)exportFields.remove("baseExportFileds");
        taxReportExportDTO.setExportNotTaxItemFileds(baseExportFileds);
        LinkedHashMap<String, DynamicProperty> dynamicPropertyMap = new LinkedHashMap<String, DynamicProperty>();
        IDataEntityProperty dataEntityProperty = null;
        BasedataEntityType basedataEntityType = null;
        DynamicProperty dynamicProperty = null;
        for (Map.Entry<String, Object> entry : exportFields.entrySet()) {
            if (entry.getValue() == null) {
                String[] fieldCodes = entry.getKey().split("\\.");
                for (int i = 0; i < fieldCodes.length; ++i) {
                    String field = fieldCodes[i];
                    if (i == 0) {
                        dataEntityProperty = (IDataEntityProperty)allFiledProperty.get(field);
                    } else if (basedataEntityType != null) {
                        dataEntityProperty = basedataEntityType.getProperty(field);
                    }
                    if (dataEntityProperty instanceof BasedataProp) {
                        basedataEntityType = (BasedataEntityType)((BasedataProp)dataEntityProperty).getComplexType();
                        continue;
                    }
                    if (!(dataEntityProperty instanceof DynamicProperty)) continue;
                    dynamicProperty = (DynamicProperty)dataEntityProperty;
                    break;
                }
                dynamicPropertyMap.put(entry.getKey(), dynamicProperty);
                continue;
            }
            DynamicObject taxItemDy = (DynamicObject)entry.getValue();
            FieldProp fieldProp = TaxExportHelper.createFieldProp(taxItemDy);
            dynamicPropertyMap.put(taxItemDy.getString("id"), (DynamicProperty)fieldProp);
            taxItemDys.add(taxItemDy);
        }
        taxReportExportDTO.setDynamicPropertyMap(dynamicPropertyMap);
        taxReportExportDTO.setTaxItemDyLists(taxItemDys);
        return taxReportExportDTO;
    }

    private QueryEntityType getQueryEntityType() {
        this.queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"itc_taxfiledeclarequery");
        if (this.queryEntityType == null) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u67e5\u8be2\u914d\u7f6e\u5df2\u88ab\u5220\u9664\uff1a%s", (String)"TaskGuideReportExportTask_0", (String)"sit-itc-business", (Object[])new Object[0]), "itc_taxfiledeclarequery");
            throw new KDBizException(msg);
        }
        return this.queryEntityType;
    }

    private Map<String, Object> parseExportFields(DynamicObject exportTemplate) {
        DynamicObjectCollection entryEntity = exportTemplate.getDynamicObjectCollection("entryentity");
        StringBuilder str = new StringBuilder();
        LinkedHashMap<String, Object> exportFieldsMap = new LinkedHashMap<String, Object>();
        for (DynamicObject entity : entryEntity) {
            if (!entity.getBoolean("isexport")) continue;
            if (!entity.get("fieldkey").equals("")) {
                str.append(entity.get("fieldkey")).append(',');
                exportFieldsMap.put(entity.getString("fieldkey"), null);
                continue;
            }
            DynamicObject taxitem = (DynamicObject)entity.get("taxitem");
            exportFieldsMap.put(taxitem.getString("id"), taxitem);
        }
        exportFieldsMap.put("baseExportFileds", str.toString());
        return exportFieldsMap;
    }

    private DynamicObject getExportTemplate() {
        Long templateId = this.getTemplateId();
        this.exportTemplate = this.queryExportTemplate(templateId);
        if (this.exportTemplate == null) {
            String msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5bfc\u51fa\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff1a%s", (String)"TaskGuideReportExportTask_1", (String)"sit-itc-business", (Object[])new Object[0]), templateId);
            throw new KDBizException(msg);
        }
        return this.exportTemplate;
    }

    private DynamicObject queryExportTemplate(Long templateId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("sitbs_taxtemplate");
        String selectFileds = "fieldkey,isexport,exportfield,ismustinput,asteriskposition,index,taxitem,taxitem.currency,taxitem.dataprecision,taxitem.datatype";
        QFilter qFilter = new QFilter("id", "=", (Object)templateId);
        DynamicObject templateObject = serviceHelper.queryOne(selectFileds, new QFilter[]{qFilter}, "index");
        return templateObject;
    }

    public Long getTemplateId() {
        String templateId = this.pageCache.get("templateId");
        return templateId == null ? 0L : Long.parseLong(templateId);
    }

    private void initCustomParams() {
        String entityName = ResManager.loadKDString((String)"\u4e2a\u7a0e\u7533\u62a5\u8868", (String)"TaskGuideReportExportTask_2", (String)"sit-itc-business", (Object[])new Object[0]);
        this.exportLogId = ExportLogHelper.create((Object)AbstractExportTask.getCacheKey(entityName, new Date().toString()), (String)entityName, (int)this.total, (String)"3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Map<String, Object>> queryData(String key, int pageIndex, int pageSize) {
        if (!this.finalResult.isSuccess()) {
            return null;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOGGER.info("1---thread is [{}], task number is [{}], begin queryData", (Object)Thread.currentThread().getName(), (Object)this.taxTaskEntity.getNumber());
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(pageSize);
        List<Object> pageIds = new ArrayList(10);
        DataSet rows = null;
        DataSet copy0 = null;
        DataSet dataSet = null;
        try {
            List<Long> taxDataIds = this.declaredTaxUnitDataMap.get(key);
            int listSize = taxDataIds.size();
            int start = pageSize * pageIndex;
            int end = pageSize * (pageIndex + 1);
            end = Math.min(end, listSize);
            pageIds = taxDataIds.subList(start, end);
            QFilter taxDataFilter = new QFilter("id", "in", pageIds);
            StringBuilder queryProperties = new StringBuilder("id,entryentity.taxitem.id,entryentity.taxitem.datatype.id,entryentity.calvalue,taxfile.id");
            if (!Strings.isNullOrEmpty((String)this.orderBy)) {
                HashSet<String> split = new HashSet<String>(Arrays.asList(queryProperties.toString().split(",")));
                String[] orderFields = this.orderBy.split(",");
                for (String orderField : orderFields) {
                    String[] fieldOrder = orderField.trim().split(" ");
                    String field = fieldOrder[0].trim();
                    if (split.contains(field)) continue;
                    queryProperties.append(',').append(field);
                }
            }
            rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"itc_taxdata", (String)queryProperties.toString(), (QFilter[])new QFilter[]{taxDataFilter}, (String)this.orderBy);
            LOGGER.info("2---thread is [{}], task number is [{}], after BusinessDataServiceHelper.load, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            LOGGER.info("query properties is {}", (Object)queryProperties);
            LOGGER.info("pageIds in taxDataFilters is {}", (Object)pageIds.toString());
            copy0 = rows.copy();
            HashSet taxFileIds = Sets.newHashSetWithExpectedSize((int)pageSize);
            for (Row row : copy0) {
                Long taxFileId = row.getLong("taxfile.id");
                taxFileIds.add(taxFileId);
            }
            copy0.close();
            QFilter taxFileFilter = new QFilter("taxfile.id", "in", (Object)taxFileIds);
            LOGGER.info("3---thread is [{}], task number is [{}], before queryEntityType.getQueryDataSet, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            LOGGER.info("3.1---thread is [{}], task number is [{}], taxFileIds is[{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), ((Object)taxFileIds).toString()});
            String oldQueryStr = this.taxReportExportDTO.getExportNotTaxItemFileds() + "taxfile.id";
            HashMap queryStrMap = Maps.newHashMapWithExpectedSize((int)7);
            queryStrMap.put("taxdatabasic", Lists.newArrayListWithCapacity((int)50));
            String[] oldFieldNames = oldQueryStr.split(",");
            HashMap newFieldNameToOldNameMap = Maps.newHashMapWithExpectedSize((int)oldFieldNames.length);
            this.initQueryStrMapAndNewFieldNameToOldNameMap(queryStrMap, newFieldNameToOldNameMap, oldFieldNames);
            QFilter taxTaskQFilter = new QFilter("taxtask.id", "=", (Object)this.taxTaskEntity.getId());
            QFilter statusQFilter = new QFilter("status", "not in", Arrays.asList("D", "E"));
            QFilter[] qFilters = new QFilter[]{taxFileFilter, taxTaskQFilter, statusQFilter};
            dataSet = this.queryTaxDataBasicData(queryStrMap, qFilters, null);
            LOGGER.info("4---thread is [{}], task number is [{}], after queryTaxDataBasic, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            LOGGER.info("4.1---thread is [{}], task number is [{}], taxtask.id is[{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), this.taxTaskEntity.getId()});
            HashMap entityQueryIdMap = Maps.newHashMapWithExpectedSize((int)queryStrMap.size());
            HashMap idsRelateMap = Maps.newHashMapWithExpectedSize((int)queryStrMap.size());
            this.initEntityQueryIdMapAndIdsRelateMap(queryStrMap, entityQueryIdMap, idsRelateMap, pageSize);
            LinkedHashMap taxFileIdToDataMap = Maps.newLinkedHashMapWithExpectedSize((int)pageSize);
            Map<String, DynamicProperty> dynamicPropertyMap = this.taxReportExportDTO.getDynamicPropertyMap();
            List taxDataBasicFieldList = (List)queryStrMap.get("taxdatabasic");
            this.initEntityQueryIdMapAndIdsRelateMapAndTaxFileIdToDataMap(dataSet, taxDataBasicFieldList, entityQueryIdMap, idsRelateMap, dynamicPropertyMap, taxFileIdToDataMap);
            LOGGER.info("4.1---thread is [{}], task number is [{}], taxFileIdToDataMap is[{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), ((Object)taxFileIdToDataMap).toString()});
            LOGGER.info("5---thread is [{}], task number is [{}], before completableFutureQuery, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            CompletableFuture<?>[] completableFutures = this.queryEntitiesData(entityQueryIdMap, queryStrMap, idsRelateMap, newFieldNameToOldNameMap, dynamicPropertyMap, taxFileIdToDataMap);
            CompletableFuture.allOf(completableFutures).join();
            LOGGER.info("6---thread is [{}], task number is [{}], after completableFutureQuery, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            List taxitemIds = this.taxReportExportDTO.getTaxItemDyLists().stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            LinkedHashMap tempMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
            for (Row row : rows) {
                Long dataTypeId;
                SitDataTypeEnum dataType;
                Map dataMap = null;
                Object dataMapFromTempMap = tempMap.get(row.getLong("taxfile.id"));
                dataMap = Objects.isNull(dataMapFromTempMap) ? (Map)taxFileIdToDataMap.get(row.getLong("taxfile.id")) : (Map)dataMapFromTempMap;
                long taxitemId = row.getLong("entryentity.taxitem.id");
                if (taxitemIds.contains(taxitemId) && null != (dataType = SitDataTypeEnum.getEnumById((long)(dataTypeId = row.getLong("entryentity.taxitem.datatype.id")))).convert(row.get("entryentity.calvalue"))) {
                    dataMap.put(row.getString("entryentity.taxitem.id"), dataType.convert(row.get("entryentity.calvalue")));
                }
                dataMap.put("id", row.getLong("id"));
                tempMap.put(row.getLong("taxfile.id"), dataMap);
            }
            tempMap.values().forEach(v1 -> {
                Map value = (Map)v1;
                dataList.add(value);
            });
            LOGGER.info("7---thread is [{}], task number is [{}], after assemble data, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            stopwatch.stop();
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when queryData data, error info: ", (Throwable)e);
            LOGGER.error("Error occurs when queryData data, error message: ", (Object)e.getMessage());
            if (!CollectionUtils.isEmpty(pageIds)) {
                StringBuilder ids = new StringBuilder("Error occurs when queryData data, error ids: ");
                pageIds.forEach(obj -> ids.append(obj).append(','));
                LOGGER.warn(ids.toString());
            }
        }
        finally {
            if (rows != null) {
                rows.close();
            }
            if (copy0 != null) {
                copy0.close();
            }
            if (dataSet != null) {
                dataSet.close();
            }
        }
        return dataList;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        BatchResult result = new BatchResult(true, null);
        List dataList = dataBatch.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return result;
        }
        try {
            Stopwatch stopwatch = Stopwatch.createStarted();
            LOGGER.info("1---thread is [{}], task number is [{}], begin handleData", (Object)Thread.currentThread().getName(), (Object)this.taxTaskEntity.getNumber());
            String dataKey = dataBatch.getDataKey();
            WorkbookInfo workbookInfo = this.getWorkbookInfo(dataKey);
            ExportResult exportResult = new ExportResult(Integer.valueOf(dataList.size()));
            ExcelHelper.writeData((WorkbookInfo)workbookInfo, dataBatch, (ExportResult)exportResult);
            String message = exportResult.generateMessage(255);
            LOGGER.info("2---thread is [{}], task number is [{}], finish handleData, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
            stopwatch.stop();
            if (!StringUtils.isEmpty((Object)message)) {
                throw new KDBizException(message);
            }
            this.setTaxDataBizStatus2Export(dataList);
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when handleData data", (Throwable)e);
            String message = e.getMessage();
            dataList.forEach(obj -> result.addFailItem(obj, (String)obj.get("number") + (String)obj.get("person.name") + message));
            return result;
        }
        return result.addSuccessResult(dataList);
    }

    private void setTaxDataBizStatus2Export(List<Map<String, Object>> dataList) {
        Object[] taxDataIds = dataList.stream().map(obj -> (Long)obj.get("id")).toArray();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, this.taxTaskEntity, this.stepCaseInfo, taxDataIds);
        List<DynamicObject> taxDataDys = TaxTaskGuideServiceHelper.loadTaxData(qFilters);
        BatchResult result = new BatchResult(true, taxDataDys);
        TaxTaskGuideServiceHelper.doSetTaxDataBizStatus2Export(this.taxTaskEntity, this.stepCaseInfo, (BatchResult<DynamicObject>)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkbookInfo getWorkbookInfo(String dataKey) {
        WorkbookInfo workbookInfo;
        DataItem dataItem;
        DataItem dataItem2 = dataItem = (DataItem)this.dataItemMap.get(dataKey);
        synchronized (dataItem2) {
            workbookInfo = this.workbookInfoMap.get(dataKey);
            if (workbookInfo == null) {
                HashMap<String, Object> param = new HashMap<String, Object>(16);
                param.put("name", dataKey);
                param.put("template", this.exportTemplate);
                param.put("DTO", this.taxReportExportDTO);
                param.put("nameMap", this.nameMap);
                workbookInfo = WorkbookInfoGenerator.generateWith((String)"sitTaxReportExport", param);
                this.workbookInfoMap.put(dataKey, workbookInfo);
            }
        }
        return workbookInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        String url = "";
        try {
            if (this.finalResult.isSuccess() && !CollectionUtils.isEmpty(this.workbookInfoMap)) {
                url = this.storeData();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when afterHandleDataBatch data", (Object)e.getMessage());
            this.setErrorMsg(e.getMessage());
        }
        finally {
            LOGGER.info(" Export end\uff1atotalSize = {} , dealNum = {} ; ", (Object)this.total, (Object)this.dealNum());
            LOGGER.info(" report export task url = {}", (Object)url);
            this.closeProcess(url, status);
        }
        return BaseResult.success(null);
    }

    private void closeProcess(String url, int status) {
        this.pageCache.put("url", url);
        this.pageCache.put("export_result", SerializationUtils.serializeToBase64(this.transferResult((BatchResult<Map<String, Object>>)this.finalResult)));
        this.pageCache.put("opkey", "reportexport");
        this.pageCache.saveChanges();
        this.processHandler.close(this.closeParams(status));
        AbstractExportTask.logAll(this.exportLogId, url, this.finalResult.getMessage(), (int)this.dealNum());
    }

    private String storeData() {
        String url = "";
        HashMap wbMap = Maps.newHashMapWithExpectedSize((int)this.workbookInfoMap.size());
        for (Map.Entry<String, WorkbookInfo> entry : this.workbookInfoMap.entrySet()) {
            WorkbookInfo workbookInfo = entry.getValue();
            Workbook workbook = workbookInfo.getWorkbook();
            if (workbook == null) continue;
            wbMap.put(workbookInfo.fullName(), workbook);
        }
        if (wbMap.size() == 1) {
            for (Map.Entry<String, Object> entry : wbMap.entrySet()) {
                url = ExcelHelper.storeFile((Workbook)((Workbook)entry.getValue()), (String)entry.getKey());
            }
        } else {
            url = ExcelHelper.storeZipFile((Map)wbMap, (String)this.getZipName(this.nameMap));
        }
        return url;
    }

    private String getZipName(Map<String, Object> nameMap) {
        Date taxStartDate = (Date)nameMap.get("taxstartdate");
        Date taxEndDate = (Date)nameMap.get("taxenddate");
        String taxcategoryName = (String)nameMap.get("taxcategoryname");
        LocalDate taxStartDate1 = taxStartDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        LocalDate taxEndDate1 = taxEndDate.toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDate();
        String taxStartDate2 = String.format(Locale.ROOT, "%04d", taxStartDate1.getYear()) + String.format(Locale.ROOT, "%02d", taxStartDate1.getMonthValue()) + String.format(Locale.ROOT, "%02d", taxStartDate1.getDayOfMonth());
        String taxEndDate2 = String.format(Locale.ROOT, "%04d", taxEndDate1.getYear()) + String.format(Locale.ROOT, "%02d", taxEndDate1.getMonthValue()) + String.format(Locale.ROOT, "%02d", taxEndDate1.getDayOfMonth());
        String fileName = String.format("%s_%s-%s.zip", taxcategoryName, taxStartDate2, taxEndDate2);
        return fileName;
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u4e2a\u7a0e\u7533\u62a5\u8868\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"TaskGuideReportExportTask_3", (String)"sit-itc-business", (Object[])new Object[0]));
        cond.put("closeCallBack", new CloseCallBack((IFormPlugin)this.plugin, "afterExportingTaxReport"));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"TaskGuideReportExportTask_4", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "afterProcessClose");
        return result;
    }

    public void prepareDataItem(Map<String, List<Long>> Map2) {
        this.declaredTaxUnitDataMap = Map2;
        this.total = this.count(this.declaredTaxUnitDataMap);
        for (Map.Entry<String, List<Long>> entry : this.declaredTaxUnitDataMap.entrySet()) {
            List<Long> taxDataIds = entry.getValue();
            this.addData(entry.getKey(), taxDataIds.size(), this.pageSize, 1);
        }
    }

    private int count(Map<String, List<Long>> declaredTaxUnitDataMap) {
        int total = 0;
        for (Map.Entry<String, List<Long>> entry : declaredTaxUnitDataMap.entrySet()) {
            total += entry.getValue().size();
        }
        return total;
    }
}

