/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.SrcStatus;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.KeyGenerator;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.api.StatusInfo;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.RollbackLockResultEnum;
import kd.sit.sitbp.common.enums.TaxTaskTypeEnum;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.TaxDataSrcGroup;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class TaskGuideRollbackLockTask
extends AssignMultiThreadTask<TaxDataSrcGroup<Long, DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(TaskGuideRollbackLockTask.class);
    private final IFormView view;
    private final TaxTaskEntity taxTaskEntity;
    private final TaxTaskGuideStepCaseInfo stepCaseInfo;
    private final TaxTaskGuideOpEnum opEnum;
    private final long rawCalTaskId;

    public TaskGuideRollbackLockTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum, long rawCalTaskId) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.opEnum = opEnum;
        this.rawCalTaskId = rawCalTaskId;
        GlobalParam.set((String)"feedbackRollback_rawCalTaskId", (Object)rawCalTaskId);
    }

    protected List<TaxDataSrcGroup<Long, DynamicObject>> queryData(String key, List<?> ids) {
        GlobalParam.remove();
        LOGGER.info("Trace By Quinn, {} - {}", (Object)"queryData start");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("id", "in", ids));
        TaxTaskGuideServiceHelper.packageFiltersForData(qFilters, this.taxTaskEntity, this.stepCaseInfo, new Object[0]);
        LOGGER.info("Trace By Quinn, {} - {}", (Object)"TaxTaskGuideServiceHelper.packageFiltersForData");
        List<DynamicObject> taxDataList = TaxTaskGuideServiceHelper.loadTaxData(qFilters);
        HashMap dataSrcGroupMap = new HashMap(taxDataList.size());
        taxDataList.forEach(e1 -> dataSrcGroupMap.put(e1.getLong("id"), new TaxDataSrcGroup(e1, KeyGenerator.DYNAMIC_OBJ_GENERATOR)));
        qFilters.clear();
        qFilters.add(new QFilter("taxdata", "in", ids));
        TaxTaskGuideServiceHelper.packageFiltersForSrcData(qFilters, this.taxTaskEntity, this.stepCaseInfo);
        DynamicObject[] taxSrcDataArr = TaxTaskGuideServiceHelper.loadTaxSrcData(qFilters);
        LOGGER.info("Trace By Quinn, {} - {}", (Object)"TaxTaskGuideServiceHelper.loadTaxSrcData");
        for (DynamicObject srcData : taxSrcDataArr) {
            TaxDataSrcGroup taxDataSrcGroup = (TaxDataSrcGroup)dataSrcGroupMap.get(srcData.getLong("taxdata"));
            if (taxDataSrcGroup == null) continue;
            taxDataSrcGroup.addTaxSrcData((Object)srcData);
        }
        LOGGER.info("Trace By Quinn, {} - {}", (Object)"queryData end");
        return Lists.newArrayList(dataSrcGroupMap.values());
    }

    protected BatchResult<TaxDataSrcGroup<Long, DynamicObject>> handleData(DataBatch<TaxDataSrcGroup<Long, DynamicObject>> dataBatch) {
        List dataList = dataBatch.getDataList();
        LOGGER.info("Trace By Quinn, {} - {}", (Object)"handleData start");
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            LOGGER.info("Trace By Quinn, {} - {}", (Object)"handleData end at once");
            return new BatchResult(true, dataList);
        }
        try {
            HashMap<Long, List<DynamicObject>> srcDataMap;
            BatchResult result = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size()));
            ArrayList<TaxDataSrcGroup> delImportDataList = new ArrayList<TaxDataSrcGroup>(dataList.size());
            HashSet<Long> needToCleanImportDataTaxDataIds = new HashSet<Long>(16);
            for (TaxDataSrcGroup group : dataList) {
                LOGGER.info("Trace By Quinn, {} - {}", (Object)"handleData start loop");
                srcDataMap = group.getSrcDataMap();
                DynamicObject taxData = (DynamicObject)group.getTaxData();
                TaxDataSrcGroup newTaxDataSrcGroup = new TaxDataSrcGroup((Object)taxData, new ArrayList(srcDataMap.values()), KeyGenerator.DYNAMIC_OBJ_GENERATOR);
                delImportDataList.add(newTaxDataSrcGroup);
                Iterator iterator = srcDataMap.entrySet().iterator();
                String taxDataBizStatus = taxData.getString("bizstatus");
                String taxDataCalStatus = taxData.getString("taxdatabasic.calstatus");
                if (srcDataMap.size() > 1) {
                    LOGGER.info("Trace By Quinn, {} - {}", (Object)"srcDataMap.size", (Object)srcDataMap.size());
                    if (!TaxDataBizStatusEnum.DECLARE.isGreaterThan(taxDataBizStatus)) {
                        result.addFailItem((Object)group, (StatusInfo)RollbackLockResultEnum.TAX_DATA_STATUS_ERROR, new Object[]{taxData.getString("taxfile.number"), taxData.getString("taxfile.person.name"), TaxDataBizStatusEnum.getI18nNameByCode((String)taxDataBizStatus)});
                        continue;
                    }
                    ArrayList<String> errMsgPara = new ArrayList<String>(4);
                    HashMap<RollbackLockResultEnum, ArrayList<String>> errMsg = new HashMap<RollbackLockResultEnum, ArrayList<String>>(1);
                    while (iterator.hasNext()) {
                        Map.Entry next = iterator.next();
                        DynamicObject rawData = (DynamicObject)next.getValue();
                        String rawTaxDataBizStatus = rawData.getString("bizstatus");
                        String rawDataCalStatus = rawData.getString("taxdatabasic.calstatus");
                        if (this.rawCalTaskId != 0L && ((DynamicObject)next.getValue()).getLong("taxdatabasic.rawcaltask.id") != this.rawCalTaskId) {
                            iterator.remove();
                            continue;
                        }
                        if (this.validateBizStatus(rawTaxDataBizStatus, rawDataCalStatus)) {
                            if (CollectionUtils.isEmpty(errMsg)) {
                                errMsgPara.add(rawData.getString("taxfile.number"));
                                errMsgPara.add(rawData.getString("taxfile.person.name"));
                                errMsgPara.add(rawData.getString("taxdatabasic.rawcaltask.number"));
                                errMsgPara.add(TaxDataBizStatusEnum.getI18nNameByCode((String)rawTaxDataBizStatus));
                                errMsg.put(RollbackLockResultEnum.TAX_RAW_DATA_STATUS_ERROR, errMsgPara);
                            }
                            iterator.remove();
                            continue;
                        }
                        String rawDataCalTaskStatus = rawData.getString("taxdatabasic.srcstatus");
                        if (!TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(this.taxTaskEntity.getTaxTaskType()) && YesOrNoEnum.isYes((String)rawDataCalStatus) && !SrcStatus.RECEIVED.isGreaterThan(rawDataCalTaskStatus)) {
                            if (CollectionUtils.isEmpty(errMsg)) {
                                errMsgPara.add(rawData.getString("taxfile.number"));
                                errMsgPara.add(rawData.getString("taxfile.person.name"));
                                errMsgPara.add(rawData.getString("taxdatabasic.rawcaltask.number"));
                                errMsgPara.add(SrcStatus.getI18nNameByCode(rawDataCalTaskStatus));
                                errMsg.put(RollbackLockResultEnum.TAX_RAW_DATA_SRC_STATUS_ERROR, errMsgPara);
                            }
                            iterator.remove();
                            continue;
                        }
                        if (!YesOrNoEnum.isYes((String)rawData.getString("importoprecord.result"))) continue;
                        needToCleanImportDataTaxDataIds.add(taxData.getLong("id"));
                    }
                    if (srcDataMap.size() == 0 || this.rawCalTaskId != 0L && !this.containCalTaskId(srcDataMap, this.rawCalTaskId)) {
                        Map.Entry errMsgEntry = errMsg.entrySet().iterator().next();
                        result.addFailItem((Object)group, (StatusInfo)errMsgEntry.getKey(), new Object[]{((List)errMsgEntry.getValue()).get(0), ((List)errMsgEntry.getValue()).get(1), ((List)errMsgEntry.getValue()).get(2), ((List)errMsgEntry.getValue()).get(3)});
                        needToCleanImportDataTaxDataIds.remove(taxData.getLong("id"));
                        continue;
                    }
                    result.addSuccessResult((Object)group);
                    continue;
                }
                LOGGER.info("Trace By Quinn, {} - {}", (Object)"srcDataMap.size = 1", (Object)srcDataMap.size());
                if (this.validateBizStatus(taxDataBizStatus, taxDataCalStatus)) {
                    result.addFailItem((Object)group, (StatusInfo)RollbackLockResultEnum.TAX_DATA_STATUS_ERROR, new Object[]{taxData.getString("taxfile.number"), taxData.getString("taxfile.person.name"), TaxDataBizStatusEnum.getI18nNameByCode((String)taxDataBizStatus)});
                    continue;
                }
                Map.Entry entry = iterator.next();
                DynamicObject taxRawData = (DynamicObject)entry.getValue();
                String rawDataCalTaskStatus = taxRawData.getString("taxdatabasic.srcstatus");
                String rawDataCalStatus = taxRawData.getString("taxdatabasic.calstatus");
                if (!TaxTaskTypeEnum.LOCAL_CAL.getCode().equals(this.taxTaskEntity.getTaxTaskType()) && YesOrNoEnum.isYes((String)rawDataCalStatus) && !SrcStatus.RECEIVED.isGreaterThan(rawDataCalTaskStatus)) {
                    result.addFailItem((Object)group, (StatusInfo)RollbackLockResultEnum.TAX_DATA_SRC_STATUS_ERROR, new Object[]{taxRawData.getString("taxfile.number"), taxRawData.getString("taxfile.person.name"), SrcStatus.getI18nNameByCode(rawDataCalTaskStatus)});
                    continue;
                }
                if (YesOrNoEnum.isYes((String)taxData.getString("importoprecord.result"))) {
                    needToCleanImportDataTaxDataIds.add(taxData.getLong("id"));
                }
                result.addSuccessResult((Object)group);
            }
            List successResult = result.getSuccessResult();
            ArrayList<DynamicObject> taxDataDys = new ArrayList<DynamicObject>(successResult.size());
            srcDataMap = new HashMap<Long, List<DynamicObject>>(successResult.size());
            for (TaxDataSrcGroup group : successResult) {
                DynamicObject taxData = (DynamicObject)group.getTaxData();
                taxDataDys.add(taxData);
                long taxDataId = taxData.getLong("id");
                ArrayList srcDataList = new ArrayList(group.getSrcDataMap().values());
                srcDataMap.put(taxDataId, srcDataList);
            }
            BatchResult rollbackTaxDataDys = new BatchResult(true, taxDataDys);
            ArrayList<DynamicObject> delTaxDataDys = new ArrayList<DynamicObject>(delImportDataList.size());
            HashMap delSrcDataMap = new HashMap(delImportDataList.size());
            for (TaxDataSrcGroup group : delImportDataList) {
                DynamicObject taxData = (DynamicObject)group.getTaxData();
                long taxDataId = taxData.getLong("id");
                if (!needToCleanImportDataTaxDataIds.contains(taxDataId)) continue;
                delTaxDataDys.add(taxData);
                ArrayList srcDataList = new ArrayList(group.getSrcDataMap().values());
                delSrcDataMap.put(taxDataId, srcDataList);
            }
            BatchResult delImportTaxDataDys = new BatchResult(true, delTaxDataDys);
            GlobalParam.remove((String)"delImportTaxDataDys");
            GlobalParam.remove((String)"delSrcDataMap");
            GlobalParam.set((String)"delImportTaxDataDys", (Object)delImportTaxDataDys);
            GlobalParam.set((String)"delSrcDataMap", delSrcDataMap);
            BatchResult<DynamicObject> resultAfterOp = TaxDataServiceHelper.saveTaxData((BatchResult<DynamicObject>)rollbackTaxDataDys, this.taxTaskEntity, this.stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_EXPORT_REPORT, srcDataMap, true, new CustomFunction[0]);
            LOGGER.info("Trace By Quinn, {} - {} - {}", new Object[]{"resultAfterOp after save", resultAfterOp.isSuccess(), resultAfterOp.getMessage()});
            if (!resultAfterOp.isSuccess()) {
                result.addFailResult(result.getSuccessResult(), result.getMessage(), ResultStatusEnum.ERROR.getCode());
            }
            TaxTaskGuideServiceHelper.repackageResult((BatchResult<TaxDataSrcGroup<Long, DynamicObject>>)result, resultAfterOp);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when hand data", (Throwable)e);
            return new BatchResult(false, dataList);
        }
    }

    private boolean validateBizStatus(String bizStatus, String calStatus) {
        if (TaxTaskTypeEnum.TAX_IMPORT.getCode().equals(this.taxTaskEntity.getTaxTaskType()) && YesOrNoEnum.isYes((String)calStatus)) {
            return !TaxDataBizStatusEnum.EXPORT_LOCK.isLessEqThan(bizStatus) || !TaxDataBizStatusEnum.FEEDBACK.isGreaterThan(bizStatus);
        }
        return !TaxDataBizStatusEnum.EXPORT_LOCK.isLessEqThan(bizStatus) || !TaxDataBizStatusEnum.DECLARE.isGreaterThan(bizStatus);
    }

    private boolean containCalTaskId(Map<Long, DynamicObject> srcDataMap, long rawCalTaskId) {
        if (CollectionUtils.isEmpty(srcDataMap)) {
            return false;
        }
        for (Map.Entry<Long, DynamicObject> entry : srcDataMap.entrySet()) {
            if (entry.getValue().getLong("taxdatabasic.rawcaltask.id") != rawCalTaskId) continue;
            return true;
        }
        return false;
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u64a4\u9500\u9501\u5b9a", (String)"TaskGuideRollbackLockTask_1", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u64a4\u9500\u9501\u5b9a\u8fdb\u5ea6\u6761", (String)"TaskGuideRollbackLockTask_2", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected BaseResult<TaxDataSrcGroup<Long, DynamicObject>> afterHandleDataBatch(int status) {
        TaxTaskGuideCacheData from = new TaxTaskGuideCacheData(this.finalResult, this.taxTaskEntity, this.stepCaseInfo, this.opEnum);
        List failItemList = this.finalResult.getFailResultOriginal();
        HashMap<Long, String> idMsgMap = new HashMap<Long, String>(failItemList.size());
        HashMap<Integer, List<Long>> statusIdMap = new HashMap<Integer, List<Long>>(8);
        for (ResultItem item : failItemList) {
            long id = ((DynamicObject)((TaxDataSrcGroup)item.getData()).getTaxData()).getLong("id");
            idMsgMap.put(id, item.getMessage());
            int errorCode = item.getStatus();
            List ids = statusIdMap.computeIfAbsent(errorCode, key -> new ArrayList());
            ids.add(id);
        }
        List successResult = this.finalResult.getSuccessResult();
        List ids = statusIdMap.computeIfAbsent(ResultStatusEnum.INFO.getCode(), key -> new ArrayList());
        successResult.forEach(e1 -> ids.add(((DynamicObject)e1.getTaxData()).getLong("id")));
        from.setIdMsgMap(idMsgMap);
        from.setStatusIdMap(statusIdMap);
        PageCache pageCache = new PageCache(this.view.getPageId());
        pageCache.put("dataOfPrevRequest", SerializationUtils.toJsonString((Object)from));
        return super.afterHandleDataBatch(status);
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "afterProcessClose");
        return result;
    }
}

