/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListGridView;
import kd.bos.list.ListOperationColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.model.page.PageMultiThreadTask;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.poi.ss.usermodel.Workbook;

public class TaskGuideStep0RawDataDownLoadTask
extends PageMultiThreadTask<Map<String, Object>> {
    private final IFormView view;
    private final BillList billList;
    private final TaxTaskEntity taxTaskEntity;
    private WorkbookInfo workbookInfo;
    private ExportResult exportResult;
    private Map<String, Map<String, String>> combMapMap;
    private Object exportLogId;
    private List<String> props;
    private Map<String, IDataEntityProperty> desensitizeMap;
    private String queryProps;
    private List<QFilter> filters;
    private String orderBy;

    public TaskGuideStep0RawDataDownLoadTask(TaxTaskEntity taxTaskEntity, BillList billList) {
        this.view = billList.getView();
        this.billList = billList;
        this.taxTaskEntity = taxTaskEntity;
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        String tabName = this.getTabName();
        this.exportResult = new ExportResult(Integer.valueOf(0));
        String suffix = BaseDataConverter.formats((Object)new Date(), (String)"yyyyMMdd");
        String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_{0}_{1}", (String)"TaskGuideStep0RawDataDownLoadTask_0", (String)"sit-itc-business", (Object[])new Object[]{tabName, suffix});
        ListSelectedRowCollection selectedRows = this.billList.getSelectedRows();
        this.filters = new ArrayList<QFilter>(10);
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.filters.add(new QFilter("id", "in", (Object)selectedRows.getPrimaryKeyValues()));
        } else {
            this.filters = TaxTaskGuideViewHelper.fetchListDataProviderQFilters(this.view.getPageCache());
        }
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdatabasic").subProp("fseq", new String[]{"taxperson.name", "taxperson.number", "status", "declarestatus"});
        info.ignoreProp(new String[]{"multilanguagetext"});
        this.queryProps = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, null);
        this.orderBy = TaxTaskGuideViewHelper.fetchListDataProviderOrderBy(this.view.getPageCache());
        if (StringUtils.isEmpty((CharSequence)this.orderBy) || "id".equals(this.orderBy)) {
            this.orderBy = "taxfile.taxunit.id asc, id desc";
        } else if (!this.orderBy.contains(",id") && !this.orderBy.contains(", id")) {
            this.orderBy = this.orderBy + ", id desc";
        }
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("fileName", fileName);
        HashMap<String, BillList> sheetInfos = new HashMap<String, BillList>(2);
        params.put("sheetInfos", sheetInfos);
        HashMap<String, List<String>> ignoreFields = new HashMap<String, List<String>>(2);
        String key = (String)this.dataItemMap.entrySet().iterator().next().getKey();
        sheetInfos.put(key, this.billList);
        ignoreFields.put(key, Collections.singletonList("viewlogap"));
        params.put("ignoreFields", ignoreFields);
        this.workbookInfo = WorkbookInfoGenerator.generateWith((String)"billListExport", params);
        this.props = this.workbookInfo.getSheetInfo(key).getHeadCellBar().getContentHeadCellInfoList().stream().map(HeadCellInfo::getValueProp).collect(Collectors.toList());
        this.desensitizeMap = SitDataServiceHelper.generateDesensitizeMap((EntityType)this.billList.getEntityType(), this.props);
        this.combMapMap = SitDataServiceHelper.resolveCombValues((String)"itc_taxdatabasic", this.props);
        Tab tab = (Tab)this.view.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        this.exportLogId = ExportLogHelper.create((Object)"", (String)("itc_taxdatabasic" + this.taxTaskEntity.getId() + currentTab), (int)this.getTotalSize(), (String)"1");
        return BaseResult.success(null);
    }

    private String getTabName() {
        Tab tab = (Tab)this.view.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String tabName = "";
        if ("changedtab".equals(currentTab)) {
            tabName = ResManager.loadKDString((String)"\u672c\u671f\u53d8\u52a8", (String)"TaxFileTreeList4GuidePlugin_0", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        } else if ("unchangedtab".equals(currentTab)) {
            tabName = ResManager.loadKDString((String)"\u672a\u53d8\u52a8", (String)"TaxFileTreeList4GuidePlugin_1", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        } else if ("alltab".equals(currentTab)) {
            tabName = ResManager.loadKDString((String)"\u5168\u90e8", (String)"TaxFileTreeList4GuidePlugin_2", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        }
        return tabName;
    }

    protected List<Map<String, Object>> queryData(String str, int pageIndex, int pageSize) {
        this.billList.getDataPermQFilters();
        DynamicObject[] taxFiles = BusinessDataServiceHelper.load((String)"itc_taxdatabasic", (String)this.queryProps, (QFilter[])this.filters.toArray(new QFilter[0]), (String)this.orderBy, (int)pageIndex, (int)pageSize);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject taxFile : taxFiles) {
            dataList.add(this.packageData(taxFile));
        }
        return dataList;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        List dataList = dataBatch.getDataList();
        try {
            int startIndex = dataBatch.getStartIndex();
            for (int i = 0; i < dataList.size(); ++i) {
                ((Map)dataList.get(i)).put("fseq", startIndex + i + 1);
            }
            ExcelHelper.writeData((WorkbookInfo)this.workbookInfo, dataBatch, (ExportResult)this.exportResult);
        }
        catch (Exception e) {
            this.exportResult.addMessage(e.getMessage());
            return new BatchResult(false, dataList);
        }
        return new BatchResult(true, dataList);
    }

    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        HashMap<String, String> cond = new HashMap<String, String>(2);
        if (status == 0 && this.workbookInfo.getWorkbook() != null) {
            String url = ExcelHelper.storeFile((Workbook)this.workbookInfo.getWorkbook(), (String)this.workbookInfo.fullName());
            cond.put("url", url);
            this.exportLog(this.getTotalSize(), url, this.exportResult.generateMessage(255));
        } else {
            this.exportLog(0, "", this.exportResult.generateMessage(255));
        }
        this.processHandler.close(cond);
        return BaseResult.success(null);
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "downloadClose");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u5217\u8868\u6570\u636e\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"TaskGuideStep0RawDataDownLoadTask_1", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"TaxTaskGuideDownLoadTask_1", (String)"sit-itc-formplugin", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    private Map<String, Object> packageData(DynamicObject taxFile) {
        HashMap<String, Object> cond = new HashMap<String, Object>(32);
        for (String string : this.props) {
            try {
                IDataEntityProperty property = this.desensitizeMap.get(string);
                if (property != null) {
                    Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)taxFile, (Object)taxFile.get(string));
                    cond.put(string, desensitizeValue);
                    continue;
                }
                cond.put(string, taxFile.get(string));
            }
            catch (Exception exception) {}
        }
        for (Map.Entry entry : this.combMapMap.entrySet()) {
            if (this.desensitizeMap.get(entry.getKey()) != null) continue;
            cond.put((String)entry.getKey(), ((Map)entry.getValue()).get(cond.get(entry.getKey())));
        }
        return cond;
    }

    private void exportLog(int complete, String url, String data) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)this.exportLogId, (DynamicObjectType)objType);
        List successResult = this.finalResult.getSuccessResult();
        dyn.set("total", (Object)(successResult.size() + this.finalResult.getFailResultOriginal().size()));
        dyn.set("complete", (Object)successResult.size());
        dyn.set("downloadurl", (Object)url);
        dyn.set("logs", (Object)data);
        dyn.set("exportstatus", (Object)"1");
        dyn.set("finishtime", (Object)new Date());
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    public static String getBillListOrderBy(IFormView view, BillList billList) {
        String orderBy = billList.generalFilterParameter().getOrderBy();
        if (!StringUtils.isBlank((CharSequence)orderBy)) {
            return orderBy;
        }
        StringBuilder defaultOrderBuilder = new StringBuilder();
        ListGridView listGridView = (ListGridView)view.getControl(billList.getListGridViewKey());
        List items = listGridView.getItems();
        for (int i = 0; i < items.size(); ++i) {
            String tempOrder;
            IListColumn column = (IListColumn)items.get(i);
            if (column instanceof ListOperationColumn || StringUtils.equals((CharSequence)(tempOrder = column.getOrder()), (CharSequence)"NotOrder")) continue;
            defaultOrderBuilder.append(column.getListFieldKey()).append(' ').append(tempOrder).append(',');
        }
        String defaultOrder = defaultOrderBuilder.toString();
        if (!StringUtils.isBlank((CharSequence)defaultOrder)) {
            defaultOrder = defaultOrder.substring(0, defaultOrderBuilder.length() - 1);
        }
        return defaultOrder;
    }
}

