/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.business.taxtaskguide.task.TaxDataBasicInitTask;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.poi.ss.usermodel.Workbook;

public class TaxDataBasicDownLoadTask
extends AssignMultiThreadTask<Map<String, Object>> {
    public static final String BY_FILE_ID = "0";
    public static final String BY_DATA_BASIC_ID = "1";
    public static final String BY_FILE = "2";
    public static final String BY_DATA_BASIC = "3";
    private final IFormView view;
    private final TaxTaskEntity taxTaskEntity;
    private TaxItemEntity[] deductionItems;
    private final BillList billList;
    private ExportResult exportResult;
    private Object exportLogId;
    private WorkbookInfo workbookInfo;
    private List<String> props;
    private String queryPropStr;
    private Map<String, Map<String, String>> combMapMap;
    private Map<String, IDataEntityProperty> desensitizeMap;
    private String prepareStatus;
    private String orderBy;
    private String byKey;

    public TaxDataBasicDownLoadTask(TaxTaskEntity taxTaskEntity, BillList billList, String byKey) {
        this.taxTaskEntity = taxTaskEntity;
        this.billList = billList;
        this.view = billList.getView();
        this.byKey = byKey;
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        this.exportResult = new ExportResult(Integer.valueOf(0));
        String suffix = BaseDataConverter.formats((Object)new Date(), (String)"MMdd");
        String fileName = ResManager.loadKDString((String)"\u5bfc\u51fa\u7b97\u7a0e\u51c6\u5907\u6570\u636e_{0}", (String)"TaxDataBasicDownLoadTask_0", (String)"sit-itc-business", (Object[])new Object[]{suffix});
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("fileName", fileName);
        HashMap<String, BillList> sheetInfos = new HashMap<String, BillList>(2);
        params.put("sheetInfos", sheetInfos);
        String key = (String)this.dataItemMap.entrySet().iterator().next().getKey();
        sheetInfos.put(key, this.billList);
        this.workbookInfo = WorkbookInfoGenerator.generateWith((String)"billListExport", params);
        this.props = this.workbookInfo.getSheetInfo(key).getHeadCellBar().getContentHeadCellInfoList().stream().map(HeadCellInfo::getValueProp).collect(Collectors.toList());
        HashSet propSet = Sets.newHashSet((Object[])new String[]{"id", "taxfile", "taxtask", "taxperson", "bizstatus"});
        StringBuilder query = new StringBuilder("id,taxfile,taxtask,taxperson,bizstatus");
        DataEntityPropertyCollection properties = this.billList.getEntityType().getProperties();
        for (String prop : this.props) {
            int index = prop.indexOf(46);
            if (index > 0) {
                prop = prop.substring(0, index);
            }
            if (!propSet.add(prop) || !properties.containsKey((Object)prop)) continue;
            query.append(',').append(prop);
        }
        this.queryPropStr = query.toString();
        this.orderBy = TaxTaskGuideViewHelper.fetchListDataProviderOrderBy(this.view.getPageCache());
        if (StringUtils.isEmpty((String)this.orderBy) || "id".equals(this.orderBy)) {
            this.orderBy = "taxfile.taxunit.id asc, id desc";
        } else if (!this.orderBy.contains(",id") && !this.orderBy.contains(", id")) {
            this.orderBy = this.orderBy + ", id desc";
        }
        this.desensitizeMap = SitDataServiceHelper.generateDesensitizeMap((EntityType)this.billList.getEntityType(), this.props);
        this.combMapMap = SitDataServiceHelper.resolveCombValues((String)"itc_taxpreparedata", null);
        this.exportLogId = ExportLogHelper.create((Object)"", (String)("itc_taxpreparedata" + this.taxTaskEntity.getId()), (int)this.getTotalSize(), (String)BY_DATA_BASIC_ID);
        this.prepareStatus = this.taxTaskEntity.isPrepared() ? ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"TaxPrepareDataList_6", (String)"sit-itc-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u5b8c\u6210", (String)"TaxPrepareDataList_5", (String)"sit-itc-formplugin", (Object[])new Object[0]);
        return BaseResult.success(null);
    }

    protected List<Map<String, Object>> queryData(String key, List<?> keys) {
        HRBaseServiceHelper dataServiceHelper = new HRBaseServiceHelper("itc_taxpreparedata");
        HRBaseServiceHelper fileServiceHelper = new HRBaseServiceHelper("itc_taxfile");
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(keys.size());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        switch (this.byKey) {
            case "0": {
                DynamicObject[] taxFiles;
                QFilter idFilter = new QFilter("id", "in", keys);
                for (DynamicObject taxFile : taxFiles = fileServiceHelper.query("id,taxfile,taxtask,taxperson,bizstatus", new QFilter[]{idFilter})) {
                    dataList.add(this.packageData(BY_FILE, taxFile, null));
                }
                break;
            }
            case "1": {
                QFilter dataBasicIdsFilter = new QFilter("id", "in", keys);
                DynamicObject[] taxDataBasic = dataServiceHelper.query(this.queryPropStr, new QFilter[]{dataBasicIdsFilter}, this.orderBy);
                qFilters.add(new QFilter("taxdatabasic.id", "in", keys));
                Map<Long, Map<String, Object>> deductMap = TaxDataBasicInitTask.queryDeductionData(this.taxTaskEntity, this.deductionItems, qFilters);
                for (DynamicObject basic : taxDataBasic) {
                    dataList.add(this.packageData(BY_DATA_BASIC, basic, deductMap.get(basic.getLong("taxfile.boid"))));
                }
                break;
            }
            case "2": {
                List taxIdFiles = keys.stream().map(e1 -> ((DynamicObject)e1).getLong("id")).collect(Collectors.toList());
                qFilters.add(new QFilter("taxfile.id", "in", taxIdFiles));
                Map<Long, Map<String, Object>> deductMap = TaxDataBasicInitTask.queryDeductionData(this.taxTaskEntity, this.deductionItems, qFilters);
                for (Object k1 : keys) {
                    DynamicObject taxFile = (DynamicObject)k1;
                    dataList.add(this.packageData(BY_FILE, taxFile, deductMap.get(taxFile.getLong("taxfile.boid"))));
                }
                break;
            }
        }
        return dataList;
    }

    private Map<String, Object> packageData(String byFile, DynamicObject taxFile, Map<String, Object> deduct) {
        Object desensitizeValue;
        HashMap<String, Object> cond = new HashMap<String, Object>(32);
        if (BY_DATA_BASIC.equals(byFile)) {
            for (String string : this.props) {
                try {
                    IDataEntityProperty property2 = this.desensitizeMap.get(string);
                    if (property2 != null) {
                        desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property2, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)taxFile, (Object)taxFile.get(string));
                        cond.put(string, desensitizeValue);
                        continue;
                    }
                    cond.put(string, taxFile.get(string));
                }
                catch (Exception property2) {}
            }
        } else {
            for (String string : this.props) {
                if (string.startsWith("taxfile.")) {
                    String fileProp = string.substring(8);
                    try {
                        IDataEntityProperty property3 = this.desensitizeMap.get(string);
                        if (property3 != null) {
                            desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property3, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)taxFile, (Object)taxFile.get(string));
                            cond.put(string, desensitizeValue);
                            continue;
                        }
                        cond.put(string, taxFile.get(fileProp));
                    }
                    catch (Exception exception) {}
                    continue;
                }
                try {
                    IDataEntityProperty property = this.desensitizeMap.get(string);
                    if (property != null) {
                        desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)taxFile, (Object)taxFile.get(string));
                        cond.put(string, desensitizeValue);
                        continue;
                    }
                    cond.put(string, taxFile.get(string));
                }
                catch (Exception exception) {}
            }
        }
        if (deduct == null) {
            cond.put("bizstatus", BY_FILE_ID);
        } else {
            cond.put("bizstatus", BY_DATA_BASIC_ID);
            cond.put("refstatus", deduct.remove("refstatus"));
            for (Map.Entry entry : deduct.entrySet()) {
                if (!(entry.getValue() instanceof DynamicObject)) continue;
                cond.put((String)entry.getKey(), ((DynamicObject)entry.getValue()).getString("itemvalue"));
            }
        }
        for (Map.Entry entry : this.combMapMap.entrySet()) {
            if (this.desensitizeMap.get(entry.getKey()) != null) continue;
            cond.put((String)entry.getKey(), ((Map)entry.getValue()).get(cond.get(entry.getKey())));
        }
        cond.put("taxtask.taskstatus", this.prepareStatus);
        return cond;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        List dataList = dataBatch.getDataList();
        try {
            int startIndex = dataBatch.getStartIndex();
            for (int i = 0; i < dataList.size(); ++i) {
                ((Map)dataList.get(i)).put("fseq", startIndex + i + 1);
            }
            ExcelHelper.writeData((WorkbookInfo)this.workbookInfo, dataBatch, (ExportResult)this.exportResult);
        }
        catch (Exception e) {
            this.exportResult.addMessage(e.getMessage());
            return new BatchResult(false, dataList);
        }
        return new BatchResult(true, dataList);
    }

    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        HashMap<String, String> cond = new HashMap<String, String>(2);
        if (status == 0 && this.workbookInfo.getWorkbook() != null) {
            String url = ExcelHelper.storeFile((Workbook)this.workbookInfo.getWorkbook(), (String)this.workbookInfo.fullName());
            cond.put("url", url);
            this.exportLog(this.getTotalSize(), url, this.exportResult.generateMessage(255));
        } else {
            this.exportLog(0, "", this.exportResult.generateMessage(255));
        }
        this.processHandler.close(cond);
        GlobalParam.remove();
        return BaseResult.success(null);
    }

    private void exportLog(int complete, String url, String data) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)this.exportLogId, (DynamicObjectType)objType);
        List successResult = this.finalResult.getSuccessResult();
        dyn.set("total", (Object)(successResult.size() + this.finalResult.getFailResultOriginal().size()));
        dyn.set("complete", (Object)successResult.size());
        dyn.set("downloadurl", (Object)url);
        dyn.set("logs", (Object)data);
        dyn.set("exportstatus", (Object)BY_DATA_BASIC_ID);
        dyn.set("finishtime", (Object)new Date());
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "downloadClose");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u4e2a\u7a0e\u8bb0\u5f55\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"TaxTaskGuideDownLoadTask_2", (String)"sit-itc-formplugin", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"TaxTaskGuideDownLoadTask_1", (String)"sit-itc-formplugin", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected long dealNum() {
        if (this.exportResult == null) {
            return 0L;
        }
        return this.exportResult.dealNum();
    }

    protected void appendLog(String msg) {
        this.exportResult.addMessage(msg);
    }

    public void setDeductionItems(TaxItemEntity[] deductionItems) {
        this.deductionItems = deductionItems;
    }
}

