/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxItemEntity;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.YesOrNoEnum;
import kd.sit.sitbp.common.model.Pair;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class TaxDataBasicInitTask
extends AssignMultiThreadTask<Pair<DynamicObject, DynamicObject>> {
    public static final String TAX_FILE = "taxfile";
    public static final String TAX_PERSON = "taxperson";
    public static final String YEAR_MONTH = "yearmonth";
    public static final String BIZ_STATUS = "bizstatus";

    protected List<Pair<DynamicObject, DynamicObject>> queryData(String needSearch, List<?> list) {
        return null;
    }

    protected BatchResult<Pair<DynamicObject, DynamicObject>> handleData(DataBatch<Pair<DynamicObject, DynamicObject>> dataBatch) {
        return null;
    }

    protected ProcessHandler openProcessHandler() {
        return ProcessHandler.DEFAULT;
    }

    public static String keyFromItemNumber(String number) {
        return number.replace("_", "").toLowerCase();
    }

    public static Map<Long, Map<String, Object>> queryDeductionData(TaxTaskEntity taxTaskEntity, TaxItemEntity[] taxItemEntities, List<QFilter> filters) {
        Set itemIds = Arrays.stream(taxItemEntities).map(TaxItemEntity::getId).collect(Collectors.toSet());
        QFilter itemFileFilter = new QFilter("entryentity.taxitem.id", "in", itemIds);
        filters.add(itemFileFilter);
        return TaxDataBasicInitTask.getDeductMapOfFile(taxTaskEntity, filters);
    }

    public static Map<Long, Map<String, Object>> queryDeductionData(TaxTaskEntity taxTaskEntity, long taxCategoryId, List<QFilter> filters) {
        QFilter categoryFilter = new QFilter("taxcategory.id", "in", (Object)taxCategoryId);
        filters.add(categoryFilter);
        return TaxDataBasicInitTask.getDeductMapOfFile(taxTaskEntity, filters);
    }

    private static Map<Long, Map<String, Object>> getDeductMapOfFile(TaxTaskEntity taxTaskEntity, List<QFilter> filters) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdeduct");
        QFilter taskFilter = new QFilter(YEAR_MONTH, "=", (Object)taxTaskEntity.yearMonth());
        QFilter taskIdFilter = new QFilter("taxtask.id", "=", (Object)taxTaskEntity.getId());
        QFilter bizStatusFilter = new QFilter(BIZ_STATUS, "=", (Object)YesOrNoEnum.YES.getCode());
        filters.add(taskFilter);
        filters.add(taskIdFilter);
        filters.add(bizStatusFilter);
        DynamicObject[] query = serviceHelper.query("id,taxdatabasic,taxfile,refoprecord,entryentity.taxitem,entryentity.taxitem.name,entryentity.taxitem.number,entryentity.itemvalue,entryentity.currency", filters.toArray(new QFilter[0]));
        HashMap result = Maps.newHashMapWithExpectedSize((int)query.length);
        for (DynamicObject object : query) {
            Map map = result.computeIfAbsent(object.getLong("taxfile.boid"), key -> new HashMap(16));
            map.put("refstatus", object.getString("refoprecord.result"));
            DynamicObjectCollection entries = object.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                map.put(TaxDataBasicInitTask.keyFromItemNumber(entry.getString("taxitem.number")), entry);
            }
        }
        return result;
    }
}

