/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideServiceHelper;
import kd.sit.itc.business.taxtaskguide.model.TaxTaskGuideCacheData;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxDataBizStatusEnum;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.CustomFunction;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.KeyGenerator;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.api.StatusInfo;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.ResultStatusEnum;
import kd.sit.sitbp.common.enums.RollbackConfirmEnum;
import kd.sit.sitbp.common.model.TaxDataSrcGroup;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.ResultItem;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class TaxGuideRollbackConfirmTask
extends AssignMultiThreadTask<TaxDataSrcGroup<Long, DynamicObject>> {
    private static final Log LOGGER = LogFactory.getLog(TaxGuideRollbackConfirmTask.class);
    private final IFormView view;
    private final TaxTaskEntity taxTaskEntity;
    private final TaxTaskGuideStepCaseInfo stepCaseInfo;
    private final TaxTaskGuideOpEnum opEnum;

    public TaxGuideRollbackConfirmTask(IFormView view, TaxTaskEntity taxTaskEntity, TaxTaskGuideStepCaseInfo stepCaseInfo, TaxTaskGuideOpEnum opEnum) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
        this.opEnum = opEnum;
    }

    protected List<TaxDataSrcGroup<Long, DynamicObject>> queryData(String key, List<?> ids) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("id", "in", ids));
        qFilters.add(new QFilter("yearmonth", "=", (Object)this.taxTaskEntity.yearMonth()));
        List<DynamicObject> taxDataList = TaxTaskGuideServiceHelper.loadTaxData(qFilters);
        qFilters.clear();
        qFilters.add(new QFilter("taxdata", "in", ids));
        qFilters.add(new QFilter("yearmonth", "=", (Object)this.taxTaskEntity.yearMonth()));
        DynamicObject[] taxSrcDataArr = TaxTaskGuideServiceHelper.loadTaxSrcData(qFilters);
        HashMap dataSrcGroupMap = new HashMap(taxDataList.size());
        taxDataList.forEach(e1 -> dataSrcGroupMap.put(e1.getLong("id"), new TaxDataSrcGroup(e1, KeyGenerator.DYNAMIC_OBJ_GENERATOR)));
        for (DynamicObject srcData : taxSrcDataArr) {
            TaxDataSrcGroup taxDataSrcGroup = (TaxDataSrcGroup)dataSrcGroupMap.get(srcData.getLong("taxdata"));
            if (taxDataSrcGroup == null) continue;
            taxDataSrcGroup.addTaxSrcData((Object)srcData);
        }
        return Lists.newArrayList(dataSrcGroupMap.values());
    }

    protected BatchResult<TaxDataSrcGroup<Long, DynamicObject>> handleData(DataBatch<TaxDataSrcGroup<Long, DynamicObject>> dataBatch) {
        List dataList = dataBatch.getDataList();
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return new BatchResult(true, dataList);
        }
        BatchResult result = new BatchResult(new ArrayList(dataList.size()), new ArrayList(dataList.size()));
        for (TaxDataSrcGroup group : dataList) {
            DynamicObject taxData = (DynamicObject)group.getTaxData();
            String taxDataBizStatus = taxData.getString("bizstatus");
            if (TaxDataBizStatusEnum.CONFIRM.isLessThan(taxDataBizStatus)) {
                result.addFailItem((Object)group, (StatusInfo)RollbackConfirmEnum.END_FAIL, new Object[]{taxData.getString("taxfile.number"), taxData.getString("taxfile.person.name"), TaxDataBizStatusEnum.getI18nNameByCode((String)taxDataBizStatus)});
                continue;
            }
            result.addSuccessResult((Object)group);
        }
        List successResult = result.getSuccessResult();
        List taxDataDys = successResult.stream().map(e1 -> (DynamicObject)e1.getTaxData()).collect(Collectors.toList());
        BatchResult rollbackConfirmTaxDataDys = new BatchResult(true, taxDataDys);
        BatchResult<DynamicObject> resultAfterOp = TaxDataServiceHelper.saveTaxData((BatchResult<DynamicObject>)rollbackConfirmTaxDataDys, this.taxTaskEntity, this.stepCaseInfo, TaxTaskGuideOpEnum.ROLLBACK_CONFIRM, true, new CustomFunction[0]);
        if (!resultAfterOp.isSuccess()) {
            result.addFailResult(result.getSuccessResult(), result.getMessage(), ResultStatusEnum.ERROR.getCode());
        }
        TaxTaskGuideServiceHelper.repackageResult((BatchResult<TaxDataSrcGroup<Long, DynamicObject>>)result, resultAfterOp);
        return result;
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u64a4\u9500\u786e\u8ba4\u7ed3\u679c", (String)"TaxGuideRollbackConfirmTask_0", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u64a4\u9500\u786e\u8ba4\u7ed3\u679c\u8fdb\u5ea6\u6761", (String)"TaxGuideRollbackConfirmTask_1", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected BaseResult<TaxDataSrcGroup<Long, DynamicObject>> afterHandleDataBatch(int status) {
        TaxTaskGuideCacheData from = new TaxTaskGuideCacheData(this.finalResult, this.taxTaskEntity, this.stepCaseInfo, this.opEnum);
        List failItemList = this.finalResult.getFailResultOriginal();
        HashMap<Long, String> idMsgMap = new HashMap<Long, String>(failItemList.size());
        HashMap<Integer, List<Long>> statusIdMap = new HashMap<Integer, List<Long>>(8);
        for (ResultItem item : failItemList) {
            long id = ((DynamicObject)((TaxDataSrcGroup)item.getData()).getTaxData()).getLong("id");
            idMsgMap.put(id, item.getMessage());
            int errorCode = item.getStatus();
            List ids = statusIdMap.computeIfAbsent(errorCode, key -> new ArrayList());
            ids.add(id);
        }
        List successResult = this.finalResult.getSuccessResult();
        List ids = statusIdMap.computeIfAbsent(ResultStatusEnum.INFO.getCode(), key -> new ArrayList());
        successResult.forEach(e1 -> ids.add(((DynamicObject)e1.getTaxData()).getLong("id")));
        from.setIdMsgMap(idMsgMap);
        from.setStatusIdMap(statusIdMap);
        PageCache pageCache = new PageCache(this.view.getPageId());
        pageCache.put("dataOfPrevRequest", SerializationUtils.toJsonString((Object)from));
        return super.afterHandleDataBatch(status);
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "afterProcessClose");
        return result;
    }
}

