/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.data.ExportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.common.model.TaxDataItemWrapper;
import kd.sit.itc.business.taxdata.TaxDataServiceHelper;
import kd.sit.itc.business.taxtaskguide.TaxTaskGuideViewHelper;
import kd.sit.itc.common.model.TaxTaskGuideStepCaseInfo;
import kd.sit.sitbp.business.enums.TaxTaskGuideOpEnum;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.business.helper.excel.ExcelHelper;
import kd.sit.sitbp.business.helper.excel.model.ExportResult;
import kd.sit.sitbp.business.helper.excel.model.HeadCellInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfo;
import kd.sit.sitbp.business.helper.excel.model.WorkbookInfoGenerator;
import kd.sit.sitbp.business.servicehelper.SitDataServiceHelper;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.model.PropertiesQueryInfo;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.GlobalParam;
import kd.sit.sitbp.common.util.async.model.page.PageMultiThreadTask;
import kd.sit.sitbp.common.util.datatype.BaseDataConverter;
import org.apache.poi.ss.usermodel.Workbook;

public class TaxTaskGuideDownLoadTask
extends PageMultiThreadTask<Map<String, Object>> {
    private static final Log LOGGER = LogFactory.getLog(TaxTaskGuideDownLoadTask.class);
    private final IFormView view;
    private final BillList billList;
    private final TaxTaskEntity taxTaskEntity;
    private final TaxTaskGuideStepCaseInfo stepCaseInfo;
    private WorkbookInfo workbookInfo;
    private ExportResult exportResult;
    private Map<String, Map<String, String>> combMapMap;
    private Object exportLogId;
    private List<Object> ids;
    private List<QFilter> filters;
    private List<String> props;
    private String queryProps;
    private String orderBy;
    private boolean containRawData = true;
    private final Map<Integer, Integer> customSeqMap = new HashMap<Integer, Integer>();
    private final AtomicInteger customSeqIndex = new AtomicInteger();
    private final AtomicInteger startIndex = new AtomicInteger();
    private Map<String, IDataEntityProperty> desensitizeMap;

    public TaxTaskGuideDownLoadTask(TaxTaskEntity taxTaskEntity, BillList billList, TaxTaskGuideStepCaseInfo stepCaseInfo) {
        this.view = billList.getView();
        this.billList = billList;
        this.taxTaskEntity = taxTaskEntity;
        this.stepCaseInfo = stepCaseInfo;
    }

    protected BaseResult<?> beforePrepareDataBatch() {
        this.exportResult = new ExportResult(Integer.valueOf(0));
        LOGGER.info("TaxTaskGuideDownLoadTask.beforePrepareDataBatch");
        String type = this.stepCaseInfo.tabByGroup() ? this.taxTaskEntity.getTaxGroup(this.stepCaseInfo.getTabValue()).getNameLocaleString().getLocaleValue() : this.taxTaskEntity.getTaxCategory(this.stepCaseInfo.getTabValue()).getNameLocaleString().getLocaleValue();
        String suffix = BaseDataConverter.formats((Object)new Date(), (String)"MMdd");
        String prefix = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_", (String)"TaxTaskGuideDownLoadTask_3", (String)"sit-itc-business", (Object[])new Object[0]);
        String fileName = ResManager.loadKDString((String)(prefix + type + "_" + suffix), (String)"TaxTaskGuideDownLoadTask_4", (String)"sit-itc-formplugin", (Object[])new Object[]{type, suffix});
        HashMap<String, Object> params = new HashMap<String, Object>(4);
        params.put("fileName", fileName);
        ListSelectedRowCollection selectedRows = this.billList.getSelectedRows();
        if (!CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.ids = Arrays.asList(selectedRows.getPrimaryKeyValues());
        } else {
            this.filters = TaxTaskGuideViewHelper.fetchListDataProviderQFilters(this.view.getPageCache());
        }
        this.orderBy = TaxTaskGuideViewHelper.fetchListDataProviderOrderBy(this.view.getPageCache());
        if (StringUtils.isEmpty((String)this.orderBy) || "id".equals(this.orderBy)) {
            this.orderBy = "taxfile.taxunit.id asc, id desc";
        } else if (!this.orderBy.contains(",id") && !this.orderBy.contains(", id")) {
            this.orderBy = this.orderBy + ", id desc";
        }
        HashMap<String, BillList> sheetInfos = new HashMap<String, BillList>(2);
        params.put("sheetInfos", sheetInfos);
        String dataKey = (String)this.dataItemMap.entrySet().iterator().next().getKey();
        sheetInfos.put(dataKey, this.billList);
        HashMap<String, List<String>> ignoreFields = new HashMap<String, List<String>>(2);
        params.put("ignoreFields", ignoreFields);
        ignoreFields.put(dataKey, Arrays.asList("srcrefnum", "id"));
        this.workbookInfo = WorkbookInfoGenerator.generateWith((String)"billListExport", params);
        PropertiesQueryInfo info = new PropertiesQueryInfo("itc_taxdata").subProp("entryentity", new String[]{"taxitem", "taxcategory", "taxcategory.group", "itemvalue", "calvalue"});
        this.queryProps = SitDataServiceHelper.toQueryProperties((PropertiesQueryInfo)info, null);
        List headCellInfoList = this.workbookInfo.getSheetInfo(dataKey).getHeadCellBar().getContentHeadCellInfoList();
        this.props = CollectionUtils.isEmpty((Collection)headCellInfoList) ? new ArrayList<String>(10) : headCellInfoList.stream().map(HeadCellInfo::getValueProp).collect(Collectors.toList());
        this.desensitizeMap = SitDataServiceHelper.generateDesensitizeMap((EntityType)this.billList.getEntityType(), this.props);
        this.combMapMap = SitDataServiceHelper.resolveCombValues((String)"itc_taxdataguidequery", this.props);
        this.exportLogId = ExportLogHelper.create((Object)"", (String)("itc_taxdata" + this.taxTaskEntity.getId()), (int)this.getTotalSize(), (String)"1");
        return BaseResult.success(null);
    }

    protected List<Map<String, Object>> keysAdapterToData(int pageIndex, int pageSize) {
        ArrayList result = Lists.newArrayListWithCapacity((int)pageSize);
        for (int i = 0; i < pageSize; ++i) {
            result.add(Maps.newHashMap());
        }
        return result;
    }

    protected List<Map<String, Object>> queryData(String key, int pageIndex, int pageSize) {
        LOGGER.info("TaxTaskGuideDownLoadTask.queryData");
        try {
            ArrayList result;
            DynamicObject[] taxSrcData;
            DynamicObject[] objects;
            if (this.ids != null) {
                LOGGER.info("By Quinn query By Id {}", (Object)this.orderBy);
                int fromIndex = pageIndex * pageSize;
                int toIndex = (pageIndex + 1) * pageSize;
                toIndex = Math.min(toIndex, this.ids.size());
                List<Object> keys = this.ids.subList(fromIndex, toIndex);
                HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("itc_taxdata");
                QFilter idFilter = new QFilter("id", "in", keys);
                QFilter yearMonthFilter = new QFilter("yearmonth", "=", (Object)this.taxTaskEntity.yearMonth());
                objects = serviceHelper.query(this.queryProps, new QFilter[]{idFilter, yearMonthFilter}, this.orderBy);
            } else {
                LOGGER.info("By Quinn query By Page {}", (Object)this.orderBy);
                objects = BusinessDataServiceHelper.load((String)"itc_taxdata", (String)this.queryProps, (QFilter[])this.filters.toArray(new QFilter[0]), (String)this.orderBy, (int)pageIndex, (int)pageSize);
            }
            Map<Long, List<DynamicObject>> srcDataMap = null;
            if (this.containRawData) {
                taxSrcData = TaxDataServiceHelper.queryTaxSrcData(this.taxTaskEntity, Arrays.stream(objects).map(e1 -> e1.getLong("id")).toArray(Long[]::new), this.queryProps + ",taxdata");
                result = Lists.newArrayListWithCapacity((int)(objects.length + taxSrcData.length));
                srcDataMap = Arrays.stream(taxSrcData).collect(Collectors.groupingBy(e1 -> e1.getLong("taxdata")));
            } else if (this.props.contains("taxdatabasic.srcstatus")) {
                taxSrcData = TaxDataServiceHelper.queryTaxSrcData(this.taxTaskEntity, Arrays.stream(objects).map(e1 -> e1.getLong("id")).toArray(Long[]::new), "taxdatabasic.srcstatus,taxdata");
                result = Lists.newArrayListWithCapacity((int)(objects.length + taxSrcData.length));
                srcDataMap = Arrays.stream(taxSrcData).collect(Collectors.groupingBy(e1 -> e1.getLong("taxdata")));
            } else {
                result = Lists.newArrayListWithCapacity((int)objects.length);
            }
            this.customSeqMap.put(pageIndex, objects.length);
            for (int i = 0; i < objects.length; ++i) {
                List<DynamicObject> srcList;
                DynamicObject object = objects[i];
                long id = object.getLong("id");
                List<DynamicObject> list = srcList = srcDataMap == null ? null : srcDataMap.get(id);
                if (srcList != null) {
                    srcList.sort(Comparator.comparingLong(o -> o.getLong("id")));
                }
                this.calculateSrcStatus(object, srcList);
                Map<String, Object> map = this.packageData(object);
                result.add(map);
                map.put("customseq", i + 1);
                String incomeItem = this.taxTaskEntity.getTaxCategory(Long.valueOf(object.getLong("taxcategory.id"))).getIncomeItemLocaleString();
                map.put("incomeitem", incomeItem);
                if (srcList == null || srcList.size() < 2) continue;
                for (int j = 0; j < srcList.size(); ++j) {
                    DynamicObject src = srcList.get(j);
                    Map<String, Object> map1 = this.packageData(src);
                    result.add(map1);
                    map1.put("incomeitem", incomeItem);
                    map1.put("customseq", i + 1 + "." + (j + 1));
                }
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error occurs when query data", (Throwable)e);
            this.exportResult.addMessage(e.getMessage());
            throw e;
        }
    }

    private void calculateSrcStatus(DynamicObject taxData, List<DynamicObject> srcList) {
        DynamicObject taxDataBasic = taxData.getDynamicObject("taxdatabasic");
        if (CollectionUtils.isEmpty(srcList)) {
            taxDataBasic.set("srcstatus", (Object)"0");
        } else {
            String srcStatus = srcList.get(0).getString("taxdatabasic.srcstatus");
            if (srcList.size() > 1) {
                for (int i = 1; i < srcList.size(); ++i) {
                    if (Objects.equals(srcStatus, srcList.get(i).getString("taxdatabasic.srcstatus"))) continue;
                    return;
                }
            }
            taxDataBasic.set("srcstatus", (Object)srcStatus);
        }
    }

    private Map<String, Object> packageData(DynamicObject object) {
        TaxTaskGuideOpEnum.convertStatus((DynamicObject)object);
        TaxDataItemWrapper wrapper = new TaxDataItemWrapper(object, "step40".equals(this.stepCaseInfo.getStepCode()) ? "calvalue" : "itemvalue");
        HashMap<String, Object> result = new HashMap<String, Object>(64);
        for (String prop : this.props) {
            IDataEntityProperty property;
            Object value = wrapper.getValue(prop);
            Map<String, String> combMap = this.combMapMap.get(prop);
            if (combMap != null) {
                value = combMap.get(value);
            } else if (value instanceof ILocaleString) {
                value = value.toString();
            }
            if (prop.equals("hasdifference")) {
                value = (Boolean)value != false ? ResManager.loadKDString((String)"\u662f", (String)"TaxExportHelper_3", (String)"sit-itc-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TaxExportHelper_4", (String)"sit-itc-business", (Object[])new Object[0]);
            }
            if ((property = this.desensitizeMap.get(prop)) != null) {
                Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((IDataEntityProperty)property, (String)Lang.get().toString(), (String)"EXPORT", (DynamicObject)object, (Object)value);
                result.put(prop, desensitizeValue);
                continue;
            }
            result.put(prop, value);
        }
        return result;
    }

    protected BatchResult<Map<String, Object>> handleData(DataBatch<Map<String, Object>> dataBatch) {
        LOGGER.info("TaxTaskGuideDownLoadTask.handleData");
        List dataList = dataBatch.getDataList();
        int customSeqBatch = this.customSeqIndex.getAndAdd(this.customSeqMap.get(dataBatch.getBatchIndex()));
        for (Map map : dataList) {
            Object customSeq = map.get("customseq");
            if (customSeq instanceof Integer) {
                map.put("customseq", (Integer)customSeq + customSeqBatch);
                continue;
            }
            if (!(customSeq instanceof String)) continue;
            String seq = (String)customSeq;
            int index = seq.indexOf(46);
            map.put("customseq", Integer.parseInt(seq.substring(0, index)) + customSeqBatch + seq.substring(index));
        }
        int startIndexBatch = this.startIndex.getAndAdd(dataList.size());
        dataBatch.setStartIndex(startIndexBatch);
        try {
            ExcelHelper.writeData((WorkbookInfo)this.workbookInfo, dataBatch, (ExportResult)this.exportResult);
        }
        catch (Exception e) {
            this.exportResult.addMessage(e.getMessage());
            return new BatchResult(false, dataList);
        }
        return new BatchResult(true, dataList);
    }

    protected BaseResult<Map<String, Object>> afterHandleDataBatch(int status) {
        LOGGER.info("TaxTaskGuideDownLoadTask.handleData");
        HashMap<String, String> cond = new HashMap<String, String>(2);
        String message = this.exportResult.generateMessage(255);
        if (status == 0 && this.workbookInfo.getWorkbook() != null) {
            String url = ExcelHelper.storeFile((Workbook)this.workbookInfo.getWorkbook(), (String)this.workbookInfo.fullName());
            cond.put("url", url);
            this.exportLog(this.getTotalSize(), url, message);
        } else {
            this.exportLog(0, "", message);
            cond.put("errorMessage", message);
        }
        this.processHandler.close(cond);
        GlobalParam.remove();
        return BaseResult.success(null);
    }

    public void excludeSrcData() {
        this.containRawData = false;
    }

    private void exportLog(int complete, String url, String data) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_exportlog");
        DynamicObject dyn = BusinessDataReader.loadSingle((Object)this.exportLogId, (DynamicObjectType)objType);
        List successResult = this.finalResult.getSuccessResult();
        dyn.set("total", (Object)(successResult.size() + this.finalResult.getFailResultOriginal().size()));
        dyn.set("complete", (Object)successResult.size());
        dyn.set("downloadurl", (Object)url);
        dyn.set("logs", (Object)data);
        dyn.set("exportstatus", (Object)"1");
        dyn.set("finishtime", (Object)new Date());
        BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
    }

    protected ProcessHandler openProcessHandler() {
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "downloadClose");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\u4e2a\u7a0e\u8bb0\u5f55\uff0c\u5b8c\u6210\u540e\u5c06\u81ea\u52a8\u4e0b\u8f7d", (String)"TaxTaskGuideDownLoadTask_4", (String)"sit-itc-business", (Object[])new Object[0]));
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u5bfc\u51fa\u8fdb\u5ea6", (String)"TaxTaskGuideDownLoadTask_1", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected long dealNum() {
        if (this.exportResult == null) {
            return 0L;
        }
        return this.exportResult.dealNum();
    }

    protected void appendLog(String msg) {
        this.exportResult.addMessage(msg);
    }
}

