/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtask.InitTaxDataBasicHelper;
import kd.sit.itc.business.taxtask.PreTaxDataBasicUnit;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class UpdateAssignTaxDataBasicTask
extends AssignMultiThreadTask<PreTaxDataBasicUnit> {
    private static final Log LOGGER = LogFactory.getLog(UpdateAssignTaxDataBasicTask.class);
    private final IFormView view;
    private final TaxTaskEntity taxTaskEntity;
    private final Map<Long, Long> allTaxFileIdMap;

    public UpdateAssignTaxDataBasicTask(IFormView view, TaxTaskEntity taxTaskEntity, Map<Long, Long> allTaxFileIdMap) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.allTaxFileIdMap = allTaxFileIdMap;
    }

    protected List<PreTaxDataBasicUnit> queryData(String key, List<?> data) {
        LOGGER.info("task number is {}, invoke queryData and data length is {}", (Object)this.taxTaskEntity.getNumber(), (Object)data.size());
        List<PreTaxDataBasicUnit> preTaxDataBasicUnits = InitTaxDataBasicHelper.taxDataBasicDyList2PreTaxDataBasicUnitList(data);
        LOGGER.info("task number is {}, invoke queryData and the preTaxDataBasicUnits size is {}", (Object)this.taxTaskEntity.getNumber(), (Object)preTaxDataBasicUnits.size());
        return preTaxDataBasicUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchResult<PreTaxDataBasicUnit> handleData(DataBatch<PreTaxDataBasicUnit> dataBatch) {
        LOGGER.info("task number is {}, UpdateAssignTaxDataBasicTask begin handleData", (Object)this.taxTaskEntity.getNumber());
        List preTaxDataBasicUnitList = dataBatch.getDataList();
        List taxDataBasicDyList = preTaxDataBasicUnitList.stream().map(PreTaxDataBasicUnit::getTaxDataBasic).collect(Collectors.toList());
        LOGGER.info("task number is {}, invoke handleData and taxDataBasicDyList length is {}", (Object)this.taxTaskEntity.getNumber(), (Object)taxDataBasicDyList.size());
        if (CollectionUtils.isEmpty(taxDataBasicDyList)) {
            return new BatchResult(true, preTaxDataBasicUnitList);
        }
        Map<Long, DynamicObject> taxDataBasicDysMap = taxDataBasicDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("taxfile.boid"), dy -> dy, (k1, k2) -> k1));
        HashMap unUpdatedTaxDataBasic = Maps.newHashMapWithExpectedSize((int)taxDataBasicDyList.size());
        InitTaxDataBasicHelper.filterUpdatedTaxDataBasic(taxDataBasicDysMap, unUpdatedTaxDataBasic);
        LOGGER.info("task number is {}, invoke handleData and after filter the taxDataBasicDysMap keyset is {}", (Object)this.taxTaskEntity.getNumber(), (Object)taxDataBasicDysMap.keySet().toString());
        LOGGER.info("task number is {}, invoke handleData and after filter the unUpdatedTaxDataBasic keyset is {}", (Object)this.taxTaskEntity.getNumber(), (Object)unUpdatedTaxDataBasic.keySet().toString());
        InitTaxDataBasicHelper.filterUpdatedChangeTypeAndDeclareStatusTaxDataBasic(unUpdatedTaxDataBasic);
        ArrayList abandonedTaxDataBasicDys = Lists.newArrayListWithExpectedSize((int)taxDataBasicDyList.size());
        HashMap updateTaxDataBasicMap = Maps.newHashMapWithExpectedSize((int)taxDataBasicDyList.size());
        HashMap updatedTaxFileIdMap = Maps.newHashMapWithExpectedSize((int)taxDataBasicDyList.size());
        taxDataBasicDysMap.values().forEach(dy -> {
            Long taxFileBoid = dy.getLong("taxfileboid");
            Long taxFileFid = this.allTaxFileIdMap.get(taxFileBoid);
            if (null != taxFileFid) {
                updateTaxDataBasicMap.put(taxFileBoid, dy);
                updatedTaxFileIdMap.put(taxFileBoid, taxFileFid);
            } else {
                abandonedTaxDataBasicDys.add(dy);
            }
        });
        LOGGER.info("task number is {}, invoke handleData and after second filter the updatedTaxFileIdMap keyset is {}", (Object)this.taxTaskEntity.getNumber(), (Object)updatedTaxFileIdMap.keySet().toString());
        LOGGER.info("task number is {}, invoke handleData and after second filter the abandonedTaxDataBasicDys idList is {}", (Object)this.taxTaskEntity.getNumber(), (Object)abandonedTaxDataBasicDys.stream().map(dy -> dy.getLong("taxfile.boid")).collect(Collectors.toList()).toString());
        InitTaxDataBasicHelper.doUpdateTaxDataBasic(this.taxTaskEntity, updateTaxDataBasicMap, updatedTaxFileIdMap, abandonedTaxDataBasicDys, unUpdatedTaxDataBasic);
        ArrayList allTaxDataBasicDys = Lists.newArrayListWithExpectedSize((int)(updateTaxDataBasicMap.size() + abandonedTaxDataBasicDys.size() + unUpdatedTaxDataBasic.size()));
        for (DynamicObject dynamicObject : abandonedTaxDataBasicDys) {
            dynamicObject.set("status", (Object)"E");
            allTaxDataBasicDys.add(dynamicObject);
        }
        for (Map.Entry entry : updateTaxDataBasicMap.entrySet()) {
            allTaxDataBasicDys.add(entry.getValue());
        }
        for (Map.Entry entry : unUpdatedTaxDataBasic.entrySet()) {
            allTaxDataBasicDys.add(entry.getValue());
        }
        try (TXHandle txHandle = TX.requiresNew();){
            HRBaseServiceHelper hRBaseServiceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
            hRBaseServiceHelper.save(allTaxDataBasicDys.toArray(new DynamicObject[0]));
        }
        LOGGER.info("UpdateAssignTaxDataBasicTask handleData successful");
        return new BatchResult(true, preTaxDataBasicUnitList);
    }

    protected ProcessHandler openProcessHandler() {
        if (Objects.isNull(this.view)) {
            return ProcessHandler.DEFAULT;
        }
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458", (String)"UpdateTaxDataBasicTask_0", (String)"sit-itc-business", (Object[])new Object[0]));
        IPageCache pageCache = this.view.getPageCache();
        String exportPersonReport = pageCache.get("exportPersonReport");
        if ("exportPersonReport".equals(exportPersonReport)) {
            labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458\uff0c\u7a0d\u540e\u5c06\u5bfc\u51fa\u4eba\u5458\u62a5\u9001\u8868", (String)"UpdateTaxDataBasicTask_2", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458\u8fdb\u5ea6\u6761", (String)"UpdateTaxDataBasicTask_1", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }
}

