/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.business.taxtaskguide.task;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.itc.business.taxtask.InitTaxDataBasicHelper;
import kd.sit.itc.business.taxtask.PreTaxDataBasicUnit;
import kd.sit.sitbp.business.handler.BaseProcessHandler;
import kd.sit.sitbp.common.api.DataBatch;
import kd.sit.sitbp.common.api.ProcessHandler;
import kd.sit.sitbp.common.entity.TaxTaskEntity;
import kd.sit.sitbp.common.enums.TaxTaskStatusEnum;
import kd.sit.sitbp.common.util.BaseResult;
import kd.sit.sitbp.common.util.BatchResult;
import kd.sit.sitbp.common.util.async.model.assign.AssignMultiThreadTask;

public class UpdateTaxDataBasicTask
extends AssignMultiThreadTask<PreTaxDataBasicUnit> {
    private static final Log LOGGER = LogFactory.getLog(UpdateTaxDataBasicTask.class);
    private final IFormView view;
    private final TaxTaskEntity taxTaskEntity;
    private final Map<Long, Long> allTaxFileIdMap;
    private final AtomicBoolean existedNewData = new AtomicBoolean(false);

    public UpdateTaxDataBasicTask(IFormView view, TaxTaskEntity taxTaskEntity, Map<Long, Long> allTaxFileIdMap) {
        this.view = view;
        this.taxTaskEntity = taxTaskEntity;
        this.allTaxFileIdMap = allTaxFileIdMap;
    }

    protected List<PreTaxDataBasicUnit> queryData(String key, List<?> data) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        LOGGER.info("1---thread is [{}], task number is [{}], begin queryData, data size is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), data.size()});
        if ("existedTaxDataBasicList".equals(key)) {
            ArrayList existedTaxDataBasicList = Lists.newArrayListWithExpectedSize((int)data.size());
            for (Object obj : data) {
                existedTaxDataBasicList.add((Long)obj);
            }
            QFilter qFilter = new QFilter("id", "in", (Object)existedTaxDataBasicList);
            HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
            DynamicObject[] dys = taxDataBasicHelper.query("id,changetype,declarestatus,srcrefnum,taxfile.boid,taxfileboid,status,modifier,modifytime,taxfile,taxperson,percre,pernontsprop,pereduexp,pertsprop,empposorgrel,taxunit,org,personstatus,taxfile.taxstatus,taxcontact,employment,bankcard,investor,overseasperson,specialinfo,yearmonth", new QFilter[]{qFilter});
            List<PreTaxDataBasicUnit> preTaxDataBasicUnits = InitTaxDataBasicHelper.taxDataBasicDyList2PreTaxDataBasicUnitList(Arrays.stream(dys).collect(Collectors.toList()));
            LOGGER.info("2---existedTaxDataBasicList---thread is [{}], task number is [{}], get preTaxDataBasicUnits size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), preTaxDataBasicUnits.size(), stopwatch.elapsed().toMillis()});
            stopwatch.stop();
            return preTaxDataBasicUnits;
        }
        ArrayList taxFileFidList = Lists.newArrayListWithExpectedSize((int)data.size());
        for (Object obj : data) {
            taxFileFidList.add((Long)obj);
        }
        if (!CollectionUtils.isEmpty((Collection)taxFileFidList)) {
            this.existedNewData.getAndSet(true);
        }
        Map<Long, PreTaxDataBasicUnit> preTaxDataBasicUnitMap = InitTaxDataBasicHelper.getPreTaxDataBasicUnitMap(taxFileFidList);
        LOGGER.info("2---newTaxFileIdMap---thread is [{}], task number is [{}], get preTaxDataBasicUnitMap size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), preTaxDataBasicUnitMap.size(), stopwatch.elapsed().toMillis()});
        stopwatch.stop();
        return Lists.newArrayList(preTaxDataBasicUnitMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected BatchResult<PreTaxDataBasicUnit> handleData(DataBatch<PreTaxDataBasicUnit> dataBatch) {
        String dataKey = dataBatch.getDataKey();
        Stopwatch stopwatch = Stopwatch.createStarted();
        if ("existedTaxDataBasicList".equals(dataKey)) {
            List preTaxDataBasicUnitList = dataBatch.getDataList();
            List taxDataBasicDyList = preTaxDataBasicUnitList.stream().map(PreTaxDataBasicUnit::getTaxDataBasic).collect(Collectors.toList());
            LOGGER.info("1---existedTaxDataBasicList---thread is [{}], task number is [{}], taxDataBasicDyList size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), taxDataBasicDyList.size(), stopwatch.elapsed().toMillis()});
            if (CollectionUtils.isEmpty(taxDataBasicDyList)) {
                return new BatchResult(true, preTaxDataBasicUnitList);
            }
            Map<Long, DynamicObject> taxDataBasicDysMap = taxDataBasicDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("taxfile.boid"), dy -> dy, (k1, k2) -> k1));
            LOGGER.info("2---existedTaxDataBasicList---thread is [{}], task number is [{}], get taxDataBasicDysMap size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), taxDataBasicDysMap.size(), stopwatch.elapsed().toMillis()});
            try {
                HashMap unUpdatedTaxDataBasic = Maps.newHashMapWithExpectedSize((int)taxDataBasicDysMap.size());
                InitTaxDataBasicHelper.filterUpdatedTaxDataBasic(taxDataBasicDysMap, unUpdatedTaxDataBasic);
                LOGGER.info("task number is {}, invoke handleData and after filter the taxDataBasicDysMap keyset is {}", (Object)this.taxTaskEntity.getNumber(), (Object)taxDataBasicDysMap.keySet().toString());
                LOGGER.info("task number is {}, invoke handleData and after filter the unUpdatedTaxDataBasic keyset is {}", (Object)this.taxTaskEntity.getNumber(), (Object)unUpdatedTaxDataBasic.keySet().toString());
                LOGGER.info("3---existedTaxDataBasicList---thread is [{}], task number is [{}], filterUpdatedTaxDataBasic finish, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
                InitTaxDataBasicHelper.filterUpdatedChangeTypeAndDeclareStatusTaxDataBasic(unUpdatedTaxDataBasic);
                HashMap updateTaxDataBasicMap = Maps.newHashMapWithExpectedSize((int)taxDataBasicDyList.size());
                HashMap updatedTaxFileIdMap = Maps.newHashMapWithExpectedSize((int)taxDataBasicDyList.size());
                ArrayList abandonedTaxDataBasicDys = Lists.newArrayListWithExpectedSize((int)taxDataBasicDyList.size());
                taxDataBasicDysMap.values().forEach(dy -> {
                    Long taxFileBoid = dy.getLong("taxfileboid");
                    Long taxFileFid = this.allTaxFileIdMap.get(taxFileBoid);
                    if (null != taxFileFid) {
                        updateTaxDataBasicMap.put(taxFileBoid, dy);
                        updatedTaxFileIdMap.put(taxFileBoid, taxFileFid);
                    } else {
                        abandonedTaxDataBasicDys.add(dy);
                    }
                });
                LOGGER.info("task number is {}, invoke handleData and after second filter the updatedTaxFileIdMap keyset is {}", (Object)this.taxTaskEntity.getNumber(), (Object)updatedTaxFileIdMap.keySet().toString());
                LOGGER.info("task number is {}, invoke handleData and after second filter the abandonedTaxDataBasicDys idList is {}", (Object)this.taxTaskEntity.getNumber(), (Object)abandonedTaxDataBasicDys.stream().map(dy -> dy.getLong("taxfile.boid")).collect(Collectors.toList()).toString());
                LOGGER.info("4---existedTaxDataBasicList---thread is [{}], task number is [{}], doUpdateTaxDataBasic begin, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
                InitTaxDataBasicHelper.doUpdateTaxDataBasic(this.taxTaskEntity, updateTaxDataBasicMap, updatedTaxFileIdMap, abandonedTaxDataBasicDys, unUpdatedTaxDataBasic);
                LOGGER.info("5---existedTaxDataBasicList---thread is [{}], task number is [{}], doUpdateTaxDataBasic finish, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
                ArrayList allTaxDataBasicDys = Lists.newArrayListWithExpectedSize((int)(updateTaxDataBasicMap.size() + abandonedTaxDataBasicDys.size() + unUpdatedTaxDataBasic.size()));
                for (DynamicObject dynamicObject : abandonedTaxDataBasicDys) {
                    dynamicObject.set("status", (Object)"E");
                    allTaxDataBasicDys.add(dynamicObject);
                }
                for (Map.Entry entry : updateTaxDataBasicMap.entrySet()) {
                    allTaxDataBasicDys.add(entry.getValue());
                }
                for (Map.Entry entry : unUpdatedTaxDataBasic.entrySet()) {
                    allTaxDataBasicDys.add(entry.getValue());
                }
                for (DynamicObject dynamicObject : allTaxDataBasicDys) {
                    dynamicObject.set("yearmonth", (Object)this.taxTaskEntity.yearMonth());
                }
                LOGGER.info("6---existedTaxDataBasicList---thread is [{}], task number is [{}], TX begin, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
                try (TXHandle txHandle = TX.requiresNew();){
                    HRBaseServiceHelper hRBaseServiceHelper = new HRBaseServiceHelper("itc_taxdatabasic");
                    hRBaseServiceHelper.save(allTaxDataBasicDys.toArray(new DynamicObject[0]));
                    LOGGER.info("task number is {}, save allTaxDataBasicDys to DB the allTaxDataBasicDys size is {}", (Object)this.taxTaskEntity.getNumber(), (Object)allTaxDataBasicDys.size());
                }
                LOGGER.info("7---existedTaxDataBasicList---thread is [{}], task number is [{}], TX end, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
                stopwatch.stop();
                return new BatchResult(true, preTaxDataBasicUnitList);
            }
            catch (Exception e) {
                LOGGER.error("task number is {}, invoke handleData occur exception {}", (Object)this.taxTaskEntity.getNumber(), (Object)e);
                return new BatchResult(false, preTaxDataBasicUnitList);
            }
        }
        HRBaseServiceHelper taxDataBasicHelper = new HRBaseServiceHelper("itc_taxdatabasic");
        List preTaxDataBasicUnitList = dataBatch.getDataList();
        LOGGER.info("1---newTaxFileIdMap---thread is [{}], task number is [{}], preTaxDataBasicUnitList size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), preTaxDataBasicUnitList.size(), stopwatch.elapsed().toMillis()});
        List<DynamicObject> newTaxDataBasic = InitTaxDataBasicHelper.createNewTaxDataBasic(this.taxTaskEntity, preTaxDataBasicUnitList, null);
        LOGGER.info("2---newTaxFileIdMap---thread is [{}], task number is [{}], createNewTaxDataBasic finish size is [{}], time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), newTaxDataBasic.size(), stopwatch.elapsed().toMillis()});
        LOGGER.info("3---newTaxFileIdMap---thread is [{}], task number is [{}], TX begin, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        try (TXHandle txHandle = TX.requiresNew();){
            taxDataBasicHelper.save(newTaxDataBasic.toArray(new DynamicObject[0]));
            LOGGER.info("task number is {}, invoke handleData and newTaxDataBasic size is {}", (Object)this.taxTaskEntity.getNumber(), (Object)newTaxDataBasic.size());
        }
        LOGGER.info("4---newTaxFileIdMap---thread is [{}], task number is [{}], TX end, time is [{}]", new Object[]{Thread.currentThread().getName(), this.taxTaskEntity.getNumber(), stopwatch.elapsed().toMillis()});
        stopwatch.stop();
        return new BatchResult(true, preTaxDataBasicUnitList);
    }

    protected ProcessHandler openProcessHandler() {
        IPageCache pageCache;
        String exportPersonReport;
        if (Objects.isNull(this.view)) {
            return ProcessHandler.DEFAULT;
        }
        this.processHandler = new BaseProcessHandler();
        HashMap<String, Object> cond = new HashMap<String, Object>(2);
        HashMap fieldVal = new HashMap(2);
        cond.put("fieldVal", fieldVal);
        cond.put("callback", "parentProcess");
        HashMap<String, String> labelVal = new HashMap<String, String>(2);
        cond.put("labelVal", labelVal);
        labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458", (String)"UpdateTaxDataBasicTask_0", (String)"sit-itc-business", (Object[])new Object[0]));
        if (this.view instanceof IListView) {
            if ("itc_taxdatabasic".equals(((IListView)this.view).getBillFormId())) {
                cond.put("closeCallBack", new CloseCallBack("kd.sit.itc.formplugin.web.tax.TaxFileDeclarePlugin", "afterprocessclose"));
            } else if ("itc_taxpreparedata".equals(((IListView)this.view).getBillFormId())) {
                cond.put("closeCallBack", new CloseCallBack("kd.sit.itc.formplugin.web.taskguide.TaxPrepareDataList", "afterprocessclose"));
            }
        }
        if (this.view instanceof IBillView && "itc_taxtask".equals(((IBillView)this.view).getEntityId())) {
            cond.put("closeCallBack", new CloseCallBack("kd.sit.itc.formplugin.web.taxtask.TaxTaskEdit", "afterprocessclose"));
        }
        if ("exportPersonReport".equals(exportPersonReport = (pageCache = this.view.getPageCache()).get("exportPersonReport"))) {
            labelVal.put("title", ResManager.loadKDString((String)"\u6b63\u5728\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458\uff0c\u7a0d\u540e\u5c06\u5bfc\u51fa\u4eba\u5458\u62a5\u9001\u8868", (String)"UpdateTaxDataBasicTask_2", (String)"sit-itc-business", (Object[])new Object[0]));
        }
        LOGGER.info("thread is [{}], allTaxFileIdMap.size is [{}], processHandler.open", (Object)Thread.currentThread().getName(), (Object)this.allTaxFileIdMap.size());
        this.processHandler.open(this.view, ResManager.loadKDString((String)"\u66f4\u65b0\u4e2a\u7a0e\u4eba\u5458\u8fdb\u5ea6\u6761", (String)"UpdateTaxDataBasicTask_1", (String)"sit-itc-business", (Object[])new Object[0]), cond);
        return this.processHandler;
    }

    protected Map<String, Object> closeParams(int status) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("processCallbackOp", "refresh");
        return result;
    }

    protected BaseResult<PreTaxDataBasicUnit> afterHandleDataBatch(int status) {
        if (this.finalResult.isSuccess()) {
            this.processHandler.close(this.closeParams(status));
            this.view.getPageCache().put("totalNum", String.valueOf(this.allTaxFileIdMap.size()));
            HRBaseServiceHelper taxTaskHelper = new HRBaseServiceHelper("itc_taxtask");
            DynamicObject taskDy = taxTaskHelper.queryOne("id,taskstatus", (Object)this.taxTaskEntity.getId());
            String mark = this.view.getPageCache().get("updateTaxDataBasicData");
            if (this.existedNewData.get()) {
                taskDy.set("taskstatus", (Object)TaxTaskStatusEnum.INIT_FINISH.getCode());
                taxTaskHelper.saveOne(taskDy);
            } else if (!Strings.isNullOrEmpty((String)mark)) {
                taskDy.set("taskstatus", (Object)this.taxTaskEntity.getTaskStatus());
                taxTaskHelper.updateOne(taskDy);
                this.view.getPageCache().remove("updateTaxDataBasicData");
                LOGGER.info("finish updateTaxDataBasicData when modifying taxtask and taxtask id is [{}]", (Object)taskDy.getLong("id"));
            }
        }
        return BaseResult.success(null);
    }
}

