/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.accresult;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.sit.itc.business.accresult.AccResultHelper;
import kd.sit.sitbp.common.util.BaseResult;

public class AccResultSaveValidator
extends AbstractValidator {
    private final BigDecimal MAX_VALUE = new BigDecimal("10000000000000");

    public void validate() {
        Object[] dataEntities = this.getDataEntities();
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        String op = this.getOption().getVariableValue("op", "");
        ArrayList passList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        HashSet taxFileIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet accIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet instanceNumSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        DynamicObject currency = AccResultHelper.getCurrency((Long)1L);
        Set taxFileBoIdSet = AccResultHelper.getTaxFileBoIdSetWithPermissionInAccResult((String)"47156aff000000ac");
        for (Object dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            int instanceNum = dynamicObject.getInt("instancenum");
            if (instanceNum == 0) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u7d2f\u52a0\u5b9e\u4f8b\u53f7\u4e0d\u80fd\u4e3a0\u3002", (String)"AccResultSaveValidator_0", (String)"sit-itc-opplugin", (Object[])new Object[0]));
                continue;
            }
            BaseResult checkTaxFileResult = AccResultHelper.checkTaxFile((DynamicObject)dynamicObject, (Set)taxFileBoIdSet);
            if (!checkTaxFileResult.isSuccess()) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, (String)checkTaxFileResult.getData());
                continue;
            }
            BaseResult checkAccumulatorResult = AccResultHelper.checkAccumulator((DynamicObject)dynamicObject);
            if (!checkAccumulatorResult.isSuccess()) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, (String)checkAccumulatorResult.getData());
                continue;
            }
            BaseResult checkInstanceNumResult = AccResultHelper.checkInstanceNum((DynamicObject)dynamicObject);
            if (!checkInstanceNumResult.isSuccess()) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, (String)checkInstanceNumResult.getData());
                continue;
            }
            AccResultHelper.setEndDateAndCurrency((DynamicObject)dynamicObject, (DynamicObject)currency);
            AccResultHelper.setOtherValue((DynamicObject)dynamicObject);
            BaseResult checkEntryResult = "save".equals(this.getOperateKey()) && "frompage".equals(op) ? AccResultHelper.checkEntry((DynamicObject)dynamicObject, (boolean)false) : AccResultHelper.checkEntry((DynamicObject)dynamicObject, (boolean)true);
            if (!checkEntryResult.isSuccess()) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, (String)checkEntryResult.getData());
                continue;
            }
            passList.add(dataEntity);
            taxFileIdSet.add(dynamicObject.getLong("taxfile.id"));
            accIdSet.add(dynamicObject.getLong("accumulator.id"));
            instanceNumSet.add(dynamicObject.getInt("instancenum"));
        }
        if ("save".equals(this.getOperateKey()) && "frompage".equals(op)) {
            this.checkByDataFromDB(passList, taxFileIdSet, accIdSet, instanceNumSet);
        }
        Set passIdsList = passList.stream().map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toSet());
        for (Object dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Long id = dynamicObject.getLong("id");
            if (!passIdsList.contains(id)) continue;
            BigDecimal oldResultValue = dynamicObject.getBigDecimal("resultvalue");
            AccResultHelper.updateChangeValueAndCalculateResultValue((DynamicObject)dynamicObject);
            BigDecimal newResultValue = dynamicObject.getBigDecimal("resultvalue");
            BigDecimal abs = newResultValue.abs();
            if (abs.compareTo(this.MAX_VALUE) < 0) continue;
            dynamicObject.set("resultvalue", (Object)oldResultValue);
            this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ResManager.loadKDString((String)"\u8c03\u6574\u503c\u7684\u7edd\u5bf9\u503c\u4e0d\u80fd\u5927\u4e8e10^13\u3002", (String)"AccResultSaveValidator_2", (String)"sit-itc-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkByDataFromDB(List<ExtendedDataEntity> passList, Set<Long> taxFileIdSet, Set<Long> accIdSet, Set<Integer> instanceNumSet) {
        Object[] data = AccResultHelper.getDateByTaxFileIdAndAccIdAndInstanceNum(taxFileIdSet, accIdSet, instanceNumSet);
        if (!ArrayUtils.isEmpty((Object[])data)) {
            String keyStr;
            Set passIdsList = passList.stream().map(extendedDataEntity -> extendedDataEntity.getDataEntity().getLong("id")).collect(Collectors.toSet());
            HashSet dataSet = Sets.newHashSetWithExpectedSize((int)data.length);
            for (Object dynamicObject : data) {
                if (passIdsList.contains(dynamicObject.getLong("id"))) continue;
                keyStr = this.getKeyStr((DynamicObject)dynamicObject);
                dataSet.add(keyStr);
            }
            Iterator<ExtendedDataEntity> iterator = passList.iterator();
            while (iterator.hasNext()) {
                ExtendedDataEntity dataEntity = iterator.next();
                DynamicObject newAccResultDy = dataEntity.getDataEntity();
                boolean fromDatabase = newAccResultDy.getDataEntityState().getFromDatabase();
                if (fromDatabase || !dataSet.contains(keyStr = this.getKeyStr(newAccResultDy))) continue;
                iterator.remove();
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5728\u7d2f\u52a0\u8d77\u6b62\u65f6\u95f4\u5185\uff0c\u5df2\u5b58\u5728\u7d2f\u52a0\u5b9e\u4f8b\u3002", (String)"AccResultSaveValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private String getKeyStr(DynamicObject newAccResultDy) {
        long taxFileId = newAccResultDy.getLong("taxfile.id");
        long accumulatorId = newAccResultDy.getLong("accumulator.id");
        int instanceNum = newAccResultDy.getInt("instancenum");
        return "" + taxFileId + accumulatorId + instanceNum;
    }
}

