/*
 * Decompiled with CFR 0.152.
 */
package kd.sit.itc.opplugin.validator.taxfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.sit.sitbp.common.model.EffectLogger;
import org.apache.commons.lang3.StringUtils;

public class BankCardSaveValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(BankCardSaveValidator.class);
    private final EffectLogger effectLogger = new EffectLogger("taxfile import", ((Object)((Object)this)).toString(), LOGGER);

    public void validate() {
        this.effectLogger.start("BankCardSaveValidator validate");
        this.dealData();
        this.effectLogger.end("BankCardSaveValidator validate");
    }

    private void dealData() {
        if (StringUtils.equals((CharSequence)this.getOption().getVariableValue("action", ""), (CharSequence)"2")) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> ids = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.validateFields(dataEntity, ids);
        }
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrpi_perbankcard");
        DynamicObject[] dys = helper.query("id,boid,sourcevid,bankdeposit,bankdeposit.province,bankdeposit.province.id,bankdeposit.province.name, bankcardnum", new QFilter[]{new QFilter("id", "in", ids)});
        Map<Long, DynamicObject> taxFileMap = Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy, (k1, k2) -> k1));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy2 = dataEntity.getDataEntity();
            if (!taxFileMap.containsKey(dy2.getLong("perbankcard.boid"))) continue;
            this.setPerBankInfo(taxFileMap, dy2);
        }
    }

    private void validateFields(ExtendedDataEntity dataEntity, List<Long> ids) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        long bankId = dynamicObject.getLong("perbankcard.id");
        if (bankId == 0L) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u201c\u94f6\u884c\u5361\u4fe1\u606f\u201d\u3002", (String)"BankCardValidator_1", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            return;
        }
        Long cardPersonId = dynamicObject.getDynamicObject("perbankcard").getLong("person.id");
        Long filePersonId = dynamicObject.getDynamicObject("taxfile").getLong("person.id");
        String cardPersonNumber = dynamicObject.getDynamicObject("perbankcard").getString("person.number");
        String filePersonNumber = dynamicObject.getDynamicObject("taxfile").getString("person.number");
        if (!(Objects.isNull(cardPersonId) || Objects.isNull(filePersonId) || cardPersonId.equals(filePersonId) || StringUtils.equals((CharSequence)cardPersonNumber, (CharSequence)filePersonNumber))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u586b\u5199\u7684\u94f6\u884c\u5361\u4fe1\u606f\u4e0e\u8be5\u4e2a\u7a0e\u4eba\u5458\u4e0d\u5339\u914d\u3002", (String)"BankCardValidator_4", (String)"sit-itc-opplugin", (Object[])new Object[0]));
            return;
        }
        ids.add(bankId);
    }

    private void setPerBankInfo(Map<Long, DynamicObject> taxFileMap, DynamicObject dy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrpi_perbankcard");
        DynamicObject dynamicObject = taxFileMap.get(dy.getLong("perbankcard.boid"));
        DynamicObject perBankCard = serviceHelper.generateEmptyDynamicObject("hrpi_perbankcard");
        perBankCard.set("id", (Object)dynamicObject.getLong("sourcevid"));
        perBankCard.set("bankcardnum", (Object)dynamicObject.getString("bankcardnum"));
        DynamicObject beBank = serviceHelper.generateEmptyDynamicObject("bd_bebank");
        beBank.set("id", (Object)dynamicObject.getLong("bankdeposit.id"));
        beBank.set("name", (Object)dynamicObject.getString("bankdeposit.name"));
        perBankCard.set("bankdeposit", (Object)beBank);
        dy.set("perbankcardvid", (Object)perBankCard);
        DynamicObject admindivision = serviceHelper.generateEmptyDynamicObject("bd_admindivision");
        admindivision.set("id", (Object)dynamicObject.getLong("bankdeposit.province.id"));
        admindivision.set("name", (Object)dynamicObject.getString("bankdeposit.province.name"));
        dy.set("province", (Object)admindivision);
    }
}

